/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.utils;

import android.content.Context;
import android.text.TextUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.base.BUtility;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexemm.encryption.RC4Encryption;
import org.zywx.wbpalmstar.plugin.uexemm.privatevo.EMMStartReportResVO;
import org.zywx.wbpalmstar.plugin.uexemm.privatevo.WidgetStartUpVO;
import org.zywx.wbpalmstar.plugin.uexemm.utils.EMMUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.HexConverter;
import org.zywx.wbpalmstar.plugin.uexemm.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.SharedPrefUtils;
import org.zywx.wbpalmstar.plugin.uexemm.vo.AppCanCertVO;
import org.zywx.wbpalmstar.plugin.uexemm.vo.AppStatusVO;
import org.zywx.wbpalmstar.plugin.uexemm.vo.EMMWWidgetData;
import org.zywx.wbpalmstar.plugin.uexemm.vo.LoginPropertyOptionVO;

public class EMMDataMgr {
    public static AppCanCertVO parseCertInfoJson(String jsonStr) {
        AppCanCertVO mCertInfo = new AppCanCertVO();
        try {
            JSONObject json = new JSONObject(jsonStr);
            mCertInfo.isCaAuth = json.optBoolean("isCertificate", false);
            mCertInfo.certPwd = json.optString("certPwd");
            mCertInfo.caUrl = json.optString("caurl");
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtils.oe("parseCertInfoJson", e);
        }
        return mCertInfo;
    }

    public static EMMStartReportResVO parseStartReportJsonResult(String jsonStr) {
        EMMStartReportResVO emmStatus = null;
        try {
            JSONObject json = new JSONObject(jsonStr);
            String status = json.optString("status");
            String info = json.optString("info");
            String reportMethod = json.optString("reportMethod");
            String pushMes = json.optString("pushMes");
            String mySpaceStatus = json.optString("mySpaceStatus");
            String mySpaceMoreApp = json.optString("mySpaceMoreApp");
            String widgetStatus = json.optString("widgetStatus");
            String widgetAdStatus = json.optString("widgetAdStatus");
            String appParam = json.optString("appParam");
            String eraseData = json.optString("eraseData");
            String newAppUrl = json.optString("newAppUrl");
            String pkgType = "upgrade";
            String authType = "";
            String widgetPlugins = "";
            String widgetWnds = "";
            String needConfirm = "";
            String forceUpdate = "";
            String auditType = "";
            String updateHints = "";
            String closeHints = "";
            String strategyId = "";
            String newVersion = "";
            boolean enableScreenShot = true;
            pkgType = json.optString("pkgType");
            authType = json.optString("authType");
            widgetPlugins = json.optString("widgetPlugins");
            widgetWnds = json.optString("widgetWnds");
            forceUpdate = json.optString("forceUpdate");
            needConfirm = json.optString("needConfirm");
            if (TextUtils.isEmpty((CharSequence)needConfirm)) {
                needConfirm = String.valueOf("false".equalsIgnoreCase(forceUpdate));
            }
            auditType = json.optString("auditType");
            updateHints = json.optString("updateHints");
            closeHints = json.optString("closeHints");
            if (json.has("strategyId")) {
                strategyId = json.optString("strategyId");
            }
            if (json.has("version")) {
                newVersion = json.optString("version");
            }
            if (json.has("enableScreenshot")) {
                enableScreenShot = json.optBoolean("enableScreenshot");
            }
            emmStatus = new EMMStartReportResVO(status, info, pushMes, widgetStatus, reportMethod, mySpaceStatus, mySpaceMoreApp, widgetAdStatus, appParam, eraseData, newAppUrl, pkgType, authType, widgetPlugins, widgetWnds, needConfirm, forceUpdate, auditType, updateHints, closeHints, strategyId, newVersion, enableScreenShot);
        }
        catch (JSONException e) {
            LogUtils.oe("parseStartReportJsonResult", (Exception)((Object)e));
            LogUtils.logDebugO("error jsonStr: " + jsonStr);
            e.printStackTrace();
        }
        return emmStatus;
    }

    public static String changeToV3Result(String jsonStr) {
        JSONObject jsonV3 = new JSONObject();
        try {
            JSONObject json = new JSONObject(jsonStr);
            jsonV3.put("oriInfo", (Object)json);
            int reportRet = json.optInt("ret", -1);
            if (0 == reportRet) {
                jsonV3.put("status", (Object)"ok");
                String data = json.optString("data", "");
                if (!TextUtils.isEmpty((CharSequence)data)) {
                    if (!data.startsWith("[")) {
                        jsonV3.put("info", (Object)new JSONObject(data));
                    } else {
                        jsonV3.put("info", (Object)new JSONArray(data));
                    }
                }
            } else {
                jsonV3.put("status", (Object)"fail");
                jsonV3.put("info", json.opt("msg"));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonV3.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WidgetStartUpVO changeToWidgetStartUpInfo(String jsonStr) {
        WidgetStartUpVO widgetStartUpInfo = new WidgetStartUpVO();
        int reportRet = -1;
        String result = "";
        if (!TextUtils.isEmpty((CharSequence)jsonStr)) {
            try {
                JSONObject json = new JSONObject(jsonStr);
                reportRet = json.optInt("ret", 0);
                if (EMMUtils.isWidgetStartRepotSuccess(reportRet)) {
                    result = json.optString("data", "");
                    if ("null".equals(result)) {
                        result = json.optString("msg", "");
                    }
                } else {
                    result = json.optString("msg", "");
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            finally {
                widgetStartUpInfo.setErrorCode(reportRet);
                widgetStartUpInfo.setResult(result);
            }
        }
        return widgetStartUpInfo;
    }

    public static String parseAccessToken(String result) {
        String accessToken = null;
        try {
            JSONObject json = new JSONObject(result);
            JSONObject info = json.getJSONObject("info");
            accessToken = info.getString("accessToken");
        }
        catch (Exception e) {
            LogUtils.logDebug("parseAccessToken Exception: " + e.getMessage());
        }
        return accessToken;
    }

    public static String parseValueFromV3Result(String result, String key) {
        String accessToken = null;
        try {
            JSONObject json = new JSONObject(result);
            JSONObject info = json.getJSONObject("info");
            accessToken = info.getString(key);
        }
        catch (Exception e) {
            LogUtils.logDebug("parseAccessToken Exception: " + e.getMessage());
        }
        return accessToken;
    }

    public static JSONObject putDataToJsonObj(JSONObject json) {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("jsonObj", (Object)json.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObj;
    }

    public static String parsePath(Context mContext, EMMWWidgetData mCurWData, String srcPath) {
        String path = null;
        if (srcPath.startsWith("wgt://")) {
            path = BUtility.makeRealPath((String)srcPath, (String)mCurWData.m_widgetPath, (int)mCurWData.m_wgtType);
        } else if (srcPath.startsWith("/")) {
            path = srcPath;
        } else if (srcPath.startsWith("box://")) {
            path = BUtility.makeRealPath((String)srcPath, (String)mCurWData.m_widgetPath, (int)mCurWData.m_wgtType);
        }
        return path;
    }

    public static LoginPropertyOptionVO parseLoginPropertyInfo(String result) {
        LoginPropertyOptionVO loginPropertyInfo = new LoginPropertyOptionVO();
        try {
            JSONObject json = new JSONObject(result);
            loginPropertyInfo.isGetOfflineData = json.optBoolean("isGetOfflineData", false);
            loginPropertyInfo.jwtKey = json.optString("jwtKey");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return loginPropertyInfo;
    }

    public static AppStatusVO getAppStatus(Context context, String appId) {
        AppStatusVO appStatusVO = new AppStatusVO();
        try {
            String appstatus = EUExUtil.getString((String)"appstatus");
            LogUtils.logDebug("appstatusStr: " + appstatus);
            byte[] appstatusToByte = HexConverter.hexStringToBinary(appstatus);
            String appstatusDecrypt = new String(RC4Encryption.os_decrypt(appstatusToByte, appstatusToByte.length, appId));
            LogUtils.logDebugO("appstatusDecrypt: " + appstatusDecrypt);
            String[] appstatusArray = appstatusDecrypt.split(",");
            if (appstatusArray == null || appstatusArray.length == 0) {
                return null;
            }
            if ("0".equals(appstatusArray[0])) {
                appStatusVO.startReport = false;
                return null;
            }
            if ("0".equals(appstatusArray[1])) {
                appStatusVO.widgetStatus = false;
            }
            if ("0".equals(appstatusArray[2])) {
                appStatusVO.appUpdate = false;
            }
            if ("0".equals(appstatusArray[3])) {
                appStatusVO.widgetParam = false;
            }
            if ("0".equals(appstatusArray[4])) {
                appStatusVO.widgetPush = false;
            }
            if ("0".equals(appstatusArray[5])) {
                appStatusVO.widgetAnalytics = false;
            }
            if ("1".equals(appstatusArray[6])) {
                appStatusVO.isAuthMam = true;
            }
            if ("1".equals(appstatusArray[7])) {
                appStatusVO.checkRoot = true;
            }
            if ("1".equals(appstatusArray[8])) {
                appStatusVO.isCertificate = true;
            }
            if ("1".equals(appstatusArray[9])) {
                appStatusVO.isPatchUpdate = true;
            }
            if ("1".equals(appstatusArray[10])) {
                appStatusVO.mdmStatus = true;
            }
            if ("1".equals(appstatusArray[11])) {
                appStatusVO.mcmStatus = true;
            }
            if ("0".equals(appstatusArray[12])) {
                LogUtils.logDebug("isForceConnected: false");
                appStatusVO.isForceConnected = false;
            }
            if ("1".equals(appstatusArray[13])) {
                appStatusVO.isCheckAppSign = true;
            }
            if ("1".equals(appstatusArray[14])) {
                appStatusVO.isCheckService = true;
            }
            if ("1".equals(appstatusArray[15])) {
                appStatusVO.isOfflineLogin = true;
            }
            if ("1".equals(appstatusArray[16])) {
                appStatusVO.isSaveDataToBox = true;
            }
        }
        catch (Exception e) {
            LogUtils.oe("checkAppStatus", e);
        }
        return appStatusVO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveGridListInfo(Context context, String gridListStr) {
        block6: {
            EMMUtils.clearGridInfo(context, "gridlist");
            try {
                JSONObject jsonObject = new JSONObject(gridListStr);
                if ("ok".equals(jsonObject.optString("status"))) {
                    String info = jsonObject.optString("info");
                    JSONArray gridArray = new JSONArray(info);
                    int gridSize = gridArray.length();
                    String[] jwtIdList = new String[gridSize];
                    String[] gridList = new String[gridSize];
                    for (int i = 0; i < gridSize; ++i) {
                        JSONObject json = gridArray.getJSONObject(i);
                        jwtIdList[i] = json.optString("token");
                        gridList[i] = json.toString();
                    }
                    SharedPrefUtils.putStringArray(context, "gridlist", jwtIdList, gridList);
                    break block6;
                }
                LogUtils.logDebug("saveGridListInfo fail,gridListStr:" + gridListStr);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }
}

