/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.utils;

import android.content.Context;
import android.text.TextUtils;
import org.json.JSONObject;
import org.zywx.wbpalmstar.plugin.uexemm.emm.EMMAgent;
import org.zywx.wbpalmstar.plugin.uexemm.http.EMMHttpURLConnection;
import org.zywx.wbpalmstar.plugin.uexemm.privatevo.HttpRequrstResultVO;
import org.zywx.wbpalmstar.plugin.uexemm.utils.EMMUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.LogUtils;

public class IPLocation {
    private static final String TAOBAO_IP_LOCATION_URL = "http://url.taobao.com/service/getIpInfo2.php?url=myip";
    private static String BAIDU_IP_LOCATION_URL = "http://api.map.baidu.com/location/url?ak={ak}";

    public static void getIPLocation(Context context, String appId) {
        String baiduLocationAK = EMMAgent.getEMMConfig().baiduLocationAK;
        if (TextUtils.isEmpty((CharSequence)baiduLocationAK)) {
            IPLocation.getIPLocationFromTaobao(context, appId);
        } else {
            IPLocation.getIPLocationFromBaidu(context, appId, baiduLocationAK);
        }
    }

    public static void getIPLocationFromTaobao(final Context context, final String appId) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String result = EMMHttpURLConnection.sendGetRequest(context, null, IPLocation.TAOBAO_IP_LOCATION_URL, " ").getResult();
                    LogUtils.logDebugO("IPLocation result: " + result);
                    JSONObject json = new JSONObject(result);
                    JSONObject contentJson = json.getJSONObject("data");
                    String country = contentJson.optString("country");
                    String region = contentJson.optString("region");
                    String city = contentJson.optString("city");
                    StringBuilder strb = new StringBuilder();
                    strb.append(country).append(",").append(region).append(",").append(city);
                    String address = strb.toString();
                    LogUtils.logDebugO("taobao IPLocation address: " + address);
                    EMMUtils.setReportAddress(context, appId, address);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    private static void getIPLocationFromBaidu(final Context context, final String appId, final String baiduLocationAK) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String url = "";
                    url = BAIDU_IP_LOCATION_URL.replace("{ak}", baiduLocationAK);
                    HttpRequrstResultVO httpResult = EMMHttpURLConnection.sendGetRequest(context, null, url);
                    String result = httpResult.getResult();
                    LogUtils.logDebugO("IPLocation result: " + result);
                    JSONObject json = new JSONObject(result);
                    JSONObject contentJson = json.getJSONObject("content");
                    JSONObject addDetial = contentJson.getJSONObject("address_detail");
                    String country = "\u4e2d\u56fd";
                    String province = addDetial.optString("province");
                    String city = addDetial.optString("city");
                    StringBuilder strb = new StringBuilder();
                    strb.append(country).append(",").append(province).append(",").append(city);
                    String address = strb.toString();
                    LogUtils.logDebugO("baidu IPLocation address: " + address);
                    EMMUtils.setReportAddress(context, appId, address);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }
}

