/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import org.zywx.wbpalmstar.plugin.uexemm.http.EMMHttpURLConnection;

public class NetworkUtils {
    public static String getNetName(Context activity) {
        if (activity == null) {
            return null;
        }
        String netName = null;
        try {
            NetworkInfo info;
            ConnectivityManager cm = (ConnectivityManager)activity.getApplicationContext().getSystemService("connectivity");
            if (cm != null && (info = cm.getActiveNetworkInfo()) != null && info.isAvailable()) {
                block1 : switch (info.getType()) {
                    case 0: {
                        TelephonyManager telephonyManager = (TelephonyManager)activity.getSystemService("phone");
                        switch (telephonyManager.getNetworkType()) {
                            case 1: 
                            case 2: 
                            case 4: 
                            case 7: 
                            case 11: {
                                netName = "GPRS";
                                break block1;
                            }
                            case 3: 
                            case 5: 
                            case 6: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 12: 
                            case 14: 
                            case 15: {
                                netName = "3G";
                                break block1;
                            }
                            case 13: {
                                netName = "4G";
                            }
                        }
                        break;
                    }
                    case 1: {
                        netName = "WIFI";
                    }
                }
            }
        }
        catch (SecurityException e) {
            netName = null;
        }
        return netName;
    }

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager mConnMan = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        NetworkInfo info = mConnMan.getActiveNetworkInfo();
        if (info == null) {
            return NetworkUtils.isNetWork(context);
        }
        return info.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isNetWork(Context context) {
        HttpURLConnection httpConnection = null;
        httpConnection = EMMHttpURLConnection.getHttpURLConnection(context, "http://www.baidu.com", 60000, false);
        try {
            httpConnection.addRequestProperty("Accept", "*/*");
            httpConnection.setRequestMethod("GET");
            httpConnection.connect();
            int responseCode = httpConnection.getResponseCode();
            if (200 == responseCode) {
                boolean bl = true;
                return bl;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpConnection.disconnect();
                httpConnection = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

