/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexemm.dialog.EmmDialog;
import org.zywx.wbpalmstar.plugin.uexemm.encryption.MD5Encryption;
import org.zywx.wbpalmstar.plugin.uexemm.encryption.RC4Encryption;
import org.zywx.wbpalmstar.plugin.uexemm.encryption.SignatureUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.DeviceInfo;
import org.zywx.wbpalmstar.plugin.uexemm.utils.EMMTokenUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.EMMUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.HexConverter;
import org.zywx.wbpalmstar.plugin.uexemm.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.NetworkUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.SharedPrefUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.SystemTime;
import org.zywx.wbpalmstar.plugin.uexemm.vo.EMMWWidgetData;

public class SafetyVerify {
    public static String getAppVerifyCode(EMMWWidgetData wData) {
        String timeStamp = System.currentTimeMillis() + "";
        String appVerifyCode = wData.m_appId + ":" + wData.m_appkey + ":" + timeStamp;
        appVerifyCode = MD5Encryption.getMD5Code(appVerifyCode) + ";" + timeStamp;
        return appVerifyCode;
    }

    public static String getEncryptAppSign(Context context) {
        String curAppSign = SignatureUtils.getCurrentAppIdentifier(context);
        byte[] curStrBytes = curAppSign.getBytes();
        byte[] encryptedBytes = RC4Encryption.os_decrypt(curStrBytes, curStrBytes.length, context.getPackageName());
        String encryptedStr = HexConverter.binaryToHexString(encryptedBytes);
        return encryptedStr;
    }

    private static String getAppIdAppKeyMD5(String appId, String appKey) {
        LogUtils.logDebug("getAppIdAppKeyMD5:" + appId + " " + appKey);
        String[] value = new String[]{appId + ":" + appKey};
        return MD5Encryption.getMD5Code(value);
    }

    public static String getStartAuthorizeMsgEx(Context ctx, EMMWWidgetData data) {
        TelephonyManager telephonyManager = (TelephonyManager)ctx.getSystemService("phone");
        StringBuilder reportData = new StringBuilder();
        reportData.append(4).append(";").append(data.m_appId).append(";").append(data.m_widgetName).append(";").append(data.m_ver).append(";").append(data.m_channelCode).append(";").append(Build.MODEL).append(";").append("Android ").append(Build.VERSION.RELEASE).append(";").append(Settings.System.getString((ContentResolver)ctx.getContentResolver(), (String)"android_id")).append(";").append(DeviceInfo.getDeviceResolution(ctx)).append(";").append(DeviceInfo.getMobileOperatorName(ctx)).append(";").append(NetworkUtils.getNetName(ctx)).append(";").append(SystemTime.getNowTime()).append(";").append(SafetyVerify.getAppIdAppKeyMD5(data.m_appId, data.m_appkey)).append(";").append(SharedPrefUtils.getLong(ctx, "app", "appTotalTime", 0L)).append(";").append(DeviceInfo.getMacAddress(ctx)).append(";").append(DeviceInfo.getSerialNumber()).append(";").append(EMMTokenUtils.getDeviceToken(ctx, "app")).append(";").append(EMMUtils.getManufacturerName()).append(";").append(EMMUtils.getReportAddress(ctx, data.m_appId)).append(";").append(SignatureUtils.getCurrentAppIdentifier(ctx)).append(";").append(SharedPrefUtils.getString(ctx, "app", "erased_data_flg", "false")).append(";").append(DeviceInfo.deviceBeRoot() ? 1 : 0);
        String reportDataStr = reportData.toString();
        return reportDataStr;
    }

    public static JSONObject getStartAuthorizeMsgExV4(Context context, EMMWWidgetData data) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        JSONObject jsonMsg = new JSONObject();
        try {
            jsonMsg.put("appId", (Object)data.m_appId);
            jsonMsg.put("tenantAccount", (Object)EMMUtils.getTenantAccount(context));
            jsonMsg.put("appName", (Object)data.m_widgetName);
            jsonMsg.put("version", (Object)data.m_ver);
            jsonMsg.put("channel", (Object)data.m_channelCode);
            jsonMsg.put("model", (Object)Build.MODEL);
            jsonMsg.put("osVersion", (Object)("Android " + Build.VERSION.RELEASE));
            jsonMsg.put("imei", (Object)Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"android_id"));
            jsonMsg.put("screenSize", (Object)DeviceInfo.getDeviceResolution(context));
            jsonMsg.put("mobileCarrier", (Object)DeviceInfo.getMobileOperatorName(context));
            jsonMsg.put("mobileNetwork", (Object)NetworkUtils.getNetName(context));
            jsonMsg.put("widgetStartupAt", (Object)SystemTime.getNowTime());
            jsonMsg.put("md5Code", (Object)SafetyVerify.getAppIdAppKeyMD5(data.m_appId, data.m_appkey));
            jsonMsg.put("duration", (Object)String.valueOf(SharedPrefUtils.getLong(context, "app", "appTotalTime", 0L)));
            jsonMsg.put("mac", (Object)DeviceInfo.getMacAddress(context));
            jsonMsg.put("sid", (Object)DeviceInfo.getSerialNumber());
            jsonMsg.put("deviceToken", (Object)EMMTokenUtils.getDeviceToken(context, "app"));
            jsonMsg.put("brandName", (Object)EMMUtils.getManufacturerName());
            jsonMsg.put("mobileLocation", (Object)EMMUtils.getReportAddress(context, data.m_appId));
            String softToken = EMMTokenUtils.getSoftToken(context, data);
            jsonMsg.put("softToken", (Object)softToken);
            jsonMsg.put("clientId", (Object)(DeviceInfo.getMacAddress(context).replaceAll(":", "") + data.m_appId));
            jsonMsg.put("eraseData", (Object)SharedPrefUtils.getString(context, "app", "erased_data_flg", "false"));
            jsonMsg.put("isCrossed", DeviceInfo.deviceBeRoot());
            jsonMsg.put("appIdentifier", (Object)SignatureUtils.getCurrentAppIdentifier(context));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonMsg;
    }

    public static String getCertificatepath(Context context, boolean isUpdateWidget) {
        String cPath = null;
        cPath = isUpdateWidget ? context.getFilesDir().getPath() + "/widget/wgtRes/clientCertificate.p12" : "file:///android_asset/widget/wgtRes/clientCertificate.p12";
        return cPath;
    }

    public static boolean checkAppSign(Context context) {
        boolean isAppSignvalidity = false;
        String appSign = EUExUtil.getString((String)"app_sign");
        LogUtils.logDebugO("sign: " + appSign);
        if (!TextUtils.isEmpty((CharSequence)appSign)) {
            byte[] appSignBytes = HexConverter.hexStringToBinary(appSign);
            String appSignDecrypted = new String(RC4Encryption.os_decrypt(appSignBytes, appSignBytes.length, context.getPackageName()));
            LogUtils.logDebugO("de sign: " + appSignDecrypted);
            String curAppSign = SignatureUtils.getCurrentAppIdentifier(context);
            LogUtils.logDebugO("cur sign: " + curAppSign);
            if (curAppSign != null && appSignDecrypted != null && curAppSign.equals(appSignDecrypted)) {
                isAppSignvalidity = true;
            }
        }
        if (!isAppSignvalidity) {
            EmmDialog.signatureError(context);
        }
        return isAppSignvalidity;
    }
}

