/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm;

import android.content.Context;
import android.text.TextUtils;
import android.util.Xml;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.zywx.wbpalmstar.acedes.ACEDes;
import org.zywx.wbpalmstar.base.BUtility;
import org.zywx.wbpalmstar.plugin.uexemm.utils.FileUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexemm.vo.EMMConfigVO;

public class EMMConfigManager {
    private static InputStream decryptWidgetConfig(InputStream inputStream) {
        ByteArrayInputStream fisResult = null;
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            ByteArrayInputStream fisCheck = new ByteArrayInputStream(baos.toByteArray());
            fisResult = new ByteArrayInputStream(baos.toByteArray());
            boolean isEncrypted = ACEDes.isEncrypted((InputStream)fisCheck);
            if (isEncrypted) {
                byte[] data = BUtility.transStreamToBytes((InputStream)fisResult, (int)((InputStream)fisResult).available());
                String result = ACEDes.htmlDecode((byte[])data, (String)"config");
                fisResult = new ByteArrayInputStream(result.getBytes());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fisResult;
    }

    private static void setBaiduLocationAK(EMMConfigVO eConfigVO, String baiduAK) {
        if (!TextUtils.isEmpty((CharSequence)baiduAK)) {
            eConfigVO.baiduLocationAK = baiduAK;
        }
    }

    private static void setAutoStartReport(EMMConfigVO eConfigVO, String autoStartReport) {
        if (!TextUtils.isEmpty((CharSequence)autoStartReport)) {
            eConfigVO.isAutoStartReport = !"false".equals(autoStartReport);
        }
    }

    private static void setShowUpgradeAuto(EMMConfigVO eConfigVO, String upgradeAuto) {
        if (!TextUtils.isEmpty((CharSequence)upgradeAuto)) {
            eConfigVO.isShowUpgradeAuto = !"false".equals(upgradeAuto);
        }
    }

    private static void setShowUpgradeManual(EMMConfigVO eConfigVO, String upgradeManual) {
        if (!TextUtils.isEmpty((CharSequence)upgradeManual)) {
            eConfigVO.isShowUpgradeManual = !"false".equals(upgradeManual);
        }
    }

    private static void setRealTimePatchUpdate(EMMConfigVO eConfigVO, String realUpdate) {
        if (!TextUtils.isEmpty((CharSequence)realUpdate)) {
            eConfigVO.isRealTimePatchUpdate = !"false".equals(realUpdate);
        }
    }

    private static void setIsExitApp(EMMConfigVO eConfigVO, String IsExitApp) {
        if (!TextUtils.isEmpty((CharSequence)IsExitApp)) {
            eConfigVO.isExitApp = !"false".equals(IsExitApp);
        }
    }

    public static EMMConfigVO getEMMConfigByXML(Context context) {
        EMMConfigVO eMMConfigVO;
        block29: {
            String configFile = context.getFilesDir() + "/widget/" + "config.xml";
            InputStream fis = null;
            InputStream fisResult = null;
            File file = new File(configFile);
            eMMConfigVO = new EMMConfigVO();
            if (!file.exists()) {
                LogUtils.logDebug(true, "box has no config.xml");
                try {
                    fis = context.getAssets().open("widget/config.xml");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                LogUtils.logDebug(true, "box has config.xml");
                fis = FileUtils.getFileInputStream(configFile);
            }
            if (fis != null) {
                try {
                    try {
                        fisResult = EMMConfigManager.decryptWidgetConfig(fis);
                        XmlPullParser parser = Xml.newPullParser();
                        parser.setInput(fisResult, "utf-8");
                        int tokenType = 0;
                        boolean needContinue = true;
                        do {
                            tokenType = parser.next();
                            switch (tokenType) {
                                case 2: {
                                    String localName = parser.getName();
                                    if ("EMMConfig".equals(localName)) {
                                        EMMConfigManager.setBaiduLocationAK(eMMConfigVO, parser.getAttributeValue(null, "BaiduLocationAK"));
                                        EMMConfigManager.setAutoStartReport(eMMConfigVO, parser.getAttributeValue(null, "AutoStartReport"));
                                        EMMConfigManager.setShowUpgradeAuto(eMMConfigVO, parser.getAttributeValue(null, "ShowUpgradeAuto"));
                                        EMMConfigManager.setShowUpgradeManual(eMMConfigVO, parser.getAttributeValue(null, "ShowUpgradeManual"));
                                        EMMConfigManager.setRealTimePatchUpdate(eMMConfigVO, parser.getAttributeValue(null, "RealTimePatchUpdate"));
                                        EMMConfigManager.setIsExitApp(eMMConfigVO, parser.getAttributeValue(null, "IsExitApp"));
                                        break;
                                    }
                                    if ("BaiduLocationAK".equals(localName)) {
                                        EMMConfigManager.setBaiduLocationAK(eMMConfigVO, parser.nextText());
                                        break;
                                    }
                                    if (!"AutoStartReport".equals(localName)) break;
                                    EMMConfigManager.setAutoStartReport(eMMConfigVO, parser.nextText());
                                    break;
                                }
                                case 1: {
                                    needContinue = false;
                                }
                            }
                        } while (needContinue);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (fis != null) {
                            try {
                                if (fisResult != null) {
                                    fisResult.close();
                                    fisResult = null;
                                }
                                fis.close();
                                fis = null;
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                        }
                        break block29;
                    }
                }
                catch (Throwable throwable) {
                    if (fis != null) {
                        try {
                            if (fisResult != null) {
                                fisResult.close();
                                fisResult = null;
                            }
                            fis.close();
                            fis = null;
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                if (fis != null) {
                    try {
                        if (fisResult != null) {
                            fisResult.close();
                            fisResult = null;
                        }
                        fis.close();
                        fis = null;
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        LogUtils.logDebugO(true, "baidu AK:" + eMMConfigVO.baiduLocationAK + " autoReport:" + eMMConfigVO.isAutoStartReport + " autoShow:" + eMMConfigVO.isShowUpgradeAuto + " ManualShow:" + eMMConfigVO.isShowUpgradeManual + " realTime:" + eMMConfigVO.isRealTimePatchUpdate + " isExitApp:" + eMMConfigVO.isExitApp);
        return eMMConfigVO;
    }
}

