/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm;

import android.content.Context;
import android.text.TextUtils;
import java.util.List;
import org.zywx.wbpalmstar.engine.EBrowserView;
import org.zywx.wbpalmstar.engine.EngineEventListener;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexemm.EngineWDataManager;
import org.zywx.wbpalmstar.plugin.uexemm.ParserStartReportRes;
import org.zywx.wbpalmstar.plugin.uexemm.analytics.AnalyticsAgent;
import org.zywx.wbpalmstar.plugin.uexemm.emm.EMMAgent;
import org.zywx.wbpalmstar.plugin.uexemm.emm.StartReportResultListener;
import org.zywx.wbpalmstar.plugin.uexemm.encryption.AppEncryption;
import org.zywx.wbpalmstar.plugin.uexemm.utils.EMMDataMgr;
import org.zywx.wbpalmstar.plugin.uexemm.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.SafetyVerify;
import org.zywx.wbpalmstar.plugin.uexemm.vo.EMMConfigVO;
import org.zywx.wbpalmstar.plugin.uexemm.vo.EMMWWidgetData;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class EMMEngineEventListener
implements EngineEventListener {
    private EMMAgent emmAgent = null;
    private AnalyticsAgent analyticsAgent = null;
    private Context mContext;

    public EMMEngineEventListener() {
        LogUtils.logDebug(true, "EMMEngineEventListener Be Created!!");
        this.emmAgent = EMMAgent.getInstance();
    }

    public void onWidgetStart(int wgtType, final WWidgetData wgtData, Context context) {
        LogUtils.logDebug(true, "EMMEngineEventListener onWidgetStart");
        this.emmAgent.initEMM(context);
        EMMConfigVO mEMMCofigVO = EMMAgent.getEMMConfig();
        if (this.mContext == null) {
            this.mContext = context;
        }
        if (this.analyticsAgent == null) {
            this.analyticsAgent = AnalyticsAgent.getInstance(context);
        }
        EMMWWidgetData wDataPlugin = EngineWDataManager.wWidgetData2Plugin(wgtData);
        switch (wgtType) {
            case 0: {
                String inAppKey = EUExUtil.getString((String)"appkey");
                wDataPlugin.m_appkey = inAppKey = AppEncryption.decodeStr(inAppKey);
                this.emmAgent.setAppStatus(EMMDataMgr.getAppStatus(context, wDataPlugin.m_appId));
                if (mEMMCofigVO.isAutoStartReport) {
                    this.emmAgent.setClientCertVO(SafetyVerify.getCertificatepath(context, EMMAgent.getAppStatus().isPatchUpdate), EUExUtil.getCertificatePsw((Context)context, (String)wDataPlugin.m_appId));
                }
                this.emmAgent.initApp(context, wDataPlugin, new StartReportResultListener(){

                    @Override
                    public void disablePlugins(Context context, int widgetType, String disablePlugins, String spName) {
                        ParserStartReportRes.saveDisablePlugins(context, wgtData, widgetType, disablePlugins, spName);
                    }

                    @Override
                    public void disableWindows(Context context, int widgetType, String disableWindows, String spName) {
                        ParserStartReportRes.saveDisableWindows(context, wgtData, widgetType, disableWindows, spName);
                    }
                });
                if (mEMMCofigVO.isAutoStartReport) {
                    this.emmAgent.widgetStartup(context, wDataPlugin, this.emmAgent.getEUExEMMInstance().cbHandler, true);
                    break;
                }
                LogUtils.logError("config.xml set widget AutoStartReport for false!");
                break;
            }
            case 1: {
                if (!TextUtils.isEmpty((CharSequence)wgtData.m_appkey)) {
                    this.emmAgent.widgetStartup(context, wDataPlugin, this.emmAgent.getEUExEMMInstance().cbHandler, false);
                    break;
                }
                LogUtils.logDebug(true, "subWidget appkey is null.");
            }
        }
    }

    public void onWindowOpen(String beEndUrl, String beShowUrl, String[] beEndPopupUrls) {
        LogUtils.logDebug(true, "EMMEngineEventListener onWindowOpen");
        this.analyticsAgent.setStartView(beEndUrl, beShowUrl, 0, 0);
        this.analyticsAgent.setEndView(beEndUrl, 1);
        String[] stringArray = beEndPopupUrls;
        int n = beEndPopupUrls.length;
        int n2 = 0;
        while (n2 < n) {
            String beEndPopupUrl = stringArray[n2];
            this.analyticsAgent.setEndView(beEndPopupUrl, 0);
            ++n2;
        }
    }

    public void onWindowClose(String beEndUrl, String beShowUrl, String[] beEndPopupUrls, String[] beShowPopupUrls) {
        LogUtils.logDebug(true, "EMMEngineEventListener onWindowClose");
        this.analyticsAgent.setEndView(beEndUrl, 0);
        this.analyticsAgent.setStartView(beEndUrl, beShowUrl, 1, 0);
        String[] stringArray = beEndPopupUrls;
        int n = beEndPopupUrls.length;
        int n2 = 0;
        while (n2 < n) {
            String beEndPopupUrl = stringArray[n2];
            this.analyticsAgent.setEndView(beEndPopupUrl, 0);
            ++n2;
        }
        stringArray = beShowPopupUrls;
        n = beShowPopupUrls.length;
        n2 = 0;
        while (n2 < n) {
            String beShowPopupUrl = stringArray[n2];
            this.analyticsAgent.setStartView(beShowUrl, beShowPopupUrl, 1, 1);
            ++n2;
        }
    }

    public void onWindowBack(String beEndUrl, String beShowUrl, String[] beEndPopupUrls, String[] beShowPopupUrls) {
        LogUtils.logDebug(true, "EMMEngineEventListener onWindowBack");
        this.analyticsAgent.setEndView(beEndUrl, 1);
        this.analyticsAgent.setStartView(beEndUrl, beShowUrl, 1, 0);
        String[] stringArray = beEndPopupUrls;
        int n = beEndPopupUrls.length;
        int n2 = 0;
        while (n2 < n) {
            String beEndPopupUrl = stringArray[n2];
            this.analyticsAgent.setEndView(beEndPopupUrl, 0);
            ++n2;
        }
        stringArray = beShowPopupUrls;
        n = beShowPopupUrls.length;
        n2 = 0;
        while (n2 < n) {
            String beShowPopupUrl = stringArray[n2];
            this.analyticsAgent.setStartView(beShowUrl, beShowPopupUrl, 1, 1);
            ++n2;
        }
    }

    public void onWindowForward(String beEndUrl, String beShowUrl, String[] beEndPopupUrls, String[] beShowPopupUrls) {
        LogUtils.logDebug(true, "EMMEngineEventListener onWindowForward");
        this.analyticsAgent.setEndView(beEndUrl, 1);
        this.analyticsAgent.setStartView(beEndUrl, beShowUrl, 1, 0);
        String[] stringArray = beEndPopupUrls;
        int n = beEndPopupUrls.length;
        int n2 = 0;
        while (n2 < n) {
            String beEndPopupUrl = stringArray[n2];
            this.analyticsAgent.setEndView(beEndPopupUrl, 0);
            ++n2;
        }
        stringArray = beShowPopupUrls;
        n = beShowPopupUrls.length;
        n2 = 0;
        while (n2 < n) {
            String beShowPopupUrl = stringArray[n2];
            this.analyticsAgent.setStartView(beShowUrl, beShowPopupUrl, 1, 1);
            ++n2;
        }
    }

    public void onPopupOpen(String curWindowUrl, String beShowPopupUrl) {
        LogUtils.logDebug(true, "EMMEngineEventListener onPopupOpen");
        this.analyticsAgent.setStartView(curWindowUrl, beShowPopupUrl, 0, 1);
    }

    public void onPopupClose(String beEndPopupUrl) {
        LogUtils.logDebug(true, "EMMEngineEventListener onPopupClose");
        this.analyticsAgent.setEndView(beEndPopupUrl, 0);
    }

    public void onAppResume(String beEndUrl, String beShowUrl, String[] beShowPopupUrls) {
        LogUtils.logDebug(true, "EMMEngineEventListener onAppResume");
        this.analyticsAgent.setStartView(beEndUrl, beShowUrl, 0, 0);
        String[] stringArray = beShowPopupUrls;
        int n = beShowPopupUrls.length;
        int n2 = 0;
        while (n2 < n) {
            String beShowPopupUrl = stringArray[n2];
            this.analyticsAgent.setStartView(beShowUrl, beShowPopupUrl, 0, 1);
            ++n2;
        }
        this.analyticsAgent.setAppBecomeActive(this.mContext);
    }

    public void onAppPause(String beEndUrl, String beShowUrl, String[] beEndPopupUrls) {
        LogUtils.logDebug(true, "EMMEngineEventListener onAppPause");
        this.analyticsAgent.setEndView(beEndUrl, 2);
        String[] stringArray = beEndPopupUrls;
        int n = beEndPopupUrls.length;
        int n2 = 0;
        while (n2 < n) {
            String beEndPopupUrl = stringArray[n2];
            this.analyticsAgent.setEndView(beEndPopupUrl, 0);
            ++n2;
        }
        this.analyticsAgent.setAppBecomeBackground(this.mContext);
    }

    public void onAppStart(String startUrl) {
        LogUtils.logDebug(true, "EMMEngineEventListener onAppStart");
        int index = startUrl.lastIndexOf(47);
        if (index > 0) {
            startUrl = startUrl.substring(index + 1);
        }
        this.analyticsAgent.setStartView(null, startUrl, 0, 0);
        this.analyticsAgent.initAppOnlineTime();
    }

    public void onAppStop() {
        LogUtils.logDebug(true, "EMMEngineEventListener onAppStop");
        this.analyticsAgent.setAppBecomeBackground(this.mContext);
        this.emmAgent.clear();
        this.analyticsAgent.clear();
    }

    public void onOther(int type, Object any) {
        LogUtils.logDebug(true, "EMMEngineEventListener onOther");
    }

    public void setPushInfo(Context context, List nameValuePairs) {
    }

    public void setPushState(Context context, int state) {
    }

    public void getPushInfo(Context context, String pushInfo, String occuredAt) {
    }

    public void delPushInfo(Context arg0, List arg1) {
    }

    public void deviceBind(String arg0, String arg1, Context arg2, EBrowserView arg3) {
    }

    public void deviceUnBind(Context arg0, EBrowserView arg1) {
    }
}

