/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.analytics;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import org.zywx.wbpalmstar.plugin.uexemm.analytics.AnalyticsAgent;
import org.zywx.wbpalmstar.plugin.uexemm.analytics.AnalyticsThread;
import org.zywx.wbpalmstar.plugin.uexemm.analytics.SubWidgetAnalyticsThread;
import org.zywx.wbpalmstar.plugin.uexemm.utils.LogUtils;

public class AlterAnalyTime
extends Thread {
    private static final String TAG = "AlterAnalyTime";
    private static final int INTERVAL_TIME_LONG = 5000;
    private static final int INTERVAL_TIME_SHORT = 200;
    private static final int WHAT_FREQ_HIGH = 0;
    private static final int WHAT_FREQ_LOW = 1;
    private Handler handler;
    private static AlterAnalyTime alterAnalyTime;

    private AlterAnalyTime() {
        super(TAG);
    }

    public static AlterAnalyTime getInstance() {
        if (alterAnalyTime == null) {
            alterAnalyTime = new AlterAnalyTime();
        }
        return alterAnalyTime;
    }

    @Override
    public void run() {
        Looper.prepare();
        this.handler = new Handler(){

            public void handleMessage(Message msg) {
                int what = msg.what;
                switch (what) {
                    case 0: {
                        LogUtils.logDebugO(true, "AnalyticsFrequency High: 200");
                        AnalyticsThread.INTERVAL_TIME = 200;
                        SubWidgetAnalyticsThread.INTERVAL_TIME = 200;
                        break;
                    }
                    case 1: {
                        LogUtils.logDebugO(true, "AnalyticsFrequency Low: 5000");
                        AnalyticsThread.INTERVAL_TIME = 5000;
                        SubWidgetAnalyticsThread.INTERVAL_TIME = 5000;
                        break;
                    }
                }
            }
        };
        this.fastAnalytics();
        Looper.loop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fastAnalytics() {
        Thread thread;
        if (this.handler != null) {
            this.handler.removeMessages(1);
            this.handler.sendEmptyMessage(0);
            this.handler.sendEmptyMessageDelayed(1, 15000L);
        }
        if (AnalyticsAgent.analyticsThread != null) {
            thread = AnalyticsAgent.analyticsThread;
            synchronized (thread) {
                try {
                    AnalyticsAgent.analyticsThread.notify();
                }
                catch (Exception e) {
                    LogUtils.oe("analyticsThreadAlterTime", e);
                }
            }
        }
        if (AnalyticsAgent.subWidgetReportThread != null) {
            thread = AnalyticsAgent.subWidgetReportThread;
            synchronized (thread) {
                try {
                    AnalyticsAgent.subWidgetReportThread.notify();
                }
                catch (Exception e) {
                    LogUtils.oe("subWidgetReportThreadAlterTime", e);
                }
            }
        }
    }

    @Override
    public void interrupt() {
        super.interrupt();
        if (this.handler != null) {
            this.handler.removeMessages(0);
            this.handler.removeMessages(1);
        }
        alterAnalyTime = null;
    }

    public static void finish() {
        if (alterAnalyTime != null) {
            alterAnalyTime.interrupt();
        }
    }
}

