/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.dialog;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.text.TextUtils;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexemm.EUExEMM;
import org.zywx.wbpalmstar.plugin.uexemm.dialog.AppUpgradeDialog;
import org.zywx.wbpalmstar.plugin.uexemm.dialog.NewAppButtonClick;
import org.zywx.wbpalmstar.plugin.uexemm.emm.EMMAgent;
import org.zywx.wbpalmstar.plugin.uexemm.emm.EMMThread;
import org.zywx.wbpalmstar.plugin.uexemm.privatevo.EMMStartReportResVO;
import org.zywx.wbpalmstar.plugin.uexemm.utils.EMMUtils;
import org.zywx.wbpalmstar.plugin.uexemm.vo.EMMWWidgetData;

public class EmmDialog {
    private static ProgressDialog eraseDataDialog = null;

    public static void showMAMFail(Context context, EMMWWidgetData wData) {
        EmmDialog.showMAMFail(context, wData, 0, EUExUtil.getString((String)"plugin_uexemm_network_error_msg"), null, false);
    }

    public static void showMAMFail(Context context, String errMsg, EUExEMM.EMMHandler handler, EMMWWidgetData wData, boolean isAutoReport) {
        EmmDialog.showMAMFail(context, wData, 1, errMsg, handler, isAutoReport);
    }

    private static void showMAMFail(final Context context, final EMMWWidgetData wData, final int errorType, final String errMsg, final EUExEMM.EMMHandler handler, final boolean isAutoReport) {
        if (context instanceof Activity) {
            Activity uiThread = (Activity)context;
            Runnable showDialog = new Runnable(){

                @Override
                public void run() {
                    String positiveBtnText = wData.m_wgtType == 0 ? EUExUtil.getString((String)"plugin_uexemm_exit_app") : EUExUtil.getString((String)"plugin_uexemm_exit_sub_app");
                    String title = "";
                    String negativeBtnText = "";
                    if (errorType == 0) {
                        negativeBtnText = EUExUtil.getString((String)"plugin_uexemm_continue");
                        title = EUExUtil.getString((String)"plugin_uexemm_network_error_title");
                    } else {
                        negativeBtnText = EUExUtil.getString((String)"plugin_uexemm_retry");
                        title = EUExUtil.getString((String)"plugin_uexemm_warning_title");
                    }
                    AlertDialog.Builder builder = new AlertDialog.Builder(context);
                    final String showMsg = TextUtils.isEmpty((CharSequence)errMsg) ? EUExUtil.getString((String)"plugin_uexemm_mamfail_msg") : errMsg;
                    builder.setMessage((CharSequence)showMsg).setTitle((CharSequence)title).setCancelable(false).setPositiveButton((CharSequence)positiveBtnText, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int id) {
                            dialog.dismiss();
                            if (wData.m_wgtType == 0) {
                                Process.killProcess((int)Process.myPid());
                            } else {
                                EMMAgent.getInstance().finishWidget(showMsg, wData.m_appId);
                            }
                        }
                    }).setNegativeButton((CharSequence)negativeBtnText, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int id) {
                            dialog.dismiss();
                            if (1 == errorType) {
                                EMMAgent.getInstance().widgetStartup(context, wData, handler, isAutoReport);
                            }
                        }
                    }).show();
                }
            };
            uiThread.runOnUiThread(showDialog);
        }
    }

    public static void showExitAppDialog(final Context mContext, final EMMWWidgetData data, final String text) {
        if (mContext instanceof Activity) {
            Activity uiThread = (Activity)mContext;
            Runnable showDialog = new Runnable(){

                @Override
                public void run() {
                    String positiveBtnText = data.m_wgtType == 0 ? EUExUtil.getString((String)"plugin_uexemm_exit_app") : EUExUtil.getString((String)"plugin_uexemm_exit_sub_app");
                    AlertDialog.Builder builder = new AlertDialog.Builder(mContext);
                    builder.setMessage((CharSequence)text).setCancelable(false).setPositiveButton((CharSequence)positiveBtnText, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int id) {
                            dialog.dismiss();
                            if (data.m_wgtType == 0) {
                                Process.killProcess((int)Process.myPid());
                            } else {
                                EMMAgent.getInstance().finishWidget(text, data.m_appId);
                            }
                        }
                    }).show();
                }
            };
            uiThread.runOnUiThread(showDialog);
        }
    }

    public static void showEraseDataDialog(final Context mContext, final String text) {
        if (mContext instanceof Activity) {
            Activity uiThread = (Activity)mContext;
            Runnable showDialog = new Runnable(){

                @Override
                public void run() {
                    eraseDataDialog = new ProgressDialog(mContext);
                    eraseDataDialog.setProgressStyle(0);
                    eraseDataDialog.setCancelable(false);
                    eraseDataDialog.setMessage((CharSequence)text);
                    eraseDataDialog.show();
                }
            };
            uiThread.runOnUiThread(showDialog);
        }
    }

    public static void dismissEraseDataDialog() {
        if (eraseDataDialog != null && eraseDataDialog.isShowing()) {
            eraseDataDialog.dismiss();
            eraseDataDialog = null;
        }
    }

    public static void showNewAppDialog(final Context mContext, final EMMStartReportResVO emmStatus, final EMMThread thread, final EMMWWidgetData mCurWData) {
        if (mContext instanceof Activity) {
            Activity uiThread = (Activity)mContext;
            Runnable showDialog = new Runnable(){

                @Override
                @SuppressLint(value={"NewApi"})
                public void run() {
                    String updateInfoMsg = emmStatus.updateHints;
                    if (updateInfoMsg == null || updateInfoMsg.trim().length() == 0) {
                        updateInfoMsg = EUExUtil.getString((String)"plugin_uexemm_new_app_default_prompt");
                    }
                    String positiveBtnText = EUExUtil.getString((String)"plugin_uexemm_update_now");
                    String negativeBtnText = EUExUtil.getString((String)"plugin_uexemm_update_later");
                    if ("true".equals(emmStatus.forceUpdate)) {
                        negativeBtnText = EUExUtil.getString((String)"plugin_uexemm_exit_app");
                    }
                    EMMUtils.AppInfo appInfo = EMMUtils.getAppInfo(mContext);
                    AppUpgradeDialog dialog = new AppUpgradeDialog(mContext);
                    dialog.setIcon(appInfo.appIcon);
                    dialog.setTitle(appInfo.appName);
                    dialog.setMsg(updateInfoMsg);
                    dialog.setRightButtonText(positiveBtnText);
                    dialog.setRightButtonOnClickListener(new NewAppButtonClick(0, mContext, mCurWData, emmStatus, thread, dialog));
                    dialog.setLeftButtonText(negativeBtnText);
                    dialog.setLeftButtonOnClickListener(new NewAppButtonClick(1, mContext, mCurWData, emmStatus, thread, dialog));
                    dialog.show();
                }
            };
            uiThread.runOnUiThread(showDialog);
        }
    }

    public static void signatureError(final Context context) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                AlertDialog.Builder dia = new AlertDialog.Builder(context);
                dia.setTitle((CharSequence)EUExUtil.getString((String)"plugin_uexemm_warning_title"));
                dia.setMessage((CharSequence)EUExUtil.getString((String)"plugin_uexemm_app_sign_error_msg"));
                dia.setCancelable(false);
                dia.setPositiveButton((CharSequence)EUExUtil.getString((String)"plugin_uexemm_exit_app"), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        Process.killProcess((int)Process.myPid());
                    }
                });
                dia.create();
                dia.show();
            }
        });
    }
}

