/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.dialog;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ProgressBar;

public class PercentageProgressBar
extends ProgressBar {
    private static final int PERCENTAGE_TEXT_SIZE = 12;
    private String text = "0%";
    private Paint mPaint;

    public PercentageProgressBar(Context context) {
        super(context);
        this.initText();
    }

    public PercentageProgressBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initText();
    }

    public PercentageProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initText();
    }

    public Drawable getProgressDrawable() {
        return super.getProgressDrawable();
    }

    public void setProgressDrawable(Drawable d) {
        super.setProgressDrawable(d);
    }

    public synchronized void setProgress(int progress) {
        this.text = String.valueOf(progress) + "%";
        super.setProgress(progress);
    }

    public synchronized void setSecondaryProgress(int secondaryProgress) {
        super.setSecondaryProgress(secondaryProgress);
    }

    public synchronized int getProgress() {
        return super.getProgress();
    }

    public synchronized int getSecondaryProgress() {
        return super.getSecondaryProgress();
    }

    public synchronized int getMax() {
        return super.getMax();
    }

    public synchronized void setMax(int max) {
        super.setMax(max);
    }

    private int sp2px(Context context, float spValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(spValue * scale + 0.5f);
    }

    private void initText() {
        this.mPaint = new Paint();
        this.mPaint.setColor(-1);
        this.mPaint.setTextSize((float)this.sp2px(this.getContext(), 12.0f));
        this.mPaint.setAntiAlias(true);
    }

    protected synchronized void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Rect rect = new Rect();
        this.mPaint.getTextBounds(this.text, 0, this.text.length(), rect);
        int x = this.getWidth() / 2 - rect.centerX();
        int y = this.getHeight() / 2 - rect.centerY();
        canvas.drawText(this.text, (float)x, (float)y, this.mPaint);
    }
}

