/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.emm;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import java.io.File;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexemm.EUExEMM;
import org.zywx.wbpalmstar.plugin.uexemm.analytics.AnalyticsAgent;
import org.zywx.wbpalmstar.plugin.uexemm.analytics.AnalyticsThread;
import org.zywx.wbpalmstar.plugin.uexemm.analytics.SubWidgetAnalyticsThread;
import org.zywx.wbpalmstar.plugin.uexemm.dialog.EmmDialog;
import org.zywx.wbpalmstar.plugin.uexemm.dialog.QueryUserCertDialog;
import org.zywx.wbpalmstar.plugin.uexemm.emm.EMMAgent;
import org.zywx.wbpalmstar.plugin.uexemm.encryption.MD5Encryption;
import org.zywx.wbpalmstar.plugin.uexemm.http.EMMHttpURLConnection;
import org.zywx.wbpalmstar.plugin.uexemm.http.EMMURLMgr;
import org.zywx.wbpalmstar.plugin.uexemm.privatevo.EMMStartReportResVO;
import org.zywx.wbpalmstar.plugin.uexemm.privatevo.WidgetStartUpVO;
import org.zywx.wbpalmstar.plugin.uexemm.upgrade.widgetpatch.WidgetPatchUpdate;
import org.zywx.wbpalmstar.plugin.uexemm.utils.DeviceInfo;
import org.zywx.wbpalmstar.plugin.uexemm.utils.EMMDataMgr;
import org.zywx.wbpalmstar.plugin.uexemm.utils.EMMTokenUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.EMMUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.FileUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.GrayRelease;
import org.zywx.wbpalmstar.plugin.uexemm.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.NetworkUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.SafetyVerify;
import org.zywx.wbpalmstar.plugin.uexemm.utils.SharedPrefUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.SystemTime;
import org.zywx.wbpalmstar.plugin.uexemm.vo.AppCanCertVO;
import org.zywx.wbpalmstar.plugin.uexemm.vo.EMMWWidgetData;

public class EMMThread
extends Thread {
    private static Context mContext;
    private int mThreadType;
    private EUExEMM.EMMHandler mHandler;
    private JSONObject mJsonData;
    private AppCanCertVO mCertInfo;
    private EMMWWidgetData mCurWData;
    private String mAppId;
    private boolean isWaitingForUpdate = false;
    private boolean isAutoReport;
    private static BroadcastReceiver mReceiver;
    private static boolean urlHasInit;

    static {
        urlHasInit = false;
    }

    private EMMThread(Context inActivity, EUExEMM.EMMHandler handler, EMMWWidgetData wData, int threadType) {
        if (!urlHasInit) {
            String emmHost = EMMUtils.getEMMHost(inActivity);
            EMMURLMgr.initUrl(emmHost);
            urlHasInit = true;
        }
        this.mThreadType = threadType;
        mContext = inActivity;
        this.mHandler = handler;
        this.mAppId = wData.m_appId;
        this.mCurWData = wData;
    }

    public static EMMThread getGetDataThread(Context inActivity, EUExEMM.EMMHandler handler, EMMWWidgetData wData, int threadType) {
        LogUtils.logDebug(true, "getGetDataThread");
        EMMThread thread = new EMMThread(inActivity, handler, wData, threadType);
        return thread;
    }

    public static EMMThread getPostThread(Context inActivity, EUExEMM.EMMHandler handler, EMMWWidgetData wData, int threadType, JSONObject jsonData) {
        return EMMThread.getPostThread(inActivity, handler, wData, threadType, jsonData, null);
    }

    public static EMMThread getPostThread(Context inActivity, EUExEMM.EMMHandler handler, EMMWWidgetData wData, int threadType, JSONObject jsonData, AppCanCertVO mCertInfo) {
        LogUtils.logDebug(true, "getPostThread");
        EMMThread thread = new EMMThread(inActivity, handler, wData, threadType);
        thread.mJsonData = jsonData;
        thread.mCertInfo = mCertInfo;
        return thread;
    }

    public static EMMThread getGetCertDataThread(Context inActivity, EUExEMM.EMMHandler handler, EMMWWidgetData wData, int threadType, AppCanCertVO mCertInfo) {
        LogUtils.logDebug(true, "getGetCertDataThread");
        EMMThread thread = new EMMThread(inActivity, handler, wData, threadType);
        thread.mCertInfo = mCertInfo;
        return thread;
    }

    public static EMMThread widgetStartupThread(final Context inActivity, EUExEMM.EMMHandler handler, final EMMWWidgetData wData, int threadType, boolean isAutoReport) {
        LogUtils.logDebug(true, "widgetStartupThread");
        EMMThread thread = new EMMThread(inActivity, handler, wData, threadType);
        thread.isAutoReport = isAutoReport;
        thread.mCurWData = wData;
        if (wData.m_wgtType != 0) {
            mReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    if (intent == null) {
                        return;
                    }
                    if (context.getPackageName().equals(intent.getPackage())) {
                        try {
                            String appId = intent.getStringExtra("appId");
                            String type = intent.getStringExtra("type");
                            LogUtils.logDebug(true, "SubWidgetAnalyticsThread OnReceive: " + appId + " type" + type);
                            if (intent != null && wData.m_appId.equals(appId)) {
                                "updateCancelled".equals(type);
                                if ("doUpdateWithConfirm".equals(type)) {
                                    EMMThread.stopSelf();
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (mReceiver != null) {
                            inActivity.unregisterReceiver(mReceiver);
                            mReceiver = null;
                        }
                    }
                }
            };
            IntentFilter filter = new IntentFilter();
            filter.addAction("org.zywx.emm.widgetupdate.event.ack.action");
            inActivity.registerReceiver(mReceiver, filter);
        }
        return thread;
    }

    public static void stopSelf() {
        if (mReceiver != null) {
            mContext.unregisterReceiver(mReceiver);
            mReceiver = null;
        }
    }

    public void setIsWaitingForUpdate(boolean value) {
        this.isWaitingForUpdate = value;
    }

    private CheckWidgetVO checkEmmStatus(EMMStartReportResVO emmStatus, int errorCode) {
        CheckWidgetVO result = new CheckWidgetVO();
        if (EMMAgent.getAppStatus().isForceConnected) {
            if ("error".equals(emmStatus.status)) {
                String errorMsg = "";
                errorMsg = TextUtils.isEmpty((CharSequence)emmStatus.info) || emmStatus.info.equalsIgnoreCase("error") ? EUExUtil.getString((String)"exit_message_appid") : emmStatus.info;
                this.handleReportStatusError(mContext, this.mCurWData, errorMsg, errorCode);
                result.status = false;
                result.info = errorMsg;
            }
        } else {
            Log.w((String)"EMM MainWidgetReport", (String)"Verify Cancelled ===Error Network");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mainWidgetCheckUpdate(Context mContext, EMMStartReportResVO emmStatus) {
        boolean isShowUpgrade;
        boolean bl = isShowUpgrade = this.isAutoReport ? EMMAgent.getEMMConfig().isShowUpgradeAuto : EMMAgent.getEMMConfig().isShowUpgradeManual;
        if (!(TextUtils.isEmpty((CharSequence)emmStatus.newAppUrl) || "false".equals(emmStatus.forceUpdate) && "false".equals(emmStatus.needConfirm) || !isShowUpgrade)) {
            this.isWaitingForUpdate = true;
            GrayRelease.saveGrayReleaseStrategyId(mContext, emmStatus, this.mCurWData.m_appId);
            if ("patch".equals(emmStatus.pkgType)) {
                if (EMMAgent.getAppStatus().isPatchUpdate) {
                    WidgetPatchUpdate.updateWidget(mContext, emmStatus, this, this.mHandler, this.mCurWData);
                } else {
                    LogUtils.logDebugO(true, "emm patch updata, but isPatchUpdate is false!");
                    this.isWaitingForUpdate = false;
                }
            } else {
                EmmDialog.showNewAppDialog(mContext, emmStatus, this, this.mCurWData);
            }
            EMMThread eMMThread = this;
            synchronized (eMMThread) {
                if (this.isWaitingForUpdate) {
                    LogUtils.logDebugO(true, "waitingForWidgetUpdateFiles");
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void subWidgetCheckUpdate(Context context, String reportResult, EMMStartReportResVO emmStatus, int errorCode) {
        if (EMMUtils.isAppStorePluginExist(context)) {
            Intent intent = new Intent("org.zywx.emm.widgetupdate.event.action");
            intent.putExtra("updateInfo", reportResult);
            intent.putExtra("updateAppId", this.mCurWData.m_appId);
            intent.putExtra("isCheckAppStatus", EMMAgent.getAppStatus().widgetStatus);
            intent.setPackage(mContext.getPackageName());
            mContext.sendBroadcast(intent);
            LogUtils.logDebug(true, "emm startUp result:" + reportResult);
        } else if (EMMAgent.getAppStatus().widgetStatus) {
            this.checkWidgetStatus(emmStatus, errorCode);
        }
    }

    private CheckWidgetVO checkWidgetStatus(EMMStartReportResVO emmStatus, int errorCode) {
        CheckWidgetVO result = new CheckWidgetVO();
        if ("000".equals(emmStatus.widgetStatus)) {
            String errorMsg = "";
            errorMsg = TextUtils.isEmpty((CharSequence)emmStatus.closeHints) || emmStatus.closeHints.equalsIgnoreCase("error") ? EUExUtil.getString((String)"exit_message_server") : emmStatus.closeHints;
            this.handleReportStatusError(mContext, this.mCurWData, errorMsg, errorCode);
            result.status = false;
            result.info = errorMsg;
        }
        return result;
    }

    private void handleReportStatusError(Context context, EMMWWidgetData mEmmwWidgetData, String errorMsg, int errorCode) {
        if (errorCode != -3 || EMMAgent.getEMMConfig().isExitApp) {
            EmmDialog.showExitAppDialog(mContext, this.mCurWData, errorMsg);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int parseStartReportResult(Context context, WidgetStartUpVO widgetStartUpInfo, String baseMsg, String url, int retryTime) {
        int errorCode;
        int ret;
        block18: {
            boolean isReportSuccess = false;
            ret = 1;
            String result = widgetStartUpInfo.getResult();
            errorCode = widgetStartUpInfo.getErrorCode();
            if (TextUtils.isEmpty((CharSequence)result)) break block18;
            try {
                String spName;
                EMMStartReportResVO emmStatus;
                block20: {
                    block19: {
                        emmStatus = null;
                        if (EMMUtils.isWidgetStartRepotSuccess(errorCode)) {
                            emmStatus = EMMDataMgr.parseStartReportJsonResult(result);
                        }
                        isReportSuccess = emmStatus != null;
                        EMMUtils.saveWidgetReportResult(context, this.mCurWData, result);
                        if (!isReportSuccess) {
                            widgetStartUpInfo.setErrorCode(-1);
                            if (-2 == errorCode) return ret;
                            this.checkIsForceConnected(context, errorCode, result);
                            return ret;
                        }
                        boolean isCopyAssetsFinish = false;
                        if ("true".equals(emmStatus.eraseData)) {
                            EmmDialog.showEraseDataDialog(context, EUExUtil.getString((String)"plugin_uexemm_erase_data_msg"));
                            int what = -1;
                            if (this.mCurWData.m_wgtType == 0) {
                                isCopyAssetsFinish = SharedPrefUtils.getBoolean(mContext, "widgetOneConfig", "copyAssetsFinish", false);
                                FileUtils.eraseMainAppData(context, this.mCurWData.m_widgetPath);
                                SharedPrefUtils.putBoolean(mContext, "widgetOneConfig", "copyAssetsFinish", isCopyAssetsFinish);
                                what = 28;
                            } else {
                                FileUtils.eraseSubAppData(context, this.mCurWData.m_appId);
                                what = 29;
                            }
                            SharedPrefUtils.putString(mContext, "app", "erased_data_flg", "true");
                            this.mHandler.sendMessageDelayed(this.mCurWData.m_appId, what, 3000);
                            return 2;
                        }
                        SharedPrefUtils.putString(mContext, "app", "erased_data_flg", "false");
                        SharedPrefUtils.putBoolean(mContext, "app", "enableScreenshot", emmStatus.enableScreenShot);
                        EMMUtils.saveWidgetStatus(context, emmStatus, baseMsg, url, this.mCurWData);
                        CheckWidgetVO cWidgetVO = this.checkEmmStatus(emmStatus, errorCode);
                        if (!cWidgetVO.status) {
                            widgetStartUpInfo.setResult(cWidgetVO.info);
                            return ret;
                        }
                        spName = "saveData";
                        if (this.mCurWData.m_wgtType != 0) {
                            spName = String.valueOf(spName) + this.mCurWData.m_appId;
                        }
                        if (this.mCurWData.m_wgtType == 0) {
                            String localPushMes = "1";
                            if (!EMMAgent.getAppStatus().widgetPush) {
                                emmStatus.pushMes = "0";
                            }
                            SharedPrefUtils.putString(mContext, spName, "pushMes", emmStatus.pushMes);
                            localPushMes = SharedPrefUtils.getString(mContext, spName, "localPushMes", emmStatus.pushMes);
                            int pushMes = "1".equals(emmStatus.pushMes) && "1".equals(localPushMes) ? 1 : 0;
                            Intent myIntent = new Intent();
                            ComponentName cnName = new ComponentName("org.zywx.wbpalmstar.platform.push", "org.zywx.wbpalmstar.platform.push.PushService");
                            myIntent.setComponent(cnName);
                            myIntent.putExtra("type", pushMes);
                            context.startService(myIntent);
                        }
                        if (this.mCurWData.m_wgtType != 0) break block19;
                        if (EMMAgent.getAppStatus().appUpdate) {
                            this.mainWidgetCheckUpdate(context, emmStatus);
                        }
                        if (EMMAgent.checkAppStatus && EMMAgent.getAppStatus().widgetStatus) {
                            CheckWidgetVO checkWidgetVO = this.checkWidgetStatus(emmStatus, errorCode);
                            if (!checkWidgetVO.status) {
                                widgetStartUpInfo.setResult(checkWidgetVO.info);
                            }
                        }
                        break block20;
                    }
                    this.subWidgetCheckUpdate(context, result, emmStatus, errorCode);
                }
                LogUtils.logDebug(true, "widgetstartreport finish");
                if (!EMMAgent.getAppStatus().widgetParam) {
                    LogUtils.logDebugO(true, "widgetParam is close, so appParam will set null!");
                    emmStatus.appParam = "";
                }
                SharedPrefUtils.putString(mContext, spName, "appParam", emmStatus.appParam);
                if (EMMAgent.mStartResultListener != null) {
                    EMMAgent.mStartResultListener.disablePlugins(mContext, this.mCurWData.m_wgtType, emmStatus.widgetPlugins, spName);
                    EMMAgent.mStartResultListener.disableWindows(mContext, this.mCurWData.m_wgtType, emmStatus.widgetWnds, spName);
                }
                if (!EMMAgent.getAppStatus().widgetAnalytics) return ret;
                if (TextUtils.isEmpty((CharSequence)emmStatus.reportMethod)) return ret;
                if (this.mCurWData.m_wgtType == 0) {
                    if (AnalyticsAgent.analyticsThread != null) return ret;
                    AnalyticsAgent.analyticsThread = new AnalyticsThread(mContext, this.mCurWData, Integer.valueOf(emmStatus.reportMethod));
                    AnalyticsAgent.analyticsThread.start();
                    return ret;
                }
                if (AnalyticsAgent.subWidgetReportThread != null) {
                    AnalyticsAgent.subWidgetReportThread.stopSelf();
                    AnalyticsAgent.subWidgetReportThread = null;
                }
                AnalyticsAgent.subWidgetReportThread = new SubWidgetAnalyticsThread(this.mCurWData, mContext, Integer.valueOf(emmStatus.reportMethod));
                AnalyticsAgent.subWidgetReportThread.start();
                return ret;
            }
            catch (Exception e) {
                e.printStackTrace();
                LogUtils.oe("Emm Verify Cancelled : Error Network", e);
                this.checkIsForceConnected(context, errorCode, EUExUtil.getString((String)"plugin_uexemm_mamfail_msg"));
                return ret;
            }
        }
        widgetStartUpInfo.setErrorCode(-1);
        if (retryTime < 3) return 0;
        this.checkIsForceConnected(context, errorCode, EUExUtil.getString((String)"plugin_uexemm_mamfail_msg"));
        return ret;
    }

    private void widgetStartup(String softToken) {
        LogUtils.logDebug(true, "widgetStartup widget type = " + this.mCurWData.m_wgtType);
        if (EMMAgent.getAppStatus().isForceConnected && !NetworkUtils.isNetworkAvailable(mContext)) {
            EmmDialog.showMAMFail(mContext, this.mCurWData);
            return;
        }
        String baseMsg = "";
        WidgetStartUpVO widgetStartUpInfo = new WidgetStartUpVO();
        int reportRet = 0;
        String url = "";
        int retryTimes = 0;
        EMMWWidgetData startAuthData = this.mCurWData.m_wgtType == 0 ? EMMAgent.s_rootWgt : this.mCurWData;
        do {
            url = EMMURLMgr.getUrlStartReport();
            ++retryTimes;
            url = String.valueOf(url) + softToken;
            baseMsg = SafetyVerify.getStartAuthorizeMsgEx(mContext, startAuthData);
            String result = EMMHttpURLConnection.sendPostRequestByStream(mContext, this.mCurWData, url, baseMsg).getResult();
            widgetStartUpInfo.setResult(result);
            widgetStartUpInfo.setErrorCode(0);
            if (this.mCurWData.m_wgtType != 0) continue;
            this.checkRoot();
        } while ((reportRet = this.parseStartReportResult(mContext, widgetStartUpInfo, baseMsg, url, retryTimes)) == 0 && retryTimes < 3);
        String stringError = AnalyticsAgent.getError(mContext);
        if (!TextUtils.isEmpty((CharSequence)stringError)) {
            String res = EMMHttpURLConnection.sendPostRequestByStream(mContext, this.mCurWData, String.valueOf(EMMURLMgr.getUrlErrorReport()) + EMMTokenUtils.getSoftToken(mContext, this.mCurWData), stringError).getResult();
            LogUtils.logDebug(true, "error res == " + res);
        }
        if (2 != reportRet && this.mCurWData.m_wgtType == 0) {
            this.mainWidgetStartReportComplete(this.isAutoReport, widgetStartUpInfo);
        }
    }

    private void checkIsForceConnected(Context mContext, int errorCode, String errMsg) {
        if (EMMAgent.getAppStatus().isForceConnected) {
            if (errorCode != -3 || EMMAgent.getEMMConfig().isExitApp) {
                EmmDialog.showMAMFail(mContext, errMsg, this.mHandler, this.mCurWData, this.isAutoReport);
            }
        } else {
            LogUtils.logError("Emm Verify fail, but ForceConnected: false.So you can enter the app.");
            LogUtils.logDebugO(true, "Emm Verify fail, but ForceConnected: false.So you can enter the app.");
        }
    }

    private void mainWidgetStartReportComplete(boolean isAutoReport, WidgetStartUpVO widgetStartUpInfo) {
        JSONObject json = new JSONObject();
        int what = isAutoReport ? 22 : 23;
        try {
            int errorCode = widgetStartUpInfo.getErrorCode();
            if (errorCode == 0) {
                json.put("status", (Object)"ok");
            } else {
                json.put("status", (Object)"fail");
                JSONObject errorJson = new JSONObject();
                errorJson.put("errorCode", errorCode);
                errorJson.put("errorInfo", (Object)widgetStartUpInfo.getResult());
                json.put("info", (Object)errorJson);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        LogUtils.logDebug(true, "mainWidgetStartReportComplete");
        EMMAgent.getInstance().getEUExEMMInstance().onJsCallback(what, json.toString());
    }

    private void checkRoot() {
        if (EMMAgent.getAppStatus().checkRoot && DeviceInfo.deviceBeRoot()) {
            EmmDialog.showExitAppDialog(mContext, this.mCurWData, EUExUtil.getString((String)"plugin_uexemm_not_root_prompt"));
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Process.killProcess((int)Process.myPid());
        }
    }

    @Override
    public void run() {
        LogUtils.logDebug(true, "Thread " + this.mThreadType);
        Process.setThreadPriority((int)10);
        String result = null;
        String accessToken = null;
        String softToken = EMMTokenUtils.getSoftToken(mContext, this.mCurWData);
        switch (this.mThreadType) {
            case 0: {
                this.widgetStartup(softToken);
                break;
            }
            case 1: {
                String url = EMMURLMgr.getUrlGetLoginProperty();
                url = url.replace("{appId}", this.mAppId);
                result = EMMHttpURLConnection.sendGetRequest(mContext, this.mCurWData, url).getResult();
                this.mHandler.send2Callback(result, 1);
                break;
            }
            case 2: {
                result = EMMHttpURLConnection.sendPostRequestByFrom(mContext, this.mCurWData, EMMURLMgr.getUrlRegist(), this.mJsonData, false).getResult();
                this.mHandler.send2Callback(result, 2);
                break;
            }
            case 3: {
                boolean isCaAuth = false;
                String urlLogin = "";
                if (this.mCertInfo != null) {
                    isCaAuth = this.mCertInfo.isCaAuth;
                }
                urlLogin = isCaAuth ? String.valueOf(this.mCertInfo.caUrl) + EMMURLMgr.getUrlLoginInterface() : EMMURLMgr.getUrlLogin();
                urlLogin = String.valueOf(urlLogin) + softToken;
                result = EMMHttpURLConnection.sendPostRequestByFrom(mContext, this.mCurWData, urlLogin, this.mJsonData, isCaAuth).getResult();
                accessToken = EMMDataMgr.parseValueFromV3Result(result, "accessToken");
                EMMTokenUtils.saveAccessToken(mContext, this.mAppId, accessToken);
                this.mHandler.send2Callback(result, 3);
                break;
            }
            case 11: {
                String urlChangePwd = EMMURLMgr.getUrlChangePassword();
                urlChangePwd = String.valueOf(urlChangePwd) + softToken;
                result = EMMHttpURLConnection.sendPostRequestByFrom(mContext, this.mCurWData, urlChangePwd, this.mJsonData, false).getResult();
                this.mHandler.send2Callback(result, 19);
                break;
            }
            case 4: {
                String urlSSLogin = EMMURLMgr.getUrlSSLogin();
                urlSSLogin = String.valueOf(urlSSLogin) + softToken;
                result = EMMHttpURLConnection.sendPostRequestByFrom(mContext, this.mCurWData, urlSSLogin, this.mJsonData, false).getResult();
                accessToken = EMMDataMgr.parseAccessToken(result);
                EMMTokenUtils.saveAccessToken(mContext, this.mAppId, accessToken);
                this.mHandler.send2Callback(result, 4);
                break;
            }
            case 5: {
                String urlUserRelation = EMMURLMgr.getUrlBindUserRelation();
                urlUserRelation = String.valueOf(urlUserRelation) + softToken;
                result = EMMHttpURLConnection.sendPostRequestByFrom(mContext, this.mCurWData, urlUserRelation, this.mJsonData, false).getResult();
                accessToken = EMMDataMgr.parseAccessToken(result);
                EMMTokenUtils.saveAccessToken(mContext, this.mAppId, accessToken);
                this.mHandler.send2Callback(result, 5);
                break;
            }
            case 6: {
                String urlValCode = String.valueOf(EMMURLMgr.getUrlValidateCode()) + softToken;
                result = EMMHttpURLConnection.sendPostRequestByFrom(mContext, this.mCurWData, urlValCode, this.mJsonData, false).getResult();
                this.mHandler.send2Callback(result, 6);
                break;
            }
            case 7: {
                String urlBindOther = String.valueOf(EMMURLMgr.getUrlBoundOtherInfo()) + softToken;
                result = EMMHttpURLConnection.sendPostRequestByFrom(mContext, this.mCurWData, urlBindOther, this.mJsonData, false).getResult();
                this.mHandler.send2Callback(result, 7);
                break;
            }
            case 8: {
                String urlBindCode = String.valueOf(EMMURLMgr.getUrlValidateBindCode()) + softToken;
                result = EMMHttpURLConnection.sendPostRequestByFrom(mContext, this.mCurWData, urlBindCode, this.mJsonData, false).getResult();
                this.mHandler.send2Callback(result, 8);
                break;
            }
            case 9: {
                String urlLogout = EMMURLMgr.getUrlLogout();
                urlLogout = String.valueOf(urlLogout) + softToken;
                result = EMMHttpURLConnection.sendPostRequestByFrom(mContext, this.mCurWData, urlLogout, this.mJsonData, false).getResult();
                this.mHandler.send2Callback(result, 9);
                break;
            }
            case 10: {
                String urlVerifImage = EMMURLMgr.getUrlGetVerificationImage();
                urlVerifImage = String.valueOf(urlVerifImage) + softToken;
                File path = mContext.getExternalCacheDir();
                LogUtils.logDebugO(true, urlVerifImage);
                String fileName = "verify" + System.currentTimeMillis() + ".jpg";
                File imageFile = new File(path, fileName);
                boolean isSuccess = EMMHttpURLConnection.getNetworkFile(mContext, this.mCurWData, urlVerifImage, this.mJsonData, "application/x-www-form-urlencoded", "POST", imageFile);
                JSONObject json = new JSONObject();
                try {
                    json.put("status", (Object)(isSuccess ? "ok" : "fail"));
                    JSONObject infoObj = new JSONObject();
                    infoObj.put("imagePath", (Object)imageFile.getAbsolutePath());
                    json.put("info", isSuccess ? infoObj : "");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                result = json.toString();
                System.out.println(result);
                result = result.replaceAll("\\\\", "");
                System.out.println(result);
                this.mHandler.send2Callback(result, 14);
                break;
            }
            case 12: {
                if (this.mCertInfo == null) break;
                this.showQueryUserCertDialog(mContext);
                break;
            }
            case 13: {
                String urlRelease = EMMURLMgr.getUrlReleaseUserRelation();
                urlRelease = String.valueOf(urlRelease) + softToken;
                result = EMMHttpURLConnection.sendPostRequestByFrom(mContext, this.mCurWData, urlRelease, this.mJsonData, false).getResult();
                if (!TextUtils.isEmpty((CharSequence)result)) {
                    result = EMMDataMgr.changeToV3Result(result);
                }
                this.mHandler.send2Callback(result, 25);
                break;
            }
            default: {
                LogUtils.logDebug(true, "unknown threadType");
            }
        }
    }

    private void showQueryUserCertDialog(final Context context) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                final QueryUserCertDialog dialog = new QueryUserCertDialog(context, EUExUtil.getResStyleID((String)"plugin_emm_query_user_cert_style"));
                WindowManager.LayoutParams lp = dialog.getWindow().getAttributes();
                lp.width = -1;
                lp.height = -1;
                EMMThread.setParams(context, (ViewGroup.LayoutParams)lp);
                dialog.setCanceledOnTouchOutside(true);
                dialog.setOnDialogButtonClickListener(new QueryUserCertDialog.OnDialogButtonClickListener(){

                    @Override
                    public void onDialogButtonClick(View v, String chechCode) {
                        if (EUExUtil.getResIdID((String)"plugin_uexemm_query_ueser_cert_btn") == v.getId()) {
                            EMMThread.this.queryUserCert(chechCode);
                            dialog.dismiss();
                        }
                    }
                });
                dialog.show();
            }
        });
    }

    private static void setParams(Context context, ViewGroup.LayoutParams lay) {
        DisplayMetrics dm = new DisplayMetrics();
        ((Activity)context).getWindowManager().getDefaultDisplay().getMetrics(dm);
        Rect rect = new Rect();
        View view = ((Activity)context).getWindow().getDecorView();
        view.getWindowVisibleDisplayFrame(rect);
        lay.height = dm.heightPixels - view.getTop();
        lay.width = dm.widthPixels;
    }

    private void queryUserCert(String checkCode) {
        String url = String.valueOf(EMMURLMgr.getUrlQuertyCert()) + checkCode;
        String certPath = "";
        JSONObject jsonRes = new JSONObject();
        boolean flg = true;
        try {
            certPath = mContext.getFilesDir() + "/" + MD5Encryption.getMD5Code(String.valueOf(this.mCertInfo.userName) + SystemTime.getSpecialFormatTime("yyyyMMddhhmmss"));
            File file = new File(certPath);
            if (file.exists()) {
                file.delete();
            }
            if (EMMHttpURLConnection.getNetworkFile(mContext, this.mCurWData, url, "POST", file)) {
                this.mCertInfo.certPath = certPath;
                this.saveCaCert(this.mCertInfo.userName, certPath);
            } else {
                flg = false;
            }
            if (flg) {
                JSONObject json = new JSONObject();
                json.put("certPath", (Object)certPath);
                jsonRes.put("status", (Object)"ok");
                jsonRes.put("info", (Object)json);
            } else {
                jsonRes.put("status", (Object)"fail");
                jsonRes.put("info", (Object)"CA\u8bc1\u4e66\u4e0b\u8f7d\u5931\u8d25");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.mHandler.send2Callback(jsonRes.toString(), 21);
    }

    public void finish() {
        this.interrupt();
        EMMHttpURLConnection.close();
    }

    public void killMyPid() {
        Process.killProcess((int)Process.myPid());
    }

    private void saveCaCert(String loginName, String certPath) {
        if (TextUtils.isEmpty((CharSequence)certPath)) {
            LogUtils.logDebug(true, "CA\u8bc1\u4e66\u8def\u5f84\u4e3a\u7a7a");
            return;
        }
        SharedPrefUtils.putString(mContext, "cert_infor", MD5Encryption.getMD5Code(loginName), certPath);
    }

    class CheckWidgetVO {
        boolean status = true;
        String info = "";

        CheckWidgetVO() {
        }
    }
}

