/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.http;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import org.zywx.wbpalmstar.plugin.uexemm.emm.EMMAgent;
import org.zywx.wbpalmstar.plugin.uexemm.http.Http;
import org.zywx.wbpalmstar.plugin.uexemm.privatevo.HttpRequrstInputVO;
import org.zywx.wbpalmstar.plugin.uexemm.privatevo.HttpRequrstResultVO;
import org.zywx.wbpalmstar.plugin.uexemm.utils.InputStreamUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.LanguageUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.SafetyVerify;
import org.zywx.wbpalmstar.plugin.uexemm.vo.AppCanCertVO;
import org.zywx.wbpalmstar.plugin.uexemm.vo.EMMWWidgetData;

public class EMMHttpURLConnection {
    private static boolean mIsCertificate = false;
    private static String mPassWord = null;
    private static String mPath = null;
    private static List<HttpURLConnection> httpURLConnections = new ArrayList<HttpURLConnection>();
    private static AppCanCertVO mCertInfo = null;

    private static void writeFormByUriEncode(PrintWriter writer, JSONObject json) {
        Iterator it = json.keys();
        String key = "";
        String value = "";
        StringBuffer sbBuffer = new StringBuffer();
        while (it.hasNext()) {
            key = (String)it.next();
            value = json.optString(key);
            if (TextUtils.isEmpty((CharSequence)value)) {
                value = "default";
            }
            sbBuffer.append(EMMHttpURLConnection.uriEncode(key, "")).append("=").append(EMMHttpURLConnection.uriEncode(value, "")).append("&");
        }
        int strLen = sbBuffer.length();
        if (strLen >= 1) {
            sbBuffer.deleteCharAt(strLen - 1);
        }
        writer.append(sbBuffer.toString());
        writer.flush();
        writer.close();
    }

    private static void addHttpURLConnectionHeader(Context context, EMMWWidgetData wData, HttpURLConnection httpConnection, String url, String contentType) {
        String cookie;
        httpConnection.addRequestProperty("Accept", "*/*");
        httpConnection.addRequestProperty("Accept-Language", String.valueOf(LanguageUtils.getLanguage(context)) + ";" + "q=" + 1.0f);
        if (wData != null) {
            httpConnection.setRequestProperty("channel", wData.m_channelCode);
            httpConnection.setRequestProperty("varifyApp", SafetyVerify.getAppVerifyCode(wData));
            httpConnection.setRequestProperty("appverify", SafetyVerify.getAppVerifyCode(wData));
            httpConnection.setRequestProperty("x-mas-app-id", wData.m_appId);
        }
        if (!TextUtils.isEmpty((CharSequence)(cookie = EMMHttpURLConnection.getCookie(url)))) {
            httpConnection.setRequestProperty("Cookie", cookie);
        }
        if (!TextUtils.isEmpty((CharSequence)contentType)) {
            httpConnection.setRequestProperty("Content-Type", contentType);
        }
    }

    private static void setHttpRequestConfig(Context context, EMMWWidgetData wData, String url, HttpURLConnection httpConnection, HttpRequrstInputVO inputVO, String requestMethod) {
        String contentType = inputVO.getContentType();
        EMMHttpURLConnection.addHttpURLConnectionHeader(context, wData, httpConnection, url, contentType);
        String data = "";
        LogUtils.logDebugO(true, "httpRequest header:" + httpConnection.getRequestProperties().toString());
        OutputStream outputStream = null;
        PrintWriter writer = null;
        try {
            try {
                httpConnection.setRequestMethod(requestMethod);
                httpConnection.connect();
                if (inputVO.getDataJson() != null || !TextUtils.isEmpty((CharSequence)inputVO.getDataStr())) {
                    outputStream = httpConnection.getOutputStream();
                    if ("application/x-www-form-urlencoded".equals(contentType)) {
                        writer = new PrintWriter(new OutputStreamWriter(outputStream, "utf-8"));
                        JSONObject dataJson = inputVO.getDataJson();
                        if (dataJson != null) {
                            EMMHttpURLConnection.writeFormByUriEncode(writer, inputVO.getDataJson());
                            data = dataJson.toString();
                        }
                    } else {
                        data = inputVO.getDataStr();
                        if (!TextUtils.isEmpty((CharSequence)data)) {
                            byte[] buffer = data.getBytes();
                            outputStream.write(buffer, 0, buffer.length);
                            outputStream.flush();
                        }
                    }
                }
                LogUtils.logDebugO(true, "httpRequest data:" + data);
            }
            catch (Exception e) {
                LogUtils.oe("sendHttpRequest:" + url + ":", e);
                e.printStackTrace();
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    outputStream = null;
                }
                if (writer != null) {
                    writer.close();
                    writer = null;
                }
            }
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                outputStream = null;
            }
            if (writer != null) {
                writer.close();
                writer = null;
            }
        }
    }

    public static HttpRequrstResultVO sendPostRequestByStream(Context mCtx, EMMWWidgetData wData, String url, String data) {
        return EMMHttpURLConnection.sendHttpRequest(mCtx, wData, url, new HttpRequrstInputVO("application/octet-stream", data, null), "POST", false);
    }

    public static HttpRequrstResultVO sendPostRequestByFrom(Context mCtx, EMMWWidgetData wData, String url, JSONObject jsonData, boolean isCaAuth) {
        return EMMHttpURLConnection.sendHttpRequest(mCtx, wData, url, new HttpRequrstInputVO("application/x-www-form-urlencoded", "", jsonData), "POST", isCaAuth);
    }

    public static HttpRequrstResultVO sendGetRequest(Context mCtx, EMMWWidgetData wData, String url) {
        return EMMHttpURLConnection.sendHttpRequest(mCtx, wData, url, new HttpRequrstInputVO("", "", null), "GET", false);
    }

    private static HttpRequrstResultVO sendHttpRequest(Context mCtx, EMMWWidgetData wData, String url, HttpRequrstInputVO inputVO, String requestMethod, boolean isCaAuth) {
        LogUtils.logDebugO(true, "sendHttpRequest url:" + url);
        HttpURLConnection httpConnection = EMMHttpURLConnection.getHttpURLConnection(mCtx, url, 40000, isCaAuth);
        HttpRequrstResultVO result = new HttpRequrstResultVO();
        if (httpConnection != null) {
            String responseRes = "";
            int responseCode = -1;
            EMMHttpURLConnection.setHttpRequestConfig(mCtx, wData, url, httpConnection, inputVO, requestMethod);
            try {
                try {
                    responseCode = httpConnection.getResponseCode();
                    LogUtils.logDebugO(true, "responseCode = " + responseCode + " url:" + url);
                    responseRes = InputStreamUtils.InputStreamTOString(httpConnection.getInputStream());
                    LogUtils.logDebugO(true, " res:" + responseRes + " url:" + url);
                    EMMHttpURLConnection.handleCookie(mCtx, url, httpConnection.getHeaderFields());
                }
                catch (Exception e) {
                    LogUtils.oe("sendHttpRequest:" + url + ":", e);
                    e.printStackTrace();
                    result.setResult(responseRes);
                    result.setResponseCode(responseCode);
                    try {
                        httpConnection.disconnect();
                        httpConnection = null;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                result.setResult(responseRes);
                result.setResponseCode(responseCode);
                try {
                    httpConnection.disconnect();
                    httpConnection = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            LogUtils.logError("sendHttpRequest get HttpRequrstResult error\uff1a" + url);
        }
        return result;
    }

    public static boolean getNetworkFile(Context mCtx, EMMWWidgetData wData, String url, String requestMethod, File file) {
        return EMMHttpURLConnection.downLoadFile(mCtx, wData, url, new HttpRequrstInputVO("", "", null), requestMethod, file);
    }

    public static boolean getNetworkFile(Context mCtx, EMMWWidgetData wData, String url, JSONObject jsonData, String contentType, String requestMethod, File file) {
        return EMMHttpURLConnection.downLoadFile(mCtx, wData, url, new HttpRequrstInputVO(contentType, "", jsonData), requestMethod, file);
    }

    private static boolean downLoadFile(Context mCtx, EMMWWidgetData wData, String url, HttpRequrstInputVO inputVO, String requestMethod, File file) {
        boolean isSuccess;
        block19: {
            LogUtils.logDebugO(true, "getGetFileData url:" + url);
            isSuccess = false;
            HttpURLConnection httpConnection = EMMHttpURLConnection.getHttpURLConnection(mCtx, url, 40000, false);
            EMMHttpURLConnection.setHttpRequestConfig(mCtx, wData, url, httpConnection, inputVO, requestMethod);
            InputStream in = null;
            try {
                try {
                    int responseCode = httpConnection.getResponseCode();
                    LogUtils.logDebugO(true, "responseCode = " + responseCode);
                    if (200 == responseCode) {
                        in = httpConnection.getInputStream();
                        isSuccess = EMMHttpURLConnection.saveInputStreamToFile(in, file);
                    }
                    EMMHttpURLConnection.handleCookie(mCtx, url, httpConnection.getHeaderFields());
                }
                catch (Exception e) {
                    LogUtils.logDebugO(true, "sendPostJsonData Exception\uff1a" + e.getMessage());
                    e.printStackTrace();
                    try {
                        httpConnection.disconnect();
                        httpConnection = null;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    if (in == null) break block19;
                    try {
                        in.close();
                        in = null;
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    httpConnection.disconnect();
                    httpConnection = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (in != null) {
                    try {
                        in.close();
                        in = null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return isSuccess;
    }

    private static boolean saveInputStreamToFile(InputStream in, File file) {
        boolean isSuccess;
        block14: {
            isSuccess = false;
            FileOutputStream os = null;
            try {
                try {
                    os = new FileOutputStream(file);
                    int len = -1;
                    long fileSize = 0L;
                    byte[] buffer = new byte[4096];
                    while ((len = in.read(buffer, 0, buffer.length)) != -1) {
                        fileSize += (long)len;
                        ((OutputStream)os).write(buffer, 0, len);
                    }
                    os.flush();
                    if (fileSize > 0L) {
                        isSuccess = true;
                        break block14;
                    }
                    LogUtils.logDebugO(true, "getGetFileData fileSize=" + fileSize);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (os == null) break block14;
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (os != null) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return isSuccess;
    }

    private static void handleCookie(Context context, String url, Map<String, List<String>> headers) {
        if (headers != null) {
            List<String> Cookie2;
            List<String> Cookie;
            List<String> setCookies2;
            List<String> setCookies = headers.get("Set-Cookie");
            if (setCookies != null) {
                for (String v : setCookies) {
                    EMMHttpURLConnection.setCookie(url, v);
                }
            }
            if ((setCookies2 = headers.get("Set-Cookie2")) != null) {
                for (String v : setCookies2) {
                    EMMHttpURLConnection.setCookie(url, v);
                }
            }
            if ((Cookie = headers.get("Cookie")) != null) {
                for (String v : Cookie) {
                    EMMHttpURLConnection.setCookie(url, v);
                }
            }
            if ((Cookie2 = headers.get("Cookie2")) != null) {
                for (String v : Cookie2) {
                    EMMHttpURLConnection.setCookie(url, v);
                }
            }
        }
    }

    private static final void setCookie(String inUrl, String cookie) {
        EMMAgent.getInstance().getEUExEMMInstance().setCookie(inUrl, cookie);
    }

    private static final String getCookie(String inUrl) {
        return EMMAgent.getInstance().getEUExEMMInstance().getCookie(inUrl);
    }

    public static void setCertificate(boolean isCertificate, String cPath, String cPassWord, Context ctx) {
        mIsCertificate = isCertificate;
        mPassWord = cPassWord;
        mPath = cPath;
    }

    public static void setAppCanCertificate(AppCanCertVO info) {
        mCertInfo = info;
    }

    public static void close() {
        try {
            for (HttpURLConnection connection : httpURLConnections) {
                if (connection == null) continue;
                connection.disconnect();
                connection = null;
            }
            httpURLConnections.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static HttpURLConnection getHttpURLConnection(Context mCtx, String urlStr, int timeout, boolean isCaAuth) {
        URLConnection httpConnection = null;
        try {
            if (!TextUtils.isEmpty((CharSequence)urlStr)) {
                URL url = new URL(EMMHttpURLConnection.uriEncode(urlStr, "/?:=&#@+$"));
                if (urlStr.startsWith("http://")) {
                    httpConnection = (HttpURLConnection)url.openConnection();
                } else if (!isCaAuth) {
                    httpConnection = mIsCertificate ? Http.getHttpsURLConnectionWithCert(url, mPassWord, mPath, mCtx) : Http.getHttpsURLConnection(url);
                } else if (mCertInfo != null) {
                    httpConnection = Http.getHttpsURLConnectionWithCert(url, EMMHttpURLConnection.mCertInfo.certPwd, EMMHttpURLConnection.mCertInfo.certPath, mCtx);
                } else {
                    LogUtils.logError("mCertInfo is null");
                }
            } else {
                LogUtils.logError("getHttpConnection url is null!");
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (httpConnection != null) {
            httpConnection.setReadTimeout(timeout);
            httpConnection.setConnectTimeout(timeout);
        }
        httpURLConnections.add((HttpURLConnection)httpConnection);
        return httpConnection;
    }

    private static String uriEncode(String url, String allow) {
        return Uri.encode((String)url, (String)allow);
    }
}

