/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.upgrade.widgetpatch;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import java.io.File;
import org.zywx.wbpalmstar.plugin.uexemm.EUExEMM;
import org.zywx.wbpalmstar.plugin.uexemm.dialog.AppUpgradeDialog;
import org.zywx.wbpalmstar.plugin.uexemm.dialog.EmmDialog;
import org.zywx.wbpalmstar.plugin.uexemm.emm.EMMAgent;
import org.zywx.wbpalmstar.plugin.uexemm.emm.EMMThread;
import org.zywx.wbpalmstar.plugin.uexemm.privatevo.EMMStartReportResVO;
import org.zywx.wbpalmstar.plugin.uexemm.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexemm.vo.EMMWWidgetData;

public class WidgetPatchUpdate {
    public static boolean checkWidgetUpdateFiles(Context context) {
        boolean isExistConfigFile;
        block4: {
            String widgetDir = String.valueOf(context.getFilesDir().getAbsolutePath()) + File.separator + "widget";
            File file = new File(widgetDir);
            File[] fileList = file.listFiles();
            isExistConfigFile = false;
            try {
                if (fileList == null) break block4;
                int i = 0;
                while (i < fileList.length) {
                    if ("config.xml".equals(fileList[i].getName())) {
                        isExistConfigFile = true;
                        break;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return isExistConfigFile;
    }

    public static void updateWidget(final Context context, final EMMStartReportResVO emmStatus, final EMMThread emmThread, EUExEMM.EMMHandler mHandler, final EMMWWidgetData mCurWData) {
        try {
            if (!WidgetPatchUpdate.checkWidgetUpdateFiles(context)) {
                LogUtils.logDebugO(true, "checkWidgetUpdateFiles: Maybe this engineVersion doesn't support patchUpdate.");
            }
        }
        catch (Exception e) {
            LogUtils.logDebugO(true, "checkWidgetUpdateFiles Exception: " + e.getMessage());
            e.printStackTrace();
        }
        if (TextUtils.isEmpty((CharSequence)emmStatus.newAppUrl)) {
            return;
        }
        boolean forceUpdate = "true".equalsIgnoreCase(emmStatus.forceUpdate);
        boolean needConfirm = "true".equalsIgnoreCase(emmStatus.needConfirm);
        if (forceUpdate && !needConfirm) {
            if (EMMAgent.getAppStatus().widgetStatus && "000".equals(emmStatus.widgetStatus)) {
                emmThread.setIsWaitingForUpdate(false);
                return;
            }
            ((Activity)context).runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    new AppUpgradeDialog(context).downloadPatchPkg(context, emmStatus, mCurWData, emmThread, null);
                }
            });
            return;
        }
        if ("true".equals(emmStatus.needConfirm) && context instanceof Activity) {
            Activity uiThread = (Activity)context;
            Runnable showDialog = new Runnable(){

                @Override
                public void run() {
                    EmmDialog.showNewAppDialog(context, emmStatus, emmThread, mCurWData);
                }
            };
            uiThread.runOnUiThread(showDialog);
        }
    }
}

