/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.upgrade.widgetpatch;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipException;
import org.zywx.wbpalmstar.base.BUtility;
import org.zywx.wbpalmstar.base.zip.CnZipInputStream;
import org.zywx.wbpalmstar.base.zip.ZipEntry;
import org.zywx.wbpalmstar.plugin.uexemm.emm.EMMAgent;
import org.zywx.wbpalmstar.plugin.uexemm.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.SharedPrefUtils;

public class WidgetPatchUpgradeMgr {
    private static String sboxPath = null;

    public WidgetPatchUpgradeMgr(Context context) {
        sboxPath = String.valueOf(context.getFilesDir().getPath()) + "/";
    }

    public void installWidgetPatch(Context context) {
        WidgetPatchConfig wConfig = this.isHasUpdateZip(context, String.valueOf(sboxPath) + "widget/");
        if (this.unZip(context, wConfig.isDynamic)) {
            EMMAgent.s_rootWgt.m_ver = wConfig.version;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private WidgetPatchConfig isHasUpdateZip(Context context, String zipPath) {
        WidgetPatchConfig wConfig = new WidgetPatchConfig();
        wConfig.version = "";
        SharedPreferences preferences = context.getSharedPreferences("updateInfo", 0);
        int totalSize = preferences.getInt("totalSize", 0);
        int downloaded = preferences.getInt("downloaded", 0);
        if (totalSize == 0 || downloaded == 0 || totalSize != downloaded) {
            wConfig.isHasZip = false;
            return wConfig;
        }
        String filePath = preferences.getString("filePath", null);
        if (!TextUtils.isEmpty((CharSequence)filePath)) {
            FileInputStream inputStream = null;
            CnZipInputStream in = null;
            try {
                try {
                    inputStream = new FileInputStream(filePath);
                    in = new CnZipInputStream((InputStream)inputStream, "utf-8");
                    ZipEntry entry = in.getNextEntry();
                    while (entry != null) {
                        String zename = entry.getName();
                        String lowerCase = zename.toLowerCase();
                        String dynamicConfigStart = "widget" + File.separator + SharedPrefUtils.getString(context, "app", "appid") + File.separator;
                        if ("config.xml".equals(lowerCase) || (String.valueOf(dynamicConfigStart) + "config.xml").equals(lowerCase)) {
                            boolean bl = wConfig.isDynamic = !"config.xml".equals(lowerCase);
                            if (wConfig.isDynamic) {
                                zename = zename.substring(dynamicConfigStart.length());
                            }
                            this.parserWidgetPatchConfig(context, wConfig, zipPath, zename, in);
                            if (wConfig.isHasZip) {
                                return wConfig;
                            }
                        }
                        entry = in.getNextEntry();
                    }
                    return wConfig;
                }
                catch (Exception i) {
                    LogUtils.oe("WidgetPatchUpgradeMgr isHasUpdateZip", i);
                    wConfig.isHasZip = false;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (in == null) return wConfig;
                        in.close();
                        return wConfig;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return wConfig;
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        wConfig.isHasZip = false;
        return wConfig;
    }

    /*
     * Loose catch block
     */
    private void parserWidgetPatchConfig(Context context, WidgetPatchConfig wConfig, String zipPath, String zename, CnZipInputStream in) {
        byte[] c = new byte[1024];
        File dir = new File(zipPath);
        File files = new File(String.valueOf(dir.getAbsolutePath()) + "/" + zename).getParentFile();
        if (!files.exists()) {
            files.mkdirs();
        }
        FileOutputStream out = null;
        FileInputStream input = null;
        File configDirTmp = null;
        File configFileTmp = null;
        try {
            try {
                int slen;
                String configPathTmp = String.valueOf(dir.getAbsolutePath()) + "/tmp/" + zename;
                configDirTmp = new File(configPathTmp).getParentFile();
                if (!configDirTmp.exists()) {
                    configDirTmp.mkdirs();
                }
                configFileTmp = new File(configPathTmp);
                out = new FileOutputStream(configPathTmp);
                while ((slen = in.read(c, 0, c.length)) != -1) {
                    out.write(c, 0, slen);
                }
                if (configFileTmp.exists()) {
                    String m_verString;
                    input = new FileInputStream(configFileTmp);
                    wConfig.version = m_verString = BUtility.parserXmlLabel((InputStream)input, (String)"config", (String)"widget", (String)"version");
                    String dbVerString = SharedPrefUtils.getString(context, "widgetOneConfig", "dbVer", null);
                    if (m_verString != null && dbVerString != null) {
                        long dbVerLong;
                        m_verString = this.formatVerString(m_verString.split("\\."));
                        dbVerString = this.formatVerString(dbVerString.split("\\."));
                        long m_verLong = Long.parseLong(m_verString);
                        if (m_verLong > (dbVerLong = Long.parseLong(dbVerString))) {
                            wConfig.isHasZip = true;
                        }
                    }
                } else {
                    wConfig.isHasZip = false;
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                configFileTmp.delete();
                configDirTmp.delete();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                configFileTmp.delete();
                configDirTmp.delete();
            }
            catch (IOException e) {
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                }
                configFileTmp.delete();
                configDirTmp.delete();
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            configFileTmp.delete();
            configDirTmp.delete();
        }
    }

    private String formatVerString(String[] s) {
        if (s.length == 1 && s[0].length() == 1) {
            s[0] = String.valueOf(0) + s[0];
        }
        if (s.length == 2 && s[1].length() == 1) {
            s[1] = "0" + s[1];
        }
        if (s.length == 3 && s[2].length() == 1) {
            s[2] = "000" + s[2];
        }
        if (s.length == 3 && s[2].length() == 2) {
            s[2] = "00" + s[2];
        }
        if (s.length == 3 && s[2].length() == 3) {
            s[2] = "0" + s[2];
        }
        StringBuffer sbf = new StringBuffer("");
        if (s.length == 1) {
            sbf.append(s[0]).append("000000");
        } else if (s.length == 2) {
            sbf.append(s[0]).append(s[1]).append("0000");
        } else if (s.length == 3) {
            sbf.append(s[0]).append(s[1]).append(s[2]);
        }
        return sbf.toString();
    }

    private boolean unZip(Context context, boolean isDynamic) {
        boolean unZip = false;
        SharedPreferences preferences = context.getSharedPreferences("updateInfo", 0);
        int totalSize = preferences.getInt("totalSize", 0);
        int downloaded = preferences.getInt("downloaded", 0);
        if (totalSize == 0 || downloaded == 0 || totalSize != downloaded) {
            return false;
        }
        String filePath = preferences.getString("filePath", null);
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return false;
        }
        String widgetPath = String.valueOf(sboxPath) + "widget/";
        try {
            FileInputStream inputStream = new FileInputStream(filePath);
            if (!isDynamic) {
                unZip = WidgetPatchUpgradeMgr.unZip(inputStream, widgetPath, null);
            } else {
                String pluginPath = String.valueOf(sboxPath) + "apkfile" + File.separator;
                unZip = WidgetPatchUpgradeMgr.unZipDynamic(context, inputStream, widgetPath, pluginPath, null);
            }
        }
        catch (FileNotFoundException e) {
            LogUtils.oe("WidgetPatchUpgradeMgr unZIP", e);
        }
        return unZip;
    }

    private static boolean unZip(InputStream inputStream, String decompression, String encoding) {
        if (encoding == null || encoding.equals("")) {
            encoding = "utf-8";
        }
        File dir = new File(decompression);
        try {
            CnZipInputStream in = new CnZipInputStream(inputStream, encoding);
            ZipEntry file = in.getNextEntry();
            byte[] c = new byte[1024];
            String dpPath = dir.getAbsolutePath();
            while (file != null) {
                String zename = file.getName();
                WidgetPatchUpgradeMgr.getFileFromZip(in, file, c, dpPath, zename);
                file = in.getNextEntry();
            }
            in.close();
        }
        catch (ZipException zipe) {
            LogUtils.oe("WidgetPatchUpgradeMgr unzip", zipe);
            return false;
        }
        catch (IOException ioe) {
            LogUtils.oe("WidgetPatchUpgradeMgr unzip", ioe);
            return false;
        }
        catch (Exception i) {
            LogUtils.oe("WidgetPatchUpgradeMgr unzip", i);
            return false;
        }
        return true;
    }

    private static boolean unZipDynamic(Context context, InputStream inputStream, String widgetPath, String pluginPath, String encoding) {
        if (encoding == null || encoding.equals("")) {
            encoding = "utf-8";
        }
        String widgetAbsolutePath = new File(widgetPath).getAbsolutePath();
        String pluginAbsolutePath = new File(pluginPath).getAbsolutePath();
        try {
            CnZipInputStream in = new CnZipInputStream(inputStream, encoding);
            ZipEntry file = in.getNextEntry();
            byte[] c = new byte[1024];
            String widgetPathStart = "widget" + File.separator + SharedPrefUtils.getString(context, "app", "appid") + File.separator;
            String pluginPathStart = "plugin" + File.separator;
            while (file != null) {
                String decompression = "";
                String startStr = "";
                String zename = file.getName();
                if (zename.startsWith(widgetPathStart)) {
                    decompression = widgetAbsolutePath;
                    startStr = widgetPathStart;
                } else if (zename.startsWith(pluginPathStart)) {
                    decompression = pluginAbsolutePath;
                    startStr = pluginPathStart;
                }
                if (!TextUtils.isEmpty((CharSequence)decompression)) {
                    zename = zename.substring(startStr.length());
                    WidgetPatchUpgradeMgr.getFileFromZip(in, file, c, decompression, zename);
                }
                file = in.getNextEntry();
            }
            in.close();
        }
        catch (ZipException zipe) {
            LogUtils.oe("WidgetPatchUpgradeMgr unzip", zipe);
            return false;
        }
        catch (IOException ioe) {
            LogUtils.oe("WidgetPatchUpgradeMgr unzip", ioe);
            return false;
        }
        catch (Exception i) {
            LogUtils.oe("WidgetPatchUpgradeMgr unzip", i);
            return false;
        }
        return true;
    }

    private static void getFileFromZip(CnZipInputStream in, ZipEntry file, byte[] c, String decompression, String zename) throws FileNotFoundException, IOException {
        if (file.isDirectory()) {
            File files = new File(String.valueOf(decompression) + "/" + zename);
            files.mkdirs();
        } else {
            int slen;
            File files = new File(String.valueOf(decompression) + "/" + zename).getParentFile();
            if (!files.exists()) {
                files.mkdirs();
            }
            FileOutputStream out = new FileOutputStream(String.valueOf(decompression) + "/" + zename);
            while ((slen = in.read(c, 0, c.length)) != -1) {
                out.write(c, 0, slen);
            }
            out.close();
        }
    }

    class WidgetPatchConfig {
        boolean isHasZip;
        String version;
        boolean isDynamic;

        WidgetPatchConfig() {
        }
    }
}

