/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.utils;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.zywx.wbpalmstar.plugin.uexemm.utils.LogUtils;

public class DeviceInfo {
    private static boolean isSilent = true;

    public static String getMacAddress(Context activity) {
        String macSerial = null;
        try {
            WifiManager wifi = (WifiManager)activity.getSystemService("wifi");
            WifiInfo info = wifi.getConnectionInfo();
            macSerial = info.getMacAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!DeviceInfo.isValidMac(macSerial)) {
            macSerial = DeviceInfo.getMac();
        }
        return macSerial;
    }

    private static boolean isValidMac(String macSerial) {
        return !TextUtils.isEmpty((CharSequence)macSerial) && !"020000000000".equals(macSerial);
    }

    public static String getCPUSerial() {
        String str = "";
        String strCPU = "";
        String cpuAddress = "0000000000000000";
        try {
            Process pp = Runtime.getRuntime().exec("cat /proc/cpuinfo");
            InputStreamReader ir = new InputStreamReader(pp.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            while (str != null) {
                str = input.readLine();
                if (str != null) {
                    if (str.indexOf("Serial") <= -1) continue;
                    strCPU = str.substring(str.indexOf(":") + 1, str.length());
                    cpuAddress = strCPU.trim();
                }
                break;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return cpuAddress;
    }

    private static String getMac() {
        String macSerial = "";
        String str = "";
        try {
            Process pp = Runtime.getRuntime().exec("cat /sys/class/net/wlan0/address ");
            InputStreamReader ir = new InputStreamReader(pp.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            while (str != null) {
                str = input.readLine();
                if (str == null) continue;
                macSerial = str.trim();
                break;
            }
        }
        catch (IOException ex) {
            LogUtils.oe("getMac", ex);
        }
        return macSerial;
    }

    public static String getMobileOperatorName(Context mContext) {
        String name = "unKnown";
        TelephonyManager telephonyManager = (TelephonyManager)mContext.getSystemService("phone");
        if (telephonyManager.getSimState() == 5) {
            String imsi = telephonyManager.getNetworkOperator();
            name = imsi.equals("46000") || imsi.equals("46002") ? "\u4e2d\u56fd\u79fb\u52a8" : (imsi.equals("46001") ? "\u4e2d\u56fd\u8054\u901a" : (imsi.equals("46003") ? "\u4e2d\u56fd\u7535\u4fe1" : telephonyManager.getSimOperatorName()));
        }
        return name;
    }

    public static String getDeviceResolution(Context activity) {
        if (activity == null) {
            return null;
        }
        DisplayMetrics dm = activity.getResources().getDisplayMetrics();
        return String.valueOf(dm.widthPixels) + "*" + dm.heightPixels;
    }

    public static String getSerialNumber() {
        String serial = null;
        try {
            Class<?> c = Class.forName("android.os.SystemProperties");
            Method get = c.getMethod("get", String.class);
            serial = (String)get.invoke(c, "ro.serialno");
            System.out.println(serial);
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
        return serial;
    }

    public static boolean deviceBeRoot() {
        if (isSilent) {
            return DeviceInfo.isRootSystem();
        }
        int i = DeviceInfo.execRootCmdSilent("echo test");
        return i != -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isRootSystem() {
        String[] paths = new String[]{"/system/bin/", "/system/xbin/", "/system/sbin/", "/sbin/", "/vendor/bin/"};
        try {
            File file = null;
            String su = "su";
            String[] stringArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String dir = stringArray[n2];
                file = new File(String.valueOf(dir) + su);
                if (file != null && file.exists()) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static int execRootCmdSilent(String cmd) {
        try {
            Process p = Runtime.getRuntime().exec("su ");
            Object obj = p.getOutputStream();
            DataOutputStream dOutStream = new DataOutputStream((OutputStream)obj);
            String str = String.valueOf(cmd);
            obj = String.valueOf(str) + "\n";
            dOutStream.writeBytes((String)obj);
            dOutStream.flush();
            dOutStream.writeBytes("exit\n");
            dOutStream.flush();
            p.waitFor();
            int result = p.exitValue();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }
}

