/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexemm.encryption.MD5Encryption;
import org.zywx.wbpalmstar.plugin.uexemm.encryption.RC4Encryption;
import org.zywx.wbpalmstar.plugin.uexemm.privatevo.EMMStartReportResVO;
import org.zywx.wbpalmstar.plugin.uexemm.utils.HexConverter;
import org.zywx.wbpalmstar.plugin.uexemm.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.SharedPrefUtils;
import org.zywx.wbpalmstar.plugin.uexemm.vo.EMMWWidgetData;

public class EMMUtils {
    public static String getManufacturerName() {
        return Build.MANUFACTURER;
    }

    public static String getWidgetReportResult(Context context, EMMWWidgetData data) {
        String spName = "saveData";
        if (data.m_wgtType != 0) {
            spName = String.valueOf(spName) + data.m_appId;
        }
        return SharedPrefUtils.getString(context, spName, "reportResult", "");
    }

    public static String getReportAddress(Context m_activity, String appId) {
        String spName = TextUtils.isEmpty((CharSequence)appId) ? "app" : "saveData" + appId;
        return SharedPrefUtils.getString(m_activity, spName, "addressAnalytics", "");
    }

    public static void setReportAddress(Context m_activity, String appId, String address) {
        String spName = TextUtils.isEmpty((CharSequence)appId) ? "app" : "saveData" + appId;
        SharedPrefUtils.putString(m_activity, spName, "addressAnalytics", address);
    }

    public static void saveMainAppId(Context context, String appId) {
        SharedPrefUtils.putString(context, "app", "appId", appId);
    }

    public static void saveWidgetReportResult(Context context, EMMWWidgetData data, String result) {
        String spName = "saveData";
        if (data.m_wgtType != 0) {
            spName = String.valueOf(spName) + data.m_appId;
        }
        SharedPrefUtils.putString(context, spName, "reportResult", result);
    }

    public static void saveWidgetStatus(Context context, EMMStartReportResVO emmStatus, String baseMsg, String url, EMMWWidgetData data) {
        String spName = data.m_wgtType == 0 ? "saveData" : "saveData" + data.m_appId;
        String[] keyArray = new String[]{"reportMsg", "reportUrl"};
        String[] valueArray = new String[]{baseMsg, url};
        SharedPrefUtils.putStringArray(context, spName, keyArray, valueArray);
        if (!TextUtils.isEmpty((CharSequence)emmStatus.widgetPlugins)) {
            try {
                JSONArray jsonArray = new JSONArray(emmStatus.widgetPlugins);
                data.disablePlugins = new String[jsonArray.length()];
                int i = 0;
                while (i < jsonArray.length()) {
                    data.disablePlugins[i] = jsonArray.getJSONObject(i).getString("name");
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            SharedPrefUtils.putString(context, spName, "disablePlugins", emmStatus.widgetPlugins);
        }
        if (!TextUtils.isEmpty((CharSequence)emmStatus.widgetWnds)) {
            String[] wnds = emmStatus.widgetWnds.split(",");
            StringBuilder disableRootWindowsString = new StringBuilder();
            StringBuilder disableSonWindowsString = new StringBuilder();
            String[] stringArray = wnds;
            int n = wnds.length;
            int n2 = 0;
            while (n2 < n) {
                String wnd = stringArray[n2];
                if (wnd.contains(":")) {
                    disableSonWindowsString.append(wnd.replaceAll(":", ""));
                    disableSonWindowsString.append(",");
                } else {
                    disableRootWindowsString.append(wnd);
                    disableRootWindowsString.append(",");
                }
                ++n2;
            }
            if (disableRootWindowsString.length() > 0) {
                data.disableRootWindows = disableRootWindowsString.toString().split(",");
            }
            if (disableSonWindowsString.length() > 0) {
                data.disableSonWindows = disableSonWindowsString.toString().split(",");
            }
            SharedPrefUtils.putString(context, spName, "disableWindows", emmStatus.widgetWnds);
        }
    }

    public static boolean isAppStorePluginExist(Context context) {
        boolean isExist = false;
        try {
            Class.forName("org.zywx.wbpalmstar.plugin.uexappstoremgr.EUExAppStoreMgr", false, context.getClassLoader());
            isExist = true;
        }
        catch (ClassNotFoundException e) {
            LogUtils.oe("isAppStorePluginExist", e);
            LogUtils.logDebug(true, "not fount AppStorePlugin");
        }
        return isExist;
    }

    public static void saveTenantAccount(Context context, String tenantAccount, boolean isEncrypt) {
        if (!isEncrypt) {
            byte[] tenantAccountByte = tenantAccount.getBytes();
            String mainAppId = SharedPrefUtils.getString(context, "app", "appid", "undefined");
            tenantAccount = HexConverter.binaryToHexString(RC4Encryption.os_decrypt(tenantAccountByte, tenantAccountByte.length, mainAppId));
        }
        SharedPrefUtils.putString(context, "app", "tenantAccount", tenantAccount);
    }

    public static boolean isSingleTenant() {
        boolean single = false;
        try {
            String tenant = EUExUtil.getString((String)"tenant_id");
            single = !TextUtils.isEmpty((CharSequence)tenant) && !"0".equals(tenant);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return single;
    }

    private static String decryptTenantAccount(Context context, String taEncryption) {
        String tenantAccount = "";
        if (!TextUtils.isEmpty((CharSequence)taEncryption)) {
            String mainAppId = SharedPrefUtils.getString(context, "app", "appid", "undefined");
            byte[] tenantAccountByte = HexConverter.hexStringToBinary(taEncryption);
            tenantAccount = new String(RC4Encryption.os_decrypt(tenantAccountByte, tenantAccountByte.length, mainAppId));
        }
        return tenantAccount;
    }

    private static String getTenantAccountFromRes(Context context) {
        String tenantAccountEncryption = "";
        String tenantAccount = "";
        try {
            tenantAccount = EUExUtil.getString((String)"tenant_id");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        tenantAccountEncryption = EMMUtils.decryptTenantAccount(context, tenantAccount);
        if ("0".equals(tenantAccountEncryption)) {
            tenantAccountEncryption = "";
        }
        return tenantAccountEncryption;
    }

    private static String getTenantAccountFromCache(Context context) {
        String tenantAccountEncryption = "";
        String tenantAccount = "";
        tenantAccount = SharedPrefUtils.getString(context, "app", "tenantAccount", "");
        tenantAccountEncryption = EMMUtils.decryptTenantAccount(context, tenantAccount);
        return tenantAccountEncryption;
    }

    public static String getTenantAccount(Context context) {
        String tenantAccountEncryption = "";
        tenantAccountEncryption = "default_null";
        return tenantAccountEncryption;
    }

    public static boolean isAppFirstStart(String tenantAccount) {
        return TextUtils.isEmpty((CharSequence)tenantAccount);
    }

    public static AppInfo getAppInfo(Context mContext) {
        AppInfo mAppInfo = new AppInfo();
        try {
            PackageManager pManager = mContext.getPackageManager();
            ApplicationInfo appInfo = pManager.getApplicationInfo(mContext.getPackageName(), 0);
            mAppInfo.appName = (String)pManager.getApplicationLabel(appInfo);
            mAppInfo.appIcon = pManager.getApplicationIcon(appInfo);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return mAppInfo;
    }

    public static String replaceReturn(String oldString) {
        String newString = null;
        Pattern CRLF = Pattern.compile("(\r\n|\r|\n|\n\r)");
        Matcher m = CRLF.matcher(oldString);
        newString = m.find() ? m.replaceAll("<br>") : oldString;
        return newString;
    }

    public static String getErrorCallbakMsg(int type, String info) {
        JSONObject json = new JSONObject();
        try {
            json.put("type", type);
            json.put("info", (Object)info);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json.toString();
    }

    public static void saveLoginResult(Context mContext, JSONObject loginJson, String loginResult) {
        String domainName = loginJson.optString("domainName");
        loginJson.remove("isFirstLogin");
        SharedPrefUtils.putString(mContext, "loginInfo", domainName, MD5Encryption.getMD5Code(loginJson.toString()));
        byte[] loginResultBytes = loginResult.getBytes();
        String rc4String = HexConverter.binaryToHexString(RC4Encryption.os_decrypt(loginResultBytes, loginResultBytes.length, "appcanuse$%^&%^&%^&%&^$#$#sdfsda90239%^)f8y99e7we98\t\t\t yhfdsuyf892yr98ghwequifyh879esa6yf83g2ui1rfgtvbiygf\t\t\t appcanuse923yhr32hjfklsdahfjsadhjkfsadfbhdjkdsahfuy\t\t\t 28973yr^%UBFG%^&*IO^bjk789234y6cxzv98324df96621378*\t\t\t ^&$69879872364327848e^$%^$*(&(&wrtf32fuiheappcanuse"));
        SharedPrefUtils.putString(mContext, "loginResult", domainName, rc4String);
    }

    public static String getCertPathByLoginName(Context mContext, String loginName) {
        return SharedPrefUtils.getString(mContext, "cert_infor", MD5Encryption.getMD5Code(loginName), "");
    }

    public static boolean isWidgetStartRepotSuccess(int errorCode) {
        return errorCode == 0 || -3 == errorCode;
    }

    public static String getEMMHost(Context context) {
        String emmHost = SharedPrefUtils.getString(context, "app", "emmHost");
        if (TextUtils.isEmpty((CharSequence)emmHost)) {
            emmHost = EUExUtil.getString((String)"widget_startup_report_host");
        }
        return emmHost;
    }

    public static class AppInfo {
        public String appName;
        public Drawable appIcon;
    }
}

