/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.zywx.wbpalmstar.base.BUtility;
import org.zywx.wbpalmstar.plugin.uexemm.utils.LogUtils;

public class FileUtils {
    public static boolean copyFile(String oldPath, String dstPath) {
        boolean isSuccess;
        block21: {
            File oldFile = new File(oldPath);
            File dstFile = new File(dstPath);
            FileInputStream fis = null;
            FileOutputStream fos = null;
            isSuccess = false;
            try {
                try {
                    fis = new FileInputStream(oldFile);
                    fos = new FileOutputStream(dstFile);
                    byte[] buffer = new byte[4096];
                    int len = -1;
                    while ((len = fis.read(buffer, 0, buffer.length)) != -1) {
                        fos.write(buffer, 0, len);
                    }
                    fos.flush();
                    isSuccess = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (fos == null) break block21;
                    try {
                        fos.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return isSuccess;
    }

    public static boolean copyFile(File oldFile, File dstFile) {
        return FileUtils.copyFile(oldFile.getAbsolutePath(), dstFile.getAbsolutePath());
    }

    private static void deleteFile(File file, String path, String libPath, String widgetPath) {
        try {
            String widgetPathParent = new File(widgetPath).getParent();
            if (file.exists()) {
                if (file.isFile()) {
                    file.delete();
                } else if (file.isDirectory()) {
                    File[] files = file.listFiles();
                    int i = 0;
                    while (i < files.length) {
                        if (!libPath.equals(files[i].getPath()) && !widgetPath.equals(files[i].getPath())) {
                            FileUtils.deleteFile(files[i], path, libPath, widgetPath);
                        }
                        ++i;
                    }
                }
                if (!path.equals(file.getPath()) && !widgetPathParent.equals(file.getPath())) {
                    file.delete();
                }
            }
        }
        catch (Exception e) {
            LogUtils.oe("deleteFile", e);
        }
    }

    private static void delDirectory(File file) {
        try {
            if (file.exists()) {
                if (file.isFile()) {
                    file.delete();
                } else if (file.isDirectory()) {
                    File[] fileList = file.listFiles();
                    int i = 0;
                    while (i < fileList.length) {
                        FileUtils.delDirectory(fileList[i]);
                        ++i;
                    }
                    file.delete();
                }
            }
        }
        catch (Exception e) {
            LogUtils.oe("deleteFile", e);
        }
    }

    private static void eraseAppData(String path, boolean delAll) {
        LogUtils.logDebug(true, "eraseData path: " + path);
        File file = new File(path);
        if (delAll) {
            FileUtils.delDirectory(file);
        } else {
            FileUtils.deleteFile(file, path, String.valueOf(path) + "/lib", String.valueOf(path) + "/files/widget");
        }
    }

    public static void eraseSubAppData(Context context, String appId) {
        String widgetonePath = String.valueOf(BUtility.getSdCardRootPath()) + "widgetone/apps/" + appId;
        FileUtils.eraseAppData(widgetonePath, true);
    }

    @SuppressLint(value={"NewApi"})
    public static void eraseMainAppData(Context context, String widgetonePath) {
        String boxPath = context.getFilesDir().getParent();
        String sdBoxPath = context.getExternalFilesDir(null).getParent();
        FileUtils.eraseAppData(boxPath, false);
        FileUtils.eraseAppData(sdBoxPath, true);
        FileUtils.eraseAppData(widgetonePath, true);
    }

    public static FileInputStream getFileInputStream(String fileName) {
        FileInputStream fis = null;
        if (!TextUtils.isEmpty((CharSequence)fileName)) {
            File file = new File(fileName);
            try {
                fis = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return fis;
    }

    public static String getUpgradeTempFilePath(Context context) {
        return String.valueOf(FileUtils.getExternalCacheDir(context).getAbsolutePath()) + File.separator;
    }

    private static File getExternalCacheDir(Context context) {
        File path = null;
        if (Build.VERSION.SDK_INT >= 8) {
            path = context.getExternalCacheDir();
        }
        if (path == null) {
            String cacheDir = "/Android/data/" + context.getPackageName() + "/cache/";
            path = new File(String.valueOf(Environment.getExternalStorageDirectory().getPath()) + cacheDir);
        }
        return path;
    }

    public static String getExternalCacheDir(Context context, String url) {
        String path = FileUtils.getUpgradeTempFilePath(context);
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return String.valueOf(path) + url.substring(url.lastIndexOf("/") + 1);
    }
}

