/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.geofencing;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.zywx.wbpalmstar.plugin.geofencing.CenterPoint;
import org.zywx.wbpalmstar.plugin.geofencing.LocationService;
import org.zywx.wbpalmstar.plugin.geofencing.ReportService;
import org.zywx.wbpalmstar.plugin.geofencing.utils.CoordinationUtils;
import org.zywx.wbpalmstar.plugin.geofencing.utils.DistanceCalcUtils;
import org.zywx.wbpalmstar.plugin.geofencing.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.geofencing.utils.ReportSettings;

public class AppCanLocationProxy
implements LocationListener {
    private static final String DEFAULT_OPID = "defaultId";
    private static String TAG = "LocationAction";
    public static final int TYPE_GEOFENCE_NOTIFICATION = 0;
    public static final int TYPE_TIMER_REPORT_LOCATION = 1;
    public static final int TYPE_ONE_TIME_REQUEST_LOCATION = 2;
    public static int GEOFENCING_LOCATE_FREQ_TIME = 10000;
    private static int LOCATE_FREQ_TIME = 3600000;
    private static int LOCATE_ACCURACY = 1;
    private static AppCanLocationProxy sGeofenceProxy;
    private HashMap<String, CenterPoint> sPointMap = null;
    private Context mContext;
    private LocationManager mLocationProMgr;
    private ReportSettings settings;
    private String opId = null;
    private long reqTime = 0L;
    private int mLocationProxyType = 0;
    private boolean isRunning = false;
    private boolean isReport = true;

    private AppCanLocationProxy(Context context, int type) {
        LogUtils.i(TAG, "a new AppCanLocationProxy created");
        this.mContext = context;
        this.mLocationProMgr = (LocationManager)context.getSystemService("location");
        this.mLocationProxyType = type;
        this.settings = ReportSettings.getInstance(context);
        if (this.sPointMap == null) {
            this.sPointMap = this.settings.getAllGeofencePointMap();
        }
    }

    public static AppCanLocationProxy getGeoFencingProxy(Context context) {
        if (sGeofenceProxy == null) {
            sGeofenceProxy = AppCanLocationProxy.newInstance(context, 0);
        }
        return sGeofenceProxy;
    }

    public static AppCanLocationProxy newInstance(Context context, int type) {
        return new AppCanLocationProxy(context, type);
    }

    public void addGeoFence(CenterPoint geofencePoint) {
        String opId = geofencePoint.geoId;
        CoordinationUtils.CoorPoint point = CoordinationUtils.bdDecrypt(geofencePoint.latitude, geofencePoint.longitude);
        geofencePoint.latitude = point.latitude;
        geofencePoint.longitude = point.longitude;
        this.removeGeofence(opId);
        this.sPointMap.put(opId, geofencePoint);
        this.settings.addGeofencePoint(geofencePoint);
        if (!this.isRunning) {
            Intent intent = new Intent(this.mContext, LocationService.class);
            intent.setAction("org.zywx.wbpalmstar.plugin.geofencing");
            PendingIntent pi = PendingIntent.getService((Context)this.mContext, (int)0, (Intent)intent, (int)0x10000000);
            AlarmManager am = (AlarmManager)this.mContext.getSystemService("alarm");
            am.setRepeating(0, System.currentTimeMillis(), (long)GEOFENCING_LOCATE_FREQ_TIME, pi);
        }
    }

    public void addGeoFence2(CenterPoint geofencePoint) {
        String opId = geofencePoint.geoId;
        PendingIntent geofencePendingIntent = null;
        CoordinationUtils.CoorPoint point = CoordinationUtils.bdDecrypt(geofencePoint.latitude, geofencePoint.longitude);
        geofencePoint.latitude = point.latitude;
        geofencePoint.longitude = point.longitude;
        this.removeGeofence2(opId);
        geofencePendingIntent = this.getGeofencePointIntent(geofencePoint);
        this.mLocationProMgr.addProximityAlert(geofencePoint.latitude, geofencePoint.longitude, geofencePoint.range, -1L, geofencePendingIntent);
        this.sPointMap.put(opId, geofencePoint);
        this.settings.addGeofencePoint(geofencePoint);
    }

    private PendingIntent getGeofencePointIntent(CenterPoint geofencePoint) {
        String latitude = String.valueOf(geofencePoint.latitude);
        String longitude = String.valueOf(geofencePoint.longitude);
        float range = geofencePoint.range;
        Intent intent = new Intent(this.mContext, ReportService.class);
        intent.setAction("org.zywx.wbpalmstar.plugin.geofencing");
        intent.setPackage(this.mContext.getPackageName());
        intent.putExtra("latitude", latitude);
        intent.putExtra("longitude", longitude);
        intent.putExtra("range", range);
        intent.putExtra("geoId", geofencePoint.geoId);
        PendingIntent geofencePendingIntent = PendingIntent.getService((Context)this.mContext, (int)0, (Intent)intent, (int)0x8000000);
        return geofencePendingIntent;
    }

    public void requestGeoFencingLoopLocation() {
        this.requestLocation(DEFAULT_OPID, GEOFENCING_LOCATE_FREQ_TIME);
    }

    public void requestLocation(String opID, long reqTime) {
        this.isReport = true;
        this.isRunning = true;
        int accuracy = LOCATE_ACCURACY;
        if (reqTime <= 0L) {
            reqTime = LOCATE_FREQ_TIME;
            this.mLocationProxyType = 2;
        }
        if (TextUtils.isEmpty((CharSequence)opID)) {
            opID = DEFAULT_OPID;
        }
        this.opId = opID;
        this.reqTime = reqTime;
        try {
            if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
                Log.i((String)TAG, (String)"On UI thread");
            } else {
                Log.i((String)TAG, (String)"Not on UI thread");
            }
            Log.e((String)TAG, (String)("requestLocation on Thread: " + Thread.currentThread().getName()));
            Criteria cr = new Criteria();
            cr.setAccuracy(1);
            cr.setAltitudeRequired(false);
            cr.setBearingRequired(false);
            cr.setCostAllowed(true);
            cr.setPowerRequirement(2);
            String provider = this.mLocationProMgr.getBestProvider(cr, true);
            LogUtils.o("Location Provider: " + provider);
            this.mLocationProMgr.removeUpdates((LocationListener)this);
            if (this.mLocationProxyType == 0) {
                this.mLocationProMgr.requestSingleUpdate(provider, (LocationListener)this, Looper.getMainLooper());
            } else {
                this.mLocationProMgr.requestLocationUpdates(provider, reqTime, (float)accuracy, (LocationListener)this);
            }
        }
        catch (Exception e) {
            LogUtils.o("requestLocation Exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void setIsReport(boolean isReport) {
        this.isReport = isReport;
    }

    public void closeLocation() {
        LogUtils.o("closeLocation");
        try {
            this.isRunning = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeGeofence(String opId) {
        if (this.sPointMap.containsKey(opId)) {
            this.sPointMap.remove(opId);
            this.settings.removeGeofencePoint(opId);
            if (this.sPointMap.isEmpty()) {
                this.closeLocation();
            }
        }
    }

    public void removeGeofence2(String opId) {
        if (this.sPointMap.containsKey(opId)) {
            CenterPoint tempGeofencePoint = this.sPointMap.get(opId);
            PendingIntent geofencePendingIntent = this.getGeofencePointIntent(tempGeofencePoint);
            this.mLocationProMgr.removeProximityAlert(geofencePendingIntent);
            this.sPointMap.remove(opId);
            this.settings.removeGeofencePoint(opId);
            if (this.sPointMap.isEmpty()) {
                this.closeLocation();
            }
        }
    }

    public void removeAllGeofence() {
        Set<String> keySet = this.sPointMap.keySet();
        for (String key : keySet) {
            CenterPoint point = this.sPointMap.remove(key);
            this.settings.removeGeofencePoint(point.geoId);
        }
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
        switch (status) {
            case 2: {
                Log.i((String)TAG, (String)("LocationProvider available:" + provider));
                break;
            }
            case 0: {
                Log.i((String)TAG, (String)("LocationProvider out of service:" + provider));
                break;
            }
            case 1: {
                Log.i((String)TAG, (String)("LocationProvider unavailable:" + provider));
            }
        }
    }

    public void onProviderEnabled(String provider) {
        Log.i((String)TAG, (String)("onProviderEnabled:" + provider));
        this.requestLocation(this.opId, this.reqTime);
    }

    public void onProviderDisabled(String provider) {
        Log.i((String)TAG, (String)("onProviderDisabled:" + provider));
        this.requestLocation(this.opId, this.reqTime);
    }

    public void onLocationChanged(Location location) {
        Log.i((String)TAG, (String)"onLocationChanged Android");
        this.solveLocation(location);
    }

    private void solveLocation(Location location) {
        LogUtils.o("solveLocation");
        long startTime = location.getTime();
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(startTime);
        LogUtils.o(String.valueOf(TAG) + " time:" + c.getTime() + " longitude:" + location.getLongitude() + " latitude:" + location.getLatitude() + " accuracy:" + location.getAccuracy() + " altitude: " + location.getAltitude() + " speed:" + location.getSpeed());
        if (!this.isReport && this.mLocationProxyType != 0) {
            LogUtils.o("solveLocation: don't report in background");
            return;
        }
        if (this.mLocationProxyType == 0) {
            new ComputeDistanceTask(location).execute(new Void[0]);
        } else {
            String latitude = String.valueOf(location.getLatitude());
            String longitude = String.valueOf(location.getLongitude());
            Intent intent = new Intent(this.mContext, ReportService.class);
            intent.setPackage(this.mContext.getPackageName());
            intent.setAction("org.zywx.wbpalmstar.plugin.location");
            intent.putExtra("latitude", latitude);
            intent.putExtra("longitude", longitude);
            this.mContext.startService(intent);
        }
    }

    class ComputeDistanceTask
    extends AsyncTask<Void, Void, Double> {
        private Location mLocation;

        public ComputeDistanceTask(Location mLocation) {
            this.mLocation = mLocation;
        }

        protected Double doInBackground(Void ... params) {
            if (AppCanLocationProxy.this.sPointMap == null || this.mLocation == null) {
                Log.i((String)TAG, (String)"no geoPoint or location is null");
                return null;
            }
            for (Map.Entry entry : AppCanLocationProxy.this.sPointMap.entrySet()) {
                CenterPoint point = (CenterPoint)entry.getValue();
                double distance = DistanceCalcUtils.getDistance(this.mLocation.getLatitude(), this.mLocation.getLongitude(), point.latitude, point.longitude);
                Intent intent = new Intent("org.zywx.wbpalmstar.plugin.geofencing");
                intent.setClass(AppCanLocationProxy.this.mContext, ReportService.class);
                intent.setPackage(AppCanLocationProxy.this.mContext.getPackageName());
                intent.putExtra("longitude", this.mLocation.getLongitude());
                intent.putExtra("latitude", this.mLocation.getLatitude());
                intent.putExtra("geoId", point.geoId);
                intent.putExtra("range", point.range);
                intent.putExtra("inMessage", point.inMessage);
                intent.putExtra("outMessage", point.outMessage);
                if (distance <= (double)point.range && point.isInGeoFence != 0) {
                    LogUtils.o("GeoFence " + point.geoId + " distance:" + distance + " status is going into the geofence.");
                    point.isInGeoFence = 0;
                    AppCanLocationProxy.this.settings.addGeofencePoint(point);
                    intent.putExtra("status", 0);
                    AppCanLocationProxy.this.mContext.startService(intent);
                    continue;
                }
                if (distance > (double)point.range && point.isInGeoFence != 1) {
                    LogUtils.o("GeoFence " + point.geoId + " distance:" + distance + " status is going out of geofence.");
                    point.isInGeoFence = 1;
                    AppCanLocationProxy.this.settings.addGeofencePoint(point);
                    intent.putExtra("status", 1);
                    AppCanLocationProxy.this.mContext.startService(intent);
                    continue;
                }
                LogUtils.o("GeoFence " + point.geoId + " distance:" + distance + " status is not changed.");
            }
            return null;
        }

        protected void onPostExecute(Double result) {
        }
    }
}

