/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.geofencing;

import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import java.net.URLEncoder;
import java.util.Calendar;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.zywx.wbpalmstar.plugin.geofencing.ReportLocationData;
import org.zywx.wbpalmstar.plugin.geofencing.utils.HttpUtils;
import org.zywx.wbpalmstar.plugin.geofencing.utils.LogUtils;

public class BaiduLocationAction
implements LocationListener {
    private static final String INTENT_OPID = "opId";
    private static final String DEFAULT_OPID = "defaultId";
    private static String TAG = "BaiduLocationAction";
    private static String BAIDU_KEY = "6Lr2fliWFNNbyvaHfHr3yLHE";
    private static String CONVERT_COORDS_URL = "http://api.map.baidu.com/geoconv/v1/?from=1&to=5&ak=" + BAIDU_KEY + "&coords=";
    private static String GEOCODE_URL = "http://api.map.baidu.com/geocoder/v2/?ak=" + BAIDU_KEY + "&output=json";
    public static final int TYPE_REPORT_LOCATION = 1;
    public static final int TYPE_COMMAND_LOCATION = 2;
    private static int LOCATE_FREQ_TIME = 5000;
    private static int LOCATE_ACCURACY = 10;
    private LocationManager mLocationProMgr;
    private ReportLocationData mLocationData;
    private Intent intent;
    private Context mContext;
    private int locationActionType = 0;

    private BaiduLocationAction(Context context, int type) {
        LogUtils.i(TAG, "a new MDMLocationAction created");
        this.mContext = context;
        this.mLocationProMgr = (LocationManager)context.getSystemService("location");
        this.locationActionType = type;
        this.mLocationData = new ReportLocationData();
    }

    public static BaiduLocationAction newInstance(Context context, int type) {
        return new BaiduLocationAction(context, type);
    }

    public void requestLocation(Intent intent) {
        Log.i((String)TAG, (String)("requestLocation, Type: " + (this.locationActionType == 1 ? "onStartOrManual" : "Command")));
        this.intent = intent;
        String opID = intent.getStringExtra(INTENT_OPID);
        try {
            if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
                Log.i((String)TAG, (String)"On UI thread");
            } else {
                Log.i((String)TAG, (String)"Not on UI thread");
            }
            Log.e((String)TAG, (String)("requestLocation on Thread: " + Thread.currentThread().getName()));
            this.mLocationData.setOpID(opID);
            this.mLocationProMgr.requestLocationUpdates("gps", (long)LOCATE_FREQ_TIME, (float)LOCATE_ACCURACY, (LocationListener)this);
            this.mLocationProMgr.requestLocationUpdates("network", (long)LOCATE_FREQ_TIME, (float)LOCATE_ACCURACY, (LocationListener)this);
        }
        catch (Exception e) {
            LogUtils.o("requestLocation Exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void closeLocation() {
        LogUtils.o("closeLocation");
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
        switch (status) {
            case 2: {
                Log.i((String)TAG, (String)"GPS available");
                break;
            }
            case 0: {
                Log.i((String)TAG, (String)"GPS out of service");
                break;
            }
            case 1: {
                Log.i((String)TAG, (String)"GPS unavailable");
            }
        }
    }

    public void onProviderEnabled(String provider) {
        Log.i((String)TAG, (String)"onProviderEnabled");
    }

    public void onProviderDisabled(String provider) {
        Log.i((String)TAG, (String)"onProviderDisabled");
    }

    public void onLocationChanged(Location location) {
    }

    public void geocode2Address(int geocodeType, String latitude, String longitude, GeocodingListener listener) {
        ReportLocationData data = new ReportLocationData();
        data.setLatitude(latitude);
        data.setLongitude(longitude);
        new QueryAddressThread(geocodeType, data, listener).start();
    }

    public void address2Geocode(int geocodeType, String address, GeocodingListener listener) {
        ReportLocationData data = new ReportLocationData();
        data.setAddress(address);
        new QueryAddressThread(geocodeType, data, listener).start();
    }

    private void solveLocation(Location location) {
        LogUtils.o("solveLocation");
        long startTime = location.getTime();
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(startTime);
        Log.i((String)TAG, (String)("time:" + c.getTime()));
        Log.i((String)TAG, (String)("longitude:" + location.getLongitude()));
        Log.i((String)TAG, (String)("latitude:" + location.getLatitude()));
        this.closeLocation();
    }

    public static interface GeocodingListener {
        public static final int TYPE_GET_ADDRESS = 0;
        public static final int TYPE_GET_LOCATION = 1;
        public static final int TYPE_CONVERT_COORDINATION = 2;

        public void onGeocodingCompleted(int var1, String var2);
    }

    class QueryAddressThread
    extends Thread {
        private int mQueryType;
        private ReportLocationData mData;
        private GeocodingListener mGeocodingListener;

        public QueryAddressThread(int queryType, ReportLocationData data, GeocodingListener listener) {
            this.mQueryType = queryType;
            this.mData = data;
            this.mGeocodingListener = listener;
        }

        private String getJsonStr(String srcStr) {
            int start = srcStr.indexOf("{");
            int end = srcStr.lastIndexOf("}") + 1;
            return srcStr.substring(start, end);
        }

        private void convertCoords() throws Exception {
            String status = null;
            String str = null;
            String convertUrl = String.valueOf(CONVERT_COORDS_URL) + this.mData.getLongitude() + "," + this.mData.getLatitude();
            HttpGet httpGet = new HttpGet(convertUrl);
            HttpClient httpClient = HttpUtils.getHttpClientEx(BaiduLocationAction.this.mContext);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode == 200) {
                HttpEntity entity = response.getEntity();
                str = EntityUtils.toString((HttpEntity)entity);
                str = this.getJsonStr(str);
                LogUtils.i(TAG, "convertCoords result==" + str);
                str = this.getJsonStr(str);
                JSONObject convertResult = new JSONObject(str);
                status = convertResult.getString("status");
                if ("0".equals(status)) {
                    JSONArray convertResultArray = convertResult.getJSONArray("result");
                    if (convertResultArray.length() > 0) {
                        JSONObject json = convertResultArray.getJSONObject(0);
                        String longitude = json.getString("x");
                        String latitude = json.getString("y");
                        if (!TextUtils.isEmpty((CharSequence)latitude) && !TextUtils.isEmpty((CharSequence)longitude)) {
                            this.mData.setLongitude(longitude);
                            this.mData.setLatitude(latitude);
                        }
                    }
                } else {
                    throw new Exception("INVALID KEY OR PARAMETERS, status:" + status);
                }
            }
        }

        private String geocode(int geocodeType) throws Exception {
            String url = null;
            if (this.mQueryType == 0) {
                url = String.valueOf(GEOCODE_URL) + "&location=" + this.mData.getLatitude() + "," + this.mData.getLongitude();
            } else {
                String address = this.mData.getAddress();
                address = URLEncoder.encode(address, "UTF-8");
                url = String.valueOf(GEOCODE_URL) + "&address=" + address;
            }
            Log.i((String)TAG, (String)url);
            String result = "";
            HttpGet httpGet = new HttpGet(url);
            HttpClient httpClient = HttpUtils.getHttpClientEx(BaiduLocationAction.this.mContext);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode == 200) {
                HttpEntity entity = response.getEntity();
                result = EntityUtils.toString((HttpEntity)entity);
                result = this.getJsonStr(result);
                LogUtils.i(TAG, "result==" + result);
            }
            return result;
        }

        @Override
        public void run() {
            String result = null;
            try {
                try {
                    result = this.geocode(this.mQueryType);
                }
                catch (Exception e) {
                    LogUtils.o(String.valueOf(TAG) + " request address from baidu error: " + e.getMessage());
                    e.printStackTrace();
                    if (this.mGeocodingListener != null) {
                        this.mGeocodingListener.onGeocodingCompleted(this.mQueryType, result);
                    }
                }
            }
            finally {
                if (this.mGeocodingListener != null) {
                    this.mGeocodingListener.onGeocodingCompleted(this.mQueryType, result);
                }
            }
        }
    }
}

