/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.geofencing;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import java.io.Serializable;
import org.zywx.wbpalmstar.engine.EBrowserView;
import org.zywx.wbpalmstar.engine.universalex.EUExBase;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.geofencing.AppCanLocationProxy;
import org.zywx.wbpalmstar.plugin.geofencing.BaiduLocationAction;
import org.zywx.wbpalmstar.plugin.geofencing.CenterPoint;
import org.zywx.wbpalmstar.plugin.geofencing.GeoFenceReceiver;
import org.zywx.wbpalmstar.plugin.geofencing.LocationService;
import org.zywx.wbpalmstar.plugin.geofencing.utils.DeviceInfoUtils;
import org.zywx.wbpalmstar.plugin.geofencing.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.geofencing.utils.ReportSettings;

public class EUExGeoFencing
extends EUExBase {
    public static final String TAG = "uexGeoFencing";
    public static final String URL_GEOFENCE_REPORT = "/widgetStartup/geofenceReport/{softToken}";
    private static final String CB_COORDINATE_TO_ADDRESS = "uexGeoFencing.cbCoordinateToAddress";
    private static final String CB_ADDRESS_TO_COORDINATE = "uexGeoFencing.cbAddressToCoordinate";
    public static Context sContext;
    public static boolean sIsBackgroundReport;
    public static EUExGeoFencing sGeofenceCallback;

    static {
        sIsBackgroundReport = true;
    }

    public EUExGeoFencing(Context context, EBrowserView view) {
        super(context, view);
        sContext = context;
        Log.i((String)TAG, (String)"EUExGeoFencing Constuctor");
    }

    protected boolean clean() {
        return true;
    }

    public void open(String[] params) {
        LogUtils.o("uexGeoFencing open");
        if (params.length < 3) {
            return;
        }
        try {
            String timeStr = params[0];
            long time = Long.parseLong(timeStr) * 1000L;
            String reportUrl = params[1];
            String isBackgroundReport = params[2];
            String user = params[3];
            LogUtils.o("uexGeoFencing open reportUrl:" + reportUrl + " user:" + user + " isBackgroundReport:" + isBackgroundReport + " time: " + time);
            sIsBackgroundReport = !"1".equals(isBackgroundReport);
            Bundle bundle = new Bundle();
            bundle.putInt("switch", 0);
            bundle.putLong("delay_time", time);
            bundle.putString("user", user);
            bundle.putString("reportUrl", reportUrl);
            Intent intent = new Intent(this.mContext, LocationService.class);
            intent.putExtras(bundle);
            this.mContext.startService(intent);
        }
        catch (Exception e) {
            LogUtils.oe("open", e);
            e.printStackTrace();
        }
    }

    public void close(String[] params) {
        LogUtils.o("uexGeoFencing close");
        try {
            Intent intent = new Intent(this.mContext, LocationService.class);
            intent.putExtra("switch", 3);
            this.mContext.startService(intent);
        }
        catch (Exception e) {
            LogUtils.oe("close", e);
            e.printStackTrace();
        }
    }

    public void coordinateToAddress(String[] params) {
        LogUtils.o("uexGeoFencing coordinateToAddress");
        if (params.length < 2) {
            return;
        }
        String latitude = params[0];
        String longitude = params[1];
        BaiduLocationAction.newInstance(this.mContext, 0).geocode2Address(0, latitude, longitude, new BaiduLocationAction.GeocodingListener(){

            @Override
            public void onGeocodingCompleted(int type, String jsonStr) {
                if (type == 0) {
                    EUExGeoFencing.this.jsCallback(EUExGeoFencing.CB_COORDINATE_TO_ADDRESS, 0, 1, jsonStr);
                }
            }
        });
    }

    public void addressToCoordinate(String[] params) {
        LogUtils.o("uexGeoFencing addressToCoordinate");
        if (params.length < 1) {
            return;
        }
        String address = params[0];
        BaiduLocationAction.newInstance(this.mContext, 1).address2Geocode(1, address, new BaiduLocationAction.GeocodingListener(){

            @Override
            public void onGeocodingCompleted(int type, String jsonStr) {
                if (type == 1) {
                    EUExGeoFencing.this.jsCallback(EUExGeoFencing.CB_ADDRESS_TO_COORDINATE, 0, 1, jsonStr);
                }
            }
        });
    }

    public void openGeoFencing(String[] params) {
        LogUtils.o("uexGeoFencing openGeoFencing");
        if (params.length < 4) {
            return;
        }
        sGeofenceCallback = this;
        GeoFenceReceiver.initRegisterReceiver(this.mContext);
        String softToken = DeviceInfoUtils.getSoftToken(this.mContext);
        String host = EUExUtil.getString((String)"widget_startup_report_host");
        String reportUrl = String.valueOf(host) + URL_GEOFENCE_REPORT.replace("{softToken}", softToken);
        LogUtils.o("geofenceReportUrl: " + reportUrl);
        ReportSettings.getInstance(this.mContext).setLocationReportUrl(reportUrl);
        try {
            String opId = params[0];
            String latitudeStr = params[1];
            String longitudeStr = params[2];
            String rangeStr = params[3];
            String inMessage = "";
            String outMessage = "";
            if (params.length >= 6) {
                LogUtils.o("in and out Message is set");
                inMessage = params[4];
                outMessage = params[5];
            }
            LogUtils.o("uexGeoFencing openGeoFencing  latitudeStr:" + latitudeStr + " longitudeStr:" + longitudeStr + " rangeStr:" + rangeStr + " inMessage:" + inMessage + " outMessage:" + outMessage);
            float range = Float.parseFloat(rangeStr);
            float latitude = Float.parseFloat(latitudeStr);
            float longitude = Float.parseFloat(longitudeStr);
            CenterPoint point = new CenterPoint(opId, latitude, longitude, range, -1, inMessage, outMessage);
            Intent intent = new Intent(this.mContext, LocationService.class);
            intent.setAction("org.zywx.wbpalmstar.plugin.addgeofence");
            intent.putExtra("geofenceCenterPoint", (Serializable)point);
            this.mContext.startService(intent);
        }
        catch (Exception e) {
            LogUtils.oe("openGeoFencing", e);
            e.printStackTrace();
        }
    }

    public void openGeoFencing2(String[] params) {
        LogUtils.o("uexGeoFencing openGeoFencing2");
        if (params.length < 4) {
            return;
        }
        sGeofenceCallback = this;
        String softToken = DeviceInfoUtils.getSoftToken(this.mContext);
        String host = EUExUtil.getString((String)"widget_startup_report_host");
        String reportUrl = String.valueOf(host) + URL_GEOFENCE_REPORT.replace("{softToken}", softToken);
        LogUtils.o("geofenceReportUrl: " + reportUrl);
        ReportSettings.getInstance(this.mContext).setLocationReportUrl(reportUrl);
        try {
            String opId = params[0];
            String latitudeStr = params[1];
            String longitudeStr = params[2];
            String rangeStr = params[3];
            String inMessage = "";
            String outMessage = "";
            if (params.length >= 6) {
                LogUtils.o("in and out Message is set");
                inMessage = params[4];
                outMessage = params[5];
            }
            LogUtils.o("uexGeoFencing openGeoFencing  latitudeStr:" + latitudeStr + " longitudeStr:" + longitudeStr + " rangeStr:" + rangeStr + " inMessage:" + inMessage + " outMessage:" + outMessage);
            float range = Float.parseFloat(rangeStr);
            float latitude = Float.parseFloat(latitudeStr);
            float longitude = Float.parseFloat(longitudeStr);
            CenterPoint point = new CenterPoint(opId, latitude, longitude, range, -1, inMessage, outMessage);
            AppCanLocationProxy.getGeoFencingProxy(this.mContext).addGeoFence2(point);
        }
        catch (Exception e) {
            LogUtils.oe("openGeoFencing", e);
            e.printStackTrace();
        }
    }

    public void closeGeoFencing(String[] params) {
        try {
            Intent intent = new Intent(this.mContext, LocationService.class);
            intent.setAction("org.zywx.wbpalmstar.plugin.removegeofence");
            if (params.length > 0) {
                String opId = params[0];
                LogUtils.o("uexGeoFencing closeGeoFencing: opId-->" + opId);
                intent.putExtra("geoId", opId);
            } else {
                LogUtils.o("uexGeoFencing closeAllGeoFencing");
            }
            this.mContext.startService(intent);
        }
        catch (Exception e) {
            LogUtils.oe("closeGeoFencing", e);
            e.printStackTrace();
        }
    }

    public void onGeoFencingChanged(CenterPoint point) {
        LogUtils.o("uexGeoFencing onGeoFencingChanged: " + point);
        String message = null;
        if (point.isInGeoFence == 0) {
            message = point.inMessage;
            if (TextUtils.isEmpty((CharSequence)message)) {
                return;
            }
        } else if (point.isInGeoFence == 1) {
            message = point.outMessage;
            if (TextUtils.isEmpty((CharSequence)message)) {
                return;
            }
        } else {
            return;
        }
        this.showAlert(message);
    }

    private void showAlert(final String message) {
        LogUtils.o("showAlert: " + message);
        ((Activity)this.mContext).runOnUiThread(new Runnable(){

            @Override
            public void run() {
                String hintMessage = message;
                if (TextUtils.isEmpty((CharSequence)hintMessage)) {
                    hintMessage = "\u5730\u7406\u56f4\u680f\u72b6\u6001\u53d1\u751f\u4e86\u6539\u53d8\uff01";
                }
                LogUtils.o("showAlert : " + hintMessage);
                AlertDialog.Builder tDialog = new AlertDialog.Builder(EUExGeoFencing.this.mContext);
                tDialog.setCancelable(false);
                tDialog.setTitle((CharSequence)"\u63d0\u793a");
                tDialog.setMessage((CharSequence)hintMessage);
                tDialog.setPositiveButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                    }
                });
                tDialog.show();
            }
        });
    }
}

