/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.geofencing;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import org.zywx.wbpalmstar.plugin.geofencing.CenterPoint;
import org.zywx.wbpalmstar.plugin.geofencing.EUExGeoFencing;
import org.zywx.wbpalmstar.plugin.geofencing.LogUtils;

public class GeoFenceReceiver
extends BroadcastReceiver {
    private static final String TAG = "GeoFenceReceiver";
    private static final String IS_REPORT_GEOFENCE_SUCCESS = "isReportGeofenceSuccess";
    private static GeoFenceReceiver receiver = null;

    public static GeoFenceReceiver initRegisterReceiver(Context context) {
        LogUtils.o("GeoFenceReceiver initRegisterReceiver");
        if (receiver == null) {
            receiver = new GeoFenceReceiver();
            IntentFilter filter = new IntentFilter();
            filter.addAction("org.zywx.wbpalmstar.plugin.geofencereceived");
            context.registerReceiver((BroadcastReceiver)receiver, filter);
        }
        return receiver;
    }

    public void onReceive(Context context, Intent intent) {
        String action = null;
        boolean isSuccess = false;
        if (intent != null) {
            action = intent.getAction();
            isSuccess = intent.getBooleanExtra(IS_REPORT_GEOFENCE_SUCCESS, true);
            LogUtils.o("GeoFenceReceiver onReceive:" + action);
            if ("org.zywx.wbpalmstar.plugin.geofencereceived".equals(action)) {
                int status = intent.getIntExtra("status", -1);
                String geoId = intent.getStringExtra("geoId");
                String inMessage = intent.getStringExtra("inMessage");
                String outMessage = intent.getStringExtra("outMessage");
                CenterPoint point = new CenterPoint(geoId, 0.0, 0.0, 0.0f, status, inMessage, outMessage);
                if (EUExGeoFencing.sGeofenceCallback != null) {
                    EUExGeoFencing.sGeofenceCallback.onGeoFencingChanged(point);
                }
            }
        }
    }
}

