/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.geofencing;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.text.TextUtils;
import org.zywx.wbpalmstar.plugin.geofencing.AppCanLocationProxy;
import org.zywx.wbpalmstar.plugin.geofencing.CenterPoint;
import org.zywx.wbpalmstar.plugin.geofencing.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.geofencing.utils.ReportSettings;

public class LocationService
extends Service {
    public static final String TAG = "LocationService";
    public static final int SWITCH_OPEN = 0;
    public static final int SWITCH_RESUME = 1;
    public static final int SWITCH_PAUSE = 2;
    public static final int SWITCH_CLOSED = 3;
    private ReportSettings settings;
    private AppCanLocationProxy locationAction;
    private AppCanLocationProxy geoFencingProxy;
    private long reqTime;
    private String userName;
    private String reportUrl;
    private int reportSwitch;
    private long lastReportTime;

    public void onCreate() {
        super.onCreate();
        LogUtils.i(TAG, "onCreate");
        this.settings = ReportSettings.getInstance((Context)this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int onStartCommand(Intent intent, int flags, int startId) {
        LogUtils.o("LocationService onStartCommand");
        try {
            long nowTime = System.currentTimeMillis();
            if (intent != null) {
                String action = intent.getAction();
                if ("org.zywx.wbpalmstar.plugin.geofencing".equals(action)) {
                    if (this.geoFencingProxy == null) {
                        this.geoFencingProxy = AppCanLocationProxy.getGeoFencingProxy((Context)this);
                    }
                    this.geoFencingProxy.requestGeoFencingLoopLocation();
                    return 1;
                }
                if ("org.zywx.wbpalmstar.plugin.addgeofence".equals(action)) {
                    if (this.geoFencingProxy == null) {
                        this.geoFencingProxy = AppCanLocationProxy.getGeoFencingProxy((Context)this);
                    }
                    try {
                        CenterPoint geofencePoint = (CenterPoint)intent.getSerializableExtra("geofenceCenterPoint");
                        this.geoFencingProxy.addGeoFence(geofencePoint);
                        return 1;
                    }
                    catch (Exception e) {
                        LogUtils.oe("onStartCommand-AddGeoFence", e);
                        e.printStackTrace();
                    }
                    return 1;
                }
                if ("org.zywx.wbpalmstar.plugin.removegeofence".equals(action)) {
                    String opId = intent.getStringExtra("geoId");
                    if (TextUtils.isEmpty((CharSequence)opId)) {
                        AppCanLocationProxy.getGeoFencingProxy((Context)this).removeAllGeofence();
                        return 1;
                    }
                    AppCanLocationProxy.getGeoFencingProxy((Context)this).removeGeofence(opId);
                    return 1;
                }
                this.reportSwitch = intent.getIntExtra("switch", -1);
            } else {
                this.reportSwitch = -1;
            }
            switch (this.reportSwitch) {
                case 0: {
                    this.reqTime = intent.getLongExtra("delay_time", -1L);
                    this.userName = intent.getStringExtra("user");
                    this.reportUrl = intent.getStringExtra("reportUrl");
                    this.settings.setLocationReportDelayTime(this.reqTime);
                    this.settings.setLocationReportUrl(this.reportUrl);
                    this.settings.setLocationUser(this.userName);
                    this.settings.setLocationSwitch(0);
                    break;
                }
                case 2: 
                case 3: {
                    this.settings.setLocationSwitch(3);
                    break;
                }
                case 1: {
                    this.settings.setLocationSwitch(0);
                    this.reqTime = this.settings.getLocationReportDelayTime();
                    this.userName = this.settings.getLocationUser();
                    this.reportUrl = this.settings.getLocationReportUrl();
                    break;
                }
                default: {
                    this.reportSwitch = this.settings.getLocationSwitch();
                    this.reqTime = this.settings.getLocationReportDelayTime();
                    this.userName = this.settings.getLocationUser();
                    this.reportUrl = this.settings.getLocationReportUrl();
                }
            }
            this.lastReportTime = this.settings.getReportTime();
            LogUtils.o("LocationService reportSwitch " + this.reportSwitch);
            if (!(this.lastReportTime != -1L && (nowTime - this.lastReportTime) / 1000L < this.reqTime || this.reportSwitch != 0 && this.reportSwitch != 1)) {
                if (this.locationAction == null) {
                    this.locationAction = AppCanLocationProxy.newInstance(this.getApplicationContext(), 1);
                }
                if (this.reportSwitch == 0) {
                    this.locationAction.requestLocation(TAG, this.reqTime);
                    LogUtils.o("LocationService location is opened");
                    return 1;
                }
                this.locationAction.setIsReport(true);
                LogUtils.o("LocationService location is resumed");
                return 1;
            }
            if (this.reportSwitch == 1) {
                if (this.locationAction == null) return 1;
                this.locationAction.setIsReport(true);
                LogUtils.o("LocationService location is resumed");
                return 1;
            }
            if (this.reportSwitch != 3 && this.reportSwitch != 2) {
                LogUtils.o("LocationService it's not the right time to report location: lastReportTime-->" + this.lastReportTime + " nowTime-->" + nowTime);
                return 1;
            }
            this.settings.setLocationSwitch(3);
            if (this.reportSwitch != 3) {
                this.locationAction.setIsReport(false);
                LogUtils.o("LocationService location is paused");
                return 1;
            }
            this.settings.setReportTime(-1L);
            if (this.locationAction != null) {
                this.locationAction.closeLocation();
                this.locationAction = null;
            }
            this.stopSelf();
            LogUtils.o("LocationService location is closed");
            return 1;
        }
        catch (Exception e) {
            LogUtils.oe("LocationStartCommand", e);
            e.printStackTrace();
        }
        return 1;
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public boolean onUnbind(Intent intent) {
        return super.onUnbind(intent);
    }

    public void onRebind(Intent intent) {
        super.onRebind(intent);
    }
}

