/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.geofencing;

import android.app.IntentService;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;
import java.util.ArrayList;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.zywx.wbpalmstar.engine.EBrowserActivity;
import org.zywx.wbpalmstar.plugin.geofencing.utils.DeviceInfoUtils;
import org.zywx.wbpalmstar.plugin.geofencing.utils.HttpUtils;
import org.zywx.wbpalmstar.plugin.geofencing.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.geofencing.utils.ReportSettings;

public class ReportService
extends IntentService {
    private static final String TAG = "LocationReportService";
    private static int notifyId = 0;
    public static final String BROADCAST_ACTION_GEOFENCE_RECEIVED = "org.zywx.wbpalmstar.plugin.geofencereceived";
    public static final String ACTION_REMOVEGEOFENCE = "org.zywx.wbpalmstar.plugin.removegeofence";
    public static final String ACTION_ADDGEOFENCE = "org.zywx.wbpalmstar.plugin.addgeofence";
    public static final String ACTION_GEOFENCE = "org.zywx.wbpalmstar.plugin.geofencing";
    public static final String ACTION_LOCATION = "org.zywx.wbpalmstar.plugin.location";
    public static final String INTENT_GEOCENTERPOINT = "geofenceCenterPoint";
    public static final String INTENT_REPORTURL = "reportUrl";
    public static final String INTENT_USER = "user";
    public static final String INTENT_TOKEN = "token";
    public static final String INTENT_INMESSAGE = "inMessage";
    public static final String INTENT_OUTMESSAGE = "outMessage";
    public static final String INTENT_GEOID = "geoId";
    public static final String INTENT_GEOTYPE_STATUS = "status";
    public static final String INTENT_LONGITUDE = "longitude";
    public static final String INTENT_LATITUDE = "latitude";
    public static final String INTENT_RANGE = "range";
    public static final String INTENT_DELAY_TIME = "delay_time";
    public static final String INTENT_SWITCH = "switch";

    public ReportService() {
        super("ReportService");
    }

    protected void onHandleIntent(Intent intent) {
        LogUtils.o("LocationReportService onHandleIntent");
        try {
            if (intent == null || !this.getPackageName().equals(intent.getPackage())) {
                LogUtils.w(TAG, "intent is null or intent is not send by this app");
                return;
            }
            new ReportTask(intent).execute(new Void[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showNotificationTest(String ContentText) {
        LogUtils.o("showNotificationTest: " + ContentText);
        int iconId = this.getApplicationInfo().icon;
        NotificationManager nm = (NotificationManager)this.getSystemService("notification");
        Notification.Builder builder = new Notification.Builder(this.getApplicationContext());
        builder.setContentTitle((CharSequence)"\u5730\u7406\u56f4\u680f\u6d4b\u8bd5\u63d0\u9192").setContentInfo((CharSequence)"zypTest").setContentText((CharSequence)ContentText).setTicker((CharSequence)"\u5730\u7406\u56f4\u680f\u72b6\u6001\u6539\u53d8\u4e86").setSmallIcon(iconId).setLargeIcon(BitmapFactory.decodeResource((Resources)this.getResources(), (int)iconId)).setWhen(System.currentTimeMillis()).setAutoCancel(true).setContentIntent(PendingIntent.getActivity((Context)this.getApplicationContext(), (int)notifyId, (Intent)new Intent(this.getApplicationContext(), EBrowserActivity.class), (int)0x8000000, null));
        Notification notification = builder.build();
        notification.defaults = -1;
        nm.notify(notifyId++, notification);
    }

    class ReportTask
    extends AsyncTask<Void, Void, String> {
        private Intent intent;
        private String type;
        private String geoId;
        private String inMessage;
        private String outMessage;

        public ReportTask(Intent intent) {
            this.intent = intent;
        }

        protected String doInBackground(Void ... params) {
            ReportSettings settings = ReportSettings.getInstance((Context)ReportService.this);
            String action = this.intent.getAction();
            String reportUrl = settings.getLocationReportUrl();
            LogUtils.o("LocationReportService action:" + action + " reportUrl:" + reportUrl);
            String result = null;
            long reportTime = settings.getReportTime();
            long delayTime = settings.getLocationReportDelayTime();
            long nowTime = System.currentTimeMillis();
            LogUtils.o("LocationReportService lastReportTime: " + reportTime + " currentTime: " + nowTime + " delayTime: " + delayTime);
            ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
            try {
                if (!ReportService.ACTION_LOCATION.equals(action) && ReportService.ACTION_GEOFENCE.equals(action)) {
                    int status = this.intent.getIntExtra(ReportService.INTENT_GEOTYPE_STATUS, -1);
                    String deviceToken = DeviceInfoUtils.getDeviceToken((Context)ReportService.this);
                    this.geoId = this.intent.getStringExtra(ReportService.INTENT_GEOID);
                    this.inMessage = this.intent.getStringExtra(ReportService.INTENT_INMESSAGE);
                    this.outMessage = this.intent.getStringExtra(ReportService.INTENT_OUTMESSAGE);
                    this.type = status == 0 ? "geoIn" : "geoOut";
                    nameValuePairs.add((NameValuePair)new BasicNameValuePair("udid", deviceToken));
                    nameValuePairs.add((NameValuePair)new BasicNameValuePair(ReportService.INTENT_GEOID, this.geoId));
                    nameValuePairs.add((NameValuePair)new BasicNameValuePair("type", this.type));
                    Intent broadcastIntent = new Intent();
                    broadcastIntent.setAction(ReportService.BROADCAST_ACTION_GEOFENCE_RECEIVED);
                    broadcastIntent.putExtra(ReportService.INTENT_GEOTYPE_STATUS, status);
                    broadcastIntent.putExtra(ReportService.INTENT_GEOID, this.geoId);
                    broadcastIntent.putExtra(ReportService.INTENT_INMESSAGE, this.inMessage);
                    broadcastIntent.putExtra(ReportService.INTENT_OUTMESSAGE, this.outMessage);
                    ReportService.this.sendBroadcast(broadcastIntent);
                }
                if ((result = HttpUtils.sendPostDataByNameValuePair(reportUrl, nameValuePairs, (Context)ReportService.this)) != null) {
                    settings.setReportTime(System.currentTimeMillis());
                }
                LogUtils.o("LocationReportService action:" + action + "result:" + result);
            }
            catch (Exception e) {
                LogUtils.oe("ReportServiceDoInBackground", e);
                e.printStackTrace();
            }
            return result;
        }

        protected void onPostExecute(String result) {
        }
    }
}

