/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.geofencing.utils;

public class CoordinationUtils {
    private static final double x_pi = 52.35987755982988;

    public static CoorPoint bdEncrypt(double gg_lat, double gg_lon) {
        CoorPoint result = new CoorPoint();
        double x = gg_lon;
        double y = gg_lat;
        double z = Math.sqrt(x * x + y * y) + 2.0E-5 * Math.sin(y * 52.35987755982988);
        double theta = Math.atan2(y, x) + 3.0E-6 * Math.cos(x * 52.35987755982988);
        result.longitude = z * Math.cos(theta) + 0.0065;
        result.latitude = z * Math.sin(theta) + 0.006;
        return result;
    }

    public static CoorPoint bdDecrypt(double bd_lat, double bd_lon) {
        CoorPoint result = new CoorPoint();
        double x = bd_lon - 0.0065;
        double y = bd_lat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * 52.35987755982988);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * 52.35987755982988);
        result.longitude = z * Math.cos(theta);
        result.latitude = z * Math.sin(theta);
        return result;
    }

    public static class CoorPoint {
        public double latitude;
        public double longitude;
    }
}

