/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.geofencing.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;

public class DeviceInfoUtils {
    public static String getSoftToken(Context mContext) {
        String appKey = EUExUtil.getString((String)"appkey");
        SharedPreferences preferences = mContext.getSharedPreferences("app", 0);
        String softToken = preferences.getString("softToken", null);
        if (softToken != null) {
            return softToken;
        }
        String[] val = new String[4];
        try {
            val[0] = DeviceInfoUtils.getMacAddress(mContext);
            TelephonyManager telephonyManager = (TelephonyManager)mContext.getSystemService("phone");
            val[1] = telephonyManager.getDeviceId();
            val[2] = DeviceInfoUtils.getCPUSerial();
            val[3] = appKey;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        softToken = DeviceInfoUtils.getMD5Code(val);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("softToken", softToken);
        editor.commit();
        return softToken;
    }

    public static String getDeviceToken(Context mContext) {
        SharedPreferences preferences = mContext.getSharedPreferences("app", 0);
        String deviceToken = preferences.getString("deviceToken", null);
        if (deviceToken != null) {
            return deviceToken;
        }
        String[] val = new String[3];
        try {
            val[0] = DeviceInfoUtils.getMacAddress(mContext);
            TelephonyManager telephonyManager = (TelephonyManager)mContext.getSystemService("phone");
            val[1] = telephonyManager.getDeviceId();
            val[2] = DeviceInfoUtils.getCPUSerial();
        }
        catch (Exception telephonyManager) {
            // empty catch block
        }
        deviceToken = DeviceInfoUtils.getMD5Code(val);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("deviceToken", deviceToken);
        editor.commit();
        return deviceToken;
    }

    private static String getCPUSerial() {
        String str = "";
        String strCPU = "";
        String cpuAddress = "0000000000000000";
        try {
            Process pp = Runtime.getRuntime().exec("cat /proc/cpuinfo");
            InputStreamReader ir = new InputStreamReader(pp.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            while (str != null) {
                str = input.readLine();
                if (str != null) {
                    if (str.indexOf("Serial") <= -1) continue;
                    strCPU = str.substring(str.indexOf(":") + 1, str.length());
                    cpuAddress = strCPU.trim();
                }
                break;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return cpuAddress;
    }

    public static String getMD5Code(String[] value) {
        if (value == null || value.length == 0) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            String[] stringArray = value;
            int n = value.length;
            int n2 = 0;
            while (n2 < n) {
                String va = stringArray[n2];
                if (va == null) {
                    va = "";
                }
                md.update(va.getBytes());
                ++n2;
            }
            byte[] md5Bytes = md.digest();
            StringBuffer hexValue = new StringBuffer();
            int i = 0;
            while (i < md5Bytes.length) {
                int val = md5Bytes[i] & 0xFF;
                if (val < 16) {
                    hexValue.append("0");
                }
                hexValue.append(Integer.toHexString(val));
                ++i;
            }
            return hexValue.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getMacAddress(Context mContext) {
        String macSerial = null;
        try {
            WifiManager wifi = (WifiManager)mContext.getSystemService("wifi");
            WifiInfo info = wifi.getConnectionInfo();
            macSerial = info.getMacAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (macSerial == null) {
            macSerial = DeviceInfoUtils.getMac();
        }
        return macSerial;
    }

    private static String getMac() {
        String macSerial = "";
        String str = "";
        try {
            Process pp = Runtime.getRuntime().exec("cat /sys/class/net/wlan0/address ");
            InputStreamReader ir = new InputStreamReader(pp.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            while (str != null) {
                str = input.readLine();
                if (str == null) continue;
                macSerial = str.trim();
                break;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return macSerial;
    }
}

