/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.geofencing.utils;

public class DistanceCalcUtils {
    private static final double EARTH_RADIUS = 6378.137;

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double getDistance(double lat1, double lon1, double lat2, double lon2) {
        double radLat1 = DistanceCalcUtils.rad(lat1);
        double radLat2 = DistanceCalcUtils.rad(lat2);
        double a = radLat1 - radLat2;
        double b = DistanceCalcUtils.rad(lon1) - DistanceCalcUtils.rad(lon2);
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s = s * 6378.137 * 1000.0;
        return s;
    }
}

