/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.geofencing.utils;

import android.content.Context;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.util.EntityUtils;
import org.zywx.wbpalmstar.base.BDebug;
import org.zywx.wbpalmstar.platform.certificates.Http;
import org.zywx.wbpalmstar.plugin.geofencing.utils.LogUtils;

public class HttpUtils {
    private static final int TIME_OUT = 300000;
    private static final int RETRY_TIMES = 3;
    private static boolean mIsCertificate = false;
    private static String mPassWord = null;
    private static String mPath = null;
    private static List<HttpClient> httpClients = new ArrayList<HttpClient>();

    public static HttpClient getHttpClientEx(Context mCtx) {
        HttpClient httpClient = null;
        httpClient = mIsCertificate ? Http.getHttpsClientWithCert((String)mPassWord, (String)mPath, (int)15000, (Context)mCtx) : Http.getHttpsClient((int)15000);
        httpClients.add(httpClient);
        return httpClient;
    }

    public static String sendPostData(String data, String url, Context mCtx) {
        HttpPost post = new HttpPost(url);
        HttpClient httpClient = HttpUtils.getSSLHttpClient(mCtx);
        HttpResponse httpResponse = null;
        post.setHeader("Accept", "*/*");
        try {
            post.setEntity((HttpEntity)new ByteArrayEntity(data.getBytes()));
            httpResponse = httpClient.execute((HttpUriRequest)post);
            int responesCode = httpResponse.getStatusLine().getStatusCode();
            if (responesCode == 200) {
                String res;
                String string = res = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                return string;
            }
            try {
                System.out.println(EntityUtils.toString((HttpEntity)httpResponse.getEntity()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            if (post != null) {
                post.abort();
                post = null;
            }
            if (httpResponse != null) {
                httpResponse = null;
            }
            if (httpClient != null) {
                httpClient.getConnectionManager().shutdown();
                httpClient = null;
            }
        }
        return null;
    }

    public static String sendPostWithFile(String url, List<NameValuePair> nameValuePairs, Map<String, String> fileMap, Context mCtx) {
        HttpPost post = new HttpPost(url);
        HttpClient httpClient = HttpUtils.getSSLHttpClient(mCtx);
        HttpResponse httpResponse = null;
        post.setHeader("Accept", "*/*");
        try {
            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            int index = 0;
            while (index < nameValuePairs.size()) {
                entity.addPart(nameValuePairs.get(index).getName(), (ContentBody)new StringBody(nameValuePairs.get(index).getValue(), Charset.forName("UTF-8")));
                ++index;
            }
            if (fileMap != null) {
                for (Map.Entry<String, String> entry : fileMap.entrySet()) {
                    File file = new File(entry.getValue());
                    entity.addPart(entry.getKey(), (ContentBody)new FileBody(file));
                }
            }
            post.setEntity((HttpEntity)entity);
            httpResponse = httpClient.execute((HttpUriRequest)post);
            int responesCode = httpResponse.getStatusLine().getStatusCode();
            BDebug.d((String)"debug", (String)("responesCode == " + responesCode));
            if (responesCode == 200) {
                String string = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                return string;
            }
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (post != null) {
                post.abort();
                post = null;
            }
            if (httpResponse != null) {
                httpResponse = null;
            }
            if (httpClient != null) {
                httpClient.getConnectionManager().shutdown();
                httpClient = null;
            }
        }
        return null;
    }

    public static String sendPostDataByNameValuePair(String url, List<NameValuePair> nameValuePairs, Context mCtx) {
        HttpPost post = new HttpPost(url);
        HttpClient httpClient = HttpUtils.getSSLHttpClient(mCtx);
        HttpResponse httpResponse = null;
        post.setHeader("Accept", "*/*");
        LogUtils.o("sendPostDataByNameValuePair: " + url);
        try {
            try {
                int i = 0;
                while (i < nameValuePairs.size()) {
                    NameValuePair nvp = nameValuePairs.get(i);
                    LogUtils.o(String.valueOf(nvp.getName()) + "=" + nvp.getValue());
                    ++i;
                }
            }
            catch (Exception e) {
                LogUtils.oe("sendPostDataByNameValuePair", e);
            }
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, "UTF-8"));
            httpResponse = httpClient.execute((HttpUriRequest)post);
            int responesCode = httpResponse.getStatusLine().getStatusCode();
            if (responesCode == 200) {
                String res;
                String string = res = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                return string;
            }
        }
        catch (Exception e) {
            LogUtils.oe("sendPostDataByNameValuePair", e);
            e.printStackTrace();
        }
        finally {
            if (post != null) {
                post.abort();
                post = null;
            }
            if (httpResponse != null) {
                httpResponse = null;
            }
            if (httpClient != null) {
                httpClient.getConnectionManager().shutdown();
                httpClient = null;
            }
        }
        return null;
    }

    public static String getGetData(String url, Context mCtx) {
        HttpGet get = new HttpGet(url);
        HttpResponse httpResponse = null;
        HttpClient httpClient = HttpUtils.getSSLHttpClient(mCtx);
        get.setHeader("Accept", "*/*");
        try {
            httpResponse = httpClient.execute((HttpUriRequest)get);
            int responesCode = httpResponse.getStatusLine().getStatusCode();
            if (responesCode == 200) {
                String res;
                String string = res = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (get != null) {
                get.abort();
                get = null;
            }
            if (httpResponse != null) {
                httpResponse = null;
            }
            if (httpClient != null) {
                httpClient.getConnectionManager().shutdown();
                httpClient = null;
            }
        }
        return null;
    }

    public static void setCertificate(boolean isCertificate, String cPassWord, String cPath, Context ctx) {
        mIsCertificate = isCertificate;
        mPassWord = cPassWord;
        mPath = cPath;
    }

    public static void close() {
        for (HttpClient httpClient : httpClients) {
            if (httpClient == null) continue;
            httpClient.getConnectionManager().shutdown();
            Object var0_1 = null;
        }
        httpClients.clear();
    }

    public static HttpClient getSSLHttpClient(Context mCtx) {
        HttpClient httpClient = null;
        httpClient = mIsCertificate ? Http.getHttpsClientWithCert((String)mPassWord, (String)mPath, (int)300000, (Context)mCtx) : Http.getHttpsClient((int)300000);
        if (httpClient != null && httpClient instanceof DefaultHttpClient) {
            DefaultHttpRequestRetryHandler dhr = new DefaultHttpRequestRetryHandler(3, true);
            ((DefaultHttpClient)httpClient).setHttpRequestRetryHandler((HttpRequestRetryHandler)dhr);
        }
        httpClients.add(httpClient);
        return httpClient;
    }

    static class ESSLSocketFactory
    extends SSLSocketFactory {
        SSLContext mSSLContext = SSLContext.getInstance("TLS");

        public ESSLSocketFactory(KeyStore truststore) throws Exception {
            super(truststore);
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            this.mSSLContext.init(null, new TrustManager[]{tm}, null);
        }

        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
            return this.mSSLContext.getSocketFactory().createSocket(socket, host, port, autoClose);
        }

        public Socket createSocket() throws IOException {
            return this.mSSLContext.getSocketFactory().createSocket();
        }
    }
}

