/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.geofencing.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import java.util.HashMap;
import java.util.Set;
import org.zywx.wbpalmstar.plugin.geofencing.CenterPoint;
import org.zywx.wbpalmstar.plugin.geofencing.utils.LogUtils;

public class ReportSettings {
    public static final String TAG = "ReportSettingsUtils";
    private static final String SP_NAME_LOCATION_REPORT = "plugin_reportlocation_location";
    private static final String SP_NAME_GEOFENCE_REPORT = "plugin_reportlocation_geofence";
    private static final String SP_APP = "app";
    private static ReportSettings sReportSettings;
    private SharedPreferences locationSp;
    private SharedPreferences geofenceSp;
    private SharedPreferences appSp;

    private ReportSettings() {
    }

    private ReportSettings(Context context) {
        this.locationSp = context.getSharedPreferences(SP_NAME_LOCATION_REPORT, 0);
        this.geofenceSp = context.getSharedPreferences(SP_NAME_GEOFENCE_REPORT, 0);
        this.appSp = context.getSharedPreferences(SP_APP, 0);
    }

    public static ReportSettings getInstance(Context context) {
        if (sReportSettings == null) {
            sReportSettings = new ReportSettings(context);
        }
        return sReportSettings;
    }

    public synchronized long getGeoFencingLocationDelayTime() {
        long delayTime = this.locationSp.getLong("geofencingDelayTime", 0L);
        return delayTime;
    }

    public synchronized void setGeoFencingLocationDelayTime(long delayTime) {
        this.locationSp.edit().putLong("geofencingDelayTime", delayTime).apply();
    }

    public synchronized long getLocationReportDelayTime() {
        long delayTime = this.locationSp.getLong("delayTime", 0L);
        return delayTime;
    }

    public synchronized void setLocationReportDelayTime(long delayTime) {
        this.locationSp.edit().putLong("delayTime", delayTime).apply();
    }

    public synchronized int getLocationSwitch() {
        int isOpen = this.locationSp.getInt("locationSwitch", -1);
        return isOpen;
    }

    public synchronized void setLocationSwitch(int isOpen) {
        this.locationSp.edit().putInt("locationSwitch", isOpen).commit();
    }

    public synchronized void closeLocationSwitch() {
        LogUtils.o("closeLocationSwitch");
        this.locationSp.edit().remove("locationSwitch").commit();
    }

    public synchronized String getLocationReportUrl() {
        String reportUrl = this.locationSp.getString("reportUrl", "");
        return reportUrl;
    }

    public synchronized void setLocationReportUrl(String reportUrl) {
        this.locationSp.edit().putString("reportUrl", reportUrl).apply();
    }

    public synchronized String getLocationUser() {
        String user = this.locationSp.getString("user", "");
        return user;
    }

    public synchronized void setLocationUser(String user) {
        this.locationSp.edit().putString("user", user).apply();
    }

    public synchronized long getReportTime() {
        long reportTime = this.locationSp.getLong("reportTime", -1L);
        return reportTime;
    }

    public synchronized void setReportTime(long reportTime) {
        this.locationSp.edit().putLong("reportTime", reportTime).apply();
    }

    public synchronized HashMap<String, CenterPoint> getAllGeofencePointMap() {
        HashMap<String, CenterPoint> map = new HashMap<String, CenterPoint>();
        try {
            Set keySet = this.geofenceSp.getAll().keySet();
            for (String key : keySet) {
                String geopointDataStr = this.geofenceSp.getString(key, "");
                if (TextUtils.isEmpty((CharSequence)geopointDataStr)) continue;
                CenterPoint point = this.getGeofencePointFromString(geopointDataStr);
                map.put(key, point);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public synchronized void addGeofencePoint(CenterPoint point) {
        String pointData = this.parseGeofencePoint2String(point);
        this.geofenceSp.edit().putString(point.geoId, pointData).apply();
        LogUtils.o("addGeofencePoint: " + point.geoId + " is added");
    }

    public synchronized void removeGeofencePoint(String opId) {
        this.geofenceSp.edit().remove(opId).apply();
        LogUtils.o("removeGeofencePoint: " + opId + " is removed");
    }

    public synchronized void removeAllGeofencePoint() {
        Set keySet = this.geofenceSp.getAll().keySet();
        for (String key : keySet) {
            this.geofenceSp.edit().remove(key).apply();
        }
    }

    public String parseGeofencePoint2String(CenterPoint point) {
        StringBuilder strb = new StringBuilder();
        strb.append(point.geoId).append(";").append(point.latitude).append(";").append(point.longitude).append(";").append(point.range).append(";").append(point.reportUrl).append(";").append(point.extraData).append(";").append(point.isInGeoFence).append(";").append(point.inMessage).append(";").append(point.outMessage);
        String pointData = strb.toString();
        return pointData;
    }

    public CenterPoint getGeofencePointFromString(String data) {
        CenterPoint centerPoint = null;
        try {
            String[] params = data.split(";");
            String opId = params[0];
            String latitudeStr = params[1];
            String longitudeStr = params[2];
            String rangeStr = params[3];
            String reportUrl = params[4];
            String extraData = params[5];
            String isInGeoFenceStr = params[6];
            String inMessage = "";
            String outMessage = "";
            if (params.length >= 9) {
                inMessage = params[7];
                outMessage = params[8];
            }
            double latitude = Double.parseDouble(latitudeStr);
            double longitude = Double.parseDouble(longitudeStr);
            float range = Float.parseFloat(rangeStr);
            int isInGeoFence = Integer.parseInt(isInGeoFenceStr);
            centerPoint = new CenterPoint(opId, latitude, longitude, extraData, reportUrl, range, isInGeoFence, inMessage, outMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return centerPoint;
    }

    public String getSoftToken() {
        String softToken = this.appSp.getString("softToken", null);
        return softToken;
    }
}

