/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmcm;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.text.format.Time;
import android.util.DisplayMetrics;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Map;
import org.zywx.wbpalmstar.base.BUtility;

public class MCMUtility {
    private static boolean isLog = true;

    public static String getLocalIpAddress() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    return inetAddress.getHostAddress().toString();
                }
            }
        }
        catch (SocketException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static String getDeviceResolution(Context activity) {
        if (activity == null) {
            return null;
        }
        DisplayMetrics dm = activity.getResources().getDisplayMetrics();
        return dm.widthPixels + "*" + dm.heightPixels;
    }

    public static String getMapToString(Map inAttriDict) {
        String attriDict = "";
        if (inAttriDict != null) {
            for (Object object : inAttriDict.keySet()) {
                if ("".equals(attriDict)) {
                    attriDict = object + ":" + inAttriDict.get(object);
                    continue;
                }
                attriDict = attriDict + "," + object + ":" + inAttriDict.get(object);
            }
        }
        return attriDict;
    }

    public static String getNowTime() {
        Time time = new Time();
        time.setToNow();
        int year = time.year;
        int month = time.month + 1;
        int day = time.monthDay;
        int minute = time.minute;
        int hour = time.hour;
        int sec = time.second;
        return year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + sec;
    }

    public static String getAppNameVer(Context activity, String name, String ver) {
        PackageManager pm = activity.getPackageManager();
        PackageInfo pinfo = null;
        try {
            pinfo = pm.getPackageInfo(activity.getPackageName(), 16384);
            String appName = pinfo.applicationInfo.loadLabel(activity.getPackageManager()).toString();
            SharedPreferences preferences = activity.getSharedPreferences(name, 0);
            SharedPreferences.Editor editor = preferences.edit();
            editor.putString("appName", appName);
            editor.commit();
            return appName + ";" + ver;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getSoftToken(Context activity, String appKey, String spName) {
        Log.d((String)"MCMUtility", (String)"getSoftToken");
        SharedPreferences preferences = activity.getSharedPreferences(spName, 0);
        String softToken = preferences.getString("softToken", null);
        if (softToken != null) {
            return softToken;
        }
        String[] val = new String[4];
        try {
            val[0] = MCMUtility.getMacAddress(activity);
            TelephonyManager telephonyManager = (TelephonyManager)activity.getSystemService("phone");
            val[1] = telephonyManager.getDeviceId();
            val[2] = MCMUtility.getCPUSerial();
            val[3] = appKey;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        softToken = MCMUtility.getMD5Code(val);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("softToken", softToken);
        editor.commit();
        return softToken;
    }

    public static String getWidgetSoftToken(Context activity, String appKey) {
        Log.d((String)"MCMUtility", (String)"getWidgetSoftToken");
        String[] val = new String[4];
        try {
            val[0] = MCMUtility.getMacAddress(activity);
            TelephonyManager telephonyManager = (TelephonyManager)activity.getSystemService("phone");
            val[1] = telephonyManager.getDeviceId();
            val[2] = MCMUtility.getCPUSerial();
            val[3] = appKey;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String softToken = MCMUtility.getMD5Code(val);
        return softToken;
    }

    public static String getDeviceToken(Context activity, String name) {
        SharedPreferences preferences = activity.getSharedPreferences(name, 0);
        String deviceToken = preferences.getString("deviceToken", null);
        if (deviceToken != null) {
            return deviceToken;
        }
        String[] val = new String[3];
        try {
            val[0] = MCMUtility.getMacAddress(activity);
            TelephonyManager telephonyManager = (TelephonyManager)activity.getSystemService("phone");
            val[1] = telephonyManager.getDeviceId();
            val[2] = MCMUtility.getCPUSerial();
        }
        catch (Exception telephonyManager) {
            // empty catch block
        }
        deviceToken = MCMUtility.getMD5Code(val);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("deviceToken", deviceToken);
        editor.commit();
        return deviceToken;
    }

    public static String getMD5Code(String[] value) {
        if (value == null || value.length == 0) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            for (String va : value) {
                if (va == null) {
                    va = "";
                }
                md.update(va.getBytes());
            }
            byte[] md5Bytes = md.digest();
            StringBuffer hexValue = new StringBuffer();
            for (int i = 0; i < md5Bytes.length; ++i) {
                int val = md5Bytes[i] & 0xFF;
                if (val < 16) {
                    hexValue.append("0");
                }
                hexValue.append(Integer.toHexString(val));
            }
            return hexValue.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getMD5Code(String value) {
        if (value == null) {
            value = "";
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(value.getBytes());
            byte[] md5Bytes = md.digest();
            StringBuffer hexValue = new StringBuffer();
            for (int i = 0; i < md5Bytes.length; ++i) {
                int val = md5Bytes[i] & 0xFF;
                if (val < 16) {
                    hexValue.append("0");
                }
                hexValue.append(Integer.toHexString(val));
            }
            return hexValue.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getMacAddress(Context activity) {
        String macSerial = null;
        try {
            WifiManager wifi = (WifiManager)activity.getSystemService("wifi");
            WifiInfo info = wifi.getConnectionInfo();
            macSerial = info.getMacAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (macSerial == null) {
            macSerial = MCMUtility.getMac();
        }
        return macSerial;
    }

    private static String getMac() {
        String macSerial = "";
        String str = "";
        try {
            Process pp = Runtime.getRuntime().exec("cat /sys/class/net/wlan0/address ");
            InputStreamReader ir = new InputStreamReader(pp.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            while (null != str) {
                str = input.readLine();
                if (str == null) continue;
                macSerial = str.trim();
                break;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return macSerial;
    }

    private static String getCPUSerial() {
        String str = "";
        String strCPU = "";
        String cpuAddress = "0000000000000000";
        try {
            Process pp = Runtime.getRuntime().exec("cat /proc/cpuinfo");
            InputStreamReader ir = new InputStreamReader(pp.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            while (str != null && (str = input.readLine()) != null) {
                if (str.indexOf("Serial") <= -1) continue;
                strCPU = str.substring(str.indexOf(":") + 1, str.length());
                cpuAddress = strCPU.trim();
                break;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return cpuAddress;
    }

    public static String getAppIdAppKeyMD5(String appId, String appKey) {
        String[] value = new String[]{appId + ":" + appKey};
        return MCMUtility.getMD5Code(value);
    }

    public static String decodeStr(String key) {
        int j;
        char[] map = new char[]{'d', 'b', 'e', 'a', 'f', 'c'};
        char[] nmap = new char[]{'2', '4', '0', '9', '7', '1', '5', '8', '3', '6'};
        String dest = "";
        String swapstr = "";
        String output = "";
        for (j = 0; j < key.length(); ++j) {
            if (key.charAt(j) == '-') continue;
            swapstr = swapstr + key.charAt(j);
        }
        for (j = 0; j < swapstr.length(); ++j) {
            if (j == 8 || j == 12 || j == 16 || j == 20) {
                dest = dest + "-";
            }
            dest = dest + swapstr.charAt(swapstr.length() - j - 1);
        }
        for (int i = 0; i < dest.length(); ++i) {
            char t = dest.charAt(i);
            if (t >= 'a' && t <= 'f') {
                t = map[t - 97];
            } else if (t >= '0' && t <= '9') {
                t = nmap[t - 48];
            }
            output = output + t;
        }
        return output;
    }

    public static void log(String text) {
        if (!isLog) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)text) && BUtility.sdCardIsWork()) {
            String developPath = BUtility.getSdCardRootPath() + "widgetone/log/";
            File dir = new File(developPath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File log = new File(developPath + "mam_log.txt");
            try {
                if (!log.exists()) {
                    log.createNewFile();
                }
                BufferedWriter m_fout = new BufferedWriter(new FileWriter(log, true));
                m_fout.write("\r" + MCMUtility.getNowTime() + "\r" + text);
                m_fout.flush();
                m_fout.close();
                m_fout = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String getSerialNumber() {
        String serial = null;
        try {
            Class<?> c = Class.forName("android.os.SystemProperties");
            Method get = c.getMethod("get", String.class);
            serial = (String)get.invoke(c, "ro.serialno");
            System.out.println(serial);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serial;
    }
}

