/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmcm.cachefile;

import android.content.Context;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Environment;
import android.view.WindowManager;
import android.widget.Toast;

public class CommonUtil {
    public static boolean hasSDCard() {
        String status = Environment.getExternalStorageState();
        return status.equals("mounted");
    }

    public static String getRootFilePath() {
        if (CommonUtil.hasSDCard()) {
            return Environment.getExternalStorageDirectory().getAbsolutePath() + "/";
        }
        return Environment.getDataDirectory().getAbsolutePath() + "/data/";
    }

    public static boolean checkNetState(Context context) {
        NetworkInfo[] info;
        boolean netstate = false;
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivity != null && (info = connectivity.getAllNetworkInfo()) != null) {
            for (int i = 0; i < info.length; ++i) {
                if (info[i].getState() != NetworkInfo.State.CONNECTED) continue;
                netstate = true;
                break;
            }
        }
        return netstate;
    }

    public static void showToask(Context context, String tip) {
        Toast.makeText((Context)context, (CharSequence)tip, (int)0).show();
    }

    public static int getScreenWidth(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Point outSize = new Point();
        wm.getDefaultDisplay().getSize(outSize);
        return outSize.x;
    }

    public static int getScreenHeight(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Point outSize = new Point();
        wm.getDefaultDisplay().getSize(outSize);
        return outSize.y;
    }
}

