/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmcm.cachefile;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.zywx.wbpalmstar.plugin.uexmcm.utils.MLog;

public class FileHelper {
    private static final int FILE_BUFFER_SIZE = 51200;

    public static boolean fileIsExist(String filePath) {
        if (filePath == null || filePath.length() < 1) {
            return false;
        }
        File f = new File(filePath);
        return f.exists();
    }

    public static InputStream readFile(String filePath) {
        if (null == filePath) {
            return null;
        }
        FileInputStream is = null;
        try {
            if (!FileHelper.fileIsExist(filePath)) {
                return null;
            }
            File f = new File(filePath);
            is = new FileInputStream(f);
        }
        catch (Exception ex) {
            return null;
        }
        return is;
    }

    public static boolean createDirectory(String filePath) {
        if (null == filePath) {
            return false;
        }
        File file = new File(filePath);
        if (file.exists()) {
            return true;
        }
        return file.mkdirs();
    }

    public static boolean deleteDirectory(String filePath) {
        if (null == filePath) {
            return false;
        }
        File file = new File(filePath);
        if (file == null || !file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            File[] list = file.listFiles();
            for (int i = 0; i < list.length; ++i) {
                if (list[i].isDirectory()) {
                    FileHelper.deleteDirectory(list[i].getAbsolutePath());
                    continue;
                }
                list[i].delete();
            }
        }
        file.delete();
        return true;
    }

    public static boolean writeFile(String filePath, InputStream inputStream) {
        if (null == filePath || filePath.length() < 1) {
            return false;
        }
        try {
            String pth;
            boolean ret;
            File file = new File(filePath);
            if (file.exists()) {
                FileHelper.deleteDirectory(filePath);
            }
            if (!(ret = FileHelper.createDirectory(pth = filePath.substring(0, filePath.lastIndexOf("/"))))) {
                return false;
            }
            if (!ret) {
                return false;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            int c = inputStream.read(buf);
            while (-1 != c) {
                fileOutputStream.write(buf, 0, c);
                c = inputStream.read(buf);
            }
            fileOutputStream.flush();
            fileOutputStream.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean writeFile(String filePath, String fileContent) {
        return FileHelper.writeFile(filePath, fileContent, false);
    }

    public static boolean writeFile(String filePath, String fileContent, boolean append) {
        if (null == filePath || fileContent == null || filePath.length() < 1 || fileContent.length() < 1) {
            return false;
        }
        try {
            File file = new File(filePath);
            if (!file.exists() && !file.createNewFile()) {
                return false;
            }
            BufferedWriter output = new BufferedWriter(new FileWriter(file, append));
            output.write(fileContent);
            output.flush();
            output.close();
        }
        catch (IOException ioe) {
            return false;
        }
        return true;
    }

    public static long getFileSize(String filePath) {
        if (null == filePath) {
            return 0L;
        }
        File file = new File(filePath);
        if (file == null || !file.exists()) {
            return 0L;
        }
        return file.length();
    }

    public static long getFileModifyTime(String filePath) {
        if (null == filePath) {
            return 0L;
        }
        File file = new File(filePath);
        if (file == null || !file.exists()) {
            return 0L;
        }
        return file.lastModified();
    }

    public static boolean setFileModifyTime(String filePath, long modifyTime) {
        if (null == filePath) {
            return false;
        }
        File file = new File(filePath);
        if (file == null || !file.exists()) {
            return false;
        }
        return file.setLastModified(modifyTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(ContentResolver cr, String fromPath, String destUri) {
        if (null == cr || null == fromPath || fromPath.length() < 1 || null == destUri || destUri.length() < 1) {
            return false;
        }
        FileInputStream is = null;
        OutputStream os = null;
        try {
            is = new FileInputStream(fromPath);
            String path = null;
            Uri uri = null;
            String lwUri = destUri.toLowerCase();
            if (lwUri.startsWith("content://")) {
                uri = Uri.parse((String)destUri);
            } else if (lwUri.startsWith("file://")) {
                uri = Uri.parse((String)destUri);
                path = uri.getPath();
            } else {
                path = destUri;
            }
            if (null != path) {
                File fl = new File(path);
                String pth = path.substring(0, path.lastIndexOf("/"));
                File pf = new File(pth);
                if (pf.exists() && !pf.isDirectory()) {
                    pf.delete();
                }
                if ((pf = new File(pth + File.separator)).exists() || !pf.mkdirs()) {
                    // empty if block
                }
                if ((pf = new File(path)).exists()) {
                    if (pf.isDirectory()) {
                        FileHelper.deleteDirectory(path);
                    } else {
                        pf.delete();
                    }
                }
                os = new FileOutputStream(path);
                fl.setLastModified(System.currentTimeMillis());
            } else {
                os = new ParcelFileDescriptor.AutoCloseOutputStream(cr.openFileDescriptor(uri, "w"));
            }
            byte[] dat = new byte[1024];
            int i = ((InputStream)is).read(dat);
            while (-1 != i) {
                os.write(dat, 0, i);
                i = ((InputStream)is).read(dat);
            }
            ((InputStream)is).close();
            is = null;
            os.flush();
            os.close();
            os = null;
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            if (null != is) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception exception) {}
            }
            if (null != os) {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public static byte[] readAll(InputStream is) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        byte[] buf = new byte[1024];
        int c = is.read(buf);
        while (-1 != c) {
            baos.write(buf, 0, c);
            c = is.read(buf);
        }
        baos.flush();
        baos.close();
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(Context ctx, Uri uri) {
        block22: {
            byte[] byArray;
            if (null == ctx || null == uri) {
                return null;
            }
            InputStream is = null;
            String scheme = uri.getScheme().toLowerCase();
            if (scheme.equals("file")) {
                is = FileHelper.readFile(uri.getPath());
            }
            try {
                is = ctx.getContentResolver().openInputStream(uri);
                if (null == is) {
                    byte[] byArray2 = null;
                    return byArray2;
                }
                byte[] bret = FileHelper.readAll(is);
                is.close();
                is = null;
                byArray = bret;
            }
            catch (FileNotFoundException fileNotFoundException) {
                break block22;
            }
            catch (Exception exception) {
                break block22;
            }
            finally {
                if (null != is) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return byArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFile(String filePath, byte[] content) {
        if (null == filePath || null == content) {
            return false;
        }
        FileOutputStream fos = null;
        try {
            String pth = filePath.substring(0, filePath.lastIndexOf("/"));
            File pf = null;
            pf = new File(pth);
            if (pf.exists() && !pf.isDirectory()) {
                pf.delete();
            }
            if ((pf = new File(filePath)).exists()) {
                if (pf.isDirectory()) {
                    FileHelper.deleteDirectory(filePath);
                } else {
                    pf.delete();
                }
            }
            if ((pf = new File(pth + File.separator)).exists() || !pf.mkdirs()) {
                // empty if block
            }
            fos = new FileOutputStream(filePath);
            fos.write(content);
            fos.flush();
            fos.close();
            fos = null;
            pf.setLastModified(System.currentTimeMillis());
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public static boolean readZipFile(String zipFileName, StringBuffer crc) {
        try {
            ZipEntry entry;
            ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFileName));
            while ((entry = zis.getNextEntry()) != null) {
                long size = entry.getSize();
                crc.append(entry.getCrc() + ", size: " + size);
            }
            zis.close();
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readGZipFile(String zipFileName) {
        if (FileHelper.fileIsExist(zipFileName)) {
            FileInputStream fin = null;
            try {
                int size;
                fin = new FileInputStream(zipFileName);
                byte[] buffer = new byte[1024];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                while ((size = fin.read(buffer, 0, buffer.length)) != -1) {
                    baos.write(buffer, 0, size);
                }
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
            catch (Exception e) {
                e.printStackTrace();
                MLog.getIns().e(e);
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        MLog.getIns().e(e);
                    }
                }
            }
        }
        return null;
    }

    public static boolean zipFile(String baseDirName, String fileName, String targerFileName) throws IOException {
        if (baseDirName == null || "".equals(baseDirName)) {
            return false;
        }
        File baseDir = new File(baseDirName);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            return false;
        }
        String baseDirPath = baseDir.getAbsolutePath();
        File targerFile = new File(targerFileName);
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(targerFile));
        File file = new File(baseDir, fileName);
        boolean zipResult = false;
        zipResult = file.isFile() ? FileHelper.fileToZip(baseDirPath, file, out) : FileHelper.dirToZip(baseDirPath, file, out);
        out.close();
        return zipResult;
    }

    public static boolean unZipFile(String fileName, String unZipDir) throws Exception {
        File f = new File(unZipDir);
        if (!f.exists()) {
            f.mkdirs();
        }
        BufferedInputStream is = null;
        ZipFile zipfile = new ZipFile(fileName);
        Enumeration<? extends ZipEntry> enumeration = zipfile.entries();
        byte[] data = new byte[51200];
        while (enumeration.hasMoreElements()) {
            int count;
            ZipEntry entry = enumeration.nextElement();
            if (entry.isDirectory()) {
                File f1 = new File(unZipDir + "/" + entry.getName());
                if (f1.exists()) continue;
                f1.mkdirs();
                continue;
            }
            is = new BufferedInputStream(zipfile.getInputStream(entry));
            String name = unZipDir + "/" + entry.getName();
            RandomAccessFile m_randFile = null;
            File file = new File(name);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            m_randFile = new RandomAccessFile(file, "rw");
            int begin = 0;
            while ((count = is.read(data, 0, 51200)) != -1) {
                try {
                    m_randFile.seek(begin);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                m_randFile.write(data, 0, count);
                begin += count;
            }
            file.delete();
            m_randFile.close();
            is.close();
        }
        zipfile.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean fileToZip(String baseDirPath, File file, ZipOutputStream out) throws IOException {
        FileInputStream in = null;
        ZipEntry entry = null;
        byte[] buffer = new byte[51200];
        try {
            int bytes_read;
            in = new FileInputStream(file);
            entry = new ZipEntry(FileHelper.getEntryName(baseDirPath, file));
            out.putNextEntry(entry);
            while ((bytes_read = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytes_read);
            }
            out.closeEntry();
            in.close();
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                out.closeEntry();
            }
            if (in != null) {
                in.close();
            }
        }
        return true;
    }

    private static boolean dirToZip(String baseDirPath, File dir, ZipOutputStream out) throws IOException {
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files.length == 0) {
            ZipEntry entry = new ZipEntry(FileHelper.getEntryName(baseDirPath, dir));
            try {
                out.putNextEntry(entry);
                out.closeEntry();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                FileHelper.fileToZip(baseDirPath, files[i], out);
                continue;
            }
            FileHelper.dirToZip(baseDirPath, files[i], out);
        }
        return true;
    }

    private static String getEntryName(String baseDirPath, File file) {
        if (!baseDirPath.endsWith(File.separator)) {
            baseDirPath = baseDirPath + File.separator;
        }
        String filePath = file.getAbsolutePath();
        if (file.isDirectory()) {
            filePath = filePath + "/";
        }
        int index = filePath.indexOf(baseDirPath);
        return filePath.substring(index + baseDirPath.length());
    }
}

