/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmcm.cachefile;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import android.widget.ImageView;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.zywx.wbpalmstar.plugin.uexmcm.cachefile.AbstractFileCache;
import org.zywx.wbpalmstar.plugin.uexmcm.cachefile.FileCache;
import org.zywx.wbpalmstar.plugin.uexmcm.cachefile.MemoryCache;
import org.zywx.wbpalmstar.plugin.uexmcm.utils.MLog;

public class ImageLoader {
    private static final String TAG = "ImageLoader";
    private MemoryCache memoryCache = new MemoryCache();
    private AbstractFileCache fileCache;
    private Map<ImageView, String> imageViews = Collections.synchronizedMap(new WeakHashMap());
    private ExecutorService executorService;

    public ImageLoader(Context context) {
        this.fileCache = new FileCache(context);
        this.executorService = Executors.newFixedThreadPool(5);
    }

    public void DisplayImage(String url, ImageView imageView, boolean isLoadOnlyFromCache) {
        this.imageViews.put(imageView, url);
        Bitmap bitmap = this.memoryCache.get(url);
        if (bitmap != null) {
            imageView.setImageBitmap(bitmap);
        } else if (!isLoadOnlyFromCache) {
            this.queuePhoto(url, imageView);
        }
    }

    private void queuePhoto(String url, ImageView imageView) {
        PhotoToLoad p = new PhotoToLoad(url, imageView);
        this.executorService.submit(new PhotosLoader(p));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getBitmap(String urlStr) {
        if (urlStr == null || urlStr.length() == 0) {
            Log.e((String)TAG, (String)("httpGet, url is null" + urlStr));
            return null;
        }
        MLog.getIns().i("urlStr = " + urlStr);
        File f = this.fileCache.getFile(urlStr);
        Bitmap b = null;
        if (f != null && f.exists()) {
            b = this.decodeFile(f);
        }
        if (b != null) {
            return b;
        }
        String urlStr1 = URLEncoder.encode(urlStr);
        String urlStr2 = urlStr1.replaceAll("%3A", ":").replaceAll("%2F", "/");
        HttpURLConnection conn = null;
        Bitmap bitmap = null;
        try {
            URL url = new URL(urlStr2);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setDoInput(true);
            int responseCode = conn.getResponseCode();
            String responseMessage = conn.getResponseMessage();
            MLog.getIns().i("responseCode = " + responseCode);
            MLog.getIns().i("responseMessage = " + responseMessage);
            if (responseCode != 200) {
                MLog.getIns().e("responseCode != 200 , responseCode = " + responseCode + " responseMessage = " + responseMessage);
                Bitmap bitmap2 = null;
                return bitmap2;
            }
            InputStream in = conn.getInputStream();
            FileOutputStream os = new FileOutputStream(f);
            ImageLoader.CopyStream(in, os);
            ((OutputStream)os).close();
            Bitmap bitmap3 = bitmap = this.decodeFile(f);
            return bitmap3;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            MLog.getIns().e(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            MLog.getIns().e(e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
                conn = null;
            }
        }
        return null;
    }

    private Bitmap decodeFile(File f) {
        try {
            BitmapFactory.Options o = new BitmapFactory.Options();
            o.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)new FileInputStream(f), null, (BitmapFactory.Options)o);
            int REQUIRED_SIZE = 100;
            int width_tmp = o.outWidth;
            int height_tmp = o.outHeight;
            int scale = 1;
            while (width_tmp / 2 >= 100 && height_tmp / 2 >= 100) {
                width_tmp /= 2;
                height_tmp /= 2;
                scale *= 2;
            }
            BitmapFactory.Options o2 = new BitmapFactory.Options();
            o2.inSampleSize = scale;
            return BitmapFactory.decodeStream((InputStream)new FileInputStream(f), null, (BitmapFactory.Options)o2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    boolean imageViewReused(PhotoToLoad photoToLoad) {
        String tag = this.imageViews.get(photoToLoad.imageView);
        return tag == null || !tag.equals(photoToLoad.url);
    }

    public void clearCache() {
        this.memoryCache.clear();
        this.fileCache.clear();
    }

    public static void CopyStream(InputStream is, OutputStream os) {
        int buffer_size = 1024;
        try {
            int count;
            byte[] bytes = new byte[1024];
            while ((count = is.read(bytes, 0, 1024)) != -1) {
                os.write(bytes, 0, count);
            }
        }
        catch (Exception ex) {
            Log.e((String)"", (String)"CopyStream catch Exception...");
        }
    }

    class BitmapDisplayer
    implements Runnable {
        Bitmap bitmap;
        PhotoToLoad photoToLoad;

        public BitmapDisplayer(Bitmap b, PhotoToLoad p) {
            this.bitmap = b;
            this.photoToLoad = p;
        }

        @Override
        public void run() {
            if (ImageLoader.this.imageViewReused(this.photoToLoad)) {
                return;
            }
            if (this.bitmap != null) {
                this.photoToLoad.imageView.setImageBitmap(this.bitmap);
            }
        }
    }

    class PhotosLoader
    implements Runnable {
        PhotoToLoad photoToLoad;

        PhotosLoader(PhotoToLoad photoToLoad) {
            this.photoToLoad = photoToLoad;
        }

        @Override
        public void run() {
            if (ImageLoader.this.imageViewReused(this.photoToLoad)) {
                return;
            }
            Bitmap bmp = ImageLoader.this.getBitmap(this.photoToLoad.url);
            ImageLoader.this.memoryCache.put(this.photoToLoad.url, bmp);
            if (ImageLoader.this.imageViewReused(this.photoToLoad)) {
                return;
            }
            BitmapDisplayer bd = new BitmapDisplayer(bmp, this.photoToLoad);
            Activity a = (Activity)this.photoToLoad.imageView.getContext();
            a.runOnUiThread((Runnable)bd);
        }
    }

    private class PhotoToLoad {
        public String url;
        public ImageView imageView;

        public PhotoToLoad(String u, ImageView i) {
            this.url = u;
            this.imageView = i;
        }
    }
}

