/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmcm.cachefile;

import android.graphics.Bitmap;
import android.support.v4.util.LruCache;
import android.util.Log;

public class LruCacheTools {
    private int portion = 4;
    private final String TAG = "LruCacheTools";
    private LruCache<String, Bitmap> mMemoryCache;

    public static LruCacheTools getInstance() {
        return new LruCacheTools();
    }

    public LruCache<String, Bitmap> getLruCache() {
        return this.mMemoryCache;
    }

    private LruCacheTools() {
        float maxMemory = Runtime.getRuntime().maxMemory();
        int cacheSize = (int)(maxMemory / (float)this.portion);
        this.mMemoryCache = new LruCache<String, Bitmap>(cacheSize){

            protected int sizeOf(String key, Bitmap value) {
                return value.getRowBytes() * value.getHeight();
            }

            protected void entryRemoved(boolean evicted, String key, Bitmap oldValue, Bitmap newValue) {
                super.entryRemoved(evicted, (Object)key, (Object)oldValue, (Object)newValue);
            }
        };
    }

    public void addBitmapToMemoryCache(String key, Bitmap bitmap) {
        if (this.getBitmapFromMemCache(key) == null) {
            this.mMemoryCache.put((Object)key, (Object)bitmap);
        }
    }

    public Bitmap getBitmapFromMemCache(String key) {
        Log.i((String)"LruCacheTools", (String)"\u4ece\u5185\u5b58\u83b7\u53d6\u56fe\u7247");
        return (Bitmap)this.mMemoryCache.get((Object)key);
    }
}

