/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmcm.cachefile;

import android.graphics.Bitmap;
import android.util.Log;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class MemoryCache {
    private static final String TAG = "MemoryCache";
    private Map<String, Bitmap> cache = Collections.synchronizedMap(new LinkedHashMap(10, 1.5f, true));
    private long size = 0L;
    private long limit = 1000000L;

    public MemoryCache() {
        this.setLimit(Runtime.getRuntime().maxMemory() / 10L);
    }

    public void setLimit(long new_limit) {
        this.limit = new_limit;
        Log.i((String)TAG, (String)("MemoryCache will use up to " + (double)this.limit / 1024.0 / 1024.0 + "MB"));
    }

    public Bitmap get(String id) {
        try {
            if (!this.cache.containsKey(id)) {
                return null;
            }
            return this.cache.get(id);
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public void put(String id, Bitmap bitmap) {
        try {
            if (this.cache.containsKey(id)) {
                this.size -= this.getSizeInBytes(this.cache.get(id));
            }
            this.cache.put(id, bitmap);
            this.size += this.getSizeInBytes(bitmap);
            this.checkSize();
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    private void checkSize() {
        Log.i((String)TAG, (String)("cache size=" + this.size + " length=" + this.cache.size()));
        if (this.size > this.limit) {
            Iterator<Map.Entry<String, Bitmap>> iter = this.cache.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, Bitmap> entry = iter.next();
                this.size -= this.getSizeInBytes(entry.getValue());
                iter.remove();
                if (this.size > this.limit) continue;
                break;
            }
            Log.i((String)TAG, (String)("Clean cache. New size " + this.cache.size()));
        }
    }

    public void clear() {
        this.cache.clear();
    }

    long getSizeInBytes(Bitmap bitmap) {
        if (bitmap == null) {
            return 0L;
        }
        return bitmap.getRowBytes() * bitmap.getHeight();
    }
}

