/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmcm.cachefile;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Environment;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.zywx.wbpalmstar.plugin.uexmcm.cachefile.LruCacheTools;
import org.zywx.wbpalmstar.plugin.uexmcm.utils.MLog;
import org.zywx.wbpalmstar.plugin.uexmcm.utils.Utils;

public class SDCardTools {
    private final String TAG = "SDCardTools";
    private LruCacheTools lruCacheTools = LruCacheTools.getInstance();
    private String directory = "image";
    private int bitmapWidth = 100;
    private int bitmapHeight = 100;

    public void setDirectory(Context context, String directory) {
        this.directory = "/Android/data/" + context.getPackageName() + "/cache/" + directory;
    }

    public int getBitmapWidth() {
        return this.bitmapWidth;
    }

    public void setBitmapWidth(int bitmapWidth) {
        this.bitmapWidth = bitmapWidth;
    }

    public int getBitmapHeight() {
        return this.bitmapHeight;
    }

    public void setBitmapHeight(int bitmapHeight) {
        this.bitmapHeight = bitmapHeight;
    }

    public boolean isMounted() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public Bitmap decodeSampledBitmapFromResource(byte[] data, int reqWidth, int reqHeight, String imageUrl) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
        options.inSampleSize = this.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
        this.setBitmapToSDcard(bitmap, imageUrl);
        return bitmap;
    }

    public int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int inSampleSize = 1;
        int height = options.outHeight;
        int width = options.outWidth;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
        }
        return inSampleSize;
    }

    public String getImageName(String url) {
        String imageName = "";
        if (url != null) {
            imageName = url.substring(url.lastIndexOf("/") + 1);
        }
        return imageName;
    }

    public Bitmap loadBitmap(String imageUrl) {
        if (imageUrl != null && this.directory != null) {
            String name;
            String path = this.getPath();
            File file = new File(path, name = this.getImageName(imageUrl));
            if (file.exists()) {
                Log.i((String)"SDCardTools", (String)"\u4eceSD\u5361\u83b7\u53d6");
                Bitmap bitmap = BitmapFactory.decodeFile((String)file.getAbsolutePath());
                if (bitmap != null) {
                    this.lruCacheTools.addBitmapToMemoryCache(imageUrl, bitmap);
                    Log.i((String)"SDCardTools", (String)"\u4eceSD\u5361\u6dfb\u52a0\u5230\u5185\u5b58\u4e2d");
                    return bitmap;
                }
            } else {
                return this.downLoadBitmap(imageUrl);
            }
        }
        return null;
    }

    public Bitmap downLoadBitmap(String imageUrl) {
        MLog.getIns().d("");
        HttpURLConnection conn = null;
        try {
            URL url = new URL(imageUrl);
            conn = (HttpURLConnection)url.openConnection();
            conn.setDoInput(true);
            if (conn.getResponseCode() != 200) {
                MLog.getIns().e("ResponseCode = " + conn.getResponseCode());
                return null;
            }
            byte[] byteArray = Utils.streamToByteArray(conn.getInputStream());
            if (byteArray == null) {
                MLog.getIns().e("byteArray == null");
                return null;
            }
            Bitmap bitmap = this.decodeSampledBitmapFromResource(byteArray, this.getBitmapWidth(), this.getBitmapHeight(), imageUrl);
            this.lruCacheTools.addBitmapToMemoryCache(imageUrl, bitmap);
            MLog.getIns().d("\u7ed3\u675f\u4e0b\u8f7d\uff0c\u6dfb\u52a0\u5230\u5185\u5b58\u4e2d");
            return bitmap;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            MLog.getIns().e(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            MLog.getIns().e(e);
        }
        return null;
    }

    public String getPath() {
        return Environment.getExternalStorageDirectory().getPath() + File.separator + this.directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setBitmapToSDcard(Bitmap bitmap, String imageUrl) {
        String path = this.getPath();
        File file = null;
        OutputStream outputStream = null;
        if (bitmap != null && this.isMounted()) {
            String name = this.getImageName(imageUrl);
            file = new File(path, name);
            if (!file.exists()) {
                File file2 = new File(path + "/");
                file2.mkdirs();
            }
            try {
                file.createNewFile();
                outputStream = new FileOutputStream(file);
                boolean file2 = bitmap.compress(Bitmap.CompressFormat.PNG, 50, outputStream);
                return file2;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return false;
    }

    public void delImage(String directory) {
    }
}

