/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmcm.documentationcenter;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;
import java.util.List;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexmcm.Constant;
import org.zywx.wbpalmstar.plugin.uexmcm.Contains;
import org.zywx.wbpalmstar.plugin.uexmcm.documentationcenter.AdapterFragment;
import org.zywx.wbpalmstar.plugin.uexmcm.documentationcenter.TabPrograma;
import org.zywx.wbpalmstar.plugin.uexmcm.documentationcenter.TabTitleJsonData;
import org.zywx.wbpalmstar.plugin.uexmcm.tab.PagerSlidingTabStrip;
import org.zywx.wbpalmstar.plugin.uexmcm.utils.MLog;
import org.zywx.wbpalmstar.plugin.uexmcm.utils.Utils;

public class MainActivity
extends FragmentActivity {
    private PagerSlidingTabStrip tabs;
    private ViewPager pager;
    private MyPagerAdapter adapter;
    public static final String INTENT_SOFTTOKEN = "softToken";
    public static final String KEY_TAG = "KEY_TAG";
    public static final String TAG = "TEST_FRAGMENT";
    private String softToken = "";
    private int width;
    private int x;
    private int y;
    private int w;
    private int h;
    private boolean isStart = true;
    String tabStr;
    String key_tag;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.i((String)"mcm", (String)(this.getLocalClassName() + " onCreate"));
        MLog.getIns().i("start");
        this.requestWindowFeature(1);
        this.setContentView(EUExUtil.getResLayoutID((String)"plugin_uexmcm_activity_main_viewpager"));
        this.tabs = (PagerSlidingTabStrip)this.findViewById(EUExUtil.getResIdID((String)"tabs"));
        this.pager = (ViewPager)this.findViewById(EUExUtil.getResIdID((String)"pager"));
        this.softToken = this.getIntent().getStringExtra(INTENT_SOFTTOKEN);
        this.key_tag = this.getIntent().getStringExtra(KEY_TAG);
        String titleTabUrl = Contains.mcmHost + "mobileContentManage/getProgramas.do?softToken=" + this.softToken;
        MLog.getIns().i("titleTabUrl = " + titleTabUrl);
        Log.i((String)TAG, (String)("onCreate_titleTabUrl=" + titleTabUrl));
        SharedPreferences preferences = this.getSharedPreferences("PagerSlidingTabStrip", 0);
        this.tabStr = preferences.getString("PagerSlidingTabStrip", null);
        this.adapter = new MyPagerAdapter(this.getSupportFragmentManager());
        this.changeColor(Color.parseColor((String)Constant.COLOR_TAB_UNDERLINE));
        DisplayMetrics metric = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(metric);
        this.tabs.widthPixels = this.width = metric.widthPixels;
        this.init(titleTabUrl);
    }

    public void init(String titleTabUrl) {
        if (Utils.visitNetWork(titleTabUrl, (Context)this)) {
            NetWorkAsyncTask task = new NetWorkAsyncTask();
            task.execute(new String[]{titleTabUrl});
        } else if (this.tabStr != null) {
            List<TabPrograma> tabList = TabTitleJsonData.getJsonTab(this.tabStr, false);
            this.adapter.addTab(tabList);
            this.pager.setAdapter((PagerAdapter)this.adapter);
            this.tabs.setViewPager(this.pager);
        }
    }

    private void changeColor(int newColor) {
        this.tabs.setIndicatorColor(newColor);
    }

    public void setPrograma(String programaId) {
        SharedPreferences.Editor token = this.getSharedPreferences("com.astuetz.viewpager.extensions.sample.MainActivity", 0).edit();
        token.putString("com.astuetz.viewpager.extensions.sample", programaId);
        token.commit();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        Log.i((String)"mcm", (String)(this.getLocalClassName() + " onKeyDown"));
        return false;
    }

    public void onBackPressed() {
        this.finish();
    }

    public class MyPagerAdapter
    extends FragmentStatePagerAdapter {
        List<TabPrograma> tabList;

        public void addTab(List<TabPrograma> tabList) {
            this.tabList = tabList;
        }

        public MyPagerAdapter(FragmentManager fm) {
            super(fm);
        }

        public CharSequence getPageTitle(int position) {
            return this.tabList.get(position).getTitle();
        }

        public int getCount() {
            return this.tabList.size();
        }

        public Fragment getItem(int position) {
            Log.i((String)"position", (String)("position=" + position));
            String programaId = this.tabList.get(position).getId();
            String description = this.tabList.get(position).getDescription();
            String urlTab = Contains.mcmHost + "mobileContentManage/getPublishContentsByPrograma.do?softToken=" + MainActivity.this.softToken + "&" + "programaId=" + programaId + "&syncDate=" + "0" + "&option=" + "dropDown" + "&pageSize=" + "10";
            Log.i((String)MainActivity.TAG, (String)("MainActivity_Fragment_urlTab=" + urlTab));
            MLog.getIns().i("urlTab = " + urlTab);
            return AdapterFragment.newInstance(urlTab, MainActivity.this.softToken, programaId, description, MainActivity.this.key_tag);
        }
    }

    class NetWorkAsyncTask
    extends AsyncTask<String, String, List<TabPrograma>> {
        NetWorkAsyncTask() {
        }

        protected List<TabPrograma> doInBackground(String ... params) {
            String url = params[0];
            MLog.getIns().i("url = " + url);
            String result = Utils.httpGet(url);
            MLog.getIns().i("result = " + result);
            if (MainActivity.this.isStart && result != null) {
                SharedPreferences.Editor tabData = MainActivity.this.getSharedPreferences("PagerSlidingTabStrip", 0).edit();
                tabData.putString("PagerSlidingTabStrip", result);
                tabData.commit();
            }
            List<TabPrograma> tabList = TabTitleJsonData.getJsonTab(result, false);
            try {
                if (tabList != null) {
                    MainActivity.this.setPrograma(tabList.get(0).getId());
                } else {
                    tabList = TabTitleJsonData.getJsonTab(MainActivity.this.tabStr, false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return tabList;
        }

        protected void onPostExecute(List<TabPrograma> result) {
            super.onPostExecute(result);
            try {
                if (result == null) {
                    return;
                }
                Log.i((String)MainActivity.TAG, (String)("result=" + result));
                MainActivity.this.adapter.addTab(result);
                MainActivity.this.pager.setAdapter((PagerAdapter)MainActivity.this.adapter);
                MainActivity.this.tabs.setViewPager(MainActivity.this.pager);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

