/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmcm.freshen;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.Scroller;
import android.widget.TextView;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexmcm.freshen.XListViewFooterFreshen;
import org.zywx.wbpalmstar.plugin.uexmcm.freshen.XListViewHeaderFreshen;

public class XListViewFreshen
extends ListView
implements AbsListView.OnScrollListener {
    private float mLastY = -1.0f;
    private Scroller mScroller;
    private AbsListView.OnScrollListener mScrollListener;
    private IXListViewListener mListViewListener;
    private XListViewHeaderFreshen mHeaderView;
    private RelativeLayout mHeaderViewContent;
    private TextView mHeaderTimeView;
    private int mHeaderViewHeight;
    private boolean mEnablePullRefresh = true;
    private boolean mPullRefreshing = false;
    private XListViewFooterFreshen mFooterView;
    private boolean mEnablePullLoad;
    private boolean mPullLoading;
    private boolean mIsFooterReady = false;
    private int mTotalItemCount;
    private int mScrollBack;
    private static final int SCROLLBACK_HEADER = 0;
    private static final int SCROLLBACK_FOOTER = 1;
    private static final int SCROLL_DURATION = 400;
    private static final int PULL_LOAD_MORE_DELTA = 100;
    private static final float OFFSET_RADIO = 1.8f;

    public XListViewFreshen(Context context) {
        super(context);
        this.initWithContext(context);
    }

    public XListViewFreshen(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initWithContext(context);
    }

    public XListViewFreshen(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initWithContext(context);
    }

    private void initWithContext(Context context) {
        this.mScroller = new Scroller(context, (Interpolator)new DecelerateInterpolator());
        super.setOnScrollListener((AbsListView.OnScrollListener)this);
        this.mHeaderView = new XListViewHeaderFreshen(context);
        this.mHeaderViewContent = (RelativeLayout)this.mHeaderView.findViewById(EUExUtil.getResIdID((String)"xlistview_header_content"));
        this.mHeaderTimeView = (TextView)this.mHeaderView.findViewById(EUExUtil.getResIdID((String)"xlistview_header_time"));
        this.addHeaderView((View)this.mHeaderView);
        this.mFooterView = new XListViewFooterFreshen(context);
        this.mHeaderView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                XListViewFreshen.this.mHeaderViewHeight = XListViewFreshen.this.mHeaderViewContent.getHeight();
                XListViewFreshen.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
    }

    public void setAdapter(ListAdapter adapter) {
        if (!this.mIsFooterReady) {
            this.mIsFooterReady = true;
            this.addFooterView((View)this.mFooterView);
        }
        super.setAdapter(adapter);
    }

    public void setPullRefreshEnable(boolean enable) {
        this.mEnablePullRefresh = enable;
        if (!this.mEnablePullRefresh) {
            this.mHeaderViewContent.setVisibility(4);
        } else {
            this.mHeaderViewContent.setVisibility(0);
        }
    }

    public void setPullLoadEnable(boolean enable) {
        this.mEnablePullLoad = enable;
        if (!this.mEnablePullLoad) {
            this.mFooterView.hide();
            this.mFooterView.setOnClickListener(null);
        } else {
            this.mPullLoading = false;
            this.mFooterView.show();
            this.mFooterView.setState(0);
            this.mFooterView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    XListViewFreshen.this.startLoadMore();
                }
            });
        }
    }

    public void stopRefresh() {
        if (this.mPullRefreshing) {
            this.mPullRefreshing = false;
            this.resetHeaderHeight();
        }
    }

    public void stopLoadMore() {
        if (this.mPullLoading) {
            this.mPullLoading = false;
            this.mFooterView.setState(0);
        }
    }

    public void setRefreshTime(String time) {
        this.mHeaderTimeView.setText((CharSequence)time);
    }

    private void invokeOnScrolling() {
        if (this.mScrollListener instanceof OnXScrollListener) {
            OnXScrollListener l = (OnXScrollListener)this.mScrollListener;
            l.onXScrolling((View)this);
        }
    }

    private void updateHeaderHeight(float delta) {
        this.mHeaderView.setVisiableHeight((int)delta + this.mHeaderView.getVisiableHeight());
        if (this.mEnablePullRefresh && !this.mPullRefreshing) {
            if (this.mHeaderView.getVisiableHeight() > this.mHeaderViewHeight) {
                this.mHeaderView.setState(1);
            } else {
                this.mHeaderView.setState(0);
            }
        }
        this.setSelection(0);
    }

    private void resetHeaderHeight() {
        int height = this.mHeaderView.getVisiableHeight();
        if (height == 0) {
            return;
        }
        if (this.mPullRefreshing && height <= this.mHeaderViewHeight) {
            return;
        }
        int finalHeight = 0;
        if (this.mPullRefreshing && height > this.mHeaderViewHeight) {
            finalHeight = this.mHeaderViewHeight;
        }
        this.mScrollBack = 0;
        this.mScroller.startScroll(0, height, 0, finalHeight - height, 400);
        this.invalidate();
    }

    private void updateFooterHeight(float delta) {
        int height = this.mFooterView.getBottomMargin() + (int)delta;
        if (this.mEnablePullLoad && !this.mPullLoading) {
            if (height > 100) {
                this.mFooterView.setState(1);
            } else {
                this.mFooterView.setState(0);
            }
        }
        this.mFooterView.setBottomMargin(height);
    }

    private void resetFooterHeight() {
        int bottomMargin = this.mFooterView.getBottomMargin();
        if (bottomMargin > 0) {
            this.mScrollBack = 1;
            this.mScroller.startScroll(0, bottomMargin, 0, -bottomMargin, 400);
            this.invalidate();
        }
    }

    private void startLoadMore() {
        this.mPullLoading = true;
        this.mFooterView.setState(2);
        if (this.mListViewListener != null) {
            this.mListViewListener.onLoadMore();
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mLastY == -1.0f) {
            this.mLastY = ev.getRawY();
        }
        switch (ev.getAction()) {
            case 0: {
                this.mLastY = ev.getRawY();
                break;
            }
            case 2: {
                float deltaY = ev.getRawY() - this.mLastY;
                this.mLastY = ev.getRawY();
                System.out.println("\u6570\u636e\u76d1\u6d4b\uff1a" + this.getFirstVisiblePosition() + "---->" + this.getLastVisiblePosition());
                if (this.getFirstVisiblePosition() == 0 && (this.mHeaderView.getVisiableHeight() > 0 || deltaY > 0.0f)) {
                    this.updateHeaderHeight(deltaY / 1.8f);
                    this.invokeOnScrolling();
                    break;
                }
                if (this.getLastVisiblePosition() != this.mTotalItemCount - 1 || this.mFooterView.getBottomMargin() <= 0 && !(deltaY < 0.0f)) break;
                this.updateFooterHeight(-deltaY / 1.8f);
                break;
            }
            default: {
                this.mLastY = -1.0f;
                if (this.getFirstVisiblePosition() == 0) {
                    if (this.mEnablePullRefresh && this.mHeaderView.getVisiableHeight() > this.mHeaderViewHeight) {
                        this.mPullRefreshing = true;
                        this.mHeaderView.setState(2);
                        if (this.mListViewListener != null) {
                            this.mListViewListener.onRefresh();
                        }
                    }
                    this.resetHeaderHeight();
                }
                if (this.getLastVisiblePosition() != this.mTotalItemCount - 1) break;
                if (this.mEnablePullLoad && this.mFooterView.getBottomMargin() > 100) {
                    this.startLoadMore();
                }
                this.resetFooterHeight();
            }
        }
        return super.onTouchEvent(ev);
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            if (this.mScrollBack == 0) {
                this.mHeaderView.setVisiableHeight(this.mScroller.getCurrY());
            } else {
                this.mFooterView.setBottomMargin(this.mScroller.getCurrY());
            }
            this.postInvalidate();
            this.invokeOnScrolling();
        }
        super.computeScroll();
    }

    public void setOnScrollListener(AbsListView.OnScrollListener l) {
        this.mScrollListener = l;
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (this.mScrollListener != null) {
            this.mScrollListener.onScrollStateChanged(view, scrollState);
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        this.mTotalItemCount = totalItemCount;
        if (this.mScrollListener != null) {
            this.mScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
        }
    }

    public void setXListViewListener(IXListViewListener listener) {
        this.mListViewListener = listener;
    }

    public static interface IXListViewListener {
        public void onRefresh();

        public void onLoadMore();
    }

    public static interface OnXScrollListener
    extends AbsListView.OnScrollListener {
        public void onXScrolling(View var1);
    }
}

