/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmcm.utils;

import android.content.Context;
import android.os.Environment;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class MLog {
    private static final String TAG = "uexMCM_3.3";
    private static final String DEVELOPER_NAME = "@waka@";
    private static final String FOLDER_NAME = "MLogs";
    private boolean log2fileSwitch = false;
    private static final String SWITCH_FILE_NAME = "mlog_switch.txt";
    private String logPath;
    private SimpleDateFormat dateFormat;
    private Date date;
    private static MLog instance = new MLog();

    public static MLog getIns() {
        return instance;
    }

    private MLog() {
        File file;
        if (("mounted".equals("mounted") || !Environment.isExternalStorageRemovable()) && (file = new File(Environment.getExternalStorageDirectory(), SWITCH_FILE_NAME)).exists()) {
            this.log2fileSwitch = true;
            this.dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss", Locale.US);
            this.date = new Date();
            this.logPath = this.getLogPath(Environment.getExternalStorageDirectory().getPath());
        }
    }

    private String getLogPath(String rootPath) {
        this.logPath = rootPath + "/" + FOLDER_NAME;
        File file = new File(this.logPath);
        if (!file.exists()) {
            file.mkdir();
        }
        this.logPath = this.logPath + "/log_" + this.dateFormat.format(this.date) + ".log";
        Log.i((String)TAG, (String)("logPath = " + this.logPath));
        return this.logPath;
    }

    public void init(Context context) {
        if ("mounted".equals("mounted") || !Environment.isExternalStorageRemovable()) {
            String cleanPath = context.getExternalFilesDir(null).getPath();
            Log.i((String)TAG, (String)("cleanPath = " + cleanPath));
            this.logPath = this.getLogPath(cleanPath);
        }
    }

    private String getFunctionName() {
        StackTraceElement[] sts = Thread.currentThread().getStackTrace();
        if (sts == null) {
            return null;
        }
        for (StackTraceElement st : sts) {
            if (st.isNativeMethod() || st.getClassName().equals(Thread.class.getName()) || st.getClassName().equals(this.getClass().getName())) continue;
            return "@waka@ [ " + Thread.currentThread().getName() + ": " + st.getFileName() + ":" + st.getLineNumber() + " " + st.getMethodName() + " ]";
        }
        return null;
    }

    public void i(Object str) {
        String name = this.getFunctionName();
        if (name != null) {
            Log.i((String)TAG, (String)(name + " - " + str));
            if (this.log2fileSwitch) {
                this.writeToFile('i', name + " - " + str);
            }
        } else {
            Log.i((String)TAG, (String)str.toString());
            if (this.log2fileSwitch) {
                this.writeToFile('i', str.toString());
            }
        }
    }

    public void d(Object str) {
        String name = this.getFunctionName();
        if (name != null) {
            Log.d((String)TAG, (String)(name + " - " + str));
            if (this.log2fileSwitch) {
                this.writeToFile('d', name + " - " + str);
            }
        } else {
            Log.d((String)TAG, (String)str.toString());
            if (this.log2fileSwitch) {
                this.writeToFile('d', str.toString());
            }
        }
    }

    public void v(Object str) {
        String name = this.getFunctionName();
        if (name != null) {
            Log.v((String)TAG, (String)(name + " - " + str));
            if (this.log2fileSwitch) {
                this.writeToFile('v', name + " - " + str);
            }
        } else {
            Log.v((String)TAG, (String)str.toString());
            if (this.log2fileSwitch) {
                this.writeToFile('v', str.toString());
            }
        }
    }

    public void w(Object str) {
        String name = this.getFunctionName();
        if (name != null) {
            Log.w((String)TAG, (String)(name + " - " + str));
            if (this.log2fileSwitch) {
                this.writeToFile('w', name + " - " + str);
            }
        } else {
            Log.w((String)TAG, (String)str.toString());
            if (this.log2fileSwitch) {
                this.writeToFile('w', str.toString());
            }
        }
    }

    public void e(Object str) {
        String name = this.getFunctionName();
        if (name != null) {
            Log.e((String)TAG, (String)(name + " - " + str));
            if (this.log2fileSwitch) {
                this.writeToFile('e', name + " - " + str);
            }
        } else {
            Log.e((String)TAG, (String)str.toString());
            if (this.log2fileSwitch) {
                this.writeToFile('e', str.toString());
            }
        }
    }

    public void e(Exception ex) {
        Log.e((String)TAG, (String)"error", (Throwable)ex);
        if (this.log2fileSwitch) {
            this.writeToFile('e', ex.getMessage());
        }
    }

    public void e(String log, Throwable tr) {
        String line = this.getFunctionName();
        Log.e((String)TAG, (String)("{Thread:" + Thread.currentThread().getName() + "}" + "[" + DEVELOPER_NAME + " " + line + ":] " + log + "\n"), (Throwable)tr);
        if (this.log2fileSwitch) {
            this.writeToFile('e', "{Thread:" + Thread.currentThread().getName() + "}" + "[" + DEVELOPER_NAME + line + ":] " + log + "\n" + tr.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(char type, String msg) {
        String log = this.dateFormat.format(this.date) + " " + type + " " + TAG + " " + msg + "\n";
        FileOutputStream fos = null;
        BufferedWriter bw = null;
        try {
            fos = new FileOutputStream(this.logPath, true);
            bw = new BufferedWriter(new OutputStreamWriter(fos));
            bw.write(log);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

