/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmcm.utils;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.net.Uri;
import android.text.TextUtils;
import android.widget.Toast;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexmcm.MCMUtility;
import org.zywx.wbpalmstar.plugin.uexmcm.Network;
import org.zywx.wbpalmstar.plugin.uexmcm.utils.MLog;

public class Utils {
    public static final String KEY_APPVERIFY = "appverify";
    public static final String XMAS_APPID = "x-mas-app-id";
    public static final int NETWORK_TIME_OUT = 20000;

    public static HttpURLConnection getHttpURLConnection(URL url, String requestMethod) {
        try {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(requestMethod);
            return conn;
        }
        catch (IOException e) {
            e.printStackTrace();
            MLog.getIns().e(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpGet(String urlStr) {
        if (urlStr == null || urlStr.length() == 0) {
            MLog.getIns().e("urlStr == null || urlStr.length() == 0");
            return null;
        }
        MLog.getIns().d("urlStr = " + urlStr);
        String newUrlStr = urlStr.replaceAll(" ", "%20");
        newUrlStr = newUrlStr.replaceAll("\"", "%22");
        newUrlStr = newUrlStr.replaceAll("\\{", "%7B");
        newUrlStr = newUrlStr.replaceAll("\\}", "%7D");
        newUrlStr = newUrlStr.replaceAll("\\[", "%5B");
        newUrlStr = newUrlStr.replaceAll("\\]", "%5D");
        HttpURLConnection conn = null;
        try {
            URL url = new URL(newUrlStr);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setDoInput(true);
            conn.setRequestProperty(KEY_APPVERIFY, Utils.getAppVerifyValue(Utils.getAppId(EUExUtil.mContext), Utils.getAppKey(), System.currentTimeMillis()));
            conn.setRequestProperty(XMAS_APPID, Utils.getAppId(EUExUtil.mContext));
            conn.setConnectTimeout(20000);
            conn.setReadTimeout(20000);
            int responseCode = conn.getResponseCode();
            String responseMessage = conn.getResponseMessage();
            MLog.getIns().i("responseCode = " + responseCode);
            MLog.getIns().i("responseMessage = " + responseMessage);
            if (responseCode != 200) {
                MLog.getIns().e("responseCode != 200 , responseCode = " + responseCode + " responseMessage = " + responseMessage);
                String string = null;
                return string;
            }
            InputStream in = conn.getInputStream();
            BufferedReader buff = new BufferedReader(new InputStreamReader(in));
            String result = "";
            String line = "";
            while ((line = buff.readLine()) != null) {
                result = result + line;
            }
            buff.close();
            MLog.getIns().i("result = " + result);
            String string = result;
            return string;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            MLog.getIns().e(e);
        }
        catch (ProtocolException e) {
            e.printStackTrace();
            MLog.getIns().e(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            MLog.getIns().e(e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
                conn = null;
            }
        }
        return null;
    }

    public static byte[] streamToByteArray(InputStream in) {
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] byteArray = null;
        try {
            int read;
            while ((read = in.read()) != 1) {
                baos.write(read);
            }
            byteArray = baos.toByteArray();
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return byteArray;
    }

    public static byte[] bmpToByteArray(Bitmap bmp, boolean needRecycle) {
        if (bmp == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bmp.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
        if (needRecycle) {
            bmp.recycle();
        }
        byte[] result = baos.toByteArray();
        try {
            baos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static AlertDialog showAlert(Context ctx, String title, String message, String label, DialogInterface.OnClickListener listener) {
        AlertDialog.Builder builder = new AlertDialog.Builder(ctx);
        builder.setTitle((CharSequence)title);
        builder.setMessage((CharSequence)message);
        builder.setPositiveButton((CharSequence)label, listener);
        AlertDialog alert = builder.create();
        alert.show();
        return alert;
    }

    public static String getAppId(Context ctx) {
        SharedPreferences prefs = ctx.getSharedPreferences("AppCanMCM", 0);
        return prefs.getString("appId", null);
    }

    public static void setAppId(Context ctx, String appId) {
        SharedPreferences prefs = ctx.getSharedPreferences("AppCanMCM", 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString("appId", appId);
        editor.commit();
    }

    public static String sha1(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest mdTemp = MessageDigest.getInstance("SHA1");
            mdTemp.update(str.getBytes());
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] buf = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                buf[k++] = hexDigits[byte0 >>> 4 & 0xF];
                buf[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(buf);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean visitNetWork(String url, Context mContext) {
        block5: {
            try {
                if (TextUtils.isEmpty((CharSequence)url)) break block5;
                if (Network.isNetworkAvailable(mContext)) {
                    try {
                        return true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break block5;
                    }
                }
                Toast.makeText((Context)mContext, (CharSequence)"\u8bf7\u67e5\u770b\u662f\u5426\u8fde\u63a5\u7f51\u7edc", (int)0).show();
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static JSONObject get2Token(String accessToken, String softtoken) {
        JSONObject json = new JSONObject();
        try {
            json.put("accessToken", (Object)accessToken);
            json.put("softToken", (Object)softtoken);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json;
    }

    private static String getAppVerifyValue(String mappId, String mappkey, long timeStamp) {
        String value = null;
        String md5 = Utils.getMD5Code(mappId + ":" + mappkey + ":" + timeStamp);
        value = "md5=" + md5 + ";ts=" + timeStamp;
        return value;
    }

    private static String getMD5Code(String value) {
        if (value == null) {
            value = "";
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(value.getBytes());
            byte[] md5Bytes = md.digest();
            StringBuffer hexValue = new StringBuffer();
            for (int i = 0; i < md5Bytes.length; ++i) {
                int val = md5Bytes[i] & 0xFF;
                if (val < 16) {
                    hexValue.append("0");
                }
                hexValue.append(Integer.toHexString(val));
            }
            return hexValue.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getAppKey() {
        String appKey = EUExUtil.getString((String)"appkey");
        appKey = MCMUtility.decodeStr(appKey);
        return appKey;
    }

    public static String urlEncode(String url) {
        return Uri.encode((String)url, (String)"/?:=&#@+$");
    }
}

