/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexMDM;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.provider.ContactsContract;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.zywx.wbpalmstar.plugin.uexMDM.ContactBackupData;
import org.zywx.wbpalmstar.plugin.uexMDM.encryption.RC4Encryptor;

public class ContactsMgr {
    public static final String TAG = "ContactsMgr";
    public static String backupTempPath = "/widgetone/tmp/backupContacts.mdm";
    private static ContactsMgr sInstance;
    private Context mContext;

    public ContactsMgr(Context mContext) {
        this.mContext = mContext;
    }

    public static ContactsMgr getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new ContactsMgr(context);
        }
        return sInstance;
    }

    private ContactBackupData loadContactsBackupData() throws UnsupportedEncodingException {
        Cursor contactCursor = this.mContext.getContentResolver().query(ContactsContract.Contacts.CONTENT_URI, new String[]{"_id", "display_name", "photo_id"}, null, null, null);
        ContactBackupData contactBackupData = new ContactBackupData();
        while (contactCursor.moveToNext()) {
            ContactBackupData.ContactData contact = new ContactBackupData.ContactData();
            contact.id = contactCursor.getLong(contactCursor.getColumnIndex("_id"));
            contact.displayName = contactCursor.getString(contactCursor.getColumnIndex("display_name"));
            contact.photoId = contactCursor.getString(contactCursor.getColumnIndex("photo_id"));
            Cursor rawContactCursor = this.mContext.getContentResolver().query(ContactsContract.RawContacts.CONTENT_URI, new String[]{"_id", "account_name"}, "contact_id = " + contact.id, null, null);
            while (rawContactCursor.moveToNext()) {
                ContactBackupData.RawContactData rawContactData = new ContactBackupData.RawContactData();
                rawContactData.id = rawContactCursor.getLong(rawContactCursor.getColumnIndex("_id"));
                rawContactData.accountName = rawContactCursor.getString(rawContactCursor.getColumnIndex("account_name"));
                Cursor dataCursor = this.mContext.getContentResolver().query(ContactsContract.Data.CONTENT_URI, new String[]{"_id", "raw_contact_id", "data1", "data2", "data_version", "is_primary", "is_super_primary", "mimetype"}, "raw_contact_id = " + rawContactData.id, null, null);
                while (dataCursor.moveToNext()) {
                    ContactBackupData.Data data = new ContactBackupData.Data();
                    data.id = dataCursor.getLong(dataCursor.getColumnIndex("_id"));
                    data.rawContactId = dataCursor.getLong(dataCursor.getColumnIndex("raw_contact_id"));
                    data.isPrimary = dataCursor.getString(dataCursor.getColumnIndex("is_primary"));
                    data.isSuperPrimary = dataCursor.getString(dataCursor.getColumnIndex("is_super_primary"));
                    data.mimeType = dataCursor.getString(dataCursor.getColumnIndex("mimetype"));
                    data.data1 = dataCursor.getString(dataCursor.getColumnIndex("data1"));
                    data.data2 = dataCursor.getString(dataCursor.getColumnIndex("data2"));
                    data.dataVersion = dataCursor.getString(dataCursor.getColumnIndex("data_version"));
                    rawContactData.dataList.add(data);
                }
                dataCursor.close();
                contact.rawContactsList.add(rawContactData);
            }
            rawContactCursor.close();
            contactBackupData.contactList.add(contact);
        }
        contactCursor.close();
        try {
            System.out.println("contactsBackupData " + this.parseBackupContacts2Json(contactBackupData));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contactBackupData;
    }

    private void writeContactsBackupData(ContactBackupData contactBackupData) throws UnsupportedEncodingException {
        if (contactBackupData == null) {
            return;
        }
        ContentResolver resolver = this.mContext.getContentResolver();
        int i = 0;
        while (i < contactBackupData.contactList.size()) {
            ContactBackupData.ContactData contact = contactBackupData.contactList.get(i);
            Cursor contactCursor = this.mContext.getContentResolver().query(ContactsContract.Contacts.CONTENT_URI, new String[]{"_id"}, "display_name =? ", new String[]{contact.displayName}, null);
            contact.id = contactCursor.moveToNext() ? Long.valueOf(contactCursor.getLong(contactCursor.getColumnIndex("_id"))) : null;
            contactCursor.close();
            int j = 0;
            while (j < contact.rawContactsList.size()) {
                ContactBackupData.RawContactData rawContactData = contact.rawContactsList.get(j);
                if (contact.id != null) {
                    Cursor rawContactCursor = this.mContext.getContentResolver().query(ContactsContract.RawContacts.CONTENT_URI, new String[]{"_id"}, "account_name =? AND contact_id=?", new String[]{rawContactData.accountName, String.valueOf(contact.id)}, null);
                    rawContactData.id = rawContactCursor.moveToNext() ? Long.valueOf(rawContactCursor.getLong(rawContactCursor.getColumnIndex("_id"))) : null;
                    rawContactCursor.close();
                } else {
                    rawContactData.id = null;
                }
                int k = 0;
                while (k < rawContactData.dataList.size()) {
                    ContactBackupData.Data data = rawContactData.dataList.get(k);
                    if (rawContactData.id == null) {
                        Uri rawContactUri = resolver.insert(ContactsContract.RawContacts.CONTENT_URI, new ContentValues());
                        rawContactData.id = ContentUris.parseId((Uri)rawContactUri);
                    }
                    ContentValues values = new ContentValues();
                    values.put("raw_contact_id", rawContactData.id);
                    values.put("is_primary", data.isPrimary);
                    values.put("is_super_primary", data.isSuperPrimary);
                    values.put("mimetype", data.mimeType);
                    values.put("data1", data.data1);
                    values.put("data2", data.data2);
                    values.put("data_version", data.dataVersion);
                    int updatedRowsNum = resolver.update(ContactsContract.Data.CONTENT_URI, values, "raw_contact_id =? AND mimetype =? ", new String[]{String.valueOf(data.rawContactId), data.mimeType});
                    if (updatedRowsNum == 0) {
                        resolver.insert(ContactsContract.Data.CONTENT_URI, values);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public boolean backupContacts() {
        boolean isSuccess;
        block22: {
            isSuccess = false;
            ByteArrayInputStream in = null;
            FileOutputStream out = null;
            File file = null;
            try {
                try {
                    ContactBackupData backupData = this.loadContactsBackupData();
                    String backupContactsStr = this.parseBackupContacts2Json(backupData);
                    backupContactsStr = new String(backupContactsStr.getBytes(), "UTF-8");
                    backupContactsStr = RC4Encryptor.encry_RC4_string(backupContactsStr);
                    in = new ByteArrayInputStream(backupContactsStr.getBytes("UTF-8"));
                    String path = String.valueOf(Environment.getExternalStorageDirectory().getAbsolutePath()) + backupTempPath;
                    file = new File(path);
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    out = new FileOutputStream(file);
                    byte[] buffer = new byte[4096];
                    int len = -1;
                    while ((len = in.read(buffer, 0, buffer.length)) != -1) {
                        out.write(buffer, 0, len);
                    }
                    out.flush();
                    isSuccess = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (out == null) break block22;
                    try {
                        out.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return isSuccess;
    }

    public boolean restoreContacts() {
        boolean isSuccess = false;
        FileInputStream in = null;
        try {
            String path = String.valueOf(Environment.getExternalStorageDirectory().getAbsolutePath()) + backupTempPath;
            File file = new File(path);
            if (!file.exists()) {
                return false;
            }
            try {
                in = new FileInputStream(file);
                int len = -1;
                byte[] buffer = new byte[4096];
                StringBuilder strb = new StringBuilder();
                while ((len = in.read(buffer, 0, buffer.length)) != -1) {
                    strb.append(new String(buffer, 0, len, "UTF-8"));
                }
                String backupContactsStr = strb.toString();
                backupContactsStr = RC4Encryptor.decry_RC4(backupContactsStr);
                ContactBackupData backupData = this.parseJson2BackupContacts(backupContactsStr);
                this.writeContactsBackupData(backupData);
                isSuccess = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return isSuccess;
    }

    private String parseBackupContacts2Json(ContactBackupData backupData) throws Exception {
        String jsonStr = null;
        JSONObject json = new JSONObject();
        JSONArray contactArray = new JSONArray();
        json.put("contactList", (Object)contactArray);
        int i = 0;
        while (i < backupData.contactList.size()) {
            ContactBackupData.ContactData contactData = backupData.contactList.get(i);
            JSONObject contactObj = new JSONObject();
            contactObj.put("id", (Object)contactData.id);
            contactObj.put("displayName", (Object)contactData.displayName);
            JSONArray rawContactArray = new JSONArray();
            contactObj.put("rawContactsList", (Object)rawContactArray);
            int j = 0;
            while (j < contactData.rawContactsList.size()) {
                ContactBackupData.RawContactData rawContactData = contactData.rawContactsList.get(j);
                JSONObject rawContactObj = new JSONObject();
                rawContactObj.put("id", (Object)rawContactData.id);
                rawContactObj.put("accountName", (Object)rawContactData.accountName);
                JSONArray dataArray = new JSONArray();
                rawContactObj.put("dataList", (Object)dataArray);
                int k = 0;
                while (k < rawContactData.dataList.size()) {
                    ContactBackupData.Data data = rawContactData.dataList.get(k);
                    JSONObject dataObj = new JSONObject();
                    dataObj.put("id", (Object)data.id);
                    dataObj.put("isPrimary", (Object)data.isPrimary);
                    dataObj.put("isSuperPrimary", (Object)data.isSuperPrimary);
                    dataObj.put("mimeTypeId", (Object)data.mimeType);
                    dataObj.put("rawContactId", (Object)data.rawContactId);
                    dataObj.put("data1", (Object)data.data1);
                    dataObj.put("data2", (Object)data.data2);
                    dataObj.put("dataVersion", (Object)data.dataVersion);
                    dataArray.put((Object)dataObj);
                    ++k;
                }
                rawContactArray.put((Object)rawContactObj);
                ++j;
            }
            contactArray.put((Object)contactObj);
            ++i;
        }
        jsonStr = json.toString();
        return jsonStr;
    }

    private ContactBackupData parseJson2BackupContacts(String jsonStr) throws Exception {
        ContactBackupData backupData = new ContactBackupData();
        JSONObject json = new JSONObject(jsonStr);
        JSONArray contactArray = json.getJSONArray("contactList");
        int i = 0;
        while (i < contactArray.length()) {
            ContactBackupData.ContactData contactData = new ContactBackupData.ContactData();
            JSONObject contactObj = contactArray.getJSONObject(i);
            contactData.id = contactObj.getLong("id");
            contactData.displayName = contactObj.getString("displayName");
            JSONArray rawContactArray = contactObj.getJSONArray("rawContactsList");
            int j = 0;
            while (j < rawContactArray.length()) {
                ContactBackupData.RawContactData rawContactData = new ContactBackupData.RawContactData();
                JSONObject rawContactObj = rawContactArray.getJSONObject(j);
                rawContactData.id = rawContactObj.getLong("id");
                rawContactData.accountName = rawContactObj.getString("accountName");
                JSONArray dataArray = rawContactObj.getJSONArray("dataList");
                int k = 0;
                while (k < dataArray.length()) {
                    ContactBackupData.Data data = new ContactBackupData.Data();
                    JSONObject dataObj = dataArray.getJSONObject(k);
                    data.id = dataObj.getLong("id");
                    data.isPrimary = dataObj.getString("isPrimary");
                    data.isSuperPrimary = dataObj.getString("isSuperPrimary");
                    data.mimeType = dataObj.getString("mimeTypeId");
                    data.rawContactId = dataObj.getLong("rawContactId");
                    data.data1 = dataObj.optString("data1");
                    data.data2 = dataObj.optString("data2");
                    data.dataVersion = dataObj.optString("dataVersion");
                    rawContactData.dataList.add(data);
                    ++k;
                }
                contactData.rawContactsList.add(rawContactData);
                ++j;
            }
            backupData.contactList.add(contactData);
            ++i;
        }
        return backupData;
    }

    private void loadContactsData() {
        Cursor cur = this.mContext.getContentResolver().query(ContactsContract.Contacts.CONTENT_URI, null, null, null, null);
        if (cur.moveToFirst()) {
            String str = "";
            do {
                String disPlayName;
                String contactId = cur.getString(cur.getColumnIndex("_id"));
                str = disPlayName = cur.getString(cur.getColumnIndex("display_name"));
                int phoneCount = cur.getInt(cur.getColumnIndex("has_phone_number"));
                if (phoneCount <= 0) continue;
                Cursor phones = this.mContext.getContentResolver().query(ContactsContract.CommonDataKinds.Phone.CONTENT_URI, null, "contact_id = " + contactId, null, null);
                if (phones.moveToFirst()) {
                    do {
                        String phoneNumber = phones.getString(phones.getColumnIndex("data1"));
                        String type = phones.getString(phones.getColumnIndex("contact_status_label"));
                        str = String.valueOf(str) + "," + phoneNumber + "," + type;
                    } while (phones.moveToNext());
                }
                phones.close();
                System.out.println(str);
            } while (cur.moveToNext());
        }
        cur.close();
    }
}

