/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexMDM;

import android.content.Context;
import android.os.Environment;
import java.io.File;

public class DataCleanManager {
    public static void cleanInternalCache(Context context) {
        DataCleanManager.deleteFilesByDirectory(context.getCacheDir());
    }

    public static void cleanDatabases(Context context) {
        DataCleanManager.deleteFilesByDirectory(new File("/data/data/" + context.getPackageName() + "/databases"));
    }

    public static void cleanSharedPreference(Context context) {
        DataCleanManager.deleteFilesByDirectory(new File("/data/data/" + context.getPackageName() + "/shared_prefs"));
    }

    public static void cleanDatabaseByName(Context context, String dbName) {
        context.deleteDatabase(dbName);
    }

    public static void cleanFiles(Context context) {
        DataCleanManager.deleteFilesByDirectory(context.getFilesDir());
    }

    public static void cleanExternalCache(Context context) {
        if (Environment.getExternalStorageState().equals("mounted")) {
            DataCleanManager.deleteFilesByDirectory(context.getExternalCacheDir());
        }
    }

    public static void cleanCustomCache(String filePath) {
        DataCleanManager.deleteFilesByDirectory(new File(filePath));
    }

    public static void cleanApplicationData(Context context, String ... filepath) {
        DataCleanManager.cleanInternalCache(context);
        DataCleanManager.cleanExternalCache(context);
        DataCleanManager.cleanDatabases(context);
        DataCleanManager.cleanSharedPreference(context);
        DataCleanManager.cleanFiles(context);
        String[] stringArray = filepath;
        int n = filepath.length;
        int n2 = 0;
        while (n2 < n) {
            String filePath = stringArray[n2];
            DataCleanManager.cleanCustomCache(filePath);
            ++n2;
        }
    }

    private static void deleteFilesByDirectory(File directory) {
        if (directory != null && directory.exists() && directory.isDirectory()) {
            File[] fileArray = directory.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File item = fileArray[n2];
                item.delete();
                ++n2;
            }
        }
    }
}

