/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexMDM;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.LocalActivityManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import org.zywx.wbpalmstar.engine.EBrowserActivity;
import org.zywx.wbpalmstar.engine.EBrowserView;
import org.zywx.wbpalmstar.engine.universalex.EUExBase;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexMDM.CallbackHandler;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMDeviceManager;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMLocationService;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMService;
import org.zywx.wbpalmstar.plugin.uexMDM.util.LogUtils;

public class EUExMDM
extends EUExBase {
    public static final String TAG = "uexMDM";
    public static final String MDM_VERSION = "3.0.35";
    public static final String function_cbLogin = "uexMDM.cbLogin";
    public static final String function_cbOnCrossChanged = "uexMDM.cbOnCrossChanged";
    public static final String function_cbBackupContacts = "uexMDM.cbBackupContacts";
    public static final String function_cbRestoreContacts = "uexMDM.cbRestoreContacts";
    public static final String function_cbRestrictMEM = "uexMDM.cbRestrictMEM";
    public static final String function_cbCheckIsNeedVerifyCode = "uexMDM.cbCheckIsNeedVerifyCode";
    public static final String function_cbGetDeviceIdentifier = "uexMDM.cbGetDeviceIdentifier";
    public static final String function_cbEventFence = "uexMDM.cbEventFence";
    private CallbackHandler callback;
    @SuppressLint(value={"HandlerLeak"})
    private Handler mHandler;

    public EUExMDM(Context context, EBrowserView inParent) {
        super(context, inParent);
        Log.i((String)TAG, (String)"constructor");
    }

    protected boolean clean() {
        Log.i((String)TAG, (String)"clean");
        return true;
    }

    public void destroy() {
        Log.i((String)TAG, (String)"destroy");
        if (this.callback != null) {
            this.callback.clean();
        }
        super.destroy();
    }

    private void initCallbackBroadCast() {
        if (this.mHandler != null) {
            return;
        }
        this.mHandler = new Handler(){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                if (msg.what == 0) {
                    EUExMDM.this.jsCallback(EUExMDM.function_cbOnCrossChanged, msg.arg1, 0, (String)msg.obj);
                } else if (msg.what == 1) {
                    LogUtils.i("MDM", "login");
                    EUExMDM.this.jsCallback(EUExMDM.function_cbLogin, 0, 0, "");
                } else if (msg.what == 2) {
                    EUExMDM.this.exitApp((String)msg.obj);
                } else if (msg.what == 3) {
                    EUExMDM.this.jsCallback(EUExMDM.function_cbBackupContacts, 0, 2, (String)msg.obj);
                } else if (msg.what == 4) {
                    EUExMDM.this.jsCallback(EUExMDM.function_cbRestoreContacts, 0, 2, (String)msg.obj);
                } else if (msg.what == 5) {
                    EUExMDM.this.jsCallback(EUExMDM.function_cbRestrictMEM, 0, 2, (String)msg.obj);
                } else if (msg.what == 6) {
                    String isRestrict = (String)msg.obj;
                    if ("1".equals(isRestrict)) {
                        EUExMDM.this.showInputCheckCode();
                    } else if ("0".equals(isRestrict)) {
                        EUExMDM.this.jsCallback(EUExMDM.function_cbCheckIsNeedVerifyCode, 0, 2, isRestrict);
                    } else if ("2".equals(isRestrict)) {
                        EUExMDM.this.jsCallback(EUExMDM.function_cbCheckIsNeedVerifyCode, 0, 2, isRestrict);
                    }
                } else if (msg.what == 7) {
                    String isSuccess = (String)msg.obj;
                    if ("1".equals(isSuccess)) {
                        EUExMDM.this.jsCallback(EUExMDM.function_cbCheckIsNeedVerifyCode, 0, 2, "1");
                    } else {
                        AlertDialog.Builder tDialog = new AlertDialog.Builder(EUExMDM.this.mContext);
                        tDialog.setCancelable(false);
                        tDialog.setTitle((CharSequence)EUExUtil.getString((String)"plugin_mdm_verifycode_title"));
                        tDialog.setMessage((CharSequence)EUExUtil.getString((String)"plugin_mdm_verifycode_error_message"));
                        tDialog.setPositiveButton((CharSequence)EUExUtil.getString((String)"confirm"), new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                EUExMDM.this.showInputCheckCode();
                            }
                        });
                        tDialog.show();
                    }
                } else if (msg.what == 8) {
                    EUExMDM.this.jsCallback(EUExMDM.function_cbEventFence, msg.arg1, 0, (String)msg.obj);
                }
            }
        };
        if (this.callback != null) {
            this.callback.clean();
        }
        this.callback = new CallbackHandler(this.mContext, this.mHandler);
    }

    public void login(String[] params) {
        LogUtils.o("login");
        this.initCallbackBroadCast();
        Intent in = new Intent();
        in.putExtra("appKey", this.mBrwView.getCurrentWidget().m_appkey);
        in.putExtra("appId", this.mBrwView.getCurrentWidget().m_appId);
        in.setClass(this.mContext.getApplicationContext(), MDMService.class);
        in.setAction("mdmLogin");
        this.mContext.startService(in);
    }

    public void getDeviceIdentifier(String[] params) {
        String IMEI = MDMDeviceManager.getInstance(this.mContext).getIMEI();
        this.jsCallback(function_cbGetDeviceIdentifier, 0, 0, IMEI);
    }

    private void showInputCheckCode() {
        LogUtils.o("showInputCheckCode");
        ((Activity)this.mContext).runOnUiThread(new Runnable(){

            @Override
            public void run() {
                final EditText editText = new EditText(EUExMDM.this.mContext);
                editText.setTextSize(15.0f);
                AlertDialog.Builder tDialog = new AlertDialog.Builder(EUExMDM.this.mContext);
                tDialog.setCancelable(false);
                tDialog.setTitle((CharSequence)EUExUtil.getString((String)"plugin_mdm_verifycode"));
                tDialog.setView((View)editText);
                tDialog.setPositiveButton((CharSequence)EUExUtil.getString((String)"confirm"), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        LogUtils.o("Confirm2CheckVerifyCode");
                        Intent serviceIntent = new Intent("mdmCheckVerifyCode");
                        serviceIntent.setClass(EUExMDM.this.mContext, MDMService.class);
                        serviceIntent.putExtra("appId", (this).EUExMDM.this.mBrwView.getCurrentWidget().m_appId);
                        String checkCode = editText.getText().toString();
                        serviceIntent.putExtra("checkCode", checkCode);
                        EUExMDM.this.mContext.startService(serviceIntent);
                    }
                });
                tDialog.setNegativeButton((CharSequence)EUExUtil.getString((String)"exit"), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        LocalActivityManager lm = ((EBrowserActivity)EUExMDM.this.mContext).getLocalActivityManager();
                        lm.removeAllActivities();
                        EUExMDM.this.clean();
                        Process.killProcess((int)Process.myPid());
                    }
                });
                tDialog.show();
            }
        });
    }

    public void backupContacts(String[] params) {
        LogUtils.o("backupContacts");
        Intent in = new Intent();
        in.setClass(this.mContext.getApplicationContext(), MDMService.class);
        in.setAction("mdmBackupContacts");
        this.mContext.startService(in);
    }

    public void restoreContacts(String[] params) {
        LogUtils.o("restoreContacts");
        Intent in = new Intent();
        in.setClass(this.mContext.getApplicationContext(), MDMService.class);
        in.setAction("mdmRestoreContacts");
        this.mContext.startService(in);
    }

    public void reportLocation(String[] params) {
        LogUtils.o("reportLocation");
        Intent serviceIntent = new Intent("mdmGetLocation");
        serviceIntent.putExtra("mdmLocationType", 1);
        serviceIntent.setClass(this.mContext, MDMLocationService.class);
        this.mContext.startService(serviceIntent);
    }

    public void reportNetworkTraffic(String[] params) {
        LogUtils.o("reportNetworkTraffic");
        Intent serviceIntent = new Intent("mdmReportNetworkTraffic");
        serviceIntent.setClass(this.mContext, MDMService.class);
        this.mContext.startService(serviceIntent);
    }

    public void exitApp(String[] params) {
        LogUtils.o("exitApp");
        String message = null;
        if (params.length > 0) {
            message = params[0];
        }
        this.exitApp(message);
    }

    public void restrictMEM(String[] params) {
        LogUtils.o("restrictMEM");
        this.initCallbackBroadCast();
        Intent serviceIntent = new Intent("mdmIsRestrictMEM");
        serviceIntent.setClass(this.mContext, MDMService.class);
        serviceIntent.putExtra("appId", this.mBrwView.getCurrentWidget().m_appId);
        this.mContext.startService(serviceIntent);
    }

    public void checkIsNeedVerifyCode(String[] params) {
        LogUtils.o("checkIsNeedVerifyCode");
        this.initCallbackBroadCast();
        Intent serviceIntent = new Intent("mdmCheckIsNeedVerifyCode");
        serviceIntent.setClass(this.mContext, MDMService.class);
        serviceIntent.putExtra("appId", this.mBrwView.getCurrentWidget().m_appId);
        this.mContext.startService(serviceIntent);
    }

    public void eventFence(String[] params) {
        LogUtils.o("eventFence");
        if (params == null || params.length < 3) {
            return;
        }
        this.initCallbackBroadCast();
        Intent serviceIntent = new Intent("mdmEventTirgger");
        serviceIntent.setClass(this.mContext, MDMService.class);
        serviceIntent.putExtra("opId", params[0]);
        serviceIntent.putExtra("eventName", params[1]);
        serviceIntent.putExtra("type", params[2]);
        this.mContext.startService(serviceIntent);
    }

    private void exitApp(final String message) {
        ((Activity)this.mContext).runOnUiThread(new Runnable(){

            @Override
            public void run() {
                String hintMessage = message;
                if (TextUtils.isEmpty((CharSequence)hintMessage)) {
                    hintMessage = EUExUtil.getString((String)"plugin_mdm_exitapp_default_hintmessage");
                }
                LogUtils.o("exitApp : " + hintMessage);
                AlertDialog.Builder tDialog = new AlertDialog.Builder(EUExMDM.this.mContext);
                tDialog.setCancelable(false);
                tDialog.setTitle((CharSequence)EUExUtil.getString((String)"plugin_mdm_exitapp"));
                tDialog.setMessage((CharSequence)hintMessage);
                tDialog.setPositiveButton((CharSequence)EUExUtil.getString((String)"exit"), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        LocalActivityManager lm = ((EBrowserActivity)EUExMDM.this.mContext).getLocalActivityManager();
                        lm.removeAllActivities();
                        EUExMDM.this.clean();
                        Process.killProcess((int)Process.myPid());
                    }
                });
                tDialog.show();
            }
        });
    }
}

