/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexMDM;

import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.widget.Toast;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexMDM.util.LogUtils;

public class MDMBlueToothManager {
    private static final String SP_MDM_CONFIG = "mdmConfig";
    private static MDMBlueToothManager sInstance;
    private BluetoothAdapter mBlueToothAdapter;
    private Context mContext;
    private SharedPreferences mdmConfigSp;

    private MDMBlueToothManager() {
    }

    private MDMBlueToothManager(Context context) {
        this();
        this.mContext = context;
        this.mBlueToothAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mdmConfigSp = this.mContext.getSharedPreferences(SP_MDM_CONFIG, 0);
    }

    public static MDMBlueToothManager getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new MDMBlueToothManager(context);
        }
        return sInstance;
    }

    public String getBlueToothMACAddress() {
        String blueToothMACAddress = "";
        try {
            blueToothMACAddress = this.mBlueToothAdapter != null && this.mBlueToothAdapter.isEnabled() ? this.mBlueToothAdapter.getAddress() : (this.mBlueToothAdapter == null ? "None" : "Closed");
        }
        catch (Exception e) {
            LogUtils.o("getBlueToothMACAddress Exception: " + e.getMessage());
            e.printStackTrace();
        }
        return blueToothMACAddress;
    }

    public boolean isBlueToothEnabled() {
        if (this.mBlueToothAdapter == null) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_mdm_bluetooth_not_found"), (int)1).show();
            return false;
        }
        return this.mBlueToothAdapter.isEnabled();
    }

    public boolean openBlueTooth() {
        if (this.mBlueToothAdapter == null) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_mdm_bluetooth_not_found"), (int)1).show();
            return false;
        }
        if (!this.mBlueToothAdapter.isEnabled()) {
            Intent intent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
            intent.putExtra("android.bluetooth.adapter.extra.DISCOVERABLE_DURATION", 300);
            this.mContext.startActivity(intent);
        }
        return true;
    }

    public boolean closeBlueTooth() {
        if (this.mBlueToothAdapter == null) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_mdm_bluetooth_not_found"), (int)1).show();
            return false;
        }
        if (this.mBlueToothAdapter.isEnabled()) {
            this.mBlueToothAdapter.disable();
        }
        return true;
    }

    public void setBluetoothAllRestricted(boolean isAllowed) {
        this.mdmConfigSp.edit().putBoolean("allowBluetooth", isAllowed).commit();
    }

    public boolean isBluetoothAllRestricted() {
        boolean isBluetoothAllowed = this.mdmConfigSp.getBoolean("allowBluetooth", true);
        return !isBluetoothAllowed;
    }
}

