/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexMDM;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import java.io.Serializable;
import java.util.Calendar;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMService;
import org.zywx.wbpalmstar.plugin.uexMDM.command.MDMCommandAckTemplateBase;
import org.zywx.wbpalmstar.plugin.uexMDM.data.MDMLocationData;
import org.zywx.wbpalmstar.plugin.uexMDM.util.HttpClientUtility;
import org.zywx.wbpalmstar.plugin.uexMDM.util.LogUtils;

public class MDMLocationAction
implements LocationListener {
    private static final String TAG = "MDMLocationAction";
    private static String BAIDU_KEY = "6Lr2fliWFNNbyvaHfHr3yLHE";
    private static String CONVERT_COORDS_URL = "http://api.map.baidu.com/geoconv/v1/?from=1&to=5&ak=" + BAIDU_KEY + "&coords=";
    private static String GEOCODE_URL = "http://api.map.baidu.com/geocoder/v2/?ak=" + BAIDU_KEY + "&output=json&pois=0&location=";
    private static final String SP_NAME_REPORT_LOCATION = "plugin_mdm_ReportLocation";
    private static final String SP_KEY_LAST_REPORT_TIME = "last_report_time";
    public static final int TYPE_COMMAND_LOCATION = 0;
    public static final int TYPE_ONE_TIME_REQUEST_LOCATION = 1;
    public static final int TYPE_TIMER_REPORT_LOCATION = 2;
    private static int LOCATE_FREQ_TIME = 5000;
    private static int LOCATE_ACCURACY = 10;
    private LocationManager mLocationProMgr;
    private MDMLocationData mMDMLocationData;
    private Intent intent;
    private Context mContext;
    private int locationActionType = 0;

    private MDMLocationAction(Context context, int type) {
        LogUtils.i(TAG, "a new MDMLocationAction created");
        this.mContext = context;
        this.mLocationProMgr = (LocationManager)context.getSystemService("location");
        this.locationActionType = type;
    }

    public static MDMLocationAction newInstance(Context context, int type) {
        return new MDMLocationAction(context, type);
    }

    private void solveLocation(Location location) {
        LogUtils.o("solveLocation");
        long startTime = location.getTime();
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(startTime);
        this.closeLocation();
        new QueryAddressThread(String.valueOf(location.getLatitude()), String.valueOf(location.getLongitude())).start();
    }

    public static void updateReportTime(Context context) {
        SharedPreferences sp = context.getSharedPreferences(SP_NAME_REPORT_LOCATION, 0);
        sp.edit().putLong(SP_KEY_LAST_REPORT_TIME, System.currentTimeMillis()).commit();
    }

    public static long getLastReportTime(Context context) {
        SharedPreferences sp = context.getSharedPreferences(SP_NAME_REPORT_LOCATION, 0);
        long lastReportTime = sp.getLong(SP_KEY_LAST_REPORT_TIME, -1L);
        return lastReportTime;
    }

    public void requestLocation(Intent intent) {
        Log.i((String)TAG, (String)("requestLocation, Type: " + (this.locationActionType == 1 ? "onStartOrManual" : "Command")));
        this.intent = intent;
        String commandUUID = intent.getStringExtra("commandUUID");
        try {
            if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
                Log.i((String)TAG, (String)"On UI thread");
            } else {
                Log.i((String)TAG, (String)"Not on UI thread");
            }
            Log.e((String)TAG, (String)("requestLocation on Thread: " + Thread.currentThread().getName()));
            Criteria cr = new Criteria();
            cr.setAccuracy(1);
            cr.setAltitudeRequired(false);
            cr.setBearingRequired(false);
            cr.setCostAllowed(true);
            cr.setPowerRequirement(2);
            String provider = this.mLocationProMgr.getBestProvider(cr, true);
            LogUtils.o("provider: " + provider);
            this.mMDMLocationData = new MDMLocationData();
            this.mMDMLocationData.setCommandUUID(commandUUID);
            this.mLocationProMgr.requestLocationUpdates(provider, (long)LOCATE_FREQ_TIME, (float)LOCATE_ACCURACY, (LocationListener)this);
        }
        catch (Exception e) {
            LogUtils.o("requestLocation Exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void closeLocation() {
        LogUtils.o("closeLocation");
        try {
            this.mLocationProMgr.removeUpdates((LocationListener)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
        switch (status) {
            case 2: {
                Log.i((String)TAG, (String)"GPS available");
                break;
            }
            case 0: {
                Log.i((String)TAG, (String)"GPS out of service");
                break;
            }
            case 1: {
                Log.i((String)TAG, (String)"GPS unavailable");
            }
        }
    }

    public void onProviderEnabled(String provider) {
        Log.i((String)TAG, (String)("onProviderEnabled:" + provider));
    }

    public void onProviderDisabled(String provider) {
        Log.i((String)TAG, (String)("onProviderDisabled:" + provider));
    }

    public void onLocationChanged(Location location) {
        this.solveLocation(location);
    }

    class QueryAddressThread
    extends Thread {
        public String mLatitude;
        public String mLongitude;

        public QueryAddressThread(String inLat, String inLon) {
            this.mLatitude = inLat;
            this.mLongitude = inLon;
        }

        private String getJsonStr(String srcStr) {
            int start = srcStr.indexOf("{");
            int end = srcStr.lastIndexOf("}") + 1;
            return srcStr.substring(start, end);
        }

        private void convertCoords() throws Exception {
            String status = null;
            String str = null;
            String convertUrl = String.valueOf(CONVERT_COORDS_URL) + this.mLongitude + "," + this.mLatitude;
            HttpGet httpGet = new HttpGet(convertUrl);
            HttpClient httpClient = HttpClientUtility.getNewHttpClient(MDMLocationAction.this.mContext, convertUrl);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode == 200) {
                HttpEntity entity = response.getEntity();
                str = EntityUtils.toString((HttpEntity)entity);
                str = this.getJsonStr(str);
                LogUtils.d(MDMLocationAction.TAG, "convertCoords result==" + str);
                str = this.getJsonStr(str);
                JSONObject convertResult = new JSONObject(str);
                status = convertResult.getString("status");
                if ("0".equals(status)) {
                    JSONArray convertResultArray = convertResult.getJSONArray("result");
                    if (convertResultArray.length() > 0) {
                        JSONObject json = convertResultArray.getJSONObject(0);
                        String longitude = json.getString("x");
                        String latitude = json.getString("y");
                        if (!TextUtils.isEmpty((CharSequence)latitude) && !TextUtils.isEmpty((CharSequence)longitude)) {
                            this.mLongitude = longitude;
                            this.mLatitude = latitude;
                        }
                    }
                } else {
                    throw new Exception("INVALID KEY OR PARAMETERS, status:" + status);
                }
            }
        }

        private String geocode() throws Exception {
            String url = String.valueOf(GEOCODE_URL) + this.mLatitude + "," + this.mLongitude;
            Log.i((String)MDMLocationAction.TAG, (String)url);
            String formatted_address = "";
            String result = null;
            HttpGet httpGet = new HttpGet(url);
            HttpClient httpClient = HttpClientUtility.getNewHttpClient(MDMLocationAction.this.mContext, url);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode == 200) {
                HttpEntity entity = response.getEntity();
                result = EntityUtils.toString((HttpEntity)entity);
                result = this.getJsonStr(result);
                LogUtils.d(MDMLocationAction.TAG, "result==" + result);
                JSONObject json = new JSONObject(result);
                String status = json.getString("status");
                if ("0".equals(status)) {
                    JSONObject jsonResult = json.getJSONObject("result");
                    formatted_address = jsonResult.getString("formatted_address");
                    LogUtils.i(MDMLocationAction.TAG, "formatted_address: " + formatted_address);
                } else {
                    throw new Exception("INVALID KEY OR PARAMETERS, status:" + status);
                }
            }
            return formatted_address;
        }

        @Override
        public void run() {
            block8: {
                try {
                    try {
                        this.convertCoords();
                        String formatted_address = this.geocode();
                        MDMLocationAction.this.mMDMLocationData.setLatitude(this.mLatitude);
                        MDMLocationAction.this.mMDMLocationData.setLongitude(this.mLongitude);
                        MDMLocationAction.this.mMDMLocationData.setAddress(formatted_address);
                        MDMLocationAction.this.mMDMLocationData.setStatus(true);
                    }
                    catch (Exception e) {
                        MDMLocationAction.this.mMDMLocationData.setStatus(false);
                        LogUtils.o("MDMLocationAction request address from baidu error: " + e.getMessage());
                        e.printStackTrace();
                        if (MDMLocationAction.this.locationActionType == 1) {
                            MDMLocationAction.this.intent.setAction("mdmStartReportLocation");
                            MDMLocationAction.this.intent.putExtra("mdmLocationData", (Serializable)MDMLocationAction.this.mMDMLocationData);
                            MDMLocationAction.this.mContext.startService(MDMLocationAction.this.intent);
                            break block8;
                        }
                        MDMLocationAction.this.intent.setAction("mdmAckcommand");
                        MDMCommandAckTemplateBase commandAckTemplateBase = MDMService.mapOfCommandAck.get(MDMLocationAction.this.mMDMLocationData.getCommandUUID());
                        commandAckTemplateBase.setMDMLocationData(MDMLocationAction.this.mMDMLocationData);
                        MDMLocationAction.this.mContext.startService(MDMLocationAction.this.intent);
                    }
                }
                finally {
                    if (MDMLocationAction.this.locationActionType == 1) {
                        MDMLocationAction.this.intent.setAction("mdmStartReportLocation");
                        MDMLocationAction.this.intent.putExtra("mdmLocationData", (Serializable)MDMLocationAction.this.mMDMLocationData);
                        MDMLocationAction.this.mContext.startService(MDMLocationAction.this.intent);
                    } else {
                        MDMLocationAction.this.intent.setAction("mdmAckcommand");
                        MDMCommandAckTemplateBase commandAckTemplateBase = MDMService.mapOfCommandAck.get(MDMLocationAction.this.mMDMLocationData.getCommandUUID());
                        commandAckTemplateBase.setMDMLocationData(MDMLocationAction.this.mMDMLocationData);
                        MDMLocationAction.this.mContext.startService(MDMLocationAction.this.intent);
                    }
                }
            }
        }
    }
}

