/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexMDM;

import android.app.IntentService;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.dd.plist.NSArray;
import com.dd.plist.NSData;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSString;
import com.dd.plist.XMLPropertyListParser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.zywx.wbpalmstar.base.BUtility;
import org.zywx.wbpalmstar.base.ResoureFinder;
import org.zywx.wbpalmstar.engine.EUtil;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexMDM.ContactsMgr;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMBluetoothBroadCastReceiver;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMDeviceManager;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMLocationAction;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMLocationService;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMNetworkTrafficStatsMgr;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMTimerNotifyMgr;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMWarningManager;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMWifiConfigInfoFactory;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMWifiManager;
import org.zywx.wbpalmstar.plugin.uexMDM.command.MDMAuthenticatePayload;
import org.zywx.wbpalmstar.plugin.uexMDM.command.MDMCommandAckTemplateBase;
import org.zywx.wbpalmstar.plugin.uexMDM.command.MDMCommandTemplateBase;
import org.zywx.wbpalmstar.plugin.uexMDM.command.MDMStatusPayload;
import org.zywx.wbpalmstar.plugin.uexMDM.command.MDMTokenUpdatePayload;
import org.zywx.wbpalmstar.plugin.uexMDM.data.MDMLocationData;
import org.zywx.wbpalmstar.plugin.uexMDM.data.MDMMobileConfig;
import org.zywx.wbpalmstar.plugin.uexMDM.data.MDMPasswordConfigInfo;
import org.zywx.wbpalmstar.plugin.uexMDM.data.MDMRestrictions;
import org.zywx.wbpalmstar.plugin.uexMDM.data.MDMWifiConfigInfo;
import org.zywx.wbpalmstar.plugin.uexMDM.encryption.PEncryption;
import org.zywx.wbpalmstar.plugin.uexMDM.encryption.RC4Encryptor;
import org.zywx.wbpalmstar.plugin.uexMDM.samsung.knox.KNOXDeviceManager;
import org.zywx.wbpalmstar.plugin.uexMDM.util.HttpClientUtility;
import org.zywx.wbpalmstar.plugin.uexMDM.util.InputStreamUtils;
import org.zywx.wbpalmstar.plugin.uexMDM.util.LogUtils;
import org.zywx.wbpalmstar.plugin.uexMDM.util.http.AuthenticationParameters;
import org.zywx.wbpalmstar.plugin.uexMDM.util.http.HttpExApi;
import org.zywx.wbpalmstar.plugin.uexMDM.util.http.IOUtil;

public class MDMService
extends IntentService {
    public static final boolean FORCEACTIVEDEVICEMGR = true;
    public static final String SP_NAME_ACCESSTOKEN = "accessToken";
    public static final String KEY_HEADER_APPVERIFY = "appverify";
    public static final String KEY_HEADER_APPID = "x-mas-app-id";
    public static final String SERVICE_ACTION_REGISTER_DEVICE = "mdmRegisterDevice";
    public static final String SERVICE_ACTION_AUTHENTICATE = "mdmAuthenticate";
    public static final String SERVICE_ACTION_TOKEN_UPDATE = "mdmTokenupdate";
    public static final String SERVICE_ACTION_REQUEST_COMMAND = "mdmRequstcommand";
    public static final String SERVICE_ACTION_ACK_COMMAND = "mdmAckcommand";
    public static final String SERVICE_ACTION_DOWNLOAD_APP = "mdmDownload";
    public static final String SERVICE_ACTION_LOGIN = "mdmLogin";
    public static final String SERVICE_ACTION_REPORT_LOCATION = "mdmStartReportLocation";
    public static final String SERVICE_ACTION_RECORD_NETWORK_TRAFFIC = "mdmRecordNetworkTraffic";
    public static final String SERVICE_ACTION_REPORT_NETWORK_TRAFFIC = "mdmReportNetworkTraffic";
    public static final String SERVICE_ACTION_GETLOCATION = "mdmGetLocation";
    public static final String SERVICE_ACTION_BACKUP_CONTACTS = "mdmBackupContacts";
    public static final String SERVICE_ACTION_RESTORE_CONTACTS = "mdmRestoreContacts";
    public static final String SERVICE_ACTION_DEVICE_MANAGER_STATUS_CHANGED = "mdmDeviceManagerStatusChanged";
    public static final String SERVICE_ACTION_DEVICE_IS_RESTRICT_MEM = "mdmIsRestrictMEM";
    public static final String SERVICE_ACTION_CHECK_IS_NEED_VERIFY_CODE = "mdmCheckIsNeedVerifyCode";
    public static final String SERVICE_ACTION_CHECK_VERIFY_CODE = "mdmCheckVerifyCode";
    public static final String SERVICE_ACTION_EVENT_TIRGGER = "mdmEventTirgger";
    public static final String SERVICE_ACTION_KNOX_DEVICE_MANAGER_STATUS_CHANGED = "mdmKNOXDeviceManagerStatusChanged";
    public static final String INTENT_LOCATION_TYPE = "mdmLocationType";
    public static final String INTENT_LOCATION_DATA = "mdmLocationData";
    public static final String INTENT_COMMAND_UUID = "commandUUID";
    public static final String INTENT_APPID = "appId";
    public static final String INTENT_CHECKCODE = "checkCode";
    public static final String INTENT_TYPE = "type";
    public static final String INTENT_APPKEY = "appKey";
    public static final int TYPE_DEVICE_MGR_REGISTERED = 0;
    public static final int TYPE_DEVICE_MGR_UNREGISTERED = 1;
    public static final String TAG_STRING = "mdmFlowerController";
    public static final String BROADCAST_ACTION_CBLOGIN = "org.zywx.wbpalmstar.plugin.uexMDM.cbLogin";
    public static final String BROADCAST_ACTION_CBONCROSSCHANGED = "org.zywx.wbpalmstar.plugin.uexMDM.cbOnCrossChanged";
    public static final String BROADCAST_ACTION_CBBACKUPCONTACTS = "org.zywx.wbpalmstar.plugin.uexMDM.cbBackupContacts";
    public static final String BROADCAST_ACTION_CBRESTORECONTACTS = "org.zywx.wbpalmstar.plugin.uexMDM.cbRestoreContacts";
    public static final String BROADCAST_ACTION_EXIT = "org.zywx.wbpalmstar.plugin.uexMDM.exit";
    public static final String BROADCAST_ACTION_ISRESTRICTMEM = "org.zywx.wbpalmstar.plugin.uexMDM.isRestrictMEM";
    public static final String BROADCAST_ACTION_CHECKISNEEDVERIFYCODE = "org.zywx.wbpalmstar.plugin.uexMDM.checkIsNeedVerifyCode";
    public static final String BROADCAST_ACTION_CHECKVERIFYCODE = "org.zywx.wbpalmstar.plugin.uexMDM.checkVerifyCode";
    public static final String BROADCAST_ACTION_EVENTTIRGGER = "org.zywx.wbpalmstar.plugin.uexMDM.eventTirgger";
    private static final String MDM_VERSION_MDMIN_URL = "mdmIn/";
    private static final String MDM_MOBILE_CONFIG_REQUEST_URL = "download/enroll";
    private static final String MDM_MOBILE_CONFIG_LOGIN_URL = "interface/queryEnrollByUdid";
    private static final String REPLACESTR_deviceToken = "{deviceToken}";
    private static final String REPLACESTR_softToken = "{softToken}";
    private static final String REPLACESTR_imei = "{imei}";
    private static final String REPLACESTR_traffic = "{trafficInfoMB}";
    private static final String REPLACESTR_latitude = "{lat,log}";
    private static final String REPLACESTR_location = "{address}";
    private static String MDM_HOST = "";
    private static String MDM_TRAFFIC_REPORT_URL = "communicate/trafficReport";
    private static String MDM_LOCATION_REPORT_URL = "communicate/reportLocation";
    private static String MDM_DEVICE_RESTORE_URL = "communicate/deviceRestore?udid={deviceToken}";
    private static String MDM_DEVICE_BACKUP_URL = "communicate/deviceBackUp?udid={deviceToken}";
    private static String MDM_IS_NEED_CHECKCODE_URL = "interface/getNeedCheckCodeByUdid?udid={deviceToken}&imei={imei}&softToken={softToken}";
    private static String MDM_VERIFY_CHECKCODE_URL = "interface/verifyCheckCode?udid={deviceToken}";
    private static String MDM_IS_MEM_RESTRICT_URL = "interface/memRestrict?udid={deviceToken}";
    private static String MDM_EVENT_TRIGGER = "communicate/eventTrigger";
    private static final String EVENT_TRIGGER_eventName = "{eventName}";
    private static final String EVENT_TRIGGER_type = "{type}";
    private MDMDeviceManager mdmDeviceManager;
    private MDMWifiManager mdmWifiManager;
    private MDMBluetoothBroadCastReceiver bluetoothBroadCastReceiver;
    private static String androidUDID = null;
    private static String softToken = null;
    private static String imei = null;
    private static String mAppId = null;
    private static String mAppKey = null;
    private static final String configfileName = "configFileName.txt";
    private static String hexStr = "0123456789ABCDEF";
    private MDMMobileConfig mdmMobileConfig = null;
    public static HashMap<String, MDMCommandAckTemplateBase> mapOfCommandAck = new HashMap();
    private String locationInternalStr = null;
    private String trafficInternalStr = null;
    private boolean isInitialedHttpClient = false;
    private static boolean isCertificate = false;
    private static boolean mdmStatus = false;
    private static boolean isUpdateWidget = false;
    private static final long TRAFFIC_INTERVAL_TIME = 900000L;

    public MDMService() {
        super("MDMService");
    }

    public void onCreate() {
        super.onCreate();
        String urlHost = EUExUtil.getString((String)"mdm_host");
        LogUtils.o("mdmHost " + urlHost);
        this.mdmDeviceManager = MDMDeviceManager.getInstance(this.getApplicationContext());
        this.mdmWifiManager = MDMWifiManager.getInstance((Context)this);
        if (urlHost != null && !"".equals(urlHost)) {
            MDM_HOST = urlHost;
            try {
                URL url = new URL(urlHost);
                String path = url.getPath();
                if (path != null && !TextUtils.isEmpty((CharSequence)path.replaceAll("/", ""))) {
                    LogUtils.o("MDM Service Version is 4.0");
                } else {
                    MDM_HOST = String.valueOf(MDM_HOST) + MDM_VERSION_MDMIN_URL;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                MDM_HOST = String.valueOf(MDM_HOST) + MDM_VERSION_MDMIN_URL;
            }
        }
        androidUDID = this.mdmDeviceManager.getDeviceToken();
        softToken = this.mdmDeviceManager.getSoftToken();
        mAppKey = this.getAppKey();
        imei = this.mdmDeviceManager.getIMEI();
        if (TextUtils.isEmpty((CharSequence)imei)) {
            imei = this.mdmDeviceManager.getDeviceUUID();
        }
        LogUtils.o("udid: " + androidUDID + " softToken: " + softToken + " imei: " + imei);
        MDM_DEVICE_RESTORE_URL = MDM_DEVICE_RESTORE_URL.replace(REPLACESTR_deviceToken, androidUDID);
        MDM_DEVICE_BACKUP_URL = MDM_DEVICE_BACKUP_URL.replace(REPLACESTR_deviceToken, androidUDID);
        MDM_IS_MEM_RESTRICT_URL = MDM_IS_MEM_RESTRICT_URL.replace(REPLACESTR_deviceToken, androidUDID);
        MDM_IS_NEED_CHECKCODE_URL = MDM_IS_NEED_CHECKCODE_URL.replace(REPLACESTR_deviceToken, androidUDID).replace(REPLACESTR_softToken, softToken).replace(REPLACESTR_imei, imei);
        MDM_VERIFY_CHECKCODE_URL = MDM_VERIFY_CHECKCODE_URL.replace(REPLACESTR_deviceToken, androidUDID);
        this.readMDMConfigFile();
        try {
            if (this.bluetoothBroadCastReceiver == null) {
                IntentFilter filter = new IntentFilter();
                filter.addAction("android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED");
                filter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
                this.bluetoothBroadCastReceiver = new MDMBluetoothBroadCastReceiver();
                this.getApplicationContext().registerReceiver((BroadcastReceiver)this.bluetoothBroadCastReceiver, filter);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onHandleIntent(Intent intent) {
        try {
            String softTokenTemp = this.mdmDeviceManager.getSoftToken();
            if (!MDM_IS_NEED_CHECKCODE_URL.contains(softTokenTemp)) {
                softToken = softTokenTemp;
                MDM_IS_NEED_CHECKCODE_URL = String.valueOf(MDM_IS_NEED_CHECKCODE_URL.substring(0, MDM_IS_NEED_CHECKCODE_URL.lastIndexOf("softToken="))) + "softToken=" + softToken;
            }
        }
        catch (Exception softTokenTemp) {
            // empty catch block
        }
        String action = intent.getAction();
        LogUtils.o("onHandleIntent action == " + action);
        if (action.equals(SERVICE_ACTION_LOGIN)) {
            this.onHandleLogin(intent);
        } else if (action.equals(SERVICE_ACTION_REGISTER_DEVICE)) {
            this.onHandleRegisterDeviceAndDownloadConfigFile(intent);
        } else if (action.equals(SERVICE_ACTION_AUTHENTICATE)) {
            this.onHandleAuthenticate(intent);
        } else if (action.equals(SERVICE_ACTION_TOKEN_UPDATE)) {
            this.onHandleTokenUpdate(intent);
        } else if (action.equals(SERVICE_ACTION_REQUEST_COMMAND)) {
            this.onHandleRequestCommand(intent);
        } else if (action.equals(SERVICE_ACTION_ACK_COMMAND)) {
            this.onHandleACKCommand(intent);
        } else if (action.equals(SERVICE_ACTION_REPORT_LOCATION)) {
            MDMLocationData locationData = (MDMLocationData)intent.getSerializableExtra(INTENT_LOCATION_DATA);
            this.onReportLocation(locationData);
        } else if (action.equals(SERVICE_ACTION_BACKUP_CONTACTS)) {
            new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... params) {
                    MDMService.this.backupContactsAndUpload();
                    return null;
                }
            }.execute((Object[])new Void[0]);
        } else if (action.equals(SERVICE_ACTION_RESTORE_CONTACTS)) {
            new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... params) {
                    MDMService.this.downloadAndRestoreContacts();
                    return null;
                }
            }.execute((Object[])new Void[0]);
        } else if (action.equals(SERVICE_ACTION_RECORD_NETWORK_TRAFFIC)) {
            MDMNetworkTrafficStatsMgr.getInstance((Context)this).calculateStatsLocalData();
        } else if (action.equals(SERVICE_ACTION_REPORT_NETWORK_TRAFFIC)) {
            final float networkTrafficMBs = (float)MDMNetworkTrafficStatsMgr.getInstance((Context)this).getCurMonthNetworkTrafficStats() / 1048576.0f;
            new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... params) {
                    MDMService.this.onReportNetworkTraffic(networkTrafficMBs);
                    return null;
                }
            }.execute((Object[])new Void[0]);
        } else if (action.equals(SERVICE_ACTION_DEVICE_MANAGER_STATUS_CHANGED)) {
            int type = intent.getIntExtra(INTENT_TYPE, 1);
            if (type == 1) {
                this.onHandleTokenCheckOut(intent);
            } else if (type == 0) {
                this.onHandleTokenReActive(intent);
            }
        } else if (action.equals(SERVICE_ACTION_KNOX_DEVICE_MANAGER_STATUS_CHANGED)) {
            KNOXDeviceManager.getmInstance(this.getApplicationContext()).setSuccess(true);
        } else if (action.equals(SERVICE_ACTION_DEVICE_IS_RESTRICT_MEM)) {
            this.onHandleRequestIsMEMRestricted(intent);
        } else if (action.equals(SERVICE_ACTION_CHECK_IS_NEED_VERIFY_CODE)) {
            this.onHandleRequestCheckIsNeedVerifyCode(intent);
        } else if (action.equals(SERVICE_ACTION_CHECK_VERIFY_CODE)) {
            this.onHandleRequestCheckVerifyCode(intent);
        } else if (action.equals(SERVICE_ACTION_EVENT_TIRGGER)) {
            this.onHandleEventTirgger(intent);
        }
    }

    private void onHandleACKCommand(Intent intent) {
        String ackCommandType = "";
        try {
            String commandUUID = intent.getStringExtra(INTENT_COMMAND_UUID);
            LogUtils.o("sendCommandAckRequest,type=" + commandUUID);
            AuthenticationParameters authParams = new AuthenticationParameters();
            authParams.setClientCertificateString(this.mdmMobileConfig.dataP12);
            authParams.setClientCertificatePassword(this.mdmMobileConfig.password);
            HttpExApi exampleApi = null;
            exampleApi = new HttpExApi(authParams, true);
            MDMCommandAckTemplateBase commandAckTemplateBase = mapOfCommandAck.get(commandUUID);
            ackCommandType = commandAckTemplateBase.getCommandType();
            String putstr1 = commandAckTemplateBase.generateStatusAckPayload(commandUUID);
            mapOfCommandAck.remove(commandAckTemplateBase);
            if (TextUtils.isEmpty((CharSequence)mAppId)) {
                mAppId = this.getAppId();
            }
            if (TextUtils.isEmpty((CharSequence)mAppKey)) {
                mAppKey = this.getAppKey();
            }
            String appverify = this.getAppVerifyValue(mAppId, mAppKey, System.currentTimeMillis());
            exampleApi.doPutEx(this.mdmMobileConfig.serverUrl, putstr1, appverify, mAppId);
            int responseCode = exampleApi.getLastResponseCode();
            LogUtils.o("commandType: " + commandAckTemplateBase.getCommandType() + " sendCommandAckRequest, responseCode=" + responseCode);
            if (responseCode == 200) {
                Log.i((String)TAG_STRING, (String)"sendCommandAckRequest success");
                commandAckTemplateBase.clear();
            }
        }
        catch (Exception e) {
            LogUtils.oe("onHandleACKCommand:" + ackCommandType, e);
            e.printStackTrace();
        }
    }

    private void onHandleRequestIsMEMRestricted(Intent intent) {
        LogUtils.o("onHandleRequestIsMEMRestricted");
        try {
            String appId = null;
            if (intent != null) {
                appId = intent.getStringExtra(INTENT_APPID);
            }
            String url = String.valueOf(MDM_HOST) + MDM_IS_MEM_RESTRICT_URL;
            LogUtils.o("onHandleRequestIsMEMRestricted: url== " + url);
            this.initHttpCertificateStatus((Context)this, appId);
            HttpClient getClient = HttpClientUtility.getNewHttpClient((Context)this, url);
            HttpPost post = new HttpPost(url);
            if (TextUtils.isEmpty((CharSequence)mAppId)) {
                mAppId = this.getAppId();
            }
            if (TextUtils.isEmpty((CharSequence)mAppKey)) {
                mAppKey = this.getAppKey();
            }
            String mAccessToken = this.getAccessToken(mAppId);
            post.setHeader(KEY_HEADER_APPVERIFY, this.getAppVerifyValue(mAppId, mAppKey, System.currentTimeMillis()));
            post.setHeader(KEY_HEADER_APPID, mAppId);
            JSONObject postJson = new JSONObject();
            postJson.put(INTENT_APPID, (Object)appId);
            postJson.put("udid", (Object)androidUDID);
            postJson.put(SP_NAME_ACCESSTOKEN, (Object)mAccessToken);
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            BasicNameValuePair nvp = new BasicNameValuePair("udid", androidUDID);
            nvps.add(nvp);
            nvp = new BasicNameValuePair("jsonObj", postJson.toString());
            nvps.add(nvp);
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
            HttpResponse response = getClient.execute((HttpUriRequest)post);
            int responseCode = response.getStatusLine().getStatusCode();
            LogUtils.o("onHandleRequestIsMEMRestricted response " + responseCode);
            if (responseCode == 200) {
                String retCode;
                Log.i((String)TAG_STRING, (String)("\u8bf7\u6c42\u670d\u52a1\u5668\u7aef\u6210\u529f " + responseCode));
                InputStream inStream = response.getEntity().getContent();
                String text = InputStreamUtils.InputStreamTOString(inStream, "UTF-8");
                inStream.close();
                LogUtils.o("onHandleRequestIsMEMRestrictedResult == " + text);
                JSONObject json = new JSONObject(text);
                if (json.has("ret")) {
                    if (!"0".equals(json.getString("ret"))) {
                        Log.i((String)TAG_STRING, (String)("\u8bf7\u6c42\u670d\u52a1\u5668\u7aef\u5931\u8d25 " + json.getString("msg")));
                        LogUtils.o("onHandleRequestIsMEMRestricted request fail : " + json.getString("msg"));
                        return;
                    }
                    json = json.getJSONObject("data");
                }
                retCode = "0".equals(retCode = json.getString("retCode")) ? retCode : "1";
                Intent broadIntent = new Intent(BROADCAST_ACTION_ISRESTRICTMEM);
                broadIntent.putExtra("isRestricted", retCode);
                this.sendBroadcast(broadIntent);
            }
            LogUtils.o("onHandleRequestIsMEMRestricted response : " + responseCode);
        }
        catch (Exception e) {
            LogUtils.oe("onHandleRequestIsMEMRestricted", e);
            e.printStackTrace();
        }
    }

    private void onHandleRequestCheckIsNeedVerifyCode(Intent intent) {
        LogUtils.o("onHandleRequestCheckIsNeedVerifyCode");
        try {
            String appId = null;
            if (intent != null) {
                appId = intent.getStringExtra(INTENT_APPID);
            }
            String url = String.valueOf(MDM_HOST) + MDM_IS_NEED_CHECKCODE_URL;
            LogUtils.o("onHandleRequestCheckIsNeedVerifyCode: url== " + url);
            this.initHttpCertificateStatus((Context)this, appId);
            HttpClient getClient = HttpClientUtility.getNewHttpClient((Context)this, url);
            HttpPost post = new HttpPost(url);
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            BasicNameValuePair nvp = new BasicNameValuePair("udid", androidUDID);
            nvps.add(nvp);
            nvp = new BasicNameValuePair("imei", imei);
            nvps.add(nvp);
            nvp = new BasicNameValuePair("softToken", softToken);
            nvps.add(nvp);
            nvp = new BasicNameValuePair(INTENT_APPID, appId);
            nvps.add(nvp);
            if (TextUtils.isEmpty((CharSequence)mAppId)) {
                mAppId = this.getAppId();
            }
            if (TextUtils.isEmpty((CharSequence)mAppKey)) {
                mAppKey = this.getAppKey();
            }
            String mAccessToken = this.getAccessToken(mAppId);
            post.setHeader(KEY_HEADER_APPVERIFY, this.getAppVerifyValue(mAppId, mAppKey, System.currentTimeMillis()));
            post.setHeader(KEY_HEADER_APPID, mAppId);
            JSONObject postJson = new JSONObject();
            postJson.put(INTENT_APPID, (Object)appId);
            postJson.put("softToken", (Object)softToken);
            postJson.put("imei", (Object)imei);
            postJson.put("udid", (Object)androidUDID);
            postJson.put(SP_NAME_ACCESSTOKEN, (Object)mAccessToken);
            nvp = new BasicNameValuePair("jsonObj", postJson.toString());
            nvps.add(nvp);
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
            HttpResponse response = getClient.execute((HttpUriRequest)post);
            int responseCode = response.getStatusLine().getStatusCode();
            LogUtils.o("onHandleRequestCheckIsNeedVerifyCode response " + responseCode);
            if (responseCode == 200) {
                InputStream inStream = response.getEntity().getContent();
                String text = InputStreamUtils.InputStreamTOString(inStream, "UTF-8");
                inStream.close();
                LogUtils.o("onHandleRequestCheckIsNeedVerifyCode Result == " + text);
                JSONObject json = new JSONObject(text);
                if (json.has("ret")) {
                    if (!"0".equals(json.getString("ret"))) {
                        LogUtils.o("onHandleRequestCheckIsNeedVerifyCode request fail : " + json.getString("msg"));
                        return;
                    }
                    json = json.getJSONObject("data");
                }
                String isforbid = json.optString("isforbid");
                String needCheckCode = json.optString("needCheckCode");
                String message = json.optString("message");
                Intent broadIntent = new Intent(BROADCAST_ACTION_CHECKISNEEDVERIFYCODE);
                if ("1".equals(isforbid)) {
                    broadIntent.setAction(BROADCAST_ACTION_EXIT);
                    broadIntent.putExtra("msg", message);
                    this.sendBroadcast(broadIntent);
                } else if ("0".equals(needCheckCode)) {
                    broadIntent.putExtra("isRestricted", "0");
                    this.sendBroadcast(broadIntent);
                } else {
                    broadIntent.putExtra("isRestricted", "1");
                    this.sendBroadcast(broadIntent);
                }
            }
        }
        catch (Exception e) {
            LogUtils.oe("onHandleRequestCheckIsNeedVerifyCode", e);
            e.printStackTrace();
        }
    }

    private void onHandleRequestCheckVerifyCode(Intent intent) {
        LogUtils.o("onHandleRequestCheckVerifyCode");
        Intent broadIntent = new Intent(BROADCAST_ACTION_CHECKVERIFYCODE);
        try {
            String appId = null;
            String checkCode = null;
            if (intent != null) {
                appId = intent.getStringExtra(INTENT_APPID);
                checkCode = intent.getStringExtra(INTENT_CHECKCODE);
            }
            String url = String.valueOf(MDM_HOST) + MDM_VERIFY_CHECKCODE_URL;
            LogUtils.o("onHandleRequestCheckVerifyCode: url== " + url);
            this.initHttpCertificateStatus((Context)this, appId);
            HttpClient getClient = HttpClientUtility.getNewHttpClient((Context)this, url);
            HttpPost post = new HttpPost(url);
            if (TextUtils.isEmpty((CharSequence)mAppId)) {
                mAppId = this.getAppId();
            }
            if (TextUtils.isEmpty((CharSequence)mAppKey)) {
                mAppKey = this.getAppKey();
            }
            String mAccessToken = this.getAccessToken(mAppId);
            post.setHeader(KEY_HEADER_APPVERIFY, this.getAppVerifyValue(mAppId, mAppKey, System.currentTimeMillis()));
            post.setHeader(KEY_HEADER_APPID, mAppId);
            JSONObject postJson = new JSONObject();
            postJson.put(INTENT_APPID, (Object)appId);
            postJson.put("checkcode", (Object)checkCode);
            postJson.put("udid", (Object)androidUDID);
            postJson.put(SP_NAME_ACCESSTOKEN, (Object)mAccessToken);
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            BasicNameValuePair nvp = new BasicNameValuePair("checkcode", checkCode);
            nvps.add(nvp);
            nvp = new BasicNameValuePair("jsonObj", postJson.toString());
            nvps.add(nvp);
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
            HttpResponse response = getClient.execute((HttpUriRequest)post);
            int responseCode = response.getStatusLine().getStatusCode();
            LogUtils.o("onHandleRequestCheckVerifyCode response " + responseCode);
            if (responseCode == 200) {
                InputStream inStream = response.getEntity().getContent();
                String text = InputStreamUtils.InputStreamTOString(inStream, "UTF-8");
                inStream.close();
                LogUtils.o("onHandleRequestCheckVerifyCode Result == " + text);
                JSONObject json = new JSONObject(text);
                if (json.has("ret")) {
                    if (!"0".equals(json.getString("ret"))) {
                        broadIntent.putExtra("isSuccess", "2");
                        this.sendBroadcast(broadIntent);
                        return;
                    }
                    json = json.getJSONObject("data");
                }
                String checkResult = json.optString("checkresult");
                "1".equals(checkResult);
                broadIntent.putExtra("isSuccess", checkResult);
                this.sendBroadcast(broadIntent);
            } else {
                broadIntent.putExtra("isSuccess", "2");
                this.sendBroadcast(broadIntent);
            }
        }
        catch (Exception e) {
            LogUtils.oe("onHandleRequestCheckVerifyCode", e);
            broadIntent.putExtra("isSuccess", "2");
            this.sendBroadcast(broadIntent);
            e.printStackTrace();
        }
    }

    private void onHandleEventTirgger(Intent intent) {
        LogUtils.o("onHandleEventTirgger");
        String opId = intent.getStringExtra("opId");
        String eventName = intent.getStringExtra("eventName");
        String type = intent.getStringExtra(INTENT_TYPE);
        Intent broadIntent = new Intent(BROADCAST_ACTION_EVENTTIRGGER);
        broadIntent.putExtra("opId", opId);
        try {
            String paramsStr = "udid={deviceToken}&eventName={eventName}&type={type}";
            String url = String.valueOf(MDM_HOST) + MDM_EVENT_TRIGGER;
            paramsStr = paramsStr.replace(REPLACESTR_deviceToken, androidUDID).replace(EVENT_TRIGGER_eventName, eventName).replace(EVENT_TRIGGER_type, type);
            LogUtils.o("onHandleEventTirgger: url= " + url + " params: " + paramsStr);
            AuthenticationParameters authParams = new AuthenticationParameters();
            if (this.mdmMobileConfig != null) {
                authParams.setClientCertificateString(this.mdmMobileConfig.dataP12);
                authParams.setClientCertificatePassword(this.mdmMobileConfig.password);
            } else {
                LogUtils.o("onHandleEventTirgger: request without cert");
            }
            if (TextUtils.isEmpty((CharSequence)mAppId)) {
                mAppId = this.getAppId();
            }
            if (TextUtils.isEmpty((CharSequence)mAppKey)) {
                mAppKey = this.getAppKey();
            }
            String mAccessToken = this.getAccessToken(mAppId);
            JSONObject json = new JSONObject();
            json.put(INTENT_APPID, (Object)mAppId);
            json.put("eventName", (Object)eventName);
            json.put(INTENT_TYPE, (Object)type);
            json.put("udid", (Object)androidUDID);
            json.put(SP_NAME_ACCESSTOKEN, (Object)mAccessToken);
            paramsStr = "jsonObj=" + json.toString();
            String appverify = this.getAppVerifyValue(mAppId, mAppKey, System.currentTimeMillis());
            HttpExApi exampleApi = null;
            exampleApi = new HttpExApi(authParams, true);
            String result = exampleApi.doPostNameValuePairs(url, paramsStr, appverify, mAppId);
            int responseCode = exampleApi.getLastResponseCode();
            LogUtils.o("onHandleEventTirgger: responseCode= " + responseCode + " result= " + result);
            if (responseCode == 200) {
                broadIntent.putExtra("isSuccess", "0");
            } else {
                broadIntent.putExtra("isSuccess", "1");
            }
        }
        catch (Exception e) {
            LogUtils.oe("onHandleEventTirgger", e);
            broadIntent.putExtra("isSuccess", "1");
        }
        this.sendBroadcast(broadIntent);
    }

    private void onHandleRequestCommand(Intent intent) {
        try {
            LogUtils.o("sendCommandRequest");
            AuthenticationParameters authParams = new AuthenticationParameters();
            authParams.setClientCertificateString(this.mdmMobileConfig.dataP12);
            authParams.setClientCertificatePassword(this.mdmMobileConfig.password);
            HttpExApi exampleApi = null;
            exampleApi = new HttpExApi(authParams, true);
            String putStr = MDMStatusPayload.generatetatusIdlePayload(androidUDID);
            LogUtils.o("onHandleRequestCommand == " + this.mdmMobileConfig.serverUrl);
            if (TextUtils.isEmpty((CharSequence)mAppId)) {
                mAppId = this.getAppId();
            }
            if (TextUtils.isEmpty((CharSequence)mAppKey)) {
                mAppKey = this.getAppKey();
            }
            String appverify = this.getAppVerifyValue(mAppId, mAppKey, System.currentTimeMillis());
            String resultStr = exampleApi.doPutEx(this.mdmMobileConfig.serverUrl, putStr, appverify, mAppId);
            int responseCode = exampleApi.getLastResponseCode();
            LogUtils.o("onHandleRequestCommand response : " + responseCode);
            if (responseCode == 200) {
                Log.i((String)TAG_STRING, (String)"getCommand success");
                this.handleCommand(resultStr);
            }
        }
        catch (Exception e) {
            LogUtils.oe("onHandleRequestCommand", e);
            e.printStackTrace();
        }
    }

    private void onHandleTokenCheckOut(Intent intent) {
        try {
            LogUtils.o("onHandleTokenCheckOut");
            AuthenticationParameters authParams = new AuthenticationParameters();
            authParams.setClientCertificateString(this.mdmMobileConfig.dataP12);
            authParams.setClientCertificatePassword(this.mdmMobileConfig.password);
            HttpExApi exampleApi = null;
            exampleApi = new HttpExApi(authParams, true);
            String udidStr = androidUDID;
            String putStr = MDMTokenUpdatePayload.generateCheckOutTokenPayload(this.mdmMobileConfig.topic, udidStr);
            LogUtils.o("generateCheckOutTokenPayload " + putStr);
            if (TextUtils.isEmpty((CharSequence)mAppId)) {
                mAppId = this.getAppId();
            }
            if (TextUtils.isEmpty((CharSequence)mAppKey)) {
                mAppKey = this.getAppKey();
            }
            String appverify = this.getAppVerifyValue(mAppId, mAppKey, System.currentTimeMillis());
            exampleApi.doPutEx(this.mdmMobileConfig.checkInUrl, putStr, appverify, mAppId);
            int responseCode = exampleApi.getLastResponseCode();
            LogUtils.o("onHandleTokenCheckOut response : " + responseCode);
            if (responseCode == 200) {
                Log.i((String)TAG_STRING, (String)"sendTokenCheckOutRequest success");
            }
        }
        catch (Exception e) {
            LogUtils.oe("onHandleTokenCheckOut", e);
            e.printStackTrace();
        }
    }

    private void onHandleTokenReActive(Intent intent) {
        try {
            LogUtils.o("onHandleTokenReActive");
            AuthenticationParameters authParams = new AuthenticationParameters();
            authParams.setClientCertificateString(this.mdmMobileConfig.dataP12);
            authParams.setClientCertificatePassword(this.mdmMobileConfig.password);
            HttpExApi exampleApi = null;
            exampleApi = new HttpExApi(authParams, true);
            String udidStr = androidUDID;
            String putStr = MDMTokenUpdatePayload.generateReActiveTokenPayload(this.mdmMobileConfig.topic, udidStr);
            LogUtils.o("onHandleTokenReActivePayload " + putStr);
            if (TextUtils.isEmpty((CharSequence)mAppId)) {
                mAppId = this.getAppId();
            }
            if (TextUtils.isEmpty((CharSequence)mAppKey)) {
                mAppKey = this.getAppKey();
            }
            String appverify = this.getAppVerifyValue(mAppId, mAppKey, System.currentTimeMillis());
            String result = exampleApi.doPutEx(this.mdmMobileConfig.checkInUrl, putStr, appverify, mAppId);
            int responseCode = exampleApi.getLastResponseCode();
            LogUtils.o("onHandleTokenReActive response : " + responseCode);
            if (responseCode == 200) {
                Log.i((String)TAG_STRING, (String)"sendTokenReActiveRequest success");
                String knoxKey = RC4Encryptor.decry_RC4(result, "emm3.0");
                KNOXDeviceManager KNOXmgr = this.mdmDeviceManager.getKNOXManager();
                if (!KNOXmgr.isKNOXactive()) {
                    KNOXmgr.setRegister(knoxKey);
                }
            }
        }
        catch (Exception e) {
            LogUtils.oe("onHandleTokenReActive", e);
            e.printStackTrace();
        }
    }

    private void onHandleTokenUpdate(Intent intent) {
        try {
            LogUtils.o("onHandleTokenUpdate");
            AuthenticationParameters authParams = new AuthenticationParameters();
            authParams.setClientCertificateString(this.mdmMobileConfig.dataP12);
            authParams.setClientCertificatePassword(this.mdmMobileConfig.password);
            HttpExApi exampleApi = null;
            exampleApi = new HttpExApi(authParams, true);
            String pushMagicStr = androidUDID;
            String tokenStr = softToken;
            tokenStr = Base64.encodeToString((byte[])tokenStr.getBytes(), (int)0);
            String unlockTokenStr = String.valueOf(androidUDID) + "unlockTokenStr";
            unlockTokenStr = Base64.encodeToString((byte[])unlockTokenStr.getBytes(), (int)0);
            if (TextUtils.isEmpty((CharSequence)mAppId)) {
                mAppId = this.getAppId();
            }
            if (TextUtils.isEmpty((CharSequence)mAppKey)) {
                mAppKey = this.getAppKey();
            }
            String appverify = this.getAppVerifyValue(mAppId, mAppKey, System.currentTimeMillis());
            String putStr = MDMTokenUpdatePayload.generateTokenPayload(pushMagicStr, tokenStr, this.mdmMobileConfig.topic, androidUDID, unlockTokenStr, mAppId);
            LogUtils.o("generateTokenPayload " + putStr);
            String result = exampleApi.doPutEx(this.mdmMobileConfig.checkInUrl, putStr, appverify, mAppId);
            int responseCode = exampleApi.getLastResponseCode();
            LogUtils.o("onHandleTokenUpdate response : " + responseCode);
            if (responseCode == 200) {
                Log.i((String)TAG_STRING, (String)"sendTokenRequest success");
                String knoxKey = RC4Encryptor.decry_RC4(result, "emm3.0");
                this.onLoginSuccess(true, knoxKey);
            }
        }
        catch (Exception e) {
            LogUtils.o("onHandleTokenUpdate Exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void onHandleAuthenticate(Intent intent) {
        try {
            LogUtils.o("sendAuthenticateRequest");
            AuthenticationParameters authParams = new AuthenticationParameters();
            authParams.setClientCertificateString(this.mdmMobileConfig.dataP12);
            authParams.setClientCertificatePassword(this.mdmMobileConfig.password);
            HttpExApi exampleApi = null;
            exampleApi = new HttpExApi(authParams, true);
            String tokenStr = softToken;
            tokenStr = Base64.encodeToString((byte[])tokenStr.getBytes(), (int)0);
            String authStr = MDMAuthenticatePayload.generateAuthenticatePayload(this.mdmMobileConfig.topic, androidUDID, tokenStr);
            if (TextUtils.isEmpty((CharSequence)mAppId)) {
                mAppId = this.getAppId();
            }
            if (TextUtils.isEmpty((CharSequence)mAppKey)) {
                mAppKey = this.getAppKey();
            }
            String appverify = this.getAppVerifyValue(mAppId, mAppKey, System.currentTimeMillis());
            String result = exampleApi.doPutEx(this.mdmMobileConfig.checkInUrl, authStr, appverify, mAppId);
            int responseCode = exampleApi.getLastResponseCode();
            LogUtils.o("onHandleAuthenticate response : " + responseCode + " result: " + result);
            if (responseCode == 200) {
                Log.i((String)TAG_STRING, (String)"sendAuthenticateRequest success");
                Intent in = new Intent(SERVICE_ACTION_TOKEN_UPDATE);
                in.setClass((Context)this, MDMService.class);
                this.startService(in);
            } else {
                LogUtils.o("sendAuthenticateRequest failed, configFile will be removed.");
                this.removeMDMConfigFile();
            }
        }
        catch (Exception e) {
            LogUtils.o("onHandleAuthenticate Exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void onHandleRegisterDeviceAndDownloadConfigFile(Intent intent) {
        Log.d((String)TAG_STRING, (String)"onHandleRegisterDeviceAndDownloadConfigFile start register");
        try {
            String url = String.valueOf(MDM_HOST) + MDM_MOBILE_CONFIG_REQUEST_URL;
            HttpClient getClient = HttpClientUtility.getNewHttpClient((Context)this, url);
            HttpPost rePost = new HttpPost(url);
            if (TextUtils.isEmpty((CharSequence)mAppId)) {
                mAppId = this.getAppId();
            }
            if (TextUtils.isEmpty((CharSequence)mAppKey)) {
                mAppKey = this.getAppKey();
            }
            String mAccessToken = this.getAccessToken(mAppId);
            rePost.setHeader(KEY_HEADER_APPVERIFY, this.getAppVerifyValue(mAppId, mAppKey, System.currentTimeMillis()));
            rePost.setHeader(KEY_HEADER_APPID, mAppId);
            JSONObject json = new JSONObject();
            json.put(INTENT_APPID, (Object)mAppId);
            json.put("softToken", (Object)softToken);
            json.put("udid", (Object)androidUDID);
            json.put(SP_NAME_ACCESSTOKEN, (Object)mAccessToken);
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            BasicNameValuePair nvp = new BasicNameValuePair("udid", androidUDID);
            nvps.add(nvp);
            nvp = new BasicNameValuePair("jsonObj", json.toString());
            nvps.add(nvp);
            rePost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
            HttpResponse response = getClient.execute((HttpUriRequest)rePost);
            int responseCode = response.getStatusLine().getStatusCode();
            LogUtils.o("onHandleRegisterDeviceAndDownloadConfigFile response : " + responseCode);
            if (responseCode == 200) {
                Log.i((String)TAG_STRING, (String)("\u8bf7\u6c42\u670d\u52a1\u5668\u7aef\u6210\u529f " + responseCode));
                InputStream inStream = response.getEntity().getContent();
                String text = InputStreamUtils.InputStreamTOString(inStream, "UTF-8");
                InputStream inStream1 = InputStreamUtils.StringTOInputStream(text);
                this.mdmMobileConfig = MDMMobileConfig.parseMobileConfigProfile(inStream1);
                Log.d((String)TAG_STRING, (String)"onHandleRegisterDeviceAndDownloadConfigFile  register  success");
                this.writeMDMConfigFile();
                Intent in = new Intent(SERVICE_ACTION_AUTHENTICATE);
                in.setClass((Context)this, MDMService.class);
                this.startService(in);
                inStream.close();
            } else {
                Log.i((String)TAG_STRING, (String)("\u8bf7\u6c42\u670d\u52a1\u5668\u7aef\u5931\u8d25 " + responseCode));
                String errorContent = EntityUtils.toString((HttpEntity)response.getEntity());
                LogUtils.o("onHandleRegisterDeviceAndDownloadConfigFile request fail : " + errorContent);
            }
        }
        catch (Exception e) {
            LogUtils.o("onHandleRegisterDeviceAndDownloadConfigFile Exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void handleCommand(String result) {
        LogUtils.o("handle command, commandStr: " + result);
        boolean isActive = this.mdmDeviceManager.isDeviceManagerActive();
        MDMCommandTemplateBase mdmCommandTemplateBase = new MDMCommandTemplateBase();
        if (mdmCommandTemplateBase.parseCommandTemplate(result)) {
            String requestType = mdmCommandTemplateBase.getRequestTypeString();
            String commandUUID = mdmCommandTemplateBase.getCommandUUIDString();
            MDMCommandAckTemplateBase commandAckTemplateBase = new MDMCommandAckTemplateBase(androidUDID, requestType);
            mapOfCommandAck.put(commandUUID, commandAckTemplateBase);
            Intent in = new Intent(SERVICE_ACTION_ACK_COMMAND);
            in.putExtra(INTENT_COMMAND_UUID, commandUUID);
            in.setClass((Context)this, MDMService.class);
            LogUtils.o("handle command,commandtype=" + requestType);
            if (requestType.equals("DeviceLock")) {
                boolean ret = this.mdmDeviceManager.lockScreen();
                LogUtils.o("lockScreen " + ret);
                commandAckTemplateBase.setLockDeviceSuccess(ret);
                this.startService(in);
            } else if (requestType.equals("ClearPasscode")) {
                boolean ret = this.mdmDeviceManager.clearPassCode();
                LogUtils.o("cancel password " + ret);
                commandAckTemplateBase.setClearPassword(ret);
                this.startService(in);
            } else if (requestType.equals("DeviceInformation")) {
                commandAckTemplateBase.setDeviceInfo(this.mdmDeviceManager.getDeviceInfo());
                this.startService(in);
            } else if (requestType.equals("EraseDevice")) {
                boolean ret = this.mdmDeviceManager.wipeData();
                if (!ret) {
                    commandAckTemplateBase.setWipeData(ret);
                    this.startService(in);
                }
            } else if (requestType.equals("InstalledApplicationList")) {
                commandAckTemplateBase.setInstallAplication(this.mdmDeviceManager.getUserInstallApplication());
                this.startService(in);
            } else if (requestType.equals("InstallApplication")) {
                String url = mdmCommandTemplateBase.getCommandDictionary().get((Object)"ManifestURL").toString();
                this.downLoadApkAndInstall(url, commandUUID);
            } else if (requestType.equals("RemoveApplication")) {
                String packageName = mdmCommandTemplateBase.getCommandDictionary().get((Object)"Identifier").toString();
                this.mdmDeviceManager.uninstall(packageName, commandUUID);
            } else if (requestType.equals("DeviceAlerm")) {
                MDMWarningManager mdmWarningManager = MDMWarningManager.getInstance(this.getApplicationContext());
                mdmWarningManager.setWarning(true);
                mdmWarningManager.setWarningMode(1);
                mdmWarningManager.setVolumeMax(2);
                mdmWarningManager.WARNING(this.getApplicationContext());
            } else if (requestType.equals("DeviceCancelAlerm")) {
                MDMWarningManager mdmWarningManager = MDMWarningManager.getInstance(this.getApplicationContext());
                mdmWarningManager.setWarning(false);
                mdmWarningManager.stop();
            } else if (requestType.equals("DeviceLockPwd")) {
                NSDictionary commandDict = mdmCommandTemplateBase.getCommandDictionary();
                String password = ((NSString)commandDict.get((Object)"lockPass")).toString();
                this.mdmDeviceManager.resetPassword(password);
                this.mdmDeviceManager.lockScreen();
            } else if (!requestType.equals("DeviceReboot")) {
                if (requestType.equals("InstallProfile")) {
                    HashMap<String, String> localWifiList = null;
                    HashMap<String, String> serverWifiList = new HashMap<String, String>();
                    HashMap<String, String> WifiWhiteList = new HashMap<String, String>();
                    HashMap<String, String> WifiBlackList = new HashMap<String, String>();
                    boolean wifiisrestrictAll = false;
                    boolean wifiConfigStatus = true;
                    NSData data = (NSData)mdmCommandTemplateBase.getCommandDictionary().get((Object)"Payload");
                    String payloadType = null;
                    byte[] dataBytes = data.bytes();
                    try {
                        InputStream inStr = InputStreamUtils.byteTOInputStream(dataBytes);
                        String text = InputStreamUtils.InputStreamTOString(inStr, "utf-8");
                        ByteArrayInputStream is = new ByteArrayInputStream(text.getBytes("UTF-8"));
                        NSDictionary rootDictObj = (NSDictionary)XMLPropertyListParser.parse((InputStream)is);
                        NSArray arrayObj = (NSArray)rootDictObj.get((Object)"PayloadContent");
                        int i = 0;
                        while (i < arrayObj.count()) {
                            NSDictionary dictObj = (NSDictionary)arrayObj.objectAtIndex(i);
                            payloadType = dictObj.get((Object)"PayloadType").toString();
                            LogUtils.i(TAG_STRING, "Parsing PayloadType: " + payloadType);
                            if (payloadType.equalsIgnoreCase("com.apple.mobiledevice.passwordpolicy")) {
                                MDMPasswordConfigInfo passConfig = MDMPasswordConfigInfo.createMDMPasswordConfigInfo(dictObj);
                                if (passConfig != null) {
                                    this.mdmDeviceManager.setPasswordConfig(passConfig, commandUUID);
                                    break;
                                }
                                this.startService(in);
                                break;
                            }
                            if (payloadType.equalsIgnoreCase("com.apple.wifi.managed")) {
                                if (!isActive) {
                                    LogUtils.o("DeviceManager is not active, ignore wifi config");
                                } else {
                                    localWifiList = this.mdmWifiManager.loadWifiConfigFile();
                                    MDMWifiConfigInfo wifiConfig = MDMWifiConfigInfoFactory.createMDMWifiConfigInfo(dictObj);
                                    if (wifiConfig != null) {
                                        int networkId = this.mdmWifiManager.addOrUpdateSSID(wifiConfig);
                                        String ssid = new String(wifiConfig.getWifiConfig().SSID.getBytes(), "UTF-8");
                                        serverWifiList.put(ssid, ssid);
                                        if (wifiConfig.isWhitelist() == 1) {
                                            WifiWhiteList.put(ssid, ssid);
                                        } else if (wifiConfig.isWhitelist() == 0) {
                                            WifiBlackList.put(ssid, ssid);
                                        } else if (wifiConfig.isWhitelist() == 2) {
                                            wifiisrestrictAll = true;
                                        }
                                        boolean isSuccess = false;
                                        if (networkId != -1) {
                                            isSuccess = true;
                                        } else {
                                            wifiConfigStatus = false;
                                        }
                                        LogUtils.o("wifi networkId:" + networkId + " SSID:" + ssid + " isSuccess? " + isSuccess);
                                    }
                                }
                            } else if (!payloadType.equalsIgnoreCase("com.apple.vpn.managed") && payloadType.equalsIgnoreCase("com.apple.applicationaccess")) {
                                String ProfileIdentifier = rootDictObj.get((Object)"PayloadIdentifier").toString();
                                MDMRestrictions restrictions = MDMRestrictions.createMDMRestrictions(dictObj);
                                if ("com.zywx.mdm7d19061b-8659-4555-81b6-64397f53c417".equals(ProfileIdentifier)) {
                                    MDMRestrictions.setMDMRestrictions("MDMRestrctions_Geo_Camera", restrictions.allowCamera, this.getApplicationContext());
                                    MDMRestrictions.setMDMRestrictions("MDMRestrctions_Geo_Wifi", restrictions.allowWifi, this.getApplicationContext());
                                    this.mdmDeviceManager.setCameraEnable(MDMRestrictions.getMultipleMDMRestriction("Camera", this.getApplicationContext()));
                                    this.mdmDeviceManager.setWifiEnable(MDMRestrictions.getMultipleMDMRestriction("Wifi", this.getApplicationContext()));
                                } else if ("com.zywx.mdmd8276560-d870-4488-809e-47ca581d31f2".equals(ProfileIdentifier)) {
                                    MDMRestrictions.setMDMRestrictions("MDMRestrctions_Eventtirgger_Camera", restrictions.allowCamera, this.getApplicationContext());
                                    MDMRestrictions.setMDMRestrictions("MDMRestrctions_Eventtirgger_Wifi", restrictions.allowWifi, this.getApplicationContext());
                                    MDMRestrictions.setMDMRestrictions("MDMRestrctions_Samsung_BlueTooth", restrictions.allowBlueTooth, this.getApplicationContext());
                                    this.mdmDeviceManager.setCameraEnable(MDMRestrictions.getMultipleMDMRestriction("Camera", this.getApplicationContext()));
                                    this.mdmDeviceManager.setWifiEnable(MDMRestrictions.getMultipleMDMRestriction("Wifi", this.getApplicationContext()));
                                } else if ("com.zywx.mdm85b76bb3-80b7-4653-a277-a25c3a57c78c".equals(ProfileIdentifier)) {
                                    MDMRestrictions.setMDMRestrictions("MDMRestrctions_Samsung_Camera", restrictions.allowCamera, this.getApplicationContext());
                                    MDMRestrictions.setMDMRestrictions("MDMRestrctions_Samsung_Wifi", restrictions.allowWifi, this.getApplicationContext());
                                    MDMRestrictions.setMDMRestrictions("MDMRestrctions_Samsung_BlueTooth", restrictions.allowBlueTooth, this.getApplicationContext());
                                    this.mdmDeviceManager.setCameraEnable(MDMRestrictions.getMultipleMDMRestriction("Camera", this.getApplicationContext()));
                                    this.mdmDeviceManager.setWifiEnable(MDMRestrictions.getMultipleMDMRestriction("Wifi", this.getApplicationContext()));
                                    this.mdmDeviceManager.setCallPhoneEnable(restrictions.allowPhone);
                                    this.mdmDeviceManager.setClipboardEnabled(restrictions.allowClipboard);
                                    this.mdmDeviceManager.setSdCardEnable(restrictions.allowSdCard);
                                    this.mdmDeviceManager.setVideoRecordEnable(restrictions.allowRecVideo);
                                    this.mdmDeviceManager.setAudioRecordEnable(restrictions.allowRecord);
                                    this.mdmDeviceManager.setScreenCaptureEnable(restrictions.allowScreenShots);
                                    this.mdmDeviceManager.setNFCEnable(restrictions.allowEnableNFC);
                                    this.mdmDeviceManager.setHomeKeyEnable(restrictions.allowHomeKey);
                                    this.mdmDeviceManager.setMockLocationEnable(restrictions.allowMockPostion);
                                    this.mdmDeviceManager.setUsbDebuggingEnabled(restrictions.allowDebugUSB);
                                    this.mdmDeviceManager.setDeveloperModeEnable(restrictions.allowDeveloperOption);
                                    this.mdmDeviceManager.setUsbHostStorageEnable(restrictions.allowEnableOTG);
                                    this.mdmDeviceManager.setPositionEnable(restrictions.allowPosition);
                                    this.mdmDeviceManager.setAppInsAndUninsEnable(restrictions.allowSpecifiedApp);
                                    this.mdmDeviceManager.setBluetoothEnable(restrictions.allowBlueTooth);
                                    this.mdmDeviceManager.setAllMessageEnable(restrictions.allowMessage);
                                }
                            }
                            ++i;
                        }
                        if (payloadType.equalsIgnoreCase("com.apple.wifi.managed") && isActive) {
                            if (localWifiList != null) {
                                Iterator it = localWifiList.entrySet().iterator();
                                while (it.hasNext()) {
                                    String ssid = (String)it.next().getKey();
                                    if (serverWifiList.containsKey(ssid)) continue;
                                    this.mdmWifiManager.removeSSID(ssid);
                                }
                            }
                            this.mdmWifiManager.saveWifiConfigFile(serverWifiList);
                            this.mdmWifiManager.saveWifiWhiteList(WifiWhiteList);
                            this.mdmWifiManager.saveWifiBlackList(WifiBlackList);
                            this.mdmWifiManager.setRestrictAllWifi(wifiisrestrictAll);
                            commandAckTemplateBase.setInstallProfile(wifiConfigStatus);
                            this.startService(in);
                        }
                        LogUtils.i(TAG_STRING, "Install Profile Completed!");
                    }
                    catch (Exception e) {
                        LogUtils.o("PayloadType: " + payloadType + " Payload Parse Exception: " + e.getMessage());
                        e.printStackTrace();
                        this.startService(in);
                    }
                } else if (requestType.equals("RemoveProfile")) {
                    String removeProfileIdentifier = mdmCommandTemplateBase.getIdentifier();
                    if ("com.zywx.mdm7d19061b-8659-4555-81b6-64397f53c417".equals(removeProfileIdentifier)) {
                        MDMRestrictions.setMDMRestrictions("MDMRestrctions_Geo_Camera", true, this.getApplicationContext());
                        MDMRestrictions.setMDMRestrictions("MDMRestrctions_Geo_Camera", true, this.getApplicationContext());
                        this.mdmDeviceManager.setCameraEnable(MDMRestrictions.getMultipleMDMRestriction("Camera", this.getApplicationContext()));
                        this.mdmDeviceManager.setWifiEnable(MDMRestrictions.getMultipleMDMRestriction("Wifi", this.getApplicationContext()));
                        commandAckTemplateBase.setRemoveProfile(true);
                    } else if ("com.zywx.mdm85b76bb3-80b7-4653-a277-a25c3a57c78c".equals(removeProfileIdentifier)) {
                        MDMRestrictions.setMDMRestrictions("MDMRestrctions_Samsung_Camera", true, this.getApplicationContext());
                        MDMRestrictions.setMDMRestrictions("MDMRestrctions_Samsung_Camera", true, this.getApplicationContext());
                        this.mdmDeviceManager.setCameraEnable(MDMRestrictions.getMultipleMDMRestriction("Camera", this.getApplicationContext()));
                        this.mdmDeviceManager.setWifiEnable(MDMRestrictions.getMultipleMDMRestriction("Wifi", this.getApplicationContext()));
                        this.mdmDeviceManager.setCallPhoneEnable(true);
                        this.mdmDeviceManager.setClipboardEnabled(true);
                        this.mdmDeviceManager.setSdCardEnable(true);
                        this.mdmDeviceManager.setVideoRecordEnable(true);
                        this.mdmDeviceManager.setAudioRecordEnable(true);
                        this.mdmDeviceManager.setScreenCaptureEnable(true);
                        this.mdmDeviceManager.setNFCEnable(true);
                        this.mdmDeviceManager.setHomeKeyEnable(true);
                        this.mdmDeviceManager.setMockLocationEnable(true);
                        this.mdmDeviceManager.setUsbDebuggingEnabled(true);
                        this.mdmDeviceManager.setDeveloperModeEnable(true);
                        this.mdmDeviceManager.setUsbHostStorageEnable(true);
                        this.mdmDeviceManager.setPositionEnable(true);
                        this.mdmDeviceManager.setAppInsAndUninsEnable(true);
                        this.mdmDeviceManager.setBluetoothEnable(true);
                        this.mdmDeviceManager.setAllMessageEnable(true);
                    } else if ("com.zywx.mdmd8276560-d870-4488-809e-47ca581d31f2".equals(removeProfileIdentifier)) {
                        MDMRestrictions.setMDMRestrictions("MDMRestrctions_Eventtirgger_Camera", true, this.getApplicationContext());
                        MDMRestrictions.setMDMRestrictions("MDMRestrctions_Eventtirgger_Camera", true, this.getApplicationContext());
                        this.mdmDeviceManager.setCameraEnable(MDMRestrictions.getMultipleMDMRestriction("Camera", this.getApplicationContext()));
                        this.mdmDeviceManager.setWifiEnable(MDMRestrictions.getMultipleMDMRestriction("Wifi", this.getApplicationContext()));
                    } else if ("com.zywx.mdmfcdafb5e-038d-45eb-8af1-86f994120d94".equals(removeProfileIdentifier)) {
                        if (this.mdmDeviceManager.removePasswordConfig()) {
                            commandAckTemplateBase.setRemoveProfile(true);
                        } else {
                            commandAckTemplateBase.setRemoveProfile(false);
                        }
                    } else if ("com.zywx.mdm9739801e-6694-46c8-95c4-3c1ebf9c2df2".equals(removeProfileIdentifier)) {
                        HashMap<String, String> localWifiList = null;
                        localWifiList = this.mdmWifiManager.loadWifiConfigFile();
                        if (localWifiList != null) {
                            Iterator<Map.Entry<String, String>> it = localWifiList.entrySet().iterator();
                            while (it.hasNext()) {
                                String ssid = it.next().getKey();
                                this.mdmWifiManager.removeSSID(ssid);
                            }
                        }
                        this.mdmWifiManager.saveWifiConfigFile(new HashMap<String, String>());
                        commandAckTemplateBase.setRemoveProfile(true);
                    }
                    this.startService(in);
                } else if (requestType.equals("Settings")) {
                    String dataRoaming;
                    NSArray items = (NSArray)mdmCommandTemplateBase.getCommandDictionary().get((Object)"Settings");
                    Bundle bundle = new Bundle();
                    int i = 0;
                    while (i < items.count()) {
                        NSDictionary nsd = (NSDictionary)items.objectAtIndex(i);
                        String item = nsd.get((Object)"Item").toString();
                        String enable = nsd.get((Object)"Enabled").toString();
                        bundle.putString(item, enable);
                        ++i;
                    }
                    String voiceRoaming = bundle.getString("VoiceRoaming");
                    if (TextUtils.isEmpty((CharSequence)voiceRoaming)) {
                        voiceRoaming = "notset";
                    }
                    if (TextUtils.isEmpty((CharSequence)(dataRoaming = bundle.getString("DataRoaming")))) {
                        voiceRoaming = "notset";
                    }
                    if (voiceRoaming.equals("true")) {
                        this.mdmDeviceManager.setVoiceRoaming(true);
                        commandAckTemplateBase.setIsVoiceRoaming("true");
                    } else if (voiceRoaming.equals("false")) {
                        this.mdmDeviceManager.setVoiceRoaming(false);
                        commandAckTemplateBase.setIsVoiceRoaming("false");
                    } else {
                        commandAckTemplateBase.setIsVoiceRoaming("notset");
                    }
                    if (dataRoaming.equals("true")) {
                        this.mdmDeviceManager.setDateRoaming(true);
                        commandAckTemplateBase.setIsDataRoaming("true");
                    } else if (dataRoaming.equals("false")) {
                        this.mdmDeviceManager.setDateRoaming(false);
                        commandAckTemplateBase.setIsDataRoaming("false");
                    } else {
                        commandAckTemplateBase.setIsDataRoaming("notset");
                    }
                    this.startService(in);
                } else if (requestType.equals("Location")) {
                    this.requestLocation(0, commandUUID);
                } else if (requestType.equals("GetSyslog")) {
                    File logFile = this.mdmDeviceManager.outputLogcatInfo((Context)this);
                    commandAckTemplateBase.setSysLog(logFile);
                    this.startService(in);
                }
            }
        }
    }

    private void requestLocation(int locationType, String commandUUID) {
        Intent serviceIntent = new Intent(SERVICE_ACTION_GETLOCATION);
        serviceIntent.putExtra(INTENT_LOCATION_TYPE, locationType);
        serviceIntent.putExtra(INTENT_COMMAND_UUID, commandUUID);
        serviceIntent.setClass((Context)this, MDMLocationService.class);
        this.startService(serviceIntent);
    }

    private void onHandleLogin(Intent intent) {
        Log.i((String)TAG_STRING, (String)"LOGIN onHandleLogin");
        try {
            String appId = null;
            String appkey = null;
            if (intent != null) {
                appId = intent.getStringExtra(INTENT_APPID);
                appkey = intent.getStringExtra(INTENT_APPKEY);
            }
            mAppId = appId;
            mAppKey = appkey;
            this.initHttpCertificateStatus((Context)this, appId);
            String url = String.valueOf(MDM_HOST) + MDM_MOBILE_CONFIG_LOGIN_URL;
            HttpClient getClient = HttpClientUtility.getNewHttpClient((Context)this, url);
            boolean isRoot = this.mdmDeviceManager.checkRootStatus();
            HttpPost post = new HttpPost(url);
            post.setHeader(KEY_HEADER_APPVERIFY, this.getAppVerifyValue(appId, appkey, System.currentTimeMillis()));
            post.setHeader(KEY_HEADER_APPID, appId);
            String mAccessToken = this.getAccessToken(mAppId);
            JSONObject json = new JSONObject();
            json.put(INTENT_APPID, (Object)appId);
            json.put("crossed", (Object)(isRoot ? "1" : "0"));
            json.put("softToken", (Object)softToken);
            json.put("systype", (Object)"Android");
            json.put("udid", (Object)androidUDID);
            json.put(SP_NAME_ACCESSTOKEN, (Object)mAccessToken);
            LogUtils.o("onHandleLogin jsonObj===> " + json.toString());
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            BasicNameValuePair nvp = new BasicNameValuePair("udid", androidUDID);
            nvps.add(nvp);
            nvp = new BasicNameValuePair("crossed", isRoot ? "1" : "0");
            nvps.add(nvp);
            nvp = new BasicNameValuePair("softToken", softToken);
            nvps.add(nvp);
            nvp = new BasicNameValuePair("systype", "Android");
            nvps.add(nvp);
            nvp = new BasicNameValuePair(INTENT_APPID, appId);
            nvps.add(nvp);
            nvp = new BasicNameValuePair("jsonObj", json.toString());
            nvps.add(nvp);
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
            HttpResponse response = getClient.execute((HttpUriRequest)post);
            int responseCode = response.getStatusLine().getStatusCode();
            LogUtils.o("onHandleLogin response " + responseCode);
            if (responseCode == 200) {
                Log.i((String)TAG_STRING, (String)("\u8bf7\u6c42\u670d\u52a1\u5668\u7aef\u6210\u529f " + responseCode));
                InputStream inStream = response.getEntity().getContent();
                String text = InputStreamUtils.InputStreamTOString(inStream, "UTF-8");
                inStream.close();
                LogUtils.o("onHandleLoginResult == " + text);
                JSONObject result = new JSONObject(text);
                if (json.has("ret")) {
                    if (!"0".equals(result.getString("ret"))) {
                        Log.i((String)TAG_STRING, (String)("\u8bf7\u6c42\u670d\u52a1\u5668\u7aef\u5931\u8d25 " + result.getString("msg")));
                        LogUtils.o("onHandleLogin request fail : " + result.getString("msg"));
                        return;
                    }
                    result = result.getJSONObject("data");
                }
                if (result.getString("isrestrict").equals("1")) {
                    String message = result.getString("message");
                    this.onAppForceClose(message);
                    return;
                }
                String resultCode = result.getString("retCode");
                this.locationInternalStr = result.optString("locationInternal");
                this.trafficInternalStr = result.optString("trafficInternal");
                Intent in = new Intent(SERVICE_ACTION_REGISTER_DEVICE);
                in.setClass((Context)this, MDMService.class);
                if (!TextUtils.isEmpty((CharSequence)resultCode)) {
                    if (resultCode.equals("100")) {
                        String status = result.getString("status");
                        if (!status.equals("0")) {
                            status.equals("1");
                        }
                        String message = result.getString("message");
                        this.onAppForceClose(message);
                    } else if (resultCode.equals("0")) {
                        LogUtils.o("error : login deviceToken is null");
                        this.startService(in);
                    } else if (resultCode.equals("1") || resultCode.equals("3") || resultCode.equals("4")) {
                        Log.i((String)TAG_STRING, (String)"login  is not register");
                        if (result.getString("message") != null && !result.getString("message").equals("")) {
                            Log.i((String)TAG_STRING, (String)"not register is root");
                            Intent broadIntent = new Intent(BROADCAST_ACTION_CBONCROSSCHANGED);
                            broadIntent.putExtra("status", "0");
                            String msg = result.getString("message");
                            broadIntent.putExtra("msg", msg);
                            this.sendBroadcast(broadIntent);
                        }
                        this.startService(in);
                    } else if (resultCode.equals("2")) {
                        Log.i((String)TAG_STRING, (String)"login  has register");
                        String isRootCode = result.getString("status");
                        if (isRootCode.equals("1") || isRootCode.equals("2")) {
                            Intent broadIntent = new Intent(BROADCAST_ACTION_CBONCROSSCHANGED);
                            broadIntent.putExtra("status", isRootCode);
                            String msg = result.getString("message");
                            broadIntent.putExtra("msg", msg);
                            this.sendBroadcast(broadIntent);
                        }
                        if (!this.readMDMConfigFile()) {
                            this.startService(in);
                        } else {
                            this.onLoginSuccess(false, null);
                        }
                    } else if (!this.readMDMConfigFile()) {
                        this.startService(in);
                    }
                }
            } else {
                Log.i((String)TAG_STRING, (String)("\u8bf7\u6c42\u670d\u52a1\u5668\u7aef\u5931\u8d25 " + responseCode));
                String errorContent = EntityUtils.toString((HttpEntity)response.getEntity());
                LogUtils.o("onHandleLogin request fail : " + errorContent);
            }
        }
        catch (Exception e) {
            LogUtils.oe("onHandleLogin request", e);
            e.printStackTrace();
        }
    }

    private boolean readMDMConfigFile() {
        block23: {
            FileInputStream fs = null;
            ObjectInputStream ois = null;
            try {
                try {
                    fs = this.getApplication().openFileInput(configfileName);
                    ois = new ObjectInputStream(fs);
                    this.mdmMobileConfig = (MDMMobileConfig)ois.readObject();
                }
                catch (Exception e) {
                    LogUtils.oe("readMDMConfigFile Failed, Missing mdmConfigFile", e);
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (fs != null) {
                        try {
                            fs.close();
                        }
                        catch (IOException e3) {
                            e3.printStackTrace();
                        }
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (fs != null) {
                    try {
                        fs.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.mdmMobileConfig != null;
    }

    private void writeMDMConfigFile() {
        FileOutputStream outs = null;
        ObjectOutputStream oouts = null;
        try {
            try {
                outs = this.getApplication().openFileOutput(configfileName, 0);
                oouts = new ObjectOutputStream(outs);
                oouts.writeObject(this.mdmMobileConfig);
            }
            catch (Exception e) {
                LogUtils.oe("writeMDMConfigFile", e);
                try {
                    oouts.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                try {
                    outs.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                oouts.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                outs.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void removeMDMConfigFile() {
        File file = new File(String.valueOf(this.getApplication().getFilesDir().getAbsolutePath()) + File.separator + configfileName);
        if (file.exists() && file.isFile()) {
            boolean res = file.delete();
            LogUtils.i(TAG_STRING, "delete MDMConfigFile " + file.getAbsolutePath() + " success? " + res);
        }
    }

    private void onLoginSuccess(boolean isFirst, String knoxKey) {
        try {
            long intervalTime = Long.parseLong(this.locationInternalStr);
            MDMTimerNotifyMgr.getInstance((Context)this).registerLocationNotify(intervalTime *= 1000L);
        }
        catch (Exception e) {
            LogUtils.oe("onHandleLogin: locationInternal ", e);
        }
        try {
            long intervalTime = Long.parseLong(this.trafficInternalStr);
            MDMTimerNotifyMgr.getInstance((Context)this).registerNetTrafficReportNotify(intervalTime *= 1000L);
        }
        catch (Exception e) {
            LogUtils.oe("onHandleLogin: trafficInternal ", e);
        }
        MDMTimerNotifyMgr.getInstance((Context)this).registerNetTrafficStatNotify(900000L);
        if (!this.mdmDeviceManager.isDeviceManagerActive()) {
            this.mdmDeviceManager.openDeviceManager();
        }
        if (this.mdmDeviceManager.isDeviceManagerActive() && this.mdmDeviceManager.getKNOXManager().isKNOXSupport() && !this.mdmDeviceManager.getKNOXManager().isKNOXactive()) {
            this.onHandleTokenReActive(null);
        }
        Intent broadIntent = new Intent(BROADCAST_ACTION_CBLOGIN);
        this.sendBroadcast(broadIntent);
    }

    private void onReportLocation(MDMLocationData locationData) {
        LogUtils.o("onReportLocation");
        try {
            String paramsStr = "udid={deviceToken}&latitude={lat,log}&location={address}";
            String url = String.valueOf(MDM_HOST) + MDM_LOCATION_REPORT_URL;
            paramsStr = paramsStr.replace(REPLACESTR_deviceToken, androidUDID).replace(REPLACESTR_latitude, String.valueOf(locationData.getLatitude()) + "," + locationData.getLongitude()).replace(REPLACESTR_location, String.valueOf(locationData.getAddress()));
            LogUtils.o("onReportLocation: url= " + url + " params: " + paramsStr);
            if (TextUtils.isEmpty((CharSequence)mAppId)) {
                mAppId = this.getAppId();
            }
            if (TextUtils.isEmpty((CharSequence)mAppKey)) {
                mAppKey = this.getAppKey();
            }
            String mAccessToken = this.getAccessToken(mAppId);
            JSONObject json = new JSONObject();
            json.put(INTENT_APPID, (Object)mAppId);
            json.put("udid", (Object)androidUDID);
            json.put(SP_NAME_ACCESSTOKEN, (Object)mAccessToken);
            json.put("latitude", (Object)(String.valueOf(locationData.getLatitude()) + "," + locationData.getLongitude()));
            json.put("location", (Object)String.valueOf(locationData.getAddress()));
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            BasicNameValuePair nvp = new BasicNameValuePair("jsonObj", json.toString());
            nvps.add(nvp);
            paramsStr = URLEncodedUtils.format(nvps, (String)"UTF-8");
            String appverify = this.getAppVerifyValue(mAppId, mAppKey, System.currentTimeMillis());
            AuthenticationParameters authParams = new AuthenticationParameters();
            if (this.mdmMobileConfig != null) {
                authParams.setClientCertificateString(this.mdmMobileConfig.dataP12);
                authParams.setClientCertificatePassword(this.mdmMobileConfig.password);
            } else {
                LogUtils.o("onReportLocation: request without cert");
            }
            HttpExApi exampleApi = null;
            exampleApi = new HttpExApi(authParams, true);
            String result = exampleApi.doPostNameValuePairs(url, paramsStr, appverify, mAppId);
            int responseCode = exampleApi.getLastResponseCode();
            MDMLocationAction.updateReportTime((Context)this);
            LogUtils.o("onReportLocation: responseCode= " + responseCode + " result= " + result);
        }
        catch (Exception e) {
            LogUtils.oe("onReportLocation", e);
        }
    }

    private void onReportNetworkTraffic(float MBytes) {
        LogUtils.o("onReportNetworkTraffic");
        try {
            String paramsStr = "udid={deviceToken}&trafficInfo={trafficInfoMB}";
            String url = String.valueOf(MDM_HOST) + MDM_TRAFFIC_REPORT_URL;
            paramsStr = paramsStr.replace(REPLACESTR_deviceToken, androidUDID).replace(REPLACESTR_traffic, String.valueOf(MBytes));
            LogUtils.o("onReportNetworkTraffic: url= " + url + " params: " + paramsStr);
            if (TextUtils.isEmpty((CharSequence)mAppId)) {
                mAppId = this.getAppId();
            }
            if (TextUtils.isEmpty((CharSequence)mAppKey)) {
                mAppKey = this.getAppKey();
            }
            String mAccessToken = this.getAccessToken(mAppId);
            String appverify = this.getAppVerifyValue(mAppId, mAppKey, System.currentTimeMillis());
            JSONObject json = new JSONObject();
            json.put(INTENT_APPID, (Object)mAppId);
            json.put("udid", (Object)androidUDID);
            json.put(SP_NAME_ACCESSTOKEN, (Object)mAccessToken);
            json.put("trafficInfo", (Object)String.valueOf(MBytes));
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            BasicNameValuePair nvp = new BasicNameValuePair("jsonObj", json.toString());
            nvps.add(nvp);
            paramsStr = URLEncodedUtils.format(nvps, (String)"UTF-8");
            AuthenticationParameters authParams = new AuthenticationParameters();
            if (this.mdmMobileConfig != null) {
                authParams.setClientCertificateString(this.mdmMobileConfig.dataP12);
                authParams.setClientCertificatePassword(this.mdmMobileConfig.password);
            } else {
                LogUtils.o("onReportNetworkTraffic: request without cert");
            }
            HttpExApi exampleApi = null;
            exampleApi = new HttpExApi(authParams, true);
            String result = exampleApi.doPostNameValuePairs(url, paramsStr, appverify, mAppId);
            int responseCode = exampleApi.getLastResponseCode();
            MDMNetworkTrafficStatsMgr.getInstance((Context)this).updateReportTime();
            LogUtils.o("onReportNetworkTraffic: responseCode= " + responseCode + " result= " + result);
        }
        catch (Exception e) {
            LogUtils.oe("onReportNetworkTraffic", e);
        }
    }

    private void backupContactsAndUpload() {
        block9: {
            String path = String.valueOf(Environment.getExternalStorageDirectory().getAbsolutePath()) + ContactsMgr.backupTempPath;
            File file = new File(path);
            boolean isSuccess = false;
            try {
                try {
                    boolean isBackupSuccess = ContactsMgr.getInstance((Context)this).backupContacts();
                    String url = String.valueOf(MDM_HOST) + MDM_DEVICE_BACKUP_URL;
                    LogUtils.o("backupContactsAndUpload url= " + url);
                    if (TextUtils.isEmpty((CharSequence)mAppId)) {
                        mAppId = this.getAppId();
                    }
                    if (TextUtils.isEmpty((CharSequence)mAppKey)) {
                        mAppKey = this.getAppKey();
                    }
                    String mAccessToken = this.getAccessToken(mAppId);
                    String appverify = this.getAppVerifyValue(mAppId, mAppKey, System.currentTimeMillis());
                    JSONObject json = new JSONObject();
                    json.put(INTENT_APPID, (Object)mAppId);
                    json.put("udid", (Object)androidUDID);
                    json.put(SP_NAME_ACCESSTOKEN, (Object)mAccessToken);
                    json.put("Content-Type", (Object)"application/octet-stream; charset=utf-8");
                    FileInputStream in = new FileInputStream(file);
                    String dataStr = IOUtil.readFully(in);
                    ((InputStream)in).close();
                    json.put("dataStr", (Object)dataStr);
                    ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                    BasicNameValuePair nvp = new BasicNameValuePair("jsonObj", json.toString());
                    nvps.add(nvp);
                    String paramsStr = URLEncodedUtils.format(nvps, (String)"UTF-8");
                    AuthenticationParameters authParams = new AuthenticationParameters();
                    if (this.mdmMobileConfig != null) {
                        authParams.setClientCertificateString(this.mdmMobileConfig.dataP12);
                        authParams.setClientCertificatePassword(this.mdmMobileConfig.password);
                    } else {
                        LogUtils.o("backupContactsAndUpload: request without cert");
                    }
                    HttpExApi exampleApi = null;
                    exampleApi = new HttpExApi(authParams, true);
                    String result = exampleApi.doPostNameValuePairs(url, paramsStr, appverify, mAppId);
                    int responseCode = exampleApi.getLastResponseCode();
                    LogUtils.o("backupContactsAndUpload response : " + responseCode + " result: " + result);
                    isSuccess = isBackupSuccess;
                }
                catch (Exception e) {
                    LogUtils.oe("backupContactsAndUpload", e);
                    file.delete();
                    Intent broadIntent = new Intent(BROADCAST_ACTION_CBBACKUPCONTACTS);
                    broadIntent.putExtra("isSuccess", isSuccess ? String.valueOf(0) : String.valueOf(1));
                    this.sendBroadcast(broadIntent);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                file.delete();
                Intent broadIntent = new Intent(BROADCAST_ACTION_CBBACKUPCONTACTS);
                broadIntent.putExtra("isSuccess", isSuccess ? String.valueOf(0) : String.valueOf(1));
                this.sendBroadcast(broadIntent);
                throw throwable;
            }
            file.delete();
            Intent broadIntent = new Intent(BROADCAST_ACTION_CBBACKUPCONTACTS);
            broadIntent.putExtra("isSuccess", isSuccess ? String.valueOf(0) : String.valueOf(1));
            this.sendBroadcast(broadIntent);
        }
    }

    private void downloadAndRestoreContacts() {
        block11: {
            String path = String.valueOf(Environment.getExternalStorageDirectory().getAbsolutePath()) + ContactsMgr.backupTempPath;
            File file = new File(path);
            File dirFile = file.getParentFile();
            boolean isSuccess = false;
            try {
                try {
                    boolean isBackupSuccess;
                    if (!dirFile.exists()) {
                        dirFile.mkdirs();
                    }
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    String url = String.valueOf(MDM_HOST) + MDM_DEVICE_RESTORE_URL;
                    if (TextUtils.isEmpty((CharSequence)mAppId)) {
                        mAppId = this.getAppId();
                    }
                    if (TextUtils.isEmpty((CharSequence)mAppKey)) {
                        mAppKey = this.getAppKey();
                    }
                    String mAccessToken = this.getAccessToken(mAppId);
                    String appverify = this.getAppVerifyValue(mAppId, mAppKey, System.currentTimeMillis());
                    JSONObject json = new JSONObject();
                    json.put(INTENT_APPID, (Object)mAppId);
                    json.put("udid", (Object)androidUDID);
                    json.put(SP_NAME_ACCESSTOKEN, (Object)mAccessToken);
                    ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                    BasicNameValuePair nvp = new BasicNameValuePair("jsonObj", json.toString());
                    nvps.add(nvp);
                    String paramsStr = URLEncodedUtils.format(nvps, (String)"UTF-8");
                    url = String.valueOf(url) + "&" + paramsStr;
                    AuthenticationParameters authParams = new AuthenticationParameters();
                    if (this.mdmMobileConfig != null) {
                        authParams.setClientCertificateString(this.mdmMobileConfig.dataP12);
                        authParams.setClientCertificatePassword(this.mdmMobileConfig.password);
                    } else {
                        LogUtils.o("downloadAndRestoreContacts: request without cert");
                    }
                    LogUtils.o("downloadAndRestoreContacts url : " + url);
                    HttpExApi exampleApi = null;
                    exampleApi = new HttpExApi(authParams, true);
                    exampleApi.doGetFile(url, file, mAppId, appverify);
                    int responseCode = exampleApi.getLastResponseCode();
                    LogUtils.o("downloadAndRestoreContacts response : " + responseCode + " " + path);
                    isSuccess = isBackupSuccess = ContactsMgr.getInstance((Context)this).restoreContacts();
                }
                catch (Exception e) {
                    LogUtils.oe("downloadAndRestoreContacts Exception: ", e);
                    LogUtils.o("downloadAndRestoreContacts result : " + isSuccess);
                    file.delete();
                    Intent broadIntent = new Intent(BROADCAST_ACTION_CBRESTORECONTACTS);
                    broadIntent.putExtra("isSuccess", isSuccess ? String.valueOf(0) : String.valueOf(1));
                    this.sendBroadcast(broadIntent);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                LogUtils.o("downloadAndRestoreContacts result : " + isSuccess);
                file.delete();
                Intent broadIntent = new Intent(BROADCAST_ACTION_CBRESTORECONTACTS);
                broadIntent.putExtra("isSuccess", isSuccess ? String.valueOf(0) : String.valueOf(1));
                this.sendBroadcast(broadIntent);
                throw throwable;
            }
            LogUtils.o("downloadAndRestoreContacts result : " + isSuccess);
            file.delete();
            Intent broadIntent = new Intent(BROADCAST_ACTION_CBRESTORECONTACTS);
            broadIntent.putExtra("isSuccess", isSuccess ? String.valueOf(0) : String.valueOf(1));
            this.sendBroadcast(broadIntent);
        }
    }

    private synchronized void downLoadApkAndInstall(final String url, final String commandUUID) {
        Log.d((String)TAG_STRING, (String)"downLoadApkAndInstall");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    File tempFile;
                    if (TextUtils.isEmpty((CharSequence)mAppId)) {
                        mAppId = MDMService.this.getAppId();
                    }
                    if (TextUtils.isEmpty((CharSequence)mAppKey)) {
                        mAppKey = MDMService.this.getAppKey();
                    }
                    String mAccessToken = MDMService.this.getAccessToken(mAppId);
                    String appverify = MDMService.this.getAppVerifyValue(mAppId, mAppKey, System.currentTimeMillis());
                    JSONObject json = new JSONObject();
                    json.put(MDMService.INTENT_APPID, (Object)mAppId);
                    json.put("udid", (Object)androidUDID);
                    json.put(MDMService.SP_NAME_ACCESSTOKEN, (Object)mAccessToken);
                    ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                    BasicNameValuePair nvp = new BasicNameValuePair("jsonObj", json.toString());
                    nvps.add(nvp);
                    String paramsStr = URLEncodedUtils.format(nvps, (String)"UTF-8");
                    String urlnew = String.valueOf(url) + "&" + paramsStr;
                    AuthenticationParameters authParams = new AuthenticationParameters();
                    authParams.setClientCertificateString(((MDMService)MDMService.this).mdmMobileConfig.dataP12);
                    authParams.setClientCertificatePassword(((MDMService)MDMService.this).mdmMobileConfig.password);
                    HttpExApi exampleApi = null;
                    exampleApi = new HttpExApi(authParams, true);
                    String tempPath = String.valueOf(BUtility.getSdCardRootPath()) + "widgetone/";
                    File tempdir = new File(tempPath);
                    if (!tempdir.exists()) {
                        tempdir.mkdir();
                    }
                    if (!(tempFile = new File(tempdir, String.valueOf(commandUUID) + ".apk")).exists()) {
                        tempFile.createNewFile();
                    }
                    LogUtils.o("downLoadApkAndInstall url : " + url);
                    exampleApi.doGetFile(urlnew, tempFile, mAppId, appverify);
                    int responseCode = exampleApi.getLastResponseCode();
                    if (responseCode == 200) {
                        Log.d((String)MDMService.TAG_STRING, (String)"download app success");
                        MDMService.this.mdmDeviceManager.install(tempFile, commandUUID);
                    }
                }
                catch (Exception e) {
                    LogUtils.oe("downLoadApkAndInstall", e);
                    e.printStackTrace();
                }
            }
        }).start();
    }

    private void initHttpCertificateStatus(Context context, String appId) {
        if (this.isInitialedHttpClient) {
            return;
        }
        this.checkAppStatus(context, appId);
        if (isCertificate) {
            LogUtils.i("MDMCertificate", "need certificate");
            String cPath = null;
            cPath = isUpdateWidget ? String.valueOf(context.getFilesDir().getPath()) + "/" + "widget/wgtRes/clientCertificate.p12" : "file:///android_asset/widget/wgtRes/clientCertificate.p12";
            HttpClientUtility.setCertificate(isCertificate, EUtil.getCertificatePsw((Context)context, (String)appId), cPath);
        } else {
            HttpClientUtility.setCertificate(isCertificate, null, null);
        }
        this.isInitialedHttpClient = true;
    }

    private void checkAppStatus(Context inActivity, String appId) {
        try {
            String appstatus = ResoureFinder.getInstance().getString(inActivity, "appstatus");
            byte[] appstatusToByte = MDMService.HexStringToBinary(appstatus);
            String appstatusDecrypt = new String(PEncryption.os_decrypt(appstatusToByte, appstatusToByte.length, appId));
            LogUtils.i(TAG_STRING, "appstatusDecrypt: " + appstatusDecrypt);
            String[] appstatuss = appstatusDecrypt.split(",");
            if (appstatuss == null || appstatuss.length == 0) {
                return;
            }
            if ("1".equals(appstatuss[8])) {
                isCertificate = true;
            }
            if ("1".equals(appstatuss[9])) {
                isUpdateWidget = true;
            }
            if ("1".equals(appstatuss[10])) {
                mdmStatus = true;
            }
        }
        catch (Exception e) {
            LogUtils.oe("checkAppStatus", e);
        }
    }

    public static byte[] HexStringToBinary(String hexString) {
        int len = hexString.length() / 2;
        byte[] bytes = new byte[len];
        byte high = 0;
        byte low = 0;
        int i = 0;
        while (i < len) {
            high = (byte)(hexStr.indexOf(hexString.charAt(2 * i)) << 4);
            low = (byte)hexStr.indexOf(hexString.charAt(2 * i + 1));
            bytes[i] = (byte)(high | low);
            ++i;
        }
        return bytes;
    }

    private void onAppForceClose(String message) {
        Intent broadIntent = new Intent(BROADCAST_ACTION_EXIT);
        broadIntent.putExtra("msg", message);
        this.sendBroadcast(broadIntent);
    }

    private String getAppVerifyValue(String appId, String appkey, long timeStamp) {
        String value = null;
        String md5 = this.getMD5Code(String.valueOf(appId) + ":" + appkey + ":" + timeStamp);
        value = "md5=" + md5 + ";ts=" + timeStamp + ";";
        return value;
    }

    private String getMD5Code(String value) {
        if (value == null) {
            value = "";
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(value.getBytes());
            byte[] md5Bytes = md.digest();
            StringBuffer hexValue = new StringBuffer();
            int i = 0;
            while (i < md5Bytes.length) {
                int val = md5Bytes[i] & 0xFF;
                if (val < 16) {
                    hexValue.append("0");
                }
                hexValue.append(Integer.toHexString(val));
                ++i;
            }
            return hexValue.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getAppId() {
        SharedPreferences sp1 = this.getApplication().getSharedPreferences("app", 0);
        return sp1.getString("appid", null);
    }

    private String getAppKey() {
        String appKey = EUExUtil.getString((String)"appkey");
        appKey = MDMService.decodeStr(appKey);
        return appKey;
    }

    private String getAccessToken(String appId) {
        SharedPreferences sp = this.getApplication().getSharedPreferences(SP_NAME_ACCESSTOKEN, 0);
        return sp.getString("accessToken_" + appId, null);
    }

    public static String decodeStr(String key) {
        char[] map = new char[]{'d', 'b', 'e', 'a', 'f', 'c'};
        char[] nmap = new char[]{'2', '4', '0', '9', '7', '1', '5', '8', '3', '6'};
        String dest = "";
        String swapstr = "";
        String output = "";
        int j = 0;
        while (j < key.length()) {
            if (key.charAt(j) != '-') {
                swapstr = String.valueOf(swapstr) + key.charAt(j);
            }
            ++j;
        }
        j = 0;
        while (j < swapstr.length()) {
            if (j == 8 || j == 12 || j == 16 || j == 20) {
                dest = String.valueOf(dest) + "-";
            }
            dest = String.valueOf(dest) + swapstr.charAt(swapstr.length() - j - 1);
            ++j;
        }
        int i = 0;
        while (i < dest.length()) {
            char t = dest.charAt(i);
            if (t >= 'a' && t <= 'f') {
                t = map[t - 97];
            } else if (t >= '0' && t <= '9') {
                t = nmap[t - 48];
            }
            output = String.valueOf(output) + t;
            ++i;
        }
        return output;
    }

    public void onDestroy() {
        Log.i((String)"uexMDM", (String)"MDM service onDestroy");
        super.onDestroy();
    }
}

