/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexMDM;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexMDM.AdminReceiver;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMDeviceManager;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMService;
import org.zywx.wbpalmstar.plugin.uexMDM.util.LogUtils;

public class MDMServiceActivity
extends Activity {
    public static final int F_START_DEVICE_MANAGER_REQUEST = 0;
    public static final int F_INSTALL_APPLICATION = 1;
    public static final int F_UNINSTALL_APPLICATION = 2;
    public static final int F_START_SETPASSWORD_REQUEST = 3;
    private static boolean isDeviceManagerActive = true;
    private String commandUUID;
    private String uninstallPackage;
    private BootReceiver mUninstallReceiver;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent in = this.getIntent();
        this.commandUUID = in.getStringExtra("commandUUID");
        int action = in.getIntExtra("action", -1);
        Intent intent = new Intent();
        this.mUninstallReceiver = new BootReceiver();
        switch (action) {
            case 0: {
                isDeviceManagerActive = MDMDeviceManager.getInstance((Context)this).isDeviceManagerActive();
                ComponentName componentName = (ComponentName)in.getParcelableExtra("android.app.extra.DEVICE_ADMIN");
                intent.setAction("android.app.action.ADD_DEVICE_ADMIN");
                intent.putExtra("android.app.extra.DEVICE_ADMIN", (Parcelable)componentName);
                intent.putExtra("android.app.extra.ADD_EXPLANATION", EUExUtil.getString((String)"plugin_mdm_device_des"));
                break;
            }
            case 1: {
                intent.setAction("android.intent.action.VIEW");
                intent.setDataAndType(in.getData(), in.getType());
                break;
            }
            case 2: {
                intent.setAction("android.intent.action.DELETE");
                this.uninstallPackage = in.getDataString();
                intent.setData(in.getData());
                IntentFilter filter = new IntentFilter("android.intent.action.PACKAGE_REMOVED");
                filter.addDataScheme("package");
                this.registerReceiver((BroadcastReceiver)this.mUninstallReceiver, filter);
                break;
            }
            case 3: {
                intent.setAction("android.app.action.SET_NEW_PASSWORD");
                IntentFilter filter1 = new IntentFilter("android.app.action.ACTION_PASSWORD_CHANGED");
                this.registerReceiver((BroadcastReceiver)this.mUninstallReceiver, filter1);
                break;
            }
        }
        this.startActivityForResult(intent, action);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 0) {
            try {
                if (!isDeviceManagerActive) {
                    isDeviceManagerActive = MDMDeviceManager.getInstance((Context)this).isDeviceManagerActive();
                    Intent serviceIntent = new Intent((Context)this, MDMService.class);
                    serviceIntent.setAction("mdmDeviceManagerStatusChanged");
                    serviceIntent.putExtra("type", isDeviceManagerActive ? 0 : 1);
                    this.startService(serviceIntent);
                }
            }
            catch (Exception e) {
                LogUtils.oe("DeviceManagerRequest", e);
            }
            this.finish();
        } else {
            Log.d((String)"serviceActivity", (String)("onActivityResult,requsetCode=" + requestCode + " ,resultCode=" + resultCode + " commandUUID=" + this.commandUUID));
            if (requestCode == 1) {
                if (resultCode == -1) {
                    MDMService.mapOfCommandAck.get(this.commandUUID).setInstallApplication(true);
                } else {
                    MDMService.mapOfCommandAck.get(this.commandUUID).setInstallApplication(false);
                }
            } else if (requestCode == 2) {
                MDMService.mapOfCommandAck.get(this.commandUUID).setUnInstallApplication(this.mUninstallReceiver.isUnInstall);
                this.unregisterReceiver((BroadcastReceiver)this.mUninstallReceiver);
            } else if (requestCode == 3) {
                MDMService.mapOfCommandAck.get(this.commandUUID).setRequestPassword(this.mUninstallReceiver.isPasswordChange);
                this.unregisterReceiver((BroadcastReceiver)this.mUninstallReceiver);
            }
            Intent in = new Intent("mdmAckcommand");
            in.putExtra("commandUUID", this.commandUUID);
            in.setClass((Context)this, MDMService.class);
            this.startService(in);
            this.finish();
        }
    }

    public class BootReceiver
    extends AdminReceiver {
        public boolean isUnInstall = false;

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.PACKAGE_ADDED")) {
                String packageName = intent.getDataString();
                System.out.println("\u5b89\u88c5\u4e86:" + packageName + "\u5305\u540d\u7684\u7a0b\u5e8f");
            } else if (intent.getAction().equals("android.intent.action.PACKAGE_REMOVED")) {
                String packageName = intent.getDataString();
                this.isUnInstall = MDMServiceActivity.this.uninstallPackage != null && MDMServiceActivity.this.uninstallPackage.equals(packageName);
            } else {
                super.onReceive(context, intent);
            }
        }
    }
}

