/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexMDM;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMLocationAction;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMLocationService;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMNetworkTrafficStatsMgr;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMService;
import org.zywx.wbpalmstar.plugin.uexMDM.util.LogUtils;

public class MDMTimerNotifyMgr {
    private static MDMTimerNotifyMgr sMDMTimerNotifyMgr;
    private static final int DEFAULT_LOCATION_REQ_CODE = 10001;
    private static final int DEFAULT_NET_TRAFFIC_REQ_CODE = 10002;
    private static final int DEFAULT_RECORD_NET_TRAFFIC_REQ_CODE = 10003;
    private Context mContext;

    private MDMTimerNotifyMgr() {
    }

    public static MDMTimerNotifyMgr getInstance(Context context) {
        if (sMDMTimerNotifyMgr == null) {
            sMDMTimerNotifyMgr = new MDMTimerNotifyMgr();
            MDMTimerNotifyMgr.sMDMTimerNotifyMgr.mContext = context;
        }
        return sMDMTimerNotifyMgr;
    }

    public void registerNotify(PendingIntent pi, long firstStartTime, long intervalTime) {
        AlarmManager am = (AlarmManager)this.mContext.getSystemService("alarm");
        if (intervalTime == -1L) {
            am.cancel(pi);
            return;
        }
        am.setRepeating(0, firstStartTime, intervalTime, pi);
    }

    public void registerLocationNotify(long intervalTime) {
        LogUtils.o("registerLocationNotify");
        Intent intent = new Intent(this.mContext, MDMLocationService.class);
        intent.setAction("mdmGetLocation");
        intent.putExtra("mdmLocationType", 1);
        PendingIntent pi = PendingIntent.getService((Context)this.mContext, (int)10001, (Intent)intent, (int)0x8000000);
        long lastReportTime = MDMLocationAction.getLastReportTime(this.mContext);
        long firstStartTime = lastReportTime + intervalTime;
        long nowTime = System.currentTimeMillis();
        firstStartTime = firstStartTime < nowTime ? nowTime + 1000L : firstStartTime;
        this.registerNotify(pi, firstStartTime, intervalTime);
    }

    public void registerNetTrafficReportNotify(long intervalTime) {
        LogUtils.o("registerNetTrafficReportNotify");
        Intent intent = new Intent(this.mContext, MDMService.class);
        intent.setAction("mdmReportNetworkTraffic");
        PendingIntent pi = PendingIntent.getService((Context)this.mContext, (int)10002, (Intent)intent, (int)0x8000000);
        long lastReportTime = MDMNetworkTrafficStatsMgr.getInstance(this.mContext).getLastReportTime();
        long firstStartTime = 0L;
        long nowTime = System.currentTimeMillis();
        firstStartTime = lastReportTime != -1L ? ((firstStartTime = lastReportTime + intervalTime) < nowTime ? nowTime + 1000L : firstStartTime) : nowTime + intervalTime;
        this.registerNotify(pi, firstStartTime, intervalTime);
    }

    public void registerNetTrafficStatNotify(long intervalTime) {
        LogUtils.o("registerNetTrafficStatNotify");
        Intent intent = new Intent(this.mContext, MDMService.class);
        intent.setAction("mdmRecordNetworkTraffic");
        PendingIntent pi = PendingIntent.getService((Context)this.mContext, (int)10003, (Intent)intent, (int)0x8000000);
        long firstStartTime = System.currentTimeMillis() + 1000L;
        this.registerNotify(pi, firstStartTime, intervalTime);
    }
}

