/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexMDM;

import android.net.wifi.WifiConfiguration;
import com.dd.plist.NSDictionary;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.zywx.wbpalmstar.plugin.uexMDM.data.MDMWifiConfigInfo;
import org.zywx.wbpalmstar.plugin.uexMDM.util.LogUtils;

public class MDMWifiConfigInfoFactory {
    public static MDMWifiConfigInfo createMDMWifiConfigInfo(NSDictionary dictObj) {
        String wifiConfigStr = dictObj.toString();
        MDMWifiConfigInfo mdmWifiConfig = new MDMWifiConfigInfo();
        WifiConfiguration wifiConfiguration = new WifiConfiguration();
        mdmWifiConfig.setWifiConfig(wifiConfiguration);
        try {
            if (dictObj.containsKey("AutoJoin")) {
                int isAutoJoin = dictObj.get((Object)"AutoJoin").toString().equals("true") ? 1 : 0;
                mdmWifiConfig.setAutoJoin(isAutoJoin);
            }
            if (dictObj.containsKey("Type")) {
                String isWhite = dictObj.get((Object)"Type").toString();
                if ("whitelist".equals(isWhite)) {
                    mdmWifiConfig.setWhitelist(1);
                    LogUtils.i("mdm", "white ");
                } else if ("blacklist".equals(isWhite)) {
                    mdmWifiConfig.setWhitelist(0);
                    LogUtils.i("mdm", "black ");
                } else if ("normal".equals(isWhite)) {
                    mdmWifiConfig.setWhitelist(-1);
                    LogUtils.i("mdm", "normal ");
                } else if ("restrictAll".equals(isWhite)) {
                    mdmWifiConfig.setWhitelist(2);
                    LogUtils.i("mdm", "restrictAll ");
                }
            }
            String SSID = dictObj.get((Object)"SSID_STR").toString();
            wifiConfiguration.SSID = "\"" + SSID + "\"";
            boolean isHiddenSSID = false;
            if (dictObj.containsKey("HIDDEN_NETWORK")) {
                isHiddenSSID = dictObj.get((Object)"HIDDEN_NETWORK").toString().equalsIgnoreCase("true");
            }
            wifiConfiguration.hiddenSSID = isHiddenSSID;
            String encryptionType = dictObj.get((Object)"EncryptionType").toString();
            if (!encryptionType.equalsIgnoreCase("None")) {
                String password = dictObj.get((Object)"Password").toString();
                String passwordStr = "\"" + password + "\"";
                if (encryptionType.equalsIgnoreCase("WEP")) {
                    int wepTxKeyIndex = 0;
                    wifiConfiguration.wepKeys[wepTxKeyIndex] = passwordStr;
                    wifiConfiguration.wepTxKeyIndex = wepTxKeyIndex;
                    wifiConfiguration.allowedKeyManagement.set(0);
                    wifiConfiguration.allowedGroupCiphers.set(2);
                } else if (encryptionType.equalsIgnoreCase("WPA")) {
                    wifiConfiguration.preSharedKey = passwordStr;
                    wifiConfiguration.allowedKeyManagement.set(1);
                    wifiConfiguration.allowedAuthAlgorithms.set(0);
                    wifiConfiguration.allowedGroupCiphers.set(2);
                    wifiConfiguration.allowedPairwiseCiphers.set(1);
                    wifiConfiguration.allowedGroupCiphers.set(3);
                    wifiConfiguration.allowedPairwiseCiphers.set(2);
                    wifiConfiguration.status = 2;
                }
            } else {
                wifiConfiguration.wepKeys[0] = "\"\"";
                wifiConfiguration.allowedKeyManagement.set(0);
                wifiConfiguration.wepTxKeyIndex = 0;
            }
            String proxyType = dictObj.get((Object)"ProxyType").toString();
            if (!proxyType.equalsIgnoreCase("None")) {
                if (proxyType.equalsIgnoreCase("Manual")) {
                    String proxyServer = dictObj.get((Object)"ProxyServer").toString();
                    int proxyServerPort = Integer.parseInt(dictObj.get((Object)"ProxyServerPort").toString());
                    String proxyUserName = dictObj.get((Object)"ProxyUsername").toString();
                    String proxyPassword = dictObj.get((Object)"ProxyPassword").toString();
                    MDMWifiConfigInfoFactory.setWifiProxySettings(wifiConfiguration, new WifiProxyProperties(proxyServer, proxyServerPort, proxyUserName, proxyPassword));
                } else if (proxyType.equalsIgnoreCase("Auto")) {
                    throw new Exception("The ProxyType \"Auto\" is Not being Supported");
                }
            } else {
                MDMWifiConfigInfoFactory.removeWifiProxySettings(wifiConfiguration);
            }
        }
        catch (Exception e) {
            LogUtils.o("parseWifiConfig Exception: " + e.getMessage() + " Detail WifiConfig: " + wifiConfigStr);
            e.printStackTrace();
            return null;
        }
        return mdmWifiConfig;
    }

    public static Object getField(Object obj, String name) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field f = obj.getClass().getField(name);
        Object out = f.get(obj);
        return out;
    }

    public static Object getDeclaredField(Object obj, String name) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field f = obj.getClass().getDeclaredField(name);
        f.setAccessible(true);
        Object out = f.get(obj);
        return out;
    }

    private static void setEnumField(Object obj, String value, String name) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field f = obj.getClass().getField(name);
        f.set(obj, Enum.valueOf(f.getType(), value));
    }

    private static void setProxySettings(String assign, WifiConfiguration wifiConf) throws SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        MDMWifiConfigInfoFactory.setEnumField(wifiConf, assign, "proxySettings");
    }

    private static void setWifiProxySettings(WifiConfiguration config, WifiProxyProperties proxy) {
        if (config == null) {
            return;
        }
        try {
            Object linkProperties = MDMWifiConfigInfoFactory.getField(config, "linkProperties");
            if (linkProperties == null) {
                return;
            }
            Class<?> proxyPropertiesClass = Class.forName("android.net.ProxyProperties");
            Class[] setHttpProxyParams = new Class[]{proxyPropertiesClass};
            Class<?> lpClass = Class.forName("android.net.LinkProperties");
            Method setHttpProxy = lpClass.getDeclaredMethod("setHttpProxy", setHttpProxyParams);
            setHttpProxy.setAccessible(true);
            Class[] proxyPropertiesCtorParamTypes = new Class[]{String.class, Integer.TYPE, String.class};
            Constructor<?> proxyPropertiesCtor = proxyPropertiesClass.getConstructor(proxyPropertiesCtorParamTypes);
            Object[] proxyPropertiesCtorParams = new Object[]{proxy.proxyServer, proxy.proxyServerPort, null};
            Object proxySettings = proxyPropertiesCtor.newInstance(proxyPropertiesCtorParams);
            Object[] params = new Object[]{proxySettings};
            setHttpProxy.invoke(linkProperties, params);
            MDMWifiConfigInfoFactory.setProxySettings("STATIC", config);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void removeWifiProxySettings(WifiConfiguration config) {
        if (config == null) {
            return;
        }
        try {
            Object linkProperties = MDMWifiConfigInfoFactory.getField(config, "linkProperties");
            if (linkProperties == null) {
                return;
            }
            Class<?> proxyPropertiesClass = Class.forName("android.net.ProxyProperties");
            Class[] setHttpProxyParams = new Class[]{proxyPropertiesClass};
            Class<?> lpClass = Class.forName("android.net.LinkProperties");
            Method setHttpProxy = lpClass.getDeclaredMethod("setHttpProxy", setHttpProxyParams);
            setHttpProxy.setAccessible(true);
            Object[] params = new Object[]{null};
            setHttpProxy.invoke(linkProperties, params);
            MDMWifiConfigInfoFactory.setProxySettings("NONE", config);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class WifiProxyProperties {
        public String proxyServer;
        public int proxyServerPort;
        public String proxyUserName;
        public String proxyPassword;

        public WifiProxyProperties(String proxyServer, int proxyServerPort, String proxyUserName, String proxyPassword) {
            this.proxyServer = proxyServer;
            this.proxyServerPort = proxyServerPort;
            this.proxyUserName = proxyUserName;
            this.proxyPassword = proxyPassword;
        }
    }
}

