/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexMDM;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.zywx.wbpalmstar.plugin.uexMDM.data.MDMWifiConfigInfo;
import org.zywx.wbpalmstar.plugin.uexMDM.util.LogUtils;

public class MDMWifiManager {
    private static final String SP_MDM_CONFIG = "mdmConfig";
    private static final String KEY_WIFI_LIST = "wifiListConfig";
    private static final String KEY_IS_RESTRICTALL = "isRestrictAll";
    private static String PATH_WIFI_CONFIG = "";
    private static MDMWifiManager wifiMgr = null;
    private WifiManager wifiManager = null;
    private HashMap<String, String> mLastWifiConfig;
    private Context mContext;
    private SharedPreferences mdmConfigSp;

    public MDMWifiManager(Context context) {
        this.mContext = context;
        this.wifiManager = (WifiManager)context.getSystemService("wifi");
        this.mdmConfigSp = this.mContext.getSharedPreferences(SP_MDM_CONFIG, 0);
    }

    public static MDMWifiManager getInstance(Context context) {
        if (wifiMgr == null) {
            wifiMgr = new MDMWifiManager(context);
        }
        PATH_WIFI_CONFIG = String.valueOf(Environment.getExternalStorageDirectory().getAbsolutePath()) + File.separator + "widgetone/" + "mdmConfig/wifiConfigFile.mdm";
        return wifiMgr;
    }

    public void turnOnWifi() {
        this.wifiManager.setWifiEnabled(true);
    }

    public void turnOffWifi() {
        this.wifiManager.setWifiEnabled(false);
    }

    public File openWifiConfigFile() {
        File wifiConfigFile = new File(PATH_WIFI_CONFIG);
        File dir = wifiConfigFile.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!wifiConfigFile.exists()) {
            try {
                wifiConfigFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return wifiConfigFile;
    }

    public void listMyWifi() {
        WifiConfiguration wifiConf = null;
        WifiInfo connectionInfo = this.wifiManager.getConnectionInfo();
        if (connectionInfo != null) {
            LogUtils.o("current WIFI AP \uff1a networkId==" + connectionInfo.getNetworkId() + " SSID==" + connectionInfo.getSSID());
        }
        List configuredNetworks = this.wifiManager.getConfiguredNetworks();
        Iterator iterator = configuredNetworks.iterator();
        while (iterator.hasNext()) {
            WifiConfiguration conf;
            wifiConf = conf = (WifiConfiguration)iterator.next();
            String ssid = "";
            try {
                ssid = new String(wifiConf.SSID.getBytes(), "UTF-8");
            }
            catch (Exception e) {
                LogUtils.o("WIFI SSID CHARSET ERROR: " + e.getMessage());
            }
            Log.i((String)"WIFI", (String)("networkId==" + wifiConf.networkId + " SSID==" + ssid + " BSSID==" + wifiConf.BSSID + " priority==" + wifiConf.priority));
        }
    }

    public void scanWifi() {
        boolean isSuccess = this.wifiManager.startScan();
        Log.i((String)"WIFI", (String)("startScanWifi " + isSuccess));
    }

    private WifiConfiguration isExistSSID(String ssid) {
        WifiConfiguration wifiConf = null;
        List configuredNetworks = this.wifiManager.getConfiguredNetworks();
        Iterator iterator = configuredNetworks.iterator();
        while (iterator.hasNext()) {
            WifiConfiguration conf;
            wifiConf = conf = (WifiConfiguration)iterator.next();
            String tempSsid = "";
            try {
                tempSsid = wifiConf.SSID;
                if (!ssid.equals(tempSsid)) continue;
                return wifiConf;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public int addOrUpdateSSID(MDMWifiConfigInfo mdmWifiConfig) {
        int networkId = -1;
        WifiConfiguration oldWifiConfig = this.isExistSSID(mdmWifiConfig.getWifiConfig().SSID);
        if (oldWifiConfig == null) {
            networkId = this.wifiManager.addNetwork(mdmWifiConfig.getWifiConfig());
        } else {
            mdmWifiConfig.getWifiConfig().networkId = oldWifiConfig.networkId;
            networkId = this.wifiManager.updateNetwork(mdmWifiConfig.getWifiConfig());
        }
        boolean isSuccess = this.wifiManager.saveConfiguration();
        if (mdmWifiConfig.isAutoJoin() == 1) {
            this.wifiManager.enableNetwork(networkId, true);
        } else {
            this.wifiManager.disableNetwork(networkId);
        }
        LogUtils.i("WIFI", "isSaveSuccess: " + isSuccess);
        return networkId;
    }

    public boolean removeSSID(String ssid) {
        WifiConfiguration wifiConfig = this.isExistSSID(ssid);
        boolean isSuccess = false;
        if (wifiConfig == null) {
            return true;
        }
        try {
            isSuccess = this.wifiManager.removeNetwork(wifiConfig.networkId) && this.wifiManager.saveConfiguration();
            LogUtils.o("removeSSID: " + ssid + " " + isSuccess);
        }
        catch (Exception e) {
            LogUtils.o("removeSSID error: " + e.getMessage());
            e.printStackTrace();
        }
        return isSuccess;
    }

    private void saveWifiConfigFile() {
        block20: {
            if (this.mLastWifiConfig == null) {
                LogUtils.o("saveWifiConfigFile error: list is null");
                return;
            }
            JSONArray array = new JSONArray();
            for (Map.Entry<String, String> set : this.mLastWifiConfig.entrySet()) {
                String key = set.getKey();
                array.put((Object)key);
            }
            String data = array.toString();
            LogUtils.o("saveWifiConfigFile: " + data);
            SharedPreferences sp = this.mContext.getSharedPreferences(SP_MDM_CONFIG, 0);
            sp.edit().putString(KEY_WIFI_LIST, data).commit();
            File file = this.openWifiConfigFile();
            ByteArrayInputStream in = new ByteArrayInputStream(data.getBytes());
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(file);
                byte[] buffer = new byte[512];
                while (in.read(buffer) != -1) {
                    ((OutputStream)out).write(buffer, 0, buffer.length);
                    out.flush();
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (out != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                break block20;
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                    break block20;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (out != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (IOException e3) {
                            e3.printStackTrace();
                        }
                    }
                }
            }
            if (out == null) break block20;
            try {
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.mLastWifiConfig = null;
    }

    public void saveWifiConfigFile(HashMap<String, String> map) {
        this.mLastWifiConfig = map;
        this.saveWifiConfigFile();
    }

    public void setRestrictAllWifi(boolean isRestrictAll) {
        this.mdmConfigSp.edit().putBoolean(KEY_IS_RESTRICTALL, isRestrictAll).commit();
        this.restrictCurrentWifi();
    }

    public boolean isRestrictAllWifi() {
        boolean isRestrictAll = this.mdmConfigSp.getBoolean(KEY_IS_RESTRICTALL, false);
        return isRestrictAll;
    }

    public HashMap<String, String> loadWifiConfigFile() {
        String wifiListStr;
        block20: {
            if (this.mLastWifiConfig != null) {
                return this.mLastWifiConfig;
            }
            wifiListStr = null;
            SharedPreferences sp = this.mContext.getSharedPreferences(SP_MDM_CONFIG, 0);
            wifiListStr = sp.getString(KEY_WIFI_LIST, "undefined");
            if (wifiListStr.equals("undefined")) {
                wifiListStr = "";
                File file = this.openWifiConfigFile();
                FileInputStream in = null;
                try {
                    try {
                        in = new FileInputStream(file);
                        byte[] buffer = new byte[512];
                        while (((InputStream)in).read(buffer) != -1) {
                            wifiListStr = String.valueOf(wifiListStr) + new String(buffer);
                        }
                    }
                    catch (Exception e) {
                        LogUtils.o("loadWifiConfigFile error: " + e.getMessage());
                        if (in != null) {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        LogUtils.o("loadWifiConfigFile: " + wifiListStr);
        HashMap<String, String> wifiList = new HashMap<String, String>();
        try {
            JSONArray array = new JSONArray(wifiListStr);
            int i = 0;
            while (i < array.length()) {
                String wifiName = array.getString(i);
                wifiList.put(wifiName, wifiName);
                ++i;
            }
            this.mLastWifiConfig = wifiList;
        }
        catch (Exception e) {
            LogUtils.o("loadWifiConfigFile error, Maybe it's the first time config wifi: " + e.getMessage());
            e.printStackTrace();
        }
        return this.mLastWifiConfig;
    }

    public HashMap<String, String> loadWifiWhiteList() {
        HashMap<String, String> list = new HashMap<String, String>();
        try {
            String data = this.mdmConfigSp.getString("whiteWifiList", "[]");
            LogUtils.o("loadWifiWhiteList: " + data);
            JSONArray array = new JSONArray(data);
            int i = 0;
            while (i < array.length()) {
                String ssid = array.getString(i);
                list.put(ssid, ssid);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public HashMap<String, String> loadWifiBlackList() {
        HashMap<String, String> list = new HashMap<String, String>();
        try {
            String data = this.mdmConfigSp.getString("blackWifiList", "[]");
            LogUtils.o("loadWifiBlackList: " + data);
            JSONArray array = new JSONArray(data);
            int i = 0;
            while (i < array.length()) {
                String ssid = array.getString(i);
                list.put(ssid, ssid);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public void saveWifiWhiteList(HashMap<String, String> list) {
        try {
            JSONArray array = new JSONArray();
            for (Map.Entry<String, String> entry : list.entrySet()) {
                String ssid = entry.getValue();
                array.put((Object)ssid);
            }
            String data = array.toString();
            this.mdmConfigSp.edit().putString("whiteWifiList", data).commit();
            LogUtils.o("saveWifiWhiteList: " + data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveWifiBlackList(HashMap<String, String> list) {
        try {
            JSONArray array = new JSONArray();
            for (Map.Entry<String, String> entry : list.entrySet()) {
                String ssid = entry.getValue();
                array.put((Object)ssid);
            }
            String data = array.toString();
            this.mdmConfigSp.edit().putString("blackWifiList", data).commit();
            LogUtils.o("saveWifiBlackList: " + data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isWifiAllRestricted() {
        boolean isWifiAllowed = this.mdmConfigSp.getBoolean("allowWifi", true);
        return !isWifiAllowed;
    }

    public void setWifiAllRestricted(boolean isAllowed) {
        this.mdmConfigSp.edit().putBoolean("allowWifi", isAllowed).commit();
        this.restrictCurrentWifi();
    }

    public void restrictCurrentWifi() {
        try {
            WifiInfo wifiInfo = this.wifiManager.getConnectionInfo();
            if (wifiInfo != null) {
                String ssid = wifiInfo.getSSID();
                LogUtils.o("WIFI connected with " + ssid);
                if (this.isWifiRestricted(ssid)) {
                    this.wifiManager.disconnect();
                    this.wifiManager.disableNetwork(wifiInfo.getNetworkId());
                    LogUtils.o("WIFI " + ssid + "is Restricted!");
                }
            }
        }
        catch (Exception e) {
            LogUtils.oe("restrictCurrentWifi", e);
            e.printStackTrace();
        }
    }

    public boolean isWifiRestricted(String ssid) {
        if (Build.VERSION.SDK_INT <= 16 && !TextUtils.isEmpty((CharSequence)ssid)) {
            ssid = "\"" + ssid + "\"";
        }
        if ("\"AZHANGYIPENG\"".equalsIgnoreCase(ssid)) {
            LogUtils.o("AZHANGYIPENG is a testAP");
            return false;
        }
        if (this.isWifiAllRestricted() || this.isRestrictAllWifi()) {
            return true;
        }
        HashMap<String, String> whiteMap = this.loadWifiWhiteList();
        if (whiteMap.size() != 0 && !whiteMap.containsKey(ssid)) {
            return true;
        }
        HashMap<String, String> blackMap = this.loadWifiBlackList();
        return blackMap.size() != 0 && blackMap.containsKey(ssid);
    }
}

