/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexMDM.data;

import android.os.Parcel;
import com.dd.plist.NSArray;
import com.dd.plist.NSData;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSString;
import com.dd.plist.XMLPropertyListParser;
import java.io.InputStream;
import java.io.Serializable;

public class MDMMobileConfig
implements Serializable {
    public int accessRights;
    public String checkInUrl = null;
    public String serverUrl = null;
    public String payloadCertificateFileName = null;
    public String dataP12 = null;
    public String password = null;
    public String topic = null;

    public MDMMobileConfig(Parcel in) {
        this.accessRights = in.readInt();
        this.checkInUrl = in.readString();
        this.serverUrl = in.readString();
        this.payloadCertificateFileName = in.readString();
        this.dataP12 = in.readString();
        this.password = in.readString();
        this.topic = in.readString();
    }

    public MDMMobileConfig() {
    }

    public static MDMMobileConfig parseMobileConfigProfile(InputStream inputStr) throws Exception {
        if (inputStr == null) {
            return null;
        }
        MDMMobileConfig mdmMobileConfig = new MDMMobileConfig();
        NSDictionary rootDictObj = (NSDictionary)XMLPropertyListParser.parse((InputStream)inputStr);
        NSArray arrayObj = (NSArray)rootDictObj.get((Object)"PayloadContent");
        if (arrayObj != null && arrayObj.count() >= 2) {
            int i = 0;
            while (i < arrayObj.count()) {
                NSDictionary dictObj = (NSDictionary)arrayObj.objectAtIndex(i);
                if (dictObj.containsKey("AccessRights")) {
                    NSNumber accessRights = (NSNumber)dictObj.get((Object)"AccessRights");
                    mdmMobileConfig.accessRights = accessRights.intValue();
                    NSString strValue = (NSString)dictObj.get((Object)"CheckInURL");
                    mdmMobileConfig.checkInUrl = strValue.toString();
                    strValue = (NSString)dictObj.get((Object)"ServerURL");
                    mdmMobileConfig.serverUrl = strValue.toString();
                    strValue = (NSString)dictObj.get((Object)"Topic");
                    mdmMobileConfig.topic = strValue.toString();
                } else if (dictObj.containsKey("Password")) {
                    NSString strValue = (NSString)dictObj.get((Object)"PayloadCertificateFileName");
                    mdmMobileConfig.payloadCertificateFileName = strValue.toString();
                    NSData dataValue = (NSData)dictObj.get((Object)"PayloadContent");
                    mdmMobileConfig.dataP12 = dataValue.getBase64EncodedData();
                    strValue = (NSString)dictObj.get((Object)"Password");
                    mdmMobileConfig.password = strValue.toString();
                }
                ++i;
            }
        }
        return mdmMobileConfig;
    }

    public String toString() {
        return "MDMMobileConfig [accessRights=" + this.accessRights + ", checkInUrl=" + this.checkInUrl + ", serverUrl=" + this.serverUrl + ", payloadCertificateFileName=" + this.payloadCertificateFileName + ", dataP12=" + this.dataP12 + ", password=" + this.password + ", topic=" + this.topic + "]";
    }
}

