/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexMDM.samsung.knox;

import android.app.enterprise.ApplicationPolicy;
import android.app.enterprise.EnterpriseDeviceManager;
import android.app.enterprise.LocationPolicy;
import android.app.enterprise.PhoneRestrictionPolicy;
import android.app.enterprise.RestrictionPolicy;
import android.app.enterprise.license.EnterpriseLicenseManager;
import android.content.Context;
import android.os.Build;
import java.util.List;
import org.json.JSONArray;
import org.zywx.wbpalmstar.plugin.uexMDM.util.LogUtils;

public class KNOXDeviceManager {
    private EnterpriseDeviceManager mEDM;
    private static KNOXDeviceManager mInstance;
    private Context mContext;
    private boolean isKNOXok = false;
    private boolean isKNOXSupport = false;

    private KNOXDeviceManager(Context context) {
        this.mContext = context;
        this.isKNOXok = this.checkKNOXactive();
        if (this.isKNOXok) {
            this.mEDM = new EnterpriseDeviceManager(this.mContext);
        }
    }

    public static KNOXDeviceManager getmInstance(Context ctx) {
        if (mInstance == null) {
            mInstance = new KNOXDeviceManager(ctx);
        }
        return mInstance;
    }

    public synchronized void setRegister(String key) {
        if (this.isKNOXSupport && !this.isKNOXok) {
            EnterpriseLicenseManager mLicenseMgr = EnterpriseLicenseManager.getInstance((Context)this.mContext);
            mLicenseMgr.activateLicense(key);
        }
    }

    public void setSuccess(boolean isSuccess) {
        this.isKNOXok = isSuccess;
        if (this.isKNOXok) {
            this.mEDM = new EnterpriseDeviceManager(this.mContext);
        }
    }

    public boolean isKNOXactive() {
        return this.isKNOXok;
    }

    public boolean isKNOXSupport() {
        return this.isKNOXSupport;
    }

    public boolean checkKNOXactive() {
        if ("samsung".equals(Build.BRAND) && "samsung".equals(Build.MANUFACTURER) && Build.VERSION.SDK_INT >= 17) {
            try {
                EnterpriseLicenseManager mLicenseMgr = EnterpriseLicenseManager.getInstance((Context)this.mContext);
                this.isKNOXSupport = true;
                LogUtils.i("KNOX Support", "isKNOXSupport");
                JSONArray arr = mLicenseMgr.getApiCallDataByAdmin(this.mContext.getPackageName());
                LogUtils.i("KnoxCheckTest", String.valueOf(arr != null ? arr.toString() : "null") + "  " + this.mContext.getPackageName());
                return true;
            }
            catch (Exception e) {
                if (this.isKNOXSupport) {
                    LogUtils.i("KNOX CheckTest", "not Activity");
                } else {
                    LogUtils.i("KNOX CheckTest", "not Support");
                }
                return false;
            }
        }
        return false;
    }

    public boolean setCameraEnable(boolean isCameraEnabled) {
        if (!this.isKNOXok) {
            return false;
        }
        try {
            RestrictionPolicy mp = this.mEDM.getRestrictionPolicy();
            mp.setCameraState(isCameraEnabled);
        }
        catch (Exception e) {
            LogUtils.oe("setCameraEnable by knox", e);
            e.printStackTrace();
        }
        return isCameraEnabled;
    }

    public boolean setScreenCaptureEnable(boolean isScreenCaptureEnable) {
        if (!this.isKNOXok) {
            return false;
        }
        try {
            RestrictionPolicy mp = this.mEDM.getRestrictionPolicy();
            mp.setScreenCapture(isScreenCaptureEnable);
        }
        catch (Exception e) {
            LogUtils.oe("setScreenCaptureEnable by knox", e);
            e.printStackTrace();
        }
        return isScreenCaptureEnable;
    }

    public boolean setClipboardEnabled(boolean isClipboardEnable) {
        if (!this.isKNOXok) {
            return false;
        }
        try {
            RestrictionPolicy restrictionPolicy = this.mEDM.getRestrictionPolicy();
            restrictionPolicy.setClipboardEnabled(isClipboardEnable);
        }
        catch (Exception e) {
            LogUtils.oe("setClipboardEnabled by knox", e);
            e.printStackTrace();
        }
        return isClipboardEnable;
    }

    public boolean setWiFiEnable(boolean isWiFiEnabled) {
        if (!this.isKNOXok) {
            return false;
        }
        try {
            RestrictionPolicy restrictionPolicy = this.mEDM.getRestrictionPolicy();
            restrictionPolicy.allowWiFi(isWiFiEnabled);
        }
        catch (Exception e) {
            LogUtils.oe("setWiFiEnable by knox", e);
            e.printStackTrace();
        }
        return isWiFiEnabled;
    }

    public boolean setBluetoothEnable(boolean isBluetoothEnabled) {
        if (!this.isKNOXok) {
            return false;
        }
        try {
            RestrictionPolicy restrictionPolicy = this.mEDM.getRestrictionPolicy();
            restrictionPolicy.allowBluetooth(isBluetoothEnabled);
        }
        catch (Exception e) {
            LogUtils.oe("setBluetoothEnable by knox", e);
            e.printStackTrace();
        }
        return isBluetoothEnabled;
    }

    public boolean setAndroidBeamEnable(boolean isAndroidBeamEnable) {
        if (!this.isKNOXok) {
            return false;
        }
        try {
            RestrictionPolicy restrictionPolicy = this.mEDM.getRestrictionPolicy();
            restrictionPolicy.allowAndroidBeam(isAndroidBeamEnable);
        }
        catch (Exception e) {
            LogUtils.oe("setAndroidBeamEnable by knox", e);
            e.printStackTrace();
        }
        return isAndroidBeamEnable;
    }

    public boolean setHeadphoneEnable(boolean isHeadphoneEnabled) {
        if (!this.isKNOXok) {
            return false;
        }
        try {
            RestrictionPolicy restrictionPolicy = this.mEDM.getRestrictionPolicy();
            restrictionPolicy.setHeadphoneState(isHeadphoneEnabled);
        }
        catch (Exception e) {
            LogUtils.oe("setHeadphoneEnable by knox", e);
            e.printStackTrace();
        }
        return isHeadphoneEnabled;
    }

    public boolean setMicrophoneEnable(boolean isMicrophoneEnabled) {
        if (!this.isKNOXok) {
            return false;
        }
        try {
            RestrictionPolicy restrictionPolicy = this.mEDM.getRestrictionPolicy();
            restrictionPolicy.setMicrophoneState(isMicrophoneEnabled);
        }
        catch (Exception e) {
            LogUtils.oe("setMicrophoneEnable by knox", e);
            e.printStackTrace();
        }
        return isMicrophoneEnabled;
    }

    public boolean setAudioRecordEnable(boolean isAudioRecordEnable) {
        if (!this.isKNOXok) {
            return false;
        }
        try {
            RestrictionPolicy restrictionPolicy = this.mEDM.getRestrictionPolicy();
            restrictionPolicy.allowAudioRecord(isAudioRecordEnable);
        }
        catch (Exception e) {
            LogUtils.oe("setAudioRecordEnable by knox", e);
            e.printStackTrace();
        }
        return isAudioRecordEnable;
    }

    public boolean setVideoRecordEnable(boolean isVideoRecordEnable) {
        if (!this.isKNOXok) {
            return false;
        }
        try {
            RestrictionPolicy restrictionPolicy = this.mEDM.getRestrictionPolicy();
            restrictionPolicy.allowVideoRecord(isVideoRecordEnable);
        }
        catch (Exception e) {
            LogUtils.oe("setVideoRecordEnable by knox", e);
            e.printStackTrace();
        }
        return isVideoRecordEnable;
    }

    public boolean setNFCEnable(boolean isNFCEnable) {
        if (!this.isKNOXok) {
            return false;
        }
        try {
            RestrictionPolicy restrictionPolicy = this.mEDM.getRestrictionPolicy();
            restrictionPolicy.setEnableNFC(isNFCEnable);
        }
        catch (Exception e) {
            LogUtils.oe("setNFCEnable by knox", e);
            e.printStackTrace();
        }
        return isNFCEnable;
    }

    public boolean setHomeKeyEnable(boolean isHomeKeyEnable) {
        if (!this.isKNOXok) {
            return false;
        }
        try {
            RestrictionPolicy restrictionPolicy = this.mEDM.getRestrictionPolicy();
            restrictionPolicy.setHomeKeyState(isHomeKeyEnable);
        }
        catch (Exception e) {
            LogUtils.oe("setHomeKeyEnable by knox", e);
            e.printStackTrace();
        }
        return isHomeKeyEnable;
    }

    public boolean setMockLocationEnable(boolean isMockLocationEnable) {
        if (!this.isKNOXok) {
            return false;
        }
        try {
            RestrictionPolicy restrictionPolicy = this.mEDM.getRestrictionPolicy();
            restrictionPolicy.setMockLocation(isMockLocationEnable);
        }
        catch (Exception e) {
            LogUtils.oe("setMockLocationEnable by knox", e);
            e.printStackTrace();
        }
        return isMockLocationEnable;
    }

    public boolean setDeveloperModeEnable(boolean isDeveloperModeEnable) {
        if (!this.isKNOXok) {
            return false;
        }
        try {
            RestrictionPolicy restrictionPolicy = this.mEDM.getRestrictionPolicy();
            restrictionPolicy.allowDeveloperMode(isDeveloperModeEnable);
        }
        catch (Exception e) {
            LogUtils.oe("setDeveloperModeEnable by knox", e);
            e.printStackTrace();
        }
        return isDeveloperModeEnable;
    }

    public boolean setUsbDebuggingEnabled(boolean isUsbDebuggingEnable) {
        if (!this.isKNOXok) {
            return false;
        }
        try {
            RestrictionPolicy restrictionPolicy = this.mEDM.getRestrictionPolicy();
            restrictionPolicy.setUsbDebuggingEnabled(isUsbDebuggingEnable);
        }
        catch (Exception e) {
            LogUtils.oe("setUsbDebuggingEnabled by knox", e);
            e.printStackTrace();
        }
        return isUsbDebuggingEnable;
    }

    public boolean setUsbMediaPlayerAvailabilityEnable(boolean isUsbMediaPlayerAvailabilityEnable) {
        if (!this.isKNOXok) {
            return false;
        }
        try {
            RestrictionPolicy restrictionPolicy = this.mEDM.getRestrictionPolicy();
            restrictionPolicy.setUsbMediaPlayerAvailability(isUsbMediaPlayerAvailabilityEnable);
        }
        catch (Exception e) {
            LogUtils.oe("setUsbMediaPlayerAvailabilityEnable by knox", e);
            e.printStackTrace();
        }
        return isUsbMediaPlayerAvailabilityEnable;
    }

    public boolean setUsbTethering(boolean isUsbTetheringEnable) {
        if (!this.isKNOXok) {
            return false;
        }
        try {
            RestrictionPolicy restrictionPolicy = this.mEDM.getRestrictionPolicy();
            restrictionPolicy.setUsbTethering(isUsbTetheringEnable);
        }
        catch (Exception e) {
            LogUtils.oe("setUsbTethering by knox", e);
            e.printStackTrace();
        }
        return isUsbTetheringEnable;
    }

    public boolean setUsbHostStorageEnable(boolean isUsbHostStorageEnable) {
        if (!this.isKNOXok) {
            return false;
        }
        try {
            RestrictionPolicy restrictionPolicy = this.mEDM.getRestrictionPolicy();
            restrictionPolicy.allowUsbHostStorage(isUsbHostStorageEnable);
        }
        catch (Exception e) {
            LogUtils.oe("setUsbHostStorageEnable by knox", e);
            e.printStackTrace();
        }
        return isUsbHostStorageEnable;
    }

    public boolean setSDCardWriteEnable(boolean isSDCardWriteEnable) {
        if (!this.isKNOXok) {
            return false;
        }
        try {
            RestrictionPolicy restrictionPolicy = this.mEDM.getRestrictionPolicy();
            restrictionPolicy.allowSDCardWrite(isSDCardWriteEnable);
        }
        catch (Exception e) {
            LogUtils.oe("setSDCardWriteEnable by knox", e);
            e.printStackTrace();
        }
        return isSDCardWriteEnable;
    }

    public boolean setSdCardEnable(boolean isSDCardEnable) {
        if (!this.isKNOXok) {
            return false;
        }
        try {
            RestrictionPolicy restrictionPolicy = this.mEDM.getRestrictionPolicy();
            restrictionPolicy.setSdCardState(isSDCardEnable);
        }
        catch (Exception e) {
            LogUtils.oe("setSdCardEnable by knox", e);
            e.printStackTrace();
        }
        return isSDCardEnable;
    }

    public boolean setEmergencyCallOnly(boolean enable) {
        if (!this.isKNOXok) {
            return false;
        }
        boolean result = false;
        try {
            PhoneRestrictionPolicy phoneResPolicy = this.mEDM.getPhoneRestrictionPolicy();
            result = phoneResPolicy.setEmergencyCallOnly(enable);
        }
        catch (Exception e) {
            LogUtils.oe("setEmergencyCallOnly by knox", e);
            e.printStackTrace();
        }
        return result;
    }

    public boolean setIncomingSMSEnable(boolean isIncomingSMSEnabled) {
        if (!this.isKNOXok) {
            return false;
        }
        try {
            PhoneRestrictionPolicy phoneResPolicy = this.mEDM.getPhoneRestrictionPolicy();
            phoneResPolicy.allowIncomingSms(isIncomingSMSEnabled);
        }
        catch (Exception e) {
            LogUtils.oe("setIncomingSMSEnable by knox", e);
            e.printStackTrace();
        }
        return isIncomingSMSEnabled;
    }

    public boolean setOutgoingSMSEnable(boolean isOutgoingSMSEnabled) {
        if (!this.isKNOXok) {
            return false;
        }
        try {
            PhoneRestrictionPolicy phoneResPolicy = this.mEDM.getPhoneRestrictionPolicy();
            phoneResPolicy.allowOutgoingSms(isOutgoingSMSEnabled);
        }
        catch (Exception e) {
            LogUtils.oe("setOutgoingSMSEnable by knox", e);
            e.printStackTrace();
        }
        return isOutgoingSMSEnabled;
    }

    public boolean setIncomingMMSEnable(boolean isIncomingMMSEnabled) {
        if (!this.isKNOXok) {
            return false;
        }
        try {
            PhoneRestrictionPolicy phoneResPolicy = this.mEDM.getPhoneRestrictionPolicy();
            phoneResPolicy.allowIncomingSms(isIncomingMMSEnabled);
        }
        catch (Exception e) {
            LogUtils.oe("setIncomingMMSEnable by knox", e);
            e.printStackTrace();
        }
        return isIncomingMMSEnabled;
    }

    public boolean setOutgoingMMSEnable(boolean isOutgoingMMSEnabled) {
        if (!this.isKNOXok) {
            return false;
        }
        try {
            PhoneRestrictionPolicy phoneResPolicy = this.mEDM.getPhoneRestrictionPolicy();
            phoneResPolicy.allowOutgoingMms(isOutgoingMMSEnabled);
        }
        catch (Exception e) {
            LogUtils.oe("setOutgoingMMSEnable by knox", e);
            e.printStackTrace();
        }
        return isOutgoingMMSEnabled;
    }

    public boolean installApplication(String apkFilePath, boolean installOnSDCard) {
        if (!this.isKNOXok) {
            return false;
        }
        boolean result = false;
        try {
            ApplicationPolicy appPolicy = this.mEDM.getApplicationPolicy();
            result = appPolicy.installApplication(apkFilePath, installOnSDCard);
        }
        catch (Exception e) {
            LogUtils.oe("installApplication by knox", e);
            e.printStackTrace();
        }
        return result;
    }

    public boolean uninstallApplication(String packageName, boolean keepDataAndCache) {
        if (!this.isKNOXok) {
            return false;
        }
        boolean result = false;
        try {
            ApplicationPolicy appPolicy = this.mEDM.getApplicationPolicy();
            result = appPolicy.uninstallApplication(packageName, keepDataAndCache);
        }
        catch (Exception e) {
            LogUtils.oe("uninstallApplication by knox", e);
            e.printStackTrace();
        }
        return result;
    }

    public boolean changeApplicationIcon(String packageName, byte[] imageData) {
        if (!this.isKNOXok) {
            return false;
        }
        boolean result = false;
        try {
            ApplicationPolicy appPolicy = this.mEDM.getApplicationPolicy();
            result = appPolicy.changeApplicationIcon(packageName, imageData);
        }
        catch (Exception e) {
            LogUtils.oe("changeApplicationIcon by knox", e);
            e.printStackTrace();
        }
        return result;
    }

    public void setApplicationUninstallationDisabled(String packageName) {
        if (!this.isKNOXok) {
            return;
        }
        try {
            ApplicationPolicy appPolicy = this.mEDM.getApplicationPolicy();
            appPolicy.setApplicationUninstallationDisabled(packageName);
        }
        catch (Exception e) {
            LogUtils.oe("setApplicationUninstallationDisabled by knox", e);
            e.printStackTrace();
        }
    }

    public void setApplicationUninstallationEnabled(String packageName) {
        if (!this.isKNOXok) {
            return;
        }
        try {
            ApplicationPolicy appPolicy = this.mEDM.getApplicationPolicy();
            appPolicy.setApplicationUninstallationEnabled(packageName);
        }
        catch (Exception e) {
            LogUtils.oe("setApplicationUninstallationEnabled by knox", e);
            e.printStackTrace();
        }
    }

    public void setApplicationInstallationDisabled(String packageName) {
        if (!this.isKNOXok) {
            return;
        }
        try {
            ApplicationPolicy appPolicy = this.mEDM.getApplicationPolicy();
            appPolicy.setApplicationInstallationDisabled(packageName);
        }
        catch (Exception e) {
            LogUtils.oe("setApplicationInstallationDisabled by knox", e);
            e.printStackTrace();
        }
    }

    public void setApplicationInstallationEnabled(String packageName) {
        if (!this.isKNOXok) {
            return;
        }
        try {
            ApplicationPolicy appPolicy = this.mEDM.getApplicationPolicy();
            appPolicy.setApplicationInstallationEnabled(packageName);
        }
        catch (Exception e) {
            LogUtils.oe("setApplicationInstallationEnabled by knox", e);
            e.printStackTrace();
        }
    }

    public boolean setAppInstallEnable(boolean isAppInstallEnable) {
        if (!this.isKNOXok) {
            return false;
        }
        boolean result = false;
        try {
            ApplicationPolicy appPolicy = this.mEDM.getApplicationPolicy();
            result = isAppInstallEnable ? appPolicy.setApplicationInstallationMode(1) : appPolicy.setApplicationInstallationMode(0);
        }
        catch (Exception e) {
            LogUtils.oe("setAppInstallEnable by knox", e);
            e.printStackTrace();
        }
        return result;
    }

    public boolean setAppUninstallEnable(boolean isAppUninstallEnable) {
        if (!this.isKNOXok) {
            return false;
        }
        boolean result = false;
        try {
            ApplicationPolicy appPolicy = this.mEDM.getApplicationPolicy();
            result = isAppUninstallEnable ? appPolicy.setApplicationUninstallationMode(1) : appPolicy.setApplicationUninstallationMode(0);
        }
        catch (Exception e) {
            LogUtils.oe("setAppUninstallEnable by knox", e);
            e.printStackTrace();
        }
        return result;
    }

    public boolean startGPS(boolean start) {
        if (!this.isKNOXok) {
            return false;
        }
        boolean result = false;
        try {
            LocationPolicy locationPolicy = this.mEDM.getLocationPolicy();
            result = locationPolicy.startGPS(start);
        }
        catch (Exception e) {
            LogUtils.oe("startGPS by knox", e);
            e.printStackTrace();
        }
        return result;
    }

    public boolean setGPSStateChangeEnabled(boolean isGPSStateChangeEnabled) {
        if (!this.isKNOXok) {
            return false;
        }
        boolean result = false;
        try {
            LocationPolicy locationPolicy = this.mEDM.getLocationPolicy();
            result = locationPolicy.setGPSStateChangeAllowed(isGPSStateChangeEnabled);
        }
        catch (Exception e) {
            LogUtils.oe("setGPSStateChangeEnabled by knox", e);
            e.printStackTrace();
        }
        return result;
    }

    public List<String> getAllLocationProviders() {
        if (!this.isKNOXok) {
            return null;
        }
        List result = null;
        try {
            LocationPolicy locationPolicy = this.mEDM.getLocationPolicy();
            result = locationPolicy.getAllLocationProviders();
        }
        catch (Exception e) {
            LogUtils.oe("getAllLocationProviders by knox", e);
            e.printStackTrace();
        }
        return result;
    }

    public boolean setLocationProviderState(String provider, boolean enable) {
        if (!this.isKNOXok) {
            return false;
        }
        boolean result = false;
        try {
            LocationPolicy locationPolicy = this.mEDM.getLocationPolicy();
            result = locationPolicy.setLocationProviderState(provider, enable);
        }
        catch (Exception e) {
            LogUtils.oe("setLocationProviderState by knox", e);
            e.printStackTrace();
        }
        return result;
    }
}

